      SUBROUTINE DIRECTION(DEVIA)
C-----------------------------------------------------
C-
C-   Purpose and Methods : PROGRAM THAT DETERMINES THE
C-   TRACK PROJECTIONS ON THE PLANE XZ AND YZ USING
C-   ONLY CALORIMETER INFORMATION .
C-
C-   Inputs  :
C-   Outputs :
C-   Controls:
C-
C-   Created   9-FEB-1994   MIRKO BOEZIO
C-   Modified  21-FEB-2003   MIRKO BOEZIO . ADAPTED TO
C-   BE USED FOR PAMELA CALORIMETER .
C-
C------------------------------------------------------

      IMPLICIT NONE

      INCLUDE 'INTEST.TXT'

      INTEGER NVAR,NPAR
      PARAMETER (NVAR=1,NPAR=2)          
 
      REAL X(NPLA),Y(NPLA),W(NPLA)
      REAL DEVIA(2),TG(2)
      REAL BAR(2,NPLA)
      REAL A, B, VAR
      REAL PIANO(22)
      REAL VARFIT(2)

      INTEGER ICONT, M, I
      INTEGER NPFIT(2)
      
      INTEGER IBAR(2,NPLA)      
      COMMON/ANGOLO/BAR,IBAR
      SAVE /ANGOLO/

      REAL CX, CY
      COMMON/WHERE/CX,CY,PIANO
      SAVE /WHERE/

      COMMON/CALOFIT/VARFIT,NPFIT
      SAVE/CALOFIT/
C
      ICONT = 0
      DEVIA(1) = 0.
      DEVIA(2) = 0.
      CX = 0.
      CY = 0.
C
      NPFIT(1) = NPLA
      NPFIT(2) = NPLA
      VARFIT(1) = 0.
      VARFIT(2) = 0.      
C
C THE FIT IS PERFORMED WHEN THERE ARE AT LEAST TWO 
C LAYERS WITH SIGNAL . FOR THE FIT THE CLUSTER WITH THE
C HIGHEST DETECTED ENERGY IS USED . 
C
      DO M = 1,2
         ICONT = 0
         CALL VZERO(X,NPLA)
         CALL VZERO(Y,NPLA)
         CALL VZERO(W,NPLA)
         DO I = 1,NPLA
C    
            IF (MOD(M,2).EQ.0) THEN
               X(I) = PIANO(I)-5.1
            ELSE
               X(I) = PIANO(I)                  
            ENDIF
C            X(I) = -(I-1) * PIANO
            Y(I) = 0.
            IF (NCL(M,I).GE.1) THEN
               ICONT = ICONT + 1
               Y(I) = CLUS(M,I,1)
               W(I) = ((CLUS(M,I,1+NCHA/2)**0.79))**2.
               IF (W(I).GT.2000.) W(I) = 2000.
            ENDIF
            if (Y(I).eq.0.or.W(I).eq.2000.) NPFIT(M) = NPFIT(M) - 1
         ENDDO
C     
         
         A = 0.
         B = 0.
         IF (ICONT.GE.2) CALL LFITW(X,Y,W,NPLA,0,A,B,VAR)
         VARFIT(M) = VAR
         IF (M.EQ.1) CX = B
         IF (M.EQ.2) CY = B
C     
         DEVIA(M) = A
         TG(M) = A
      ENDDO
C

  500 CONTINUE
      RETURN
      END
