      SUBROUTINE CLUSTER
C----------------------------------------------------------------------
C-
C-   Purpose and Methods : IT FINDS THE NUMBER OF 
C-   CLUSTERS PER LAYER AND PER VIEW AND THE POSITION 
C-   OF THE CENTRE OF GRAVITY OF THE DETECTED ENERGY .
C-   IN THE MATRIX CLUS 2xNPLAxNCHA WE HAVE THE 
C-   CENTRES IN THE FIRST NCHA/2 ELEMENTS ORDERED FROM
C-   THE HIGHEST IN ENERGY TO THE LOWEST . THE SECOND
C-   NCHA/2 ELEMENTS ARE THE DETECTED ENERGIES IN 
C-   THESE CLUSTERS .
C-   IN THE MATRIX NCL 2xNPLA WE HAVE THE NUMBER OF 
C-   CLUSTERS PER LAYER .
C-
C-   Inputs  :
C-   Outputs :
C-   Controls:
C-
C-   Created   3-FEB-1994   MIRKO BOEZIO
C-   Modified  21-FEB-2003   MIRKO BOEZIO . INTRODUCED
C-   THE SHIFT IN THE SILICON DETECTORS PLACEMENT
C-   FOR THE CALL TO MILLIM IN BARIC .
C-
C-----------------------------------------------------
      INCLUDE 'INTEST.TXT'
      REAL QQQ(NCHA)
      INTEGER I

      COMMON /SHIFT/ SHIFT
      SAVE /SHIFT/
C
      I = 0
      DO J = 1,NPLA
        DO N = 1,2
          DO M = 1,NCHA
            CLUS(N,J,M) = 0.
          ENDDO
          NCL(N,J) = 0
        ENDDO
      ENDDO
C
      DO N = 1,2
        DO J = 1,NPLA
          DO M = 1,NCHA
            QQQ(M) = 0.
            IF (DEXY(N,J,M).GT.EMIN) THEN
              QQQ(M) = DEXY(N,J,M)
            ENDIF
          ENDDO
C
          IGIRO = 0.
C
   50     CONTINUE
C
C THE FIRST CLUSTER FOR THE LAYER J IS THAT WITH THE
C HIGHEST DETECTED ENERGY .
C
          MAX = LVMAX(QQQ,NCHA)
          IF (QQQ(MAX).LT.EMIN) GO TO 100
          MSTR = MAX
   55     CONTINUE
          MSTR = MSTR + 1
          IF (MSTR.GT.NCHA) GO TO 56
          IF (QQQ(MSTR).GT.EMIN) GO TO 55
   56     CONTINUE
          IB = MSTR - 1
C
          MSTR = MAX
   65     CONTINUE
          MSTR = MSTR - 1
          IF (MSTR.LT.1) GO TO 66
          IF (QQQ(MSTR).GT.EMIN) GO TO 65
   66     CONTINUE
          IA = MSTR + 1
C
          NN = 0
          IF (M.EQ.2) NN = 1
          IF (MOD(I,2).EQ.NN) THEN
             SHIFT = +0.5
          ELSE
             SHIFT = -0.5
          ENDIF
          CALL BARIC(QQQ,IA,IB,BAR,ENE,IERR1)
          IGIRO = IGIRO + 1
          IGI = IGIRO + NCHA / 2
          CLUS(N,J,IGIRO) = BAR
          CLUS(N,J,IGI) = ENE
C
          DO LL = IA,IB
            QQQ(LL) = 0.
          ENDDO
          GO TO 50
C
  100     CONTINUE
          NCL(N,J) = IGIRO
        ENDDO
      ENDDO
C
      RETURN
      END

C
C------------------------------------------------------
      SUBROUTINE BARIC(Q,INF,ISUP,BAR,EPLA4,INDEX)
C------------------------------------------------------
      INCLUDE 'INTEST.TXT'
      REAL Q(NCHA)
      REAL BAR

      COMMON /SHIFT/ SHIFT
      SAVE /SHIFT /

      CM = 0.
      EPLA4 = 0.
      DO LL = INF,ISUP
        ENN = Q(LL)
        IF (ENN.GT.EMIN) THEN
C
          CALL MILLIM(LL,RMM)
          CM = CM + RMM * ENN
          EPLA4 = EPLA4 + ENN
        ENDIF
      ENDDO
      IF (EPLA4.EQ.0) GO TO 300
      BAR = CM / EPLA4
      GOTO 400
C
  300 INDEX = 0
      GOTO 500
C
  400 INDEX = 1
C
  500 CONTINUE
      RETURN
      END
C
C----------------------------------------------------------------------
      SUBROUTINE CLUSTER2
C----------------------------------------------------------------------
C-
C-   Purpose and Methods : IT WORKS AS CLUSTER BUT USING TWO PARTS OF THE
C-   CALORIMETER (LAYERS 1 - 4 AND LAYERS 5 - 8) INSTEAD OF THE 8
C-   LAYERS .
C-
C-   Created   25-FEB-1995   MIRKO BOEZIO
C-   Modified  30-MAR-1995   MIRKO BOEZIO . CORRECTED AN ERROR IN THE
C-             DEFINITION OF THE TWO PARTS , OTHERWISE IT WAS LAYERS 1 - 5 AND
C-             LAYERS 6 - 8 .
C-
C----------------------------------------------------------------------
      INCLUDE 'INTEST.TXT'
      REAL QQQ(NCHA)

C
      DO J = 1,2
        DO N = 1,2
          DO M = 1,NCHA
            CLUS2(N,J,M) = 0.
          ENDDO
          NCL2(N,J) = 0
        ENDDO
      ENDDO
C
      LPIANO = NPLA / 2
C
      DO N = 1,2
        DO J = 1,2
          DO M = 1,NCHA
            QQQ(M) = 0.
            DO L = 1,NPLA
              EN = DEXY(N,L,M)
              IF (EN.GT.EMIN.AND.J.EQ.1.AND.L.LE.LPIANO) THEN
                QQQ(M) = QQQ(M) + EN
              ENDIF
              IF (EN.GT.EMIN.AND.J.EQ.2.AND.L.GT.LPIANO) THEN
                QQQ(M) = QQQ(M) + EN
              ENDIF
            ENDDO
          ENDDO
C
          IGIRO = 0.
C
   50     CONTINUE
          MAX = LVMAX(QQQ,NCHA)
          IF (QQQ(MAX).LT.EMIN) GO TO 100
          MSTR = MAX
   55     CONTINUE
          MSTR = MSTR + 1
          IF (MSTR.GT.NCHA) GO TO 56
          IF (QQQ(MSTR).GT.EMIN) GO TO 55
   56     CONTINUE
          IB = MSTR - 1
C
          MSTR = MAX
   65     CONTINUE
          MSTR = MSTR - 1
          IF (MSTR.LT.1) GO TO 66
          IF (QQQ(MSTR).GT.EMIN) GO TO 65
   66     CONTINUE
          IA = MSTR + 1
C
          CALL BARIC(QQQ,IA,IB,BAR,ENE,IERR1)
          IGIRO = IGIRO + 1
          IGI = IGIRO + NCHA / 2
          CLUS2(N,J,IGIRO) = BAR
          CLUS2(N,J,IGI) = ENE
C
          DO LL = IA,IB
            QQQ(LL) = 0.
          ENDDO
          GO TO 50
C
  100     CONTINUE
          NCL2(N,J) = IGIRO
        ENDDO
      ENDDO
C
      RETURN
      END

