//
// C/C++ headers
//
#include <iostream>
//
// ROOT headers
//
#include <TString.h>
#include <TSQLServer.h>
//
// This package headers
//
#include <MyDect2Core.h>
#include <MyDect2Verl2.h>
//
using namespace std;
//
// Usage subroutine
//
void usage(){
  printf("\nUsage:\n");
  printf("\n MyDetector2Level2 [-v] [-h] [--version] -idRun ID_RUN [-processFile filename] [-processFolder folder]\n");
  printf("\n                   [-host host] [-user username] [-psw password]\n");
  printf("\n --version       print informations about compilation and exit\n");
  printf("\n -h | --help     print this help and exit \n");
  printf("\n -v | --verbose  be verbose [default: print nothing on STDOUT]\n");
  printf("\n -idRun          ID_RUN: ID number of the run to be processed \n");
  printf("\n -processFile    filename : output filename [default ID_RUN.Level2.root]\n");
  printf("\n -processFolder  default \"mydetector2Folder\"\n");
  printf("\n -host           name for the host [default = mysql://localhost/pamelaprod]\n");
  printf("\n -user           username for the DB [default = anonymous] \n");
  printf("\n -psw            password for the DB [default = \"\"]\n");
  printf("\n Notice that parameter order does not matter. \n");
  printf("\nExample: \n\nMyDetector2Level2 -idRun 1085 -processFile nomefile.root\n\n");
};
//
bool debug = false;
//
// Here the main
//
int main(int numinp, char *inps[]){
  //
  // Variables booking
  //
  int nul = 0;
  Int_t error = 0;
  Bool_t beverbose = false;
  ULong64_t run = 0;
  TString filename;
  TSQLServer *dbc = 0;
  Bool_t givenid = false;
  TString processFolder = "mydetector2Folder";
  //
  TString host = "mysql://localhost/pamelaprod";
  TString user = "anonymous";
  TString psw = "";
  //
  // Checking input parameters
  //
  if ( numinp > 1 ){
    for ( int i = 0; i < numinp; i++ ){
      if ( !strcmp(inps[i],"--version") ){
	MyDect2Info(true);
	exit(0);
      };
      if ( !strcmp(inps[i],"-h") || !strcmp(inps[i],"--help") ){
	usage();
	exit(0);
      };
      if ( !strcmp(inps[i],"-idRun") ) {
	if ( numinp-1 < i+1 ){
	  usage();
	  exit(-3);
	};
	givenid = true;
	char *pEnd;	
	run = strtoull(inps[i+1],&pEnd,0);	
      };
      if ( !strcmp(inps[i],"-processFile") ) {
	if ( numinp-1 < i+1 ){
	  usage();
	  exit(-3);
	};
	filename = (TString)inps[i+1];	
      };
      if ( !strcmp(inps[i],"-processFolder") ) {
	if ( numinp-1 < i+1 ){
	  usage();
	  exit(-3);
	};
	processFolder = (TString)inps[i+1];	
      };
      if ( !strcmp(inps[i],"-host") ) {
	if ( numinp-1 < i+1 ){
	  usage();
	  exit(-3);
	};
	host = (TString)inps[i+1];	
      };
      if ( !strcmp(inps[i],"-user") ) {
	if ( numinp-1 < i+1 ){
	  usage();
	  exit(-3);
	};
	user = (TString)inps[i+1];	
      };
      if ( !strcmp(inps[i],"-psw") ) {
	if ( numinp-1 < i+1 ){
	  usage();
	  exit(-3);
	};
	psw = (TString)inps[i+1];	
      };
      if ( !strcmp(inps[i],"-v") || !strcmp(inps[i],"--verbose") ) beverbose = true;
    };
  } else {
    //
    // no input parameters exit with error, we need at least the run id.
    //
    printf(" MYDETECTOR2 - ERROR: you must provide a run number (at least -1)\n");
    exit(-1);
  };
  //
  // If not in verbose mode redirect to /dev/null the stdout and stderr
  //
  if ( !beverbose ){
    nul = open("/dev/null", O_CREAT | O_RDWR,S_IREAD | S_IWRITE);
    dup2(nul,1);
    dup2(nul,2);
  };
  //
  // Check that an input run number has been given
  //
  if ( !givenid ) {
    printf(" MYDETECTOR2 - ERROR: you must provide a run number (at least -1)\n");
    exit(-1);
  };
  //
  char *version = MyDect2Info(false);
  //
  // Start:
  //
  printf("\n Welcome to the MyDetector2 LEVEL2 flight software, version %s \n",version);
  //
  // Connect to the DB
  //
  printf("\nConnecting to database... \n"); 
  //
  dbc = TSQLServer::Connect(host.Data(),user.Data(),psw.Data());
  if( !dbc ) {
    printf(" MYDETECTOR2 - ERROR: problems connecting to the DB (check username and passwd), exiting...\n\n");
    exit(-2);    
  };
  bool connect = dbc->IsConnected();
  //
  if( !connect ) {
    printf(" MYDETECTOR2 - ERROR: problems connecting to the DB (check username and passwd), exiting...\n\n");
    exit(-2);    
  };
  printf("...connected! \n\n");
  //
  // Run the core program, put any output error in the "error" variable
  //
  error = MyDect2Core(run,filename,processFolder,dbc);
  //
  // Close the DB connection
  //
  printf("\nClose the connection to the database... \n");
  dbc->Close();
  printf("...connection terminated!\n\n");   
  //
  // Close redirection if the case.
  //
  if ( !beverbose ) close(nul);
  //
  // Return "error"
  //
  if ( error > 0 ) printf(" MYDETECTOR2 - WARNING: exiting with signal %i \n\n",error);
  if ( error < 0 ) printf(" MYDETECTOR2 - ERROR: exiting with signal %i \n\n",error);
  exit(error);
}
