//
// CaloMIP.cc -- standalone program to call the CaloMIP macro. 
//    by Emiliano Mocchiutti
//
//   Version 1.00 (2005/11/07)
//
// Changelog: 
//
// 0.00 - 1.00 : working.
//
#include <TString.h>
#include <stdlib.h>
#include <iostream>
//
#include <FCaloMIPfun.h>
extern void info();
using namespace std;
//
int main(int numinp, char *inps[]){
  TString name;
  TString outdir;
  TString figty;
  int view;
  int plane;
  int strip;
  int fromevent;
  int toevent;
  if ( numinp != 9 ){
    if ( numinp > 1 ){
      if ( !strcmp(inps[1],"--version") ){
	info();
	return(0);
      };
    };
    printf("\nUsage:\n\n FCaloMIP file view plane strip fromevent toevent outDir figformat \n");
    printf("\n - file                must be in the form: /path/to/filesfromyoda/dw_000000_00000/  \n");
    printf(  " - view                0 = both views, 1 = x-view, 2 = y-view \n");
    printf(  " - plane               plane number, 0 = all \n");
    printf(  " - strip               strip number, 0 = all \n");
    printf(  " - fromevent           first event to process (progressive number), 0 = first \n");
    printf(  " - toevent             last event to process (progressive number), 0 = last \n");
    printf(  " - outDir              directory where to save figures\n");
    printf(  " - figformat           format to save figures (eps,ps,root,...) \n");
    printf("\nExample: \n\nFCaloMIP /home/pamela/filesfromyoda/dw_050301_00100/ 0 0 0 0 0 /home/pamela/ ps \n\n");
    //
    return(0);
  } else {
    printf("\n Welcome to FCaloMIP! \n");
    name = (TString)inps[1];
    view = atoi(inps[2]);
    plane = atoi(inps[3]);
    strip = atoi(inps[4]);
    fromevent = atoi(inps[5]);
    toevent = atoi(inps[6]);
    outdir = (TString)inps[7];
    figty = (TString)inps[8];
  };
  //
  FCaloMIP(name,view,plane,strip,fromevent,toevent,outdir,figty);
  //
  return(0);
}
