#ifndef __caloclasses__
#define __caloclasses__

#include <TObject.h>
#include <TString.h>

class CalorimeterCalibration : public TObject {
 public:
    CalorimeterCalibration();
    Int_t  status;
    TString fname;
    Float_t mip[2][22][96];  
    Float_t ermip[2][22][96];      
    Float_t fp[4][2][22][96]; 
    Float_t fpe[4][2][22][96]; 
    Float_t chi2[2][22][96];      
    Float_t ndf[2][22][96];      
    Float_t mask[2][22][96];
    ClassDef(CalorimeterCalibration,1);
};

class CalorimeterCalibScan : public TObject {
 public:
    CalorimeterCalibScan();
    Int_t evno;
    Int_t etime[4];
    Int_t cstwerr[4];
    Float_t cperror[4];
    Float_t calped[2][22][96];
    Float_t calgood[2][22][96];
    Float_t calthr[2][22][6];
    Float_t calrms[2][22][96];
    Float_t calbase[2][22][6];
    Float_t calvar[2][22][6];
    Double_t calno;
    void Clear();
    ClassDef(CalorimeterCalibScan,1);
};

class CalorimeterLevel1 : public TObject {
 public:
    CalorimeterLevel1();
    UInt_t  obt;
    Int_t   evno;    
    Int_t   stwerr[4];    
    Int_t   nobase;
    Int_t   good[2][22][96];
    Float_t perror[4];
    Float_t nstrip;   
    Float_t qtot;
    Float_t calevnum[4];
    Float_t estrip[2][22][96];
    Float_t diffbas[2][22][6];
    ClassDef(CalorimeterLevel1,2);
};

class CalorimeterLevel2 : public TObject {
 public:
    CalorimeterLevel2();
    Int_t OBT;
    Int_t pkt_num;
    Int_t pro_num;
    Float_t trigty;
    Bool_t good;
    Bool_t perr[4];
    Bool_t swerr[4];
    Bool_t crc[4];
    Float_t nstrip;
    Float_t qtot;
    Float_t ncore;
    Float_t qcore;
    Float_t impx;
    Float_t impy;
    Float_t tanx;
    Float_t tany;
    Float_t nint;
    Float_t ncyl;
    Float_t qcyl;
    Float_t qtrack;
    Float_t qmax;
    Float_t nx22;
    Float_t qx22;
    Float_t qq[4];
    Float_t qtrackx;
    Float_t qtracky;
    Float_t dxtrack;
    Float_t dytrack;
    Float_t qlast;
    Float_t nlast;
    Float_t qpre;
    Float_t npre;
    Float_t qpresh;
    Float_t npresh;
    Float_t qlow;
    Float_t nlow;
    Float_t qtr;
    Float_t ntr;
    Int_t cibar[22][2];
    Int_t tibar[22][2];
    Float_t cbar[22][2];
    Float_t tbar[22][2];
    ClassDef(CalorimeterLevel2,1);
};

class CalorimeterADCRAW : public TObject {
 public:
    CalorimeterADCRAW();
    Int_t   evno;    
    Int_t   etime;
    Float_t estrip[2][22][96];
    Float_t diffbas[2][22][6];
    ClassDef(CalorimeterADCRAW,1);
};

#endif
