#include <TTree.h>
#include <TClassEdit.h>
#include <TObject.h>
#include <TList.h>
#include <TSystem.h>
#include <TSystemDirectory.h>
#include <TString.h>
#include <TFile.h>
#include <TClass.h>
#include <TCanvas.h>
#include <TH1.h>
#include <TH1F.h>
#include <TH2D.h>
#include <TLatex.h>
#include <TPad.h>
#include <TPaveLabel.h>
#include <TChain.h>
#include <caloclassesfun.h>
ClassImp(CalorimeterCalibration);
ClassImp(CalorimeterCalibScan);
ClassImp(CalorimeterLevel1);
ClassImp(CalorimeterLevel2);
ClassImp(CalorimeterADCRAW);

CalorimeterCalibration::CalorimeterCalibration() {    
  fname = "dw_000000_000.dat";
  status = 0;
  for (Int_t i=0; i<2;i++){
    for (Int_t j=0; j<22;j++){
      for (Int_t m=0; m<96;m++){
	mip[i][j][m] = 0.;
	ermip[i][j][m] = 0.;
	chi2[i][j][m] = 0.;
	ndf[i][j][m] = 0.;
	mask[i][j][m] = 0.;
	for (Int_t a = 0; a < 4 ; a++){
	  fp[a][i][j][m] = 0.;
	  fpe[a][i][j][m] = 0.;
	};
      };
    };	
  };        
};

CalorimeterCalibScan::CalorimeterCalibScan() {    
    calno = 0.;
    evno = 0;
    for (Int_t a = 0; a < 4 ; a++){
	etime[a] = 0;
	cperror[a] = 0.;
	cstwerr[a] = 0;
    };
    for (Int_t i=0; i<2;i++){
	for (Int_t j=0; j<22;j++){
	    for (Int_t m=0; m<96;m++){
		calped[i][j][m] = 0.;
		calgood[i][j][m] = 0.;
		calrms[i][j][m] = 0.;		
		if ( m < 6){
		    calbase[i][j][m] = 0.;
		    calthr[i][j][m] = 0.;
		    calvar[i][j][m] = 0.;
		};
	    };
	};	
    };        
};


void CalorimeterCalibScan::Clear(){
    calno = 0.;
    evno = 0;
    for (Int_t a = 0; a < 4 ; a++){
	etime[a] = 0;
	cperror[a] = 0.;
	cstwerr[a] = 0;
    };
    for (Int_t i=0; i<2;i++){
	for (Int_t j=0; j<22;j++){
	    for (Int_t m=0; m<96;m++){
		calped[i][j][m] = 0.;
		calgood[i][j][m] = 0.;
		calrms[i][j][m] = 0.;		
		if ( m < 6){
		    calbase[i][j][m] = 0.;
		    calthr[i][j][m] = 0.;
		    calvar[i][j][m] = 0.;
		};
	    };
	};	
    };         
}

CalorimeterLevel1::CalorimeterLevel1() {    
  obt = 0;
    evno = 0;
    nobase = 0;
    nstrip = 0.;
    qtot = 0.;
    for (Int_t i=0; i<2;i++){
	stwerr[i] = 0;
	perror[i] = 0.;
	calevnum[i] = 0.;
    };
    for (Int_t i=0; i<2;i++){
	for (Int_t j=0; j<22;j++){
	    for (Int_t m=0; m<96;m++){
		if ( m < 6 ) diffbas[i][j][m] = 0.;
		estrip[i][j][m] = 0.;
		good[i][j][m] = 0;
	    };
	};	
    };        
}

CalorimeterLevel2::CalorimeterLevel2() {    
    OBT = 0;
    pkt_num = 0;
    pro_num = 0;
    trigty = 0.;
    good = 0;
    nstrip = 0.;
    qtot = 0.;
   ncore = 0.;
   qcore = 0.;
   impx = 0.;
   impy = 0.;
   tanx = 0.;
   tany = 0.;
   nint = 0.;
   ncyl = 0.;
   qcyl = 0.;
   qtrack = 0.;
   qmax = 0.;
   nx22 = 0.;
   qx22 = 0.;
   qtrackx = 0.;
   qtracky = 0.;
   dxtrack = 0.;
   dytrack = 0.;
   qlast = 0.;
   nlast = 0.;
   qpre = 0.;
   npre = 0.;
   qpresh = 0.;
   npresh = 0.;
   qlow = 0.;
   nlow = 0.;
   qtr = 0.;
   ntr = 0.;
   for (Int_t i=0; i<4;i++){
	qq[i] = 0.;
	swerr[i] = 0;
	perr[i] = 0;
	crc[i] = 0;
   };        
   for (Int_t i=0; i<2;i++){
       for (Int_t j=0; j<22;j++){
	   cibar[j][i] = 0;
	   cibar[j][i] = 0;
	   cbar[j][i] = 0.;
	   tbar[j][i] = 0.;
       };
   };
};

CalorimeterADCRAW::CalorimeterADCRAW() {    
    for (Int_t i=0; i<2;i++){
	for (Int_t j=0; j<22;j++){
	    for (Int_t m=0; m<96;m++){
		if ( m < 6 ) diffbas[i][j][m] = 0.;
		estrip[i][j][m] = 0.;
	    };
	};	
    };        
};
