//
// FCaloQLOOK.cc -- standalone program to call the FCaloQLOOK macro. 
//    by Emiliano Mocchiutti
//
//   Version 1.00 (2005/02/28)
//
// Changelog:
//
// 0.00 - 1.00 : working.
//
#include <TSystem.h>
#include <iostream>
#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
//
extern void FCaloQLOOK(TString, int, int, TString, TString);
extern void info();
using namespace std;
//
void usage(){
  printf("\nUsage:\n\n FCaloQLOOK [-v] file from_event to_event output_dir figure_format \n");
  printf("\n -v               be verbose \n");  
  printf(  " file             must be in the form: /path/to/filesfromyoda/dw_000000_00000/  \n");
  printf(  " from_event       is an integer (progressive number) \n");
  printf(  " to_event         is an integer (progressive number) \n");
  printf(  " output_dir       directory where to store figures \n");
  printf(  " figure format    any format recognized by ROOT (ps,eps,gif,...)\n");
  printf("\nExample: \n\nFCaloQLOOK /home/pamela/filesfromyoda/dw_050301_00100/ 0 0 /tmp/ ps \n\n");
}

int main(int numinp, char *inps[]){
  TString name;
  TString outdir = "";
  TString format = "ps";
  int fromev = 0;
  int toev = 0;
  int nul = 0;
  bool beverbose = false;
  if ( numinp == 1 ){
    usage();
    return(0);    
  };
  if ( numinp > 1 ){
    if ( !strcmp(inps[1],"--version") ){
      info();
      return(0);
    };
    if ( !strcmp(inps[1],"-h") || !strcmp(inps[1],"--help") || numinp>7 ){
      usage();
      return(0);
    } else {
      if ( !strcmp(inps[1],"-v") || !strcmp(inps[1],"--verbose") ){
	beverbose = true;
	if ( numinp == 2 ) { 
	  info();
	  return(0);    
	};
	if ( numinp >= 3 ) name = (TString)inps[2];
	if ( numinp >= 4 ) fromev = atoi(inps[3]);
	if ( numinp >= 5 ) toev = atoi(inps[4]);
	if ( numinp >= 6 ) outdir = (TString)inps[5];
	if ( numinp == 7 ) format = (TString)inps[6];
      } else {
	if ( numinp >= 2 ) name = (TString)inps[1];
	if ( numinp >= 3 ) fromev = atoi(inps[2]);
	if ( numinp >= 4 ) toev = atoi(inps[3]);
	if ( numinp >= 5 ) outdir = (TString)inps[4];
	if ( numinp == 6 ) format = (TString)inps[5];
      };
    };
  };
  //
  if ( !beverbose ){
    //
    // redirect to /dev/null the stdout and stderr
    //
    nul = open("/dev/null", O_CREAT | O_RDWR,S_IREAD | S_IWRITE);
    dup2(nul,1);
    dup2(nul,2);
  };
  printf("\n Welcome to FCaloQLOOK! \n");
  //
  FCaloQLOOK(name,fromev,toev,outdir,format);
  //
  if ( !beverbose ) close(nul);
  //
  return(0);
}
