#include <CaloViewer.h>

//--------------------------------------
/**
 * Default constructor 
 */
CaloViewer::CaloViewer(){
  Clear();
};

CaloViewer::CaloViewer(PamLevel2 *l2p){  
  //
  Clear();
  //
  L2 = l2p;
  debug = false;
  //
};

void CaloViewer::Clear(){
  //
};

void CaloViewer::Print(){
  //
};

void CaloViewer::Delete(){
  Clear();
};

void ColorMIP(Float_t mip, int& colo){
    //    printf("mip = %f \n",mip);
    if ( colo > 0 ){
	colo = 10;
	if ( mip > 0.7  ) colo = 38;
	if ( mip > 2.   ) colo = 4;    
	if ( mip > 10.  ) colo = 3;
	if ( mip > 100. ) colo = 2;
	if ( mip > 500. ) colo = 6;
    } else {
	colo = 10;
	if ( mip > 0.7  ) colo = 17;
	if ( mip > 2.   ) colo = 15;    
	if ( mip > 10.  ) colo = 14;
	if ( mip > 100. ) colo = 13;
	if ( mip > 500. ) colo = 12;
    };
}

void CaloViewer::Draw(TString type){
  //  
  //
  gStyle->SetLabelSize(0.04);
  gStyle->SetNdivisions(510,"XY");
  //  
  TCanvas *cview = 0;
  cview = dynamic_cast<TCanvas*>(gDirectory->FindObject("cview"));
  if ( !cview ){
    cview = new TCanvas("Calorimeter viewer","Calorimeter viewer",850,950);
    cview->SetFillColor(10);
    cview->Range(0,0,100,100);
  };
  //
  if ( debug ) printf(" Processing event \n");
  //
  Clear();
  //
  cview->Clear();
  gPad->SetFrameBorderMode(0);
  //
  stringstream xview;
  stringstream yview;
  //
  // figures:
  //
  Float_t paddim = 0.88;
  Int_t bgcolor = 10;
  xview.str("");
  xview << "cv x-view event ";
  yview.str("");
  yview << "cv y-view event ";
  gDirectory->Delete(xview.str().c_str());
  gDirectory->Delete(yview.str().c_str());
  TH2F *Xview = new TH2F(xview.str().c_str(),"",96,-0.5,95.5,22,-0.5,21.5);
  TH2F *Yview = new TH2F(yview.str().c_str(),"",96,-0.5,95.5,22,-0.5,21.5);	
  //
  if ( !strcmp(type.Data(),"lego") ){
    paddim = 0.98;
  } else {
    paddim = 0.88;
  };
  gDirectory->Delete("cvpd1");
  gDirectory->Delete("cvpd2");
  gDirectory->Delete("cvpalette");
  TPad *pd1 = new TPad("cvpd1","This is pad1",0.02,0.05,paddim,0.49,bgcolor);
  TPad *pd2 = new TPad("cvpd2","This is pad2",0.02,0.51,paddim,0.95,bgcolor);
  TPad *palette = 0;
  cview->cd();
  pd1->Range(0,0,100,100);
  pd2->Range(0,0,100,100);
  pd1->SetTicks();
  pd2->SetTicks();
  pd1->Draw();
  pd2->Draw();
  if ( !strcmp(type.Data(),"box") ){
    palette = new TPad("cvpalette","This is palette",0.90,0.05,0.98,0.9,bgcolor);
    cview->cd();
    if ( dynamic_cast<TLatex*>(gDirectory->FindObject("t")) ) dynamic_cast<TLatex*>(gDirectory->FindObject("t"))->Delete();
    TLatex *t=new TLatex();
    t->SetTextFont(32);
    t->SetTextColor(1);
    t->SetTextSize(0.03);
    t->SetTextAlign(12);
    t->DrawLatex(92.,92.5,"MIP");
    palette->Range(0,0,100,100);
    palette->Draw();
    palette->cd();
    // palette
    if ( dynamic_cast<TPaveLabel*>(gDirectory->FindObject("box1")) ) dynamic_cast<TPaveLabel*>(gDirectory->FindObject("box1"))->Delete();
    TPaveLabel *box1 = new TPaveLabel(2,2,98,16.3,"0","");
    box1->SetTextFont(32);
    box1->SetTextColor(1);	
    box1->SetTextSize(0.25);	
    box1->SetFillColor(10);
    box1->Draw();
    if ( dynamic_cast<TPaveLabel*>(gDirectory->FindObject("box2")) ) dynamic_cast<TPaveLabel*>(gDirectory->FindObject("box2"))->Delete();
    TPaveLabel *box2 = new TPaveLabel(2,18.3,98,32.66,"0-2","");
    box2->SetTextFont(32);
    box2->SetTextColor(1);		
    box2->SetTextSize(0.25);	
    box2->SetFillColor(38);
    box2->Draw();
    if ( dynamic_cast<TPaveLabel*>(gDirectory->FindObject("box3")) ) dynamic_cast<TPaveLabel*>(gDirectory->FindObject("box3"))->Delete();
    TPaveLabel *box3 = new TPaveLabel(2,34.66,98,48.96,"2-10","");
    box3->SetTextFont(32);
    box3->SetTextColor(1);	
    box3->SetTextSize(0.25);	
    box3->SetFillColor(4);
    box3->Draw();
    if ( dynamic_cast<TPaveLabel*>(gDirectory->FindObject("box4")) ) dynamic_cast<TPaveLabel*>(gDirectory->FindObject("box4"))->Delete();
    TPaveLabel *box4 = new TPaveLabel(2,50.96,98,65.26,"10-100","");
    box4->SetTextFont(32);
    box4->SetTextColor(1);	
    box4->SetTextSize(0.25);	
    box4->SetFillColor(3);
    box4->Draw();
    if ( dynamic_cast<TPaveLabel*>(gDirectory->FindObject("box5")) ) dynamic_cast<TPaveLabel*>(gDirectory->FindObject("box5"))->Delete();
    TPaveLabel *box5 = new TPaveLabel(2,67.26,98,81.56,"100-500","");
    box5->SetTextFont(32);
    box5->SetTextColor(1);	
    box5->SetTextSize(0.2);	
    box5->SetFillColor(2);
    box5->Draw();
    if ( dynamic_cast<TPaveLabel*>(gDirectory->FindObject("box6")) ) dynamic_cast<TPaveLabel*>(gDirectory->FindObject("box6"))->Delete();
    TPaveLabel *box6 = new TPaveLabel(2,83.56,98,97.86,">500","");
    box6->SetTextFont(32);
    box6->SetTextColor(1);	
    box6->SetTextSize(0.25);	
    box6->SetFillColor(6);
    box6->Draw();
  };
  cview->cd();
  if ( type == "box" ) {
    pd2->cd();	   
    gStyle->SetOptStat(0);
    Xview->SetXTitle("strip");
    Xview->SetYTitle("X - plane");
    Xview->GetYaxis()->SetTitleOffset(0.5);
    Xview->SetFillColor(bgcolor);	    
    Xview->Fill(1.,1.,1.);	    
    Xview->Draw(type);
    pd2->Update();
    pd1->cd();
    gStyle->SetOptStat(0);
    Yview->SetXTitle("strip");
    Yview->SetYTitle("Y - plane");
    Yview->GetYaxis()->SetTitleOffset(0.5);	
    Yview->SetFillColor(bgcolor);	    
    Yview->Fill(1.,1.,1.);	    
    Yview->Draw(type);
    pd1->Update();
  };
  //
  // run over views and planes
  //
  Int_t m = 0;
  Int_t l = 0;
  Int_t n = 0;
  Float_t mip = 0.;
  for (Int_t i=0; i<L2->GetCaloLevel1()->istrip; i++){
    mip = L2->GetCaloLevel1()->DecodeEstrip(i,l,m,n);
    if ( l == 1 ) n = 95-n;
    m = 21-m;
    //
    // OK, now in estrip we have the energy deposit in MIP of all the strips for this event (at the end of loops of course)
    //			
    if ( type == "box" ){
      xview.str("");
      xview << "cv x-view event " << n;
      xview << " " << m;
      xview << " " << l;
      yview.str("");
      yview << "cv y-view event " << n;
      yview << " " << m;
      yview << " " << l;
      gDirectory->Delete(xview.str().c_str());
      gDirectory->Delete(yview.str().c_str());
      TH2F *Xview = new TH2F(xview.str().c_str(),"",96,-0.5,95.5,22,-0.5,21.5);
      TH2F *Yview = new TH2F(yview.str().c_str(),"",96,-0.5,95.5,22,-0.5,21.5);	
      //      TH2F *Yview = new TH2F(yview.str().c_str(),"",96,-0.5,95.5,22,21.5,-0.5);	
      Int_t colo;
      ColorMIP(mip,colo);
      Xview->SetFillColor(colo);
      Yview->SetFillColor(colo);
      if ( l == 0 ) {
	Xview->Fill(n,m,1.);
	pd2->cd();				    
	Xview->Draw("box same");
      };				    
      if ( l == 1 ) {
	Yview->Fill(n,m,1.);
	pd1->cd();
	Yview->Draw("box same");
      };
    } else {			    
      if ( l == 0 ) Xview->Fill(n,m,mip);
      if ( l == 1 ) Yview->Fill(n,m,mip);						    
    };
  };
  //
  if ( type == "lego" ){
    pd2->cd();
    gStyle->SetOptStat(0);
    Xview->SetXTitle("strip");
    Xview->SetYTitle("X - plane");
    Xview->GetXaxis()->SetTitleOffset(1.5);
    Xview->GetYaxis()->SetTitleOffset(1.5);
    Xview->SetZTitle("MIP");	
    Xview->Draw(type);
    pd2->Update();
    pd1->cd();
    gStyle->SetOptStat(0);
    Yview->SetXTitle("strip");
    Yview->SetYTitle("Y - plane");
    Yview->GetXaxis()->SetTitleOffset(1.5);
    Yview->GetYaxis()->SetTitleOffset(1.5);
    Yview->SetZTitle("MIP");
    Yview->Draw(type);
    pd1->Update();
  };
  pd2->Update();
  pd1->Update();
  cview->cd();
  cview->Update();
  //
  //
  gStyle->SetLabelSize(0);
  gStyle->SetNdivisions(1,"XY");
  //
  //
};
