/**
 * \file CaloViewer.h
 * \author Emiliano Mocchiutti
 */
#ifndef caloviewer_h
#define caloviewer_h

#include <PamLevel2.h>

#include <TTree.h>
#include <TFriendElement.h>
#include <TChain.h>
#include <TFile.h>
#include <TList.h>
#include <TKey.h>
#include <TSystemFile.h>
#include <TSystemDirectory.h>
#include <TSQLServer.h>
#include <TCanvas.h>
#include <TPad.h>
#include <TPaveLabel.h>
#include <TLatex.h>
#include <TStyle.h>
#include <TH2F.h>

#include <iostream>

using namespace std;

/**
 *
 */
class CaloViewer : public TObject {

 private:
    //
    PamLevel2 *L2;
    Bool_t debug;
    //

 public:
    //
    //
    CaloViewer();
    CaloViewer(PamLevel2 *L2);
    ~CaloViewer(){ Delete(); };
    //
    void SetDebug(Bool_t d){ debug=d; };
    //
    void Clear();
    void Clear(Option_t *option){Clear();};
    void Delete();
    void Delete(Option_t *option){Delete();};
    //
    void Draw(TString type = "box");
    void Print();
    void Print(Option_t *option){Print();};
    //
    ClassDef(CaloViewer,1);
};

#endif

