

/**
 * \file CaloPreSampler.h
 * \author Emiliano Mocchiutti (2007/07/18)
 */
#ifndef calopresampler_h
#define calopresampler_h

#include <PamLevel2.h>

#include <TTree.h>
#include <TFriendElement.h>
#include <TChain.h>
#include <TFile.h>
#include <TList.h>
#include <TKey.h>
#include <TSystemFile.h>
#include <TSystemDirectory.h>
#include <TSQLServer.h>

#include <iostream>

using namespace std;

/**
 *
 * Class to store and calculate variables useful for presampler analysis
 */
class CaloPreSampler : public TObject {

 private:
    //
    PamLevel2 *L2;
    Bool_t debug;
    //
    // needed to avoid reprocessing the same event over and over to obtain the variables;
    //
    UInt_t OBT;
    UInt_t PKT;
    UInt_t atime;
    Bool_t ssel;
    //
    Bool_t simulation; ///< True when using simulated data, false by default;
    //
    CaloLevel0 *event; ///< CaloLevel0 event needed to process data from level0/1 to level2
	//CaloLevel1 *c1; ///< CaloLevel1 event
    CaloStrip *cstrip; ///< CaloStrip object needed to easily recover parameter files
    CaloLevel2 *pcalo; ///< CaloLevel2 object which contains variables calculated with a reduced calorimeter.
    //
    Int_t N; ///< Number of W planes to be used as presampler. NOTICE: none the silicon detectors attached to these planes will be used;
    Bool_t sel; ///< Selection mode: planes from 1 to 22-N are used, plane 18 - N is masked if "emulate18" variable is true;
    Bool_t cont; ///< Contamination mode: planes from N to 22 are used;
    Bool_t emulate18; ///< If true emulates the non-working plane 18;
    //

 public:
    //
    //
    CaloLevel2* GetCaloLevel2(){ Process(); return pcalo;}; ///< Retrieve CaloLevel2 pointer which contains variables calculated with a reduced calorimeter.
    //
    void SetNoWpreSampler(Int_t n){ N=n;}; ///< Set the number of W planes to be used as presampler. NOTICE: none the silicon detectors attached to these planes will be used. Default: N = 3;
    void Selection(){sel = true; cont = false;}; ///< Set selection mode: planes from 1 to 22-N are used, plane 18 - N is masked if "emulate18" variable is true (DEFAULT);
    void Contamination(){sel = false; cont = true;}; ///< Set contamination mode: planes from N to 22 are used.
    void EmulatePlane18(Bool_t emu){emulate18 = emu;} ///< Emulates the non-working plane 18; Default = true;
    void Simulation(Bool_t sim){simulation = sim;}; ///< Set simulated data flag. Default FALSE;
    //
    CaloPreSampler();
    CaloPreSampler(PamLevel2 *L2);
    ~CaloPreSampler(){ Delete(); };
    //
    void SetDebug(Bool_t d){ debug=d; };
    //
    void Clear();
    void Clear(Option_t *option){Clear();};
    void Delete();
    //
    void Process(); ///< Process data 
    void Print();
    //
    ClassDef(CaloPreSampler,1);
};

#endif

