//
// CaloHK.cc -- standalone program to call the qlook_cal macro. 
//    by Emiliano Mocchiutti
//
//   Version 1.00 (2005/08/16)
//
// Changelog: 
//
// 0.00 - 1.00 : working.
//
#include <TSystem.h>
#include <iostream>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <cstdlib>

//

extern void qlook_cal(TString filename, TString outDir="", TString saveas = "png", Bool_t iactive =false, Bool_t w4i=false);
extern void info();
using namespace std;
//
void usage(){
  printf("\nUsage:\n\n CheckPhysEndRun [-name] file [OPTIONS] \n");
  printf("\n file             must be in the form: /path/to/filesfromyoda/ZZZ_XXX_YYYYY_cln2.root  \n");
  printf(  "                  if in the first position \"-name\" can be omitted. \n");  
  printf("\n OPTIONS: \n");  
  printf("\n -v                  be verbose \n");  
  //  printf(  " -entry entry        calibration entry to analyze [default = 0, all] \n");
  printf(  " -interactive        shows figures on the screen [default = non-interactive] \n");
  printf(  " -wait               wait for canvas to be closed before going on [default = don't wait] \n");
  //  printf(  " -matra              draw the strip rms in a box plot [default: do not draw] \n");
  printf(  " -oudDir output_dir  path of the output directory [default = ./] (with or without final '/') \n");
  printf(  " -format format      format for output file (without . )[default = png] \n");
  printf("\nExamples: ");
  printf("\n\nCheckPhysEndRun /home/pamela/filesfromyoda/dw_050301_00100.root \n");
  printf("\nCheckPhysEndRun -v -name /home/pamela/filesfromyoda/dw_050301_00100.root \n");
  printf("\nCheckPhysEndRun /home/pamela/filesfromyoda/DW_050523_01600.root -v -entry 2 -matra -outDir /tmp/ -format gif \n\n");
}

//
int main(int numinp, char *inps[]){
  TString name;
  TString outdir = "./";
  TString format = "png";
  //  int matra = 0;
  //  Long64_t calibno = 0;
  //  char *pEnd;
  int nul = 0;
  bool beverbose = false;
  Bool_t iactive = false;
  Bool_t w4i = false;

  if ( numinp > 1 ){
    name = (TString)inps[1];
    for ( int i = 0; i < numinp; i++ ){
      
      if ( !strcmp(inps[i],"--version") ){
	info();
	return(0);
      };
      if ( !strcmp(inps[i],"-h") || !strcmp(inps[i],"--help") ){
	usage();
	return(0);
      };
      if ( !strcmp(inps[i],"-name") ) {
	if ( numinp-1 < i+1 ){
	  usage();
	  exit(-3);
	};
	name = (TString)inps[i+1];
      };
      if ( !strcmp(inps[i],"-outDir") ) {
	if ( numinp-1 < i+1 ){
	  usage();
	  exit(-3);
	};
	outdir = (TString)inps[i+1];
      };
      if ( !strcmp(inps[i],"-format") ) {
	if ( numinp-1 < i+1 ){
	  usage();
	  exit(-3);
	};
	format = (TString)inps[i+1];
      };

      /*      if ( !strcmp(inps[i],"-entry") ) {
	if ( numinp-1 < i+1 ){
	  usage();
	  exit(-3);
	};
	calibno = strtoull(inps[i+1],&pEnd,0);
      };
      if ( !strcmp(inps[i],"-matra") ) {
	matra = 1;
        };*/     
      if ( !strcmp(inps[i],"-interactive") ) {
	iactive = true;
      };     
      if ( !strcmp(inps[i],"-wait") ) {
	w4i = true;
      };     
      if ( !strcmp(inps[i],"-v") || !strcmp(inps[i],"--verbose") ) beverbose = true;
    };
  } else {
    //
    // no input parameters exit with error, we need at least the run id.
    //
    usage();
    return(0);    
  };
  //
  if ( !beverbose ){
    //
    // redirect to /dev/null the stdout and stderr
    //
    nul = open("/dev/null", O_CREAT | O_RDWR,S_IREAD | S_IWRITE);
    dup2(nul,1);
    dup2(nul,2);
  };
  printf("\n Welcome to CheckPhysEndRun! \n");
  //
  qlook_cal(name,outdir, format, iactive, w4i);
  //
  if ( !beverbose ) close(nul);
  return(0);
}
