#ifndef caloshape_h
#define caloshape_h


#if !defined(__CINT__) || defined(__MAKECINT__)

#include <PamLevel2.h>

#include <TMinuit.h>
#include <TPaveStats.h>
#include <TStyle.h>
#include <TSystem.h>
#include <TCanvas.h>
#include <TGraphErrors.h>
#include <TH1F.h>
#include <TGraphErrors.h>
#include <TF2.h>
#include <TH2F.h>

#include <iostream>
#include <iomanip>
using namespace std;

#endif
///////////////////////////////////////////////////
///
///
///  CLASS FOR INITIALIZATIONS & PARAMETERS
///
///
///////////////////////////////////////////////////
class CaloShape_parameters : public TObject{

 private:
    
    CaloShape_parameters(){ SetDefault(); };
    
    static CaloShape_parameters * _parameters;

 public:

    static CaloShape_parameters *Get(){
	if(_parameters==0) {
//	    cout << "**NEW**"<<endl;
	    _parameters = new CaloShape_parameters();
	}
	return _parameters;
    }

    void SetDefault();    
    // ------
    //general
    // ------

    ClassDef(CaloShape_parameters,1);

};
///////////////////////////////////////////////////
///
///
///  CLASS INPLEMENTATION
///
///
///////////////////////////////////////////////////
class CaloShape : public TObject{

 private:
    
 public:

    int   nstrip[23];
    float qtot[23];//q
    float delta[23];//<x-x0> (=0 if evaluated relative to mean, !=0 if evaluated relative to the track)
    float rms[23];//<(x-x0)**2>
    float skew[23];//<(x-x0)**3>
    float kurt[23];//<(x-x0)**4>
    float qtrk[23];//charge along the track (3 strips)
    float mean[23];//<x>

    float qmax; //maximum energy release in a strip
    float qtotmax;//maximum energy release in a plane
    int   pmax;// plane with maximum release


    CaloShape(){ Reset(); };
    CaloShape(CaloLevel1* l1, CaloTrkVar* ca2, int view, Bool_t usemechal)
	{ Reset(); Set(l1,ca2,view,usemechal); }; 
    CaloShape(PamLevel2* l2, int ntr, int view, Bool_t usemechal)
	{ Reset(); Set(l2,ntr,view,usemechal); }; 

    bool Set(PamLevel2*,int,int,Bool_t);
    bool Set(CaloLevel1*,CaloTrkVar*,int,bool);
    void Init();
    void Reset(){ Init(); };    
    void Print();

    ClassDef(CaloShape,1);

};

#endif
