//
// CaloMATRA.cc -- standalone program to call the CaloMATRA macro. 
//    by Emiliano Mocchiutti
//
//   Version 1.00 (2005/08/16)
//
// Changelog: 
//
// 0.00 - 1.00 : working.
//
#include <TString.h>
#include <iostream>
#include <stdlib.h>
#include <FCaloMATRAfun.h>
extern void info();
using namespace std;
//
int main(int numinp, char *inps[]){
  TString name;
  TString tyhist;
  TString outdir;
  TString format;
  int from;
  int to;
  if ( numinp != 7 ){
    if ( numinp > 1 ){
      if ( !strcmp(inps[1],"--version") ){
	info();
	return(0);
      };
    };
    printf("\nUsage:\n\n FCaloMATRA file from to plot_format output_directory figure_format \n");
    printf("\n - file                must be in the form: /path/to/filesfromyoda/dw_000000_00000/  \n");
    printf(  " - from                from event (progressive number), 0 = all \n");
    printf(  " - to                  to event (progressive number), 0 = all \n");
    printf(  " - plot_format         can be box or lego \n");
    printf(  " - output_directory    where to store figures \n");
    printf(  " - figure format       any format recognized by ROOT (eps,gif,...)\n");
    printf("\nExample: \n\nFCaloMATRA /home/pamela/filesfromyoda/dw_050301_00100/ 0 0 box /tmp/ eps \n\n");
    return(0);
    //
  } else {
    printf("\n Welcome to FCaloMATRA! \n");
    name = (TString)inps[1];
    from = atoi(inps[2]);
    to = atoi(inps[3]);
    tyhist = (TString)inps[4];
    outdir = (TString)inps[5];
    format = (TString)inps[6];
  };
  //
  FCaloMATRA(name,from,to,tyhist,outdir,format);
  //
  return(0);
}
