

/**
 * \file CaloDoubleShower.h
 * \author Emiliano Mocchiutti (2007/08/09)
 */
#ifndef calodblsh_h
#define calodblsh_h

#include <PamLevel2.h>

#include <TTree.h>
#include <TFriendElement.h>
#include <TChain.h>
#include <TFile.h>
#include <TList.h>
#include <TKey.h>
#include <TSystemFile.h>
#include <TSystemDirectory.h>
#include <TSQLServer.h>

#include <iostream>
//
// Declaration of the core fortran routines
//
#define getdblsh getdblsh_
extern "C" int getdblsh();

using namespace std;

struct Calo2sh {
    Float_t pos;
    Float_t angol;
    Float_t dblsq;
    Float_t dbls;
};

/**
 *
 * Class to store and calculate variables useful for recognizing double showers in the calorimeter
 */
class CaloDoubleShower : public TObject {

 private:
    //
    PamLevel2 *L2;
    Bool_t debug;
    //
    // needed to avoid reprocessing the same event over and over to obtain the variables;
    //
    UInt_t OBT;
    UInt_t PKT;
    UInt_t atime;
    UInt_t tr;
    UInt_t sntr;
   //
    Bool_t simulation; ///< True when using simulated data, false by default;
    CaloLevel0 *event; ///< Pointer to calorimeter level0 structure needed to process the data
    CaloStrip *cstrip; ///< CaloStrip object needed to easily recover parameter files
    struct Calo2sh *c2s; ///< Fortran i/o common
    //
    Int_t dbls;///< Double shower flag: 0 : NO DOUBLE SHOWER     1  :  DOUBLE SHOWER ONLY ACCORDING TO DBLSC     3  :  TOO LITTLE BENDING FOR THE CHARGED PARTICLE AND SO NO DOUBLE SHOWER           ACCORDING TO DBLSC     10 :  DOUBLE SHOWER ONLY ACCORDING TO DUBSC     11 :  DOUBLE SHOWER ACCORDING TO DBLSC AND TO DUBSC     13 :  CASE 3 + CASE 10
    //
    Float_t qdbls;///< Energy (MIP) on the X view of the secondary shower (one not on the particle trajectory as defined by the tracker)
    //
 public:
    //
    //
    Int_t GetDblsFlag(){ Process(); return dbls;}; ///< Retrieve dbls variable
    Float_t GetDblsQ(){ Process(); return qdbls;}; ///< Retrieve qdbls variable
    //
    Bool_t IsDouble(){ Process(); if ( dbls == 11 ) return true; return false;}; ///< True if the double shower has been recognized by both the algorithms
    //
    CaloDoubleShower();
    CaloDoubleShower(PamLevel2 *L2);
    ~CaloDoubleShower(){ Delete(); };
    //
    void SetDebug(Bool_t d){ debug=d; };
    //
    void Clear();
    void Clear(Option_t *option){Clear();};
    void Delete();
    //
    void Process(UInt_t tr); ///<  Process data for track number tr 
    void Process(); ///< Process data for track number 0
    void Print(UInt_t tr);
    void Print();
    //
    void LoadMagneticField();
    //
    ClassDef(CaloDoubleShower,1);
};

#endif

