/**
 * \file CaloEnergy.h
 * \authors Emiliano Mocchiutti & Giovanna Jerse
 */
#ifndef caloenergy_h
#define caloenergy_h

#include <PamLevel2.h>

#include <TTree.h>
#include <TFriendElement.h>
#include <TChain.h>
#include <TFile.h>
#include <TList.h>
#include <TKey.h>
#include <TSystemFile.h>
#include <TSystemDirectory.h>
#include <TSQLServer.h>

#include <iostream>

using namespace std;

/**
 *
 */
class CaloEnergy : public TObject {

 private:
    //
    PamLevel2 *L2;
    Bool_t debug;
    //
    // needed to avoid reprocessing the same event over and over to obtain the variables
    //
    UInt_t OBT;
    UInt_t PKT;
    UInt_t atime;
    TString sntr;
    UInt_t AOBT;
    UInt_t APKT;
    UInt_t aatime;
    TString asntr;
    //
    Float_t fM;
    Float_t fM1;
    Float_t fPl;
    Float_t fConv_r;
    Bool_t fLong;
    //
    Float_t fEnergy;
    Float_t fCount;
    Int_t fMax_plane;
    //
    Float_t xe1;
    Float_t xe2;
    Float_t xe3;
    Float_t xe4;
    Float_t xe5;
    Float_t xe6;
    Float_t z1;
    Float_t yo1;
    Float_t yo2;
    Float_t yo3;
    Float_t yo4;
    Float_t yo5;
    Float_t yo6;
    Float_t z2;
    Float_t xo1;
    Float_t xo2;
    Float_t xo3;
    Float_t xo4;
    Float_t xo5;
    Float_t xo6;
    Float_t z3;
    Float_t ye1;
    Float_t ye2;
    Float_t ye3;
    Float_t ye4;
    Float_t ye5;
    Float_t ye6;
    Float_t z4;
    Float_t trk_z[22][2];  
    Float_t en;
    Int_t view;
    Int_t plane;
    Int_t strip;
    Float_t energyxe; 
    Float_t energyyo; 
    Float_t energyxo; 
    Float_t energyye; 
    Float_t en_xep[11];
    Float_t en_yop[11];
    Float_t en_xop[11];
    Float_t en_yep[11];
    Float_t enstrip[2][22][96];    
    //
    Bool_t fXosel;
    Bool_t fXesel;
    Bool_t fYosel;    
    Bool_t fYesel;
    Bool_t fSel;
    //
    Bool_t fSimu;
    void DefineGeometry();

 public:
    //
    CaloEnergy();
    CaloEnergy(PamLevel2 *L2);
    CaloEnergy(PamLevel2 *L2, Bool_t simulation);
    ~CaloEnergy(){ Delete(); };
    //
    void SetDebug(Bool_t d){ debug=d; };
    //
    void Clear();
    void Clear(Option_t *option){Clear();};
    void Delete();
    void Delete(Option_t *option){Delete();};
    //
    void Process();
    void Process(TString section); 
    void Print();
    void Print(Option_t *option){Print();};
    //
    Bool_t IsInsideAcceptance(TString section);
    Bool_t IsInsideAcceptance(TString section, Bool_t fast);
    //
    Bool_t IsInsideXE(){return(IsInsideAcceptance("XE"));};
    Bool_t InsideXEcheck(){return fXesel;};
    Bool_t IsInsideXO(){return(IsInsideAcceptance("XO"));};
    Bool_t InsideXOcheck(){return fXosel;};
    Bool_t IsInsideYE(){return(IsInsideAcceptance("YE"));};
    Bool_t InsideYEcheck(){return fYesel;};
    Bool_t IsInsideYO(){return(IsInsideAcceptance("YO"));};
    Bool_t InsideYOcheck(){return fYosel;};
    //
    Float_t GetEnergy(){ Process(); return fEnergy;};
    Float_t GetEnergy(TString section){ Process(section); return fEnergy;};
    Float_t GetCount(){ return fCount;};
    //
    void UseLongitudinalFitEnergy(){ fPl = 0; fLong = true;};
    void UseMeasuredEnergyUpToMax(){ fLong = false;};
    void SetMargin(Float_t margin){fM = margin; fM1 = fM - 0.122 -0.096; if ( fM1 < 0. ) fM1 = 0.;};
    void SetMaxPlaneOffset(Int_t noplanes){fPl = noplanes;};
    //
    void SetConversionFactor(Float_t conv_r){ fConv_r = conv_r;};
    //
    ClassDef(CaloEnergy,1);
};

#endif

