//
//   Show the hit distribution on each plane. Can be used to see tracks - Emiliano Mocchiutti
//
//   FCaloPLANES.cxx    version 1.01  (2006-03-08)
//
//   The only input needed is the path to the directory created by YODA for the data file you want to analyze.
//
//   Changelog:
//
//   1.00 - 1.01 (2006-03-08): Flight version, read unique YODA file.  
//
//   0.00 - 1.00 (2006-03-08): Clone of CaloPLANES v2r13.
//

#include <fstream>
#include <sstream>
#include <TTree.h>
#include <TClassEdit.h>
#include <TObject.h>
#include <TList.h>
#include <TSystem.h>
#include <TSystemDirectory.h>
#include <TString.h>
#include <TFile.h>
#include <TClass.h>
#include <TCanvas.h>
#include <TH1.h>
#include <TH1F.h>
#include <TH2D.h>
#include <TLatex.h>
#include <TPad.h>
#include <TPaveLabel.h>
#include <TChain.h>
#include <TStyle.h>
//
extern bool existfile(TString);
extern TString getFilename(const TString);
extern void PrintFigure(TString, TString, TString, TString, TCanvas&);
//
#include <caloclassesfun.h>
//
using namespace std;

void FCaloPLANES(TString filename, TString viewxy="both", TString parity="both", Int_t plane = 0, Int_t fromevent = 0, Int_t toevent = 0, TString outDir = "", TString saveas = "gif"){
    const char* startingdir = gSystem->WorkingDirectory();
    if ( !strcmp(outDir.Data(),"") ) outDir = startingdir;
    if ( !existfile(filename) ){
      printf(" %s :no such file or directory \n",filename.Data());
      printf("\n ERROR: No calorimeter LEVEL1 file! \n\n Run FCaloLEVEL1 to generate level1 data. \n\n");	
      return;
    };
    //
    TFile *File = new TFile(filename.Data());
    TTree *otr = (TTree*)File->Get("CaloLevel1");
    if ( !otr ){
      printf(" %s are you sure? I need a LEVEL1 file! \n",filename.Data());
      return;
    };
    //    
    CalorimeterLevel1 *calo = new CalorimeterLevel1();
    otr->SetBranchAddress("Event", &calo);
    //
    Long64_t nevents    = otr->GetEntries();
    //
    // input limits
    //
    Int_t minview = 0;
    Int_t maxview = 0;
    if ( viewxy != "both" && viewxy != "x" && viewxy != "y" ) {
	printf("You can choose viewxy = x, viewxy = y or viewxy = both \n");
	return;
    };
    if ( viewxy == "both" ) {
	minview = 0;
	maxview = 2;
    };
    if ( viewxy == "x" ) {
	minview = 0;
	maxview = 1;
    };
    if ( viewxy == "y" ) {
	minview = 1;
	maxview = 2;
    };


    if ( parity !="both" && parity != "odd" && parity != "even" ) {
	printf("You can choose parity = odd, parity = even or parity = both \n");
	return;
    };
    Int_t dispari = 0;
    if ( parity == "odd" ){
    	dispari = 1;
    };
    if ( parity == "even" ){
    	dispari = 0;
    };
    if ( parity == "both" ){
    	dispari = -1;
    };

    if ( plane > 11 || plane < 0 ) {
	printf("You can choose plane between 1 and 11 or plane = 0 (all)\n");
	return;
    };
    plane--;


   if ( fromevent > toevent && toevent ){
	printf("It must be fromevent < toevent \n");
	return;
    };


    if ( fromevent > nevents+1 || fromevent < 0 ) {
	printf("You can choose fromevent between 0 (all) and %i \n",(int)nevents+1);
	return;
    };

    if ( toevent > nevents+1 || toevent < 0 ) {
	printf("You can choose toevent between 0 (all) and %i \n",(int)nevents+1);
	return;
    };

    Int_t minevent;
    Int_t maxevent;
    if ( fromevent == 0 ) {
	minevent = 0;
	maxevent = nevents;
    } else {
	minevent = fromevent - 1;
	if ( toevent > 0 ){
	    maxevent = toevent - 1;
	} else {
	    maxevent = fromevent - 1;
	};
    };
    nevents = maxevent-minevent;
    Float_t fnev;
    fnev = (Float_t)(maxevent-minevent);
    //
    // run over all the events
    //
    printf("\n Processed events: \n\n");
    //
    TH1F *Plane[2][2][11];
    //TH1 *Plane[2][2][11];
    //    char *tutti="asldkalskdlasdjkafoiwhkehguierahgklshdfjkhakfhdasklkdfhksadfhkjdsblablah";
    stringstream tutti;
    stringstream plfor;
    char *uno="blablah";
    char *due="blablah";
    //    char *tre="blablah";
    for (Int_t i = 0; i < 2; i++){
	for (Int_t j = 0; j < 2; j++){
	    for (Int_t l = 0; l < 11; l++){
		//		gDirectory->Delete(Form("plane %i%i%i",i,j,l));
		//		sprintf(tre," %i ",(l+1));
		if ( i == 0 ){
		    uno = "x";
		} else {
		    uno = "y";
		};
		if ( j == 0 ){
		    due = "even";
		} else {
		    due = "odd";
		};
		//		tutti = Form("View %s %s Plane %i",uno,due,(l+1));
		tutti.str("");
		tutti << "View " << uno;
		tutti << " " << due;
		tutti << " Plane " << (l+1);
		plfor.str("");
		plfor << "plane " << i;
		plfor << j << l;
		Plane[i][j][l] = new TH1F(plfor.str().c_str(),tutti.str().c_str(),96,-0.5,95.5);
	    };
	};
    };
    Float_t energia = 0.;
    Int_t stripclu = 0;
    Float_t eclu = 0.;
    Int_t pari = 0;
    Int_t pl = 0;
    Int_t pre = -1;
    for (Int_t i = minevent; i < maxevent; i++){
	if ( i%1000 == 0 && i > 0 ) printf(" %iK \n",i/1000);	
	//
	otr->GetEntry(i);
	//
	// run over views and planes
	//
	stripclu = 0;
	eclu = 0.;
	//
	for (Int_t l = minview; l < maxview; l++){
	    for (Int_t m = 0; m < 22; m++){
		//
		// determine the section number
		//
		pari = 0;
		pl = 0;
		if (l == 0 && m%2 == 0){
		    pl = m/2;
		    pari = 0;
		};
		if (l == 0 && m%2 != 0){
		    pl = (m-1)/2;
		    pari = 1;
		    };
		if (l == 1 && m%2 == 0){
		    pl = m/2;
		    pari = 0;
		};
		if (l == 1 && m%2 != 0){
		    pl = (m-1)/2;
		    pari = 1;
		};
		//
		// run over strips
		//
		pre = -1;
		stripclu = 0;
		eclu = 0.;
		//
		//goto boh;
		//printf("qua1 ");
		for (Int_t n = 0; n < 96; n++){		    		    
		    if ( n%16 == 0 ) pre++;
		    if ( calo-> estrip[l][m][n] > 0.7  ) {
			stripclu++;
			eclu += calo->estrip[l][m][n];
		    };
		};
		//		printf("qua2 ");
		//	    boh:
		//goto boh;
		energia = 0.;
		for (Int_t n = 0; n < 96; n++){		    		    
		    if ( stripclu ) {
			if ( calo->estrip[l][m][n] > 0.7  ) {
			    energia = (calo->estrip[l][m][n]/eclu)/(fnev*(Float_t)stripclu);		    		    
			    //			    printf(" fnev %f  n %i eclu %f stripclu %f  energia = %f \n",fnev,n,eclu,(Float_t)stripclu,energia);
			    Plane[l][pari][pl]->Fill(n,energia);		   
			}
		    };
		};	
		//	    boh:
		//		printf("qua3 %i %i \n",l,m);
	    };
	};
    };   
    gStyle->SetOptStat(0);
    //    TString *file[17];
    //file = "dw_000000_000.dat";
    //file = getFilename(filename);    
    printf("\n Finished!\n");
    //
    TString fififile =  getFilename(filename);
    //    const char *file = fififile;
    //
    TPad *pd1;
    TPad *pd2;
    if ( plane >= 0 ){
	TCanvas *figura = new TCanvas("The_calorimeter_planes_hit", "The_calorimeter_planes_hit", 1100, 900);
	figura->SetFillColor(10);
	figura->Range(0,0,100,100);
	figura->cd();
	if ( dispari == -1 && viewxy == "both" ) {
	    //
	    // four figures
	    //
	    TPad *pd[2][2];
	    pd[0][0] = new TPad("pd1","This is pad1",0.02,0.02,0.49,0.49,10);
	    pd[0][1] = new TPad("pd2","This is pad2",0.51,0.02,0.98,0.49,10);
	    pd[1][0] = new TPad("pd2","This is pad3",0.02,0.51,0.49,0.98,10);
	    pd[1][1] = new TPad("pd4","This is pad4",0.51,0.51,0.98,0.98,10);
	    for (Int_t l = 0; l < 2; l++) {
		for (Int_t m = 0; m < 2; m++) {
		    figura->cd();
		    pd[l][m]->Range(0,0,100,100);
		    pd[l][m]->Draw();
		    pd[l][m]->cd();
		    Plane[l][m][plane]->GetYaxis()->SetTitleOffset(1.5);
		    pd[l][m]->SetLeftMargin(0.15);
		    Plane[l][m][plane]->SetXTitle("strip");
		    Plane[l][m][plane]->SetYTitle("Average energy released (MIP)");
		    Plane[l][m][plane]->SetFillColor(1);
		    Plane[l][m][plane]->Draw();
		    pd[l][m]->Update();
		};
	    };
	    TString figty = "planes4";
	    PrintFigure(filename,outDir,figty,saveas,*figura);
	    return;
	};
	if ( dispari == -1 || viewxy == "both" ) {
	    //
	    // two figures
	    //
	    pd1 = new TPad("pd1","This is pad1",0.02,0.02,0.49,0.98,10);
	    pd2 = new TPad("pd2","This is pad2",0.51,0.02,0.98,0.98,10);
	    figura->cd();
	    pd1->Range(0,0,100,100);
	    pd2->Range(0,0,100,100);
	    pd1->Draw();
	    pd2->Draw();
	    if ( dispari != -1 ){
		pd1->cd();
		gStyle->SetTitleFontSize(0.07);
		pd1->SetLeftMargin(0.15);
		Plane[0][dispari][plane]->GetYaxis()->SetTitleOffset(1.8);
		Plane[0][dispari][plane]->SetXTitle("strip");
		Plane[0][dispari][plane]->SetYTitle("Average energy released (MIP)");
		Plane[0][dispari][plane]->SetFillColor(1);
		Plane[0][dispari][plane]->Draw();
		pd2->cd();
		gStyle->SetTitleFontSize(0.07);
		pd2->SetLeftMargin(0.15);
		Plane[1][dispari][plane]->GetYaxis()->SetTitleOffset(1.8);
		Plane[1][dispari][plane]->SetXTitle("strip");
		Plane[1][dispari][plane]->SetYTitle("Average energy released (MIP)");
		Plane[1][dispari][plane]->SetFillColor(1);
		Plane[1][dispari][plane]->Draw();
	    }
	    if ( viewxy != "both" ){
		Int_t l = 0;
		if ( viewxy == "x" ) l = 0;
		if ( viewxy == "y" ) l = 1;
		pd1->cd();
		pd1->SetLeftMargin(0.15);
		gStyle->SetTitleFontSize(0.07);
		Plane[l][0][plane]->GetYaxis()->SetTitleOffset(1.8);
		Plane[l][0][plane]->SetXTitle("strip");
		Plane[l][0][plane]->SetYTitle("Average energy released (MIP)");
		Plane[l][0][plane]->SetFillColor(1);
		Plane[l][0][plane]->Draw();
		pd2->cd();
		gStyle->SetTitleFontSize(0.07);
		pd2->SetLeftMargin(0.15);
		Plane[l][1][plane]->GetYaxis()->SetTitleOffset(1.8);
		Plane[l][1][plane]->SetXTitle("strip");
		Plane[l][1][plane]->SetYTitle("Average energy released (MIP)");
		Plane[l][1][plane]->SetFillColor(1);
		Plane[l][1][plane]->Draw();
	    }
	    TString figty = "planes2";
	    PrintFigure(filename,outDir,figty,saveas,*figura);
	    return;
	};
	// 
	// one figure
	//
	pd1 = new TPad("pd1","This is pad1",0.02,0.02,0.98,0.98,10);
	figura->cd();
	pd1->Range(0,0,100,100);
	pd1->Draw();
	pd1->cd();
	gStyle->SetTitleFontSize(0.03);
	pd1->SetLeftMargin(0.15);
	Int_t l = 0;
	if ( viewxy == "x" ) l = 0;
	if ( viewxy == "y" ) l = 1;	
	Plane[l][dispari][plane]->GetYaxis()->SetTitleOffset(2.);
	Plane[l][dispari][plane]->SetXTitle("strip");
	Plane[l][dispari][plane]->SetYTitle("Average energy released (MIP)");
	Plane[l][dispari][plane]->SetFillColor(1);
	Plane[l][dispari][plane]->Draw();
	TString figty = "planes1";
	PrintFigure(filename,outDir,figty,saveas,*figura);
	return;
    } else {
	if ( dispari == -1 && viewxy == "both"  ){
	    //
	    // 44 figures
	    //
	    TCanvas *figura = new TCanvas("The_calorimeter_planes_hit_1", "The_calorimeter_planes_hit", 1300, 1100);
	    figura->SetFillColor(10);
	    figura->Range(0,0,100,100);
	    figura->cd();
	    TPad *pd[11][11];
	    Float_t ypos1;
	    Float_t ypos2 = 0.;
	    TLatex *t=new TLatex();
	    t->SetTextFont(32);
	    t->SetTextColor(1);
	    t->SetTextSize(0.02);
	    t->SetTextAlign(12);
	    t->DrawLatex(20.,99.,"View x odd");
	    t->DrawLatex(70.,99.,"View y even");
	    for (Int_t m = 0; m < 11; m++) {
		figura->cd();
		ypos1 = 0.01 + ypos2;
		ypos2 = 0.079 + ypos1;
		Float_t ytit = 100.*(ypos1 + (ypos2-ypos1)/2.);
		TLatex *t=new TLatex();
		t->SetTextFont(32);
		t->SetTextColor(1);
		t->SetTextSize(0.03);
		t->SetTextAlign(12);
		//char *tito;
		stringstream tito;
		tito.str("");
		tito << "pl. " << (m+1);
		//		tito = Form("pl. %i",m+1);
		t->DrawLatex(48.,ytit,tito.str().c_str());
		for (Int_t n = 0; n < 2; n++) {
		    Float_t xpos1;   
		    Float_t xpos2;
		    figura->cd();
		    if ( n == 0 ){
			xpos1 = 0.02;   
			xpos2 = 0.45;
		    } else{
			xpos1 = 0.55;
			xpos2 = 0.98;
		    };
		    pd[m][n] = new TPad("pd1","This is pad1",xpos1,ypos1,xpos2,ypos2,10);
		    pd[m][n]->Range(0,0,100,100);
		    pd[m][n]->Draw();
		    pd[m][n]->cd();
		    dispari = 0;
		    if ( n == 0 ) dispari = 1;
		    Plane[n][dispari][m]->SetXTitle("");
		    Plane[n][dispari][m]->SetYTitle("");
		    Plane[n][dispari][m]->SetTitle("");
		    Plane[n][dispari][m]->SetFillColor(1);
		    Plane[n][dispari][m]->Draw();
		};
	    };
	    TCanvas *figura2 = new TCanvas("The_calorimeter_planes_hit_2", "The_calorimeter_planes_hit", 1300, 1100);
	    figura2->SetFillColor(10);
	    figura2->Range(0,0,100,100);
	    figura2->cd();
	    //TPad *pd[11][11];
	    //	    Float_t ypos1;
	    ypos1 = 0;
	    //	    Float_t ypos2 = 0.;
	    ypos2 = 0.;
	    //TLatex *t=new TLatex();
	    t=new TLatex();
	    t->SetTextFont(32);
	    t->SetTextColor(1);
	    t->SetTextSize(0.02);
	    t->SetTextAlign(12);
	    t->DrawLatex(20.,99.,"View x even");
	    t->DrawLatex(70.,99.,"View y odd");
	    for (Int_t mu = 0; mu < 11; mu++) {
		figura2->cd();
		ypos1 = 0.01 + ypos2;
		ypos2 = 0.079 + ypos1;
		Float_t ytit = 100.*(ypos1 + (ypos2-ypos1)/2.);
		TLatex *t=new TLatex();
		t->SetTextFont(32);
		t->SetTextColor(1);
		t->SetTextSize(0.03);
		t->SetTextAlign(12);
		stringstream tato;
		tato.str("");
		tato << "pl. " << (mu+1);
		//		char *tato;
		//tato = Form("pl. %i",mu+1);
		t->DrawLatex(48.,ytit,tato.str().c_str());
		for (Int_t n = 0; n < 2; n++) {
		    figura2->cd();	
		    Float_t xpos1;   
		    Float_t xpos2;
		    if ( n == 0 ){
			xpos1 = 0.02;   
			xpos2 = 0.45;
		    } else{
			xpos1 = 0.55;
			xpos2 = 0.98;
		    };
		    pd[mu][n] = new TPad("pd1","This is pad1",xpos1,ypos1,xpos2,ypos2,10);
		    pd[mu][n]->Range(0,0,100,100);
		    pd[mu][n]->Draw();
		    pd[mu][n]->cd();
		    dispari = n;
		    Plane[n][dispari][mu]->SetXTitle("");
		    Plane[n][dispari][mu]->SetYTitle("");
		    Plane[n][dispari][mu]->SetTitle("");
		    Plane[n][dispari][mu]->SetFillColor(1);
		    Plane[n][dispari][mu]->Draw();
		};
	    };
	    TString figty = "planes22a";
	    PrintFigure(filename,outDir,figty,saveas,*figura);
	    //TString figty = "planes22b";
	    figty = "planes22b";
	    PrintFigure(filename,outDir,figty,saveas,*figura2);
	    return;
	};
	if ( dispari == -1 || viewxy == "both"  ){
	    //
	    // 22 figures
	    //
	    TCanvas *figura = new TCanvas("The_calorimeter_planes_hit", "The_calorimeter_planes_hit", 1300, 1100);
	    figura->SetFillColor(10);
	    figura->Range(0,0,100,100);
	    figura->cd();
	    TPad *pd[11][11];
	    if ( dispari == -1 ){
		Float_t ypos1;
		Float_t ypos2 = 0.;
		Int_t l = 0;
		if ( viewxy == "x" ) l = 0;
		if ( viewxy == "y" ) l = 1;
		TLatex *t=new TLatex();
		t->SetTextFont(32);
		t->SetTextColor(1);
		t->SetTextSize(0.02);
		t->SetTextAlign(12);
		//		char *titol="calcalcalcalaclaclcalca";
		stringstream titol;
		char *zuno;
		char *zdue;
		if ( viewxy == "x" ) {
		    zuno = "x";
		} else {
		    zuno = "y";
		};
		zdue ="even";
		titol.str("");
		titol << "View " << zuno;
		titol << " " << zdue;
		//		titol = Form("View %s %s",zuno,zdue);
		t->DrawLatex(20.,99.,titol.str().c_str());
		zdue ="odd";
		titol.str("");
		titol << "View " <<zuno;
		titol << " " << zdue;
		//		titol = Form("View %s %s",zuno,zdue);
		t->DrawLatex(70.,99.,titol.str().c_str());
		for (Int_t m = 0; m < 11; m++) {
		    figura->cd();
		    ypos1 = 0.01 + ypos2;
		    ypos2 = 0.079 + ypos1;
		    Float_t ytit = 100.*(ypos1 + (ypos2-ypos1)/2.);
		    TLatex *t=new TLatex();
		    t->SetTextFont(32);
		    t->SetTextColor(1);
		    t->SetTextSize(0.03);
		    t->SetTextAlign(12);
		    //		    char *tito;
		    stringstream tito;
		    tito.str("");
		    tito << "pl. " << (m+1);
		    //tito = Form("pl. %i",m+1);
		    t->DrawLatex(48.,ytit,tito.str().c_str());
		    for (Int_t n = 0; n < 2; n++) {
			figura->cd();
			Float_t xpos1;   
			Float_t xpos2;
			if ( n == 0 ){
			    xpos1 = 0.02;   
			    xpos2 = 0.45;
			} else{
			    xpos1 = 0.55;
			    xpos2 = 0.98;
			};
			pd[m][n] = new TPad("pd1","This is pad1",xpos1,ypos1,xpos2,ypos2,10);
			pd[m][n]->Range(0,0,100,100);
			pd[m][n]->Draw();
			pd[m][n]->cd();
			Plane[l][n][m]->SetXTitle("");
			Plane[l][n][m]->SetYTitle("");
			Plane[l][n][m]->SetTitle("");
			Plane[l][n][m]->SetFillColor(1);
			Plane[l][n][m]->Draw();
		    };
		};
	    } else {
		Float_t ypos1;
		Float_t ypos2 = 0.;
		TLatex *t=new TLatex();
		t->SetTextFont(32);
		t->SetTextColor(1);
		t->SetTextSize(0.02);
		t->SetTextAlign(12);
		stringstream titol;		
		//		char *titol="calcalcalcalaclaclcalca";
		char *zuno;
		char *zdue;
		if ( parity == "odd" ) {
		    zdue = "odd";
		} else {
		    zdue = "even";
		};
		zuno ="x";
		titol.str("");
		titol << "View " << zuno;
		titol << " " << zdue;
		//		titol = Form("View %s %s",zuno,zdue);
		t->DrawLatex(20.,99.,titol.str().c_str());
		zuno ="y";
		titol.str("");
		titol << "View " << zuno;
		titol << " " << zdue;
		//		titol = Form("View %s %s",zuno,zdue);
		t->DrawLatex(70.,99.,titol.str().c_str());
		for (Int_t m = 0; m < 11; m++) {
		    figura->cd();
		    ypos1 = 0.01 + ypos2;
		    ypos2 = 0.079 + ypos1;
		    Float_t ytit = 100.*(ypos1 + (ypos2-ypos1)/2.);
		    TLatex *t=new TLatex();
		    t->SetTextFont(32);
		    t->SetTextColor(1);
		    t->SetTextSize(0.03);
		    t->SetTextAlign(12);
		    //		    char *tito;
		    stringstream tito;
		    tito.str("");
		    tito << "pl. " << (m+1);
		    //		    tito = Form("pl. %i",m+1);
		    t->DrawLatex(48.,ytit,tito.str().c_str());
		    for (Int_t n = 0; n < 2; n++) {
			figura->cd();
			Float_t xpos1;   
			Float_t xpos2;
			if ( n == 0 ){
			    xpos1 = 0.02;   
			    xpos2 = 0.45;
			} else{
			    xpos1 = 0.55;
			    xpos2 = 0.98;
			};
			pd[m][n] = new TPad("pd1","This is pad1",xpos1,ypos1,xpos2,ypos2,10);
			pd[m][n]->Range(0,0,100,100);
			pd[m][n]->Draw();
			pd[m][n]->cd();
			Plane[n][dispari][m]->SetXTitle("");
			Plane[n][dispari][m]->SetYTitle("");
			Plane[n][dispari][m]->SetTitle("");
			Plane[n][dispari][m]->SetFillColor(1);
			Plane[n][dispari][m]->Draw();
		    };
		};
	    };
	    TString figty = "planes11";
	    PrintFigure(filename,outDir,figty,saveas,*figura);
	    return;
	};
	//
	// 11 figures
	//
	TCanvas *figura = new TCanvas("The_calorimeter_planes_hit", "The_calorimeter_planes_hit", 650, 1100);
	figura->SetFillColor(10);
	figura->Range(0,0,100,100);
	figura->cd();
	TPad *pd[11];
	Float_t ypos1;
	Float_t ypos2 = 0.;
	Int_t l = 0;
	if ( viewxy == "x" ) l = 0;
	if ( viewxy == "y" ) l = 1;
	TLatex *t=new TLatex();
	t->SetTextFont(32);
	t->SetTextColor(1);
	t->SetTextSize(0.03);
	t->SetTextAlign(12);
	stringstream titol;
	//	char *titol="calcalcalcalaclaclcalca";
	char *zuno;
	char *zdue;
	if ( viewxy == "x" ) {
	    zuno = "x";
	} else {
	    zuno = "y";
	};
	if ( parity == "odd" ) {
	    zdue = "odd";
	} else {
	    zdue = "even";
	};
	titol.str("");
	titol << "View " << zuno;
	titol << " " << zdue;
	//	titol = Form("View %s %s",zuno,zdue);
	t->DrawLatex(40.,99.,titol.str().c_str());
	for (Int_t m = 0; m < 11; m++) {
	    figura->cd();
	    ypos1 = 0.01 + ypos2;
	    ypos2 = 0.079 + ypos1;
	    Float_t ytit = 100.*(ypos1 + (ypos2-ypos1)/2.);
	    TLatex *t=new TLatex();
	    t->SetTextFont(32);
	    t->SetTextColor(1);
	    t->SetTextSize(0.03);
	    t->SetTextAlign(12);
	    stringstream tito;
	    tito.str("");
	    tito << "pl. " << (m+1);
	    //	    char *tito;
	    //tito = Form("pl. %i",m+1);
	    t->DrawLatex(93.,ytit,tito.str().c_str());
	    pd[m] = new TPad("pd1","This is pad1",0.02,ypos1,0.91,ypos2,10);
	    pd[m]->Range(0,0,100,100);
	    pd[m]->Draw();
	    pd[m]->cd();
	    Plane[l][dispari][m]->SetXTitle("");
	    Plane[l][dispari][m]->SetYTitle("");
	    Plane[l][dispari][m]->SetTitle("");
	    Plane[l][dispari][m]->SetFillColor(1);
	    Plane[l][dispari][m]->Draw();
	};
	TString figty = "planes11";
	PrintFigure(filename,outDir,figty,saveas,*figura);
	return;	
    };
    //
    //    caloFile->Close();
    //headerFile->Close();
    gSystem->ChangeDirectory(startingdir);
}
