/**
 * \file CaloProfile.h
 * \author Emiliano Mocchiutti
 */
#ifndef caloprofile_h
#define caloprofile_h

#include <PamLevel2.h>

#include <TTree.h>
#include <TFriendElement.h>
#include <TChain.h>
#include <TCanvas.h>
#include <TGraph.h>
#include <TH1F.h>
#include <TH2F.h>
#include <TFile.h>
#include <TPolyLine.h>
#include <TMath.h>
#include <TStyle.h>
#include <TList.h>
#include <TKey.h>
#include <TSystemFile.h>
#include <TSystemDirectory.h>
#include <TSQLServer.h>
#include <TF1.h>
#include <iostream>

using namespace std;

/**
 *
 */
class CaloLat : public TObject {

 private:
    //
    PamLevel2 *L2;
    Bool_t debug;
    //
    // needed to avoid reprocessing the same event over and over to obtain the variables
    //
    UInt_t OBT;
    UInt_t PKT;
    UInt_t atime;
    //
    Float_t estrip[2][22][96];
    //

 public:
    //
    //
    void Draw();
    void Draw(Int_t,Int_t);
    //
    CaloLat();
    CaloLat(PamLevel2 *L2);
    ~CaloLat(){ Delete(); };
    //
    void SetDebug(Bool_t d){ debug=d; };
    //
    void Clear();
    void Clear(Option_t *option){Clear();};
    void Delete();
    //
    void Process(); ///< Process data 
    void Print();
    //
    ClassDef(CaloLat,1);
};

/**
 *
 */
class CaloLong : public TObject {

 private:
    //
    PamLevel2 *L2;
    Bool_t debug;
    //
    // needed to avoid reprocessing the same event over and over to obtain the variables
    //
    UInt_t OBT;
    UInt_t PKT;
    UInt_t atime;
    //
    Float_t eplane[2][22];
    //

 public:
    //
    //
    void Draw();
    void Draw(Int_t);
    //
    CaloLong();
    CaloLong(PamLevel2 *L2);
    ~CaloLong(){ Delete(); };
    //
    void SetDebug(Bool_t d){ debug=d; };
    //
    void Clear();
    void Clear(Option_t *option){Clear();};
    void Delete();
    //
    void Process(); ///< Process data 
    void Print();
    //
    ClassDef(CaloLong,1);
};

#endif

