//
// CaloADC2MIP.cc -- standalone program to call the CaloADC2MIP macro. 
//    by Emiliano Mocchiutti
//
//   Version 1.00 (2005/08/16)
//
// Changelog: 
//
// 0.00 - 1.00 : working.
//
#include <TString.h>
#include <iostream>
extern void FCaloADC2MIP(TString, TString, TString ,TString,Int_t);
extern void info();
using namespace std;
//
int main(int numinp, char *inps[]){
  TString name;
  TString calname;
  TString list;
  TString outdir;
  Int_t fit = 1;
  if ( numinp < 5 ){
    if ( numinp == 2 ){
      if ( !strcmp(inps[1],"--version") ){
	info();
	return(0);
      };
      if ( !strcmp(inps[1],"-h") || !strcmp(inps[1],"--help") ){
	printf("\nUsage:\n\n FCaloADC2MIP file calibration_file outdir list \n");
	printf("\n - file                must be in the form: /path/to/filesfromyoda/dw_000000_00000/  \n");
	printf("\n                       or /path/to/filesfromyoda/ if a file list is given \n");
	printf("\n - calibration_file    must be in the form: /path/to/filesfromyoda/dw_000000_00000/  \n");
	printf("\n - outdir              output directory \n");
	printf("\n - list                text file containing a list of files \n");
	printf("\n                       in the form: dw_000000_00000 <new line> dw_000000_00000 ... \n");
	printf("\nExample: \n\nFCaloADC2MIP /home/pamela/filesfromyoda/dw_050301_00100/ \"\" \"\" \"\"\n\n");
	return(0);
      };
      printf(" Try with --help or -h \n");
      return(0);
    };
    if ( numinp == 1 ){
      printf("\n Welcome to FCaloADC2MIP! \n");
      //
      printf("\n You must provide the following input parameters: \n\n");
      //
      char input[256];
      //
      printf(" Path to YODA unpacked directory or to the FilesFromYoda: \n ");
      cin.getline(input,256);
      name = (TString)input;
      printf(" Path to YODA unpacked directory for a calorimeter calibration: \n ");
      cin.getline(input,256);
      calname = (TString)input;
      printf(" Output directory: \n ");
      cin.getline(input,256);
      outdir = (TString)input;
      printf(" Filename of the list of files (if any): \n ");
      cin.getline(input,256);
      list = (TString)input;
    };
  } else {
    printf("\n Welcome to FCaloADC2MIP! \n");
    name = (TString)inps[1];
    calname = (TString)inps[2];
    outdir = (TString)inps[3];
    list = (TString)inps[4];
    fit = (Int_t)inps[5];
  };
  //
  FCaloADC2MIP(name,calname,outdir,list,fit);
  //
  return(0);
}
