//
//   Check the calorimter calibrations - Emiliano Mocchiutti
//
//   FCaloCHKCALIB.c      version 1.14  (2007-07-18)
//
//   The only input needed is the path to the directory created by YODA for the data file you want to analyze.
//
//   Changelog:
//
//   1.12 - 1.14 (2007-07-18): 05953 bug fixed (infinite loop).
//
//   1.12 - 1.13 (2006-09-22): Set upper limit in calvar plot.
//
//   1.07 - 1.12 (2006-08-04): bugs fixed.
//
//   1.07 - 1.11 (2006-07-17): Adapted to flight conditions.
//
//   1.06 - 1.07 (2006-05-29): Fixed bug in output filename when input is not in the form DW_YYMMDD_NNN. Changed threshold for bad strip warning (from 0.005 to 0.03).
//
//   1.05 - 1.06 (2006-03-22): Add optimize flag in compiling the script!
//
//   1.04 - 1.05 (2006-03-22): Corrected wrong .C files.
//
//   1.03 - 1.04 (2006-03-20): Documentation updated.
//
//   1.02 - 1.03 (2006-03-20): Changed name of shared libraries (for example from FCaloQLOOK_cxx.so to libFCaloQLOOK.so).
//
//   1.01 - 1.02 (2006-03-13): Include files from YODA without "event" directory.
//
//   1.00 - 1.01 (2006-03-02): Works on YODA v6 output (single file), does not require anymore calocommon package.
//
//   0.00 - 1.00 (2006-03-02): Clone of CaloCHKCALIB.c
//
#include <iostream>
#include <fstream>
#include <cstdlib>
//
#include <TROOT.h>
#include <TTree.h>
#include <TObject.h>
#include <TString.h>
#include <TFile.h>
#include <TCanvas.h>
#include <TH1.h>
#include <TPolyLine.h>
#include <TH1F.h>
#include <TH2D.h>
#include <TLatex.h>
#include <TPad.h>
#include <TPaveLabel.h>
#include <TStyle.h>
#include <TSystem.h>
#include <TApplication.h>
//
#include <CalibCalPedEvent.h>
#include <PamelaRun.h>
//
using namespace std;
//
void stringcopy(TString& s1, const TString& s2, Int_t from=0, Int_t to=0){    
  if ( to == 0 ){
    Int_t t2length = s2.Length();
    s1 = "";
    to = t2length;
  };
  for (Int_t i = from; i<to; i++){
    s1.Append(s2[i],1);
  };
}
void stringappend(TString& s1, const TString& s2){    
  Int_t t2length = s2.Length();
  for (Int_t i = 0; i<t2length; i++){
    s1.Append(s2[i],1);
  };
}

TString getFilename(const TString filename){
  //
  const string fil = gSystem->BaseName(filename.Data());
  Int_t posiz = fil.find(".root");
  //
  TString file2;
  if ( posiz == -1 ){
    file2 = gSystem->BaseName(filename.Data());
  } else {
    Int_t posiz2 = 0;
    stringcopy(file2,gSystem->BaseName(filename.Data()),posiz2,posiz);
    TString pdat(".dat");
    stringappend(file2,pdat);  
  };
  return file2;
}

typedef struct Calib {
  Int_t iev;
  Int_t cstwerr[4];//per l'header contenente lo stato del calorimetro
  Float_t cperror[4];
  Float_t mip[2][22][96];//(xy,piano,strip)
  Float_t calped[2][22][96];
  Float_t calgood[2][22][96];
  Float_t calthr[2][22][6];
  Float_t calrms[2][22][96];
  Float_t calbase[2][22][6];
  Float_t calvar[2][22][6];
  Float_t calpuls[2][22][96];
} calib;



//main
void FCaloCHKCALIB(TString filename, Long64_t calibnumber = 0, TString outDir = "", Int_t figmatra = 0, TString saveas = "png", Bool_t iactive =false, Bool_t w4i=false){
  
  gStyle->SetPaperSize(19.,25.);
  //
  TApplication *app = 0; //crea un ambiente root (app)
  if ( iactive ) app = new TApplication("app",0,0);//verifica se deve essere interattivo
  //
  //definizione delle soglie per valutare problemi nell calibrazione
  Float_t ccalrmsthr=0.95;// numero di strip con rms entro i limiti (99%)
  Float_t ccalpedthr=0.95;// numero di strip con piedistallo entro i limiti(99%)
  Float_t ccalbadthr=0.03;// 0.005 numero massimo di strip non utilizzate (3%)  per calibrare
  Float_t ccalthrthr=0.95;
  Float_t ccalvarthr=0.95;
  Float_t ccalbasthr=0.95;
  //
  Float_t ccalrms = 0.;
  Float_t ccalped = 0.;
  Float_t ccalbad = 0.;
  Float_t ccalthr = 0.;
  Float_t ccalvar = 0.;
  Float_t ccalbas = 0.;
  //
  struct Calib calib;
  stringstream titolo, sottotitolo;
  stringstream xviewev;
  stringstream yviewev;
  
  //directory di lavoro
  const char* startingdir = gSystem->WorkingDirectory();
  if ( !strcmp(outDir.Data(),"") ) outDir = startingdir;
  
  //nome del file 
  TString fififile =  getFilename(filename);
  const char *file;
  file = fififile;
  
  //verifica se esiste il file
  ifstream myfile;
  myfile.open(filename.Data());
  if ( !myfile ){
    printf(" %s :no such file, exiting...\n\n",filename.Data());
    return;
  };
  myfile.close();
//

  //apre il file in 'File'
  TFile *File = new TFile(filename.Data());
  
  //crea struttura tree (tr) con il tree "CalibCalPed" in File
  TTree *tr = (TTree*)File->Get("CalibCalPed");
  //definisco struttura tree per caricare gli header cpu
  TTree *cpuhe = (TTree*)File->Get("CalibHeader"); 

  if ( !tr ) {
    printf(" CalibCalPed : no such tree in %s \n",filename.Data());
    printf(" Exiting, are you sure this is a LEVEL0 not corrupted file? \n\n");
    return;
  };

  pamela::CalibCalPedEvent *ce = 0;
  pamela::EventHeader *eh = 0;//definisco variabili di tipo header
  pamela::EventHeader *ch =0;//definisco la variabile per header cpu
  //  pamela::PscuHeader *ph = 0; //definisco variabile di tipo pscu

  //
  //UInt_t found;
  UInt_t  cpuobt=0, obt=0, obt0=0, obt1=0, obt2=0, obt3=0;

//  tr->SetBranchStatus("*",0,&found); //disable all branches
//
//   found = 0;
//   tr->SetBranchStatus("iev*",1,&found);
//   found = 0;
//   tr->SetBranchStatus("cstwerr*",1,&found);
//   //    printf("enabled %i branches \n",found);
//   found = 0;
//   tr->SetBranchStatus("cperror*",1,&found);
//   //printf("enabled %i branches \n",found);
//   found = 0;
//   tr->SetBranchStatus("cal*",1,&found);
//   //printf("enabled %i branches \n",found);
//   found = 0;
//   tr->SetBranchStatus("CalibCalPed*",1,&found);
  //printf("enabled %i branches \n",found);
  //
  tr->SetBranchAddress("CalibCalPed", &ce);//dichiaro in che ramo trovare quello che voglio puntare con ce
  tr->SetBranchAddress("Header", &eh);//dichiaro dove trovare quello che voglio in he
  //
  cpuhe->SetBranchAddress("Header",&ch);
  //
  Long64_t ncalibs    = tr->GetEntries();//cerca il ramo Entries (calibrazioni)
  if ( ncalibs == 0 || cpuhe->GetEntries() == 0){
    printf(" No calibrations in this files! \n Exiting... \n");
    return;
  };
  //
  UInt_t cpuhead[1000];
  memset(cpuhead, 0, 1000*sizeof(UInt_t));
  for (Int_t i=0; i<cpuhe->GetEntries(); i++){
    cpuhe->GetEntry(i);
    if ( i < 1000 ) cpuhead[i]=ch->GetPscuHeader()->GetOrbitalTime();
    if ( i > 1000 ){
      printf(" ERROR: too many calibrations in this file, cannot handle it \n Exiting... \n");
      return;
    };
  };
  //
  printf("\n This file contains %i entries which corrispond to %i calibrations \n\n",(int)ncalibs,(int)ncalibs/4);
  Long64_t minev = 0;
  Long64_t maxev = ncalibs;
  if ( calibnumber ){//calibnumber e' in ingresso nel main
    minev = (calibnumber - 1)* 4;
    maxev = minev + 4;
  };
  TCanvas *figura1;//finestra grafica che posso suddividere in piu' aree (pads)
  TCanvas *figura2 = 0;
  TCanvas *figura3;
  TCanvas *rapporto = 0;
  Int_t cmask = 127 ;//maschera per selezionare i Byte di errore dall'header
  Int_t cestw = 0;   //variabile per contenere i Byte di errore del calorimetro estratti dall'header
  Int_t ver[4][23];  //variabile per riportare gli errori(22) su ogni sezione (4)
  
  //azzera ver 
  for (Int_t k = 0; k < 4; k++ ){
    for (Int_t m = 0; m < 23 ; m++ ){
      ver[k][m] = 0 ;
    };
  };
  //
  //
  const string fil = gSystem->BaseName(filename.Data());
  Int_t posiz = fil.find(".root");
  //
  TString file2;
  if ( posiz == -1 ){
    file2 = gSystem->BaseName(filename.Data());
  } else {
    Int_t posiz2 = 0;
    stringcopy(file2,gSystem->BaseName(filename.Data()),posiz2,posiz);
  };
  const char *figrec = file2;
  //
  const char *outdir = outDir;
  const char *format = saveas;
  stringstream figsave;    //definisco stringhe i/o
  stringstream figsave1;    
  stringstream figsave2;    
  if ( !strcmp(format,"ps") ) {
    figsave.str("");
    figsave << outdir << "/" ;
    figsave << figrec << "_CaloCHKCALIB.";
    figsave << format;
    figsave << "(";
  };	    	    
  //

//-----------------inizio CHECK per ricerca errori dal calorimetro-------------------
  // to check or not to check? this is the problem...

  Bool_t check = false;//azzera flag presenza errori
  
  //
  Int_t hi = (minev/4)-1;
  //inizio loop su tutti gli header degli eventi di calibrazione
  //  for (Int_t ci = minev; ci < maxev ; ci+=4){
  Int_t ci = minev;
  while ( ci < maxev ){
    //scorre i pacchetti di 4 in 4 (cioe scorre le calibrazioni)
    Int_t incalrms = 0;
    Int_t outcalrms = 0;
    Int_t totcalbad = 0;
    Int_t incalped = 0;
    Int_t outcalped = 0;
    Int_t incalthr = 0;
    Int_t outcalthr = 0;
    Int_t incalvar = 0;
    Int_t outcalvar = 0;
    Int_t incalbas = 0;
    Int_t outcalbas = 0;
    //dall'albero calibheader, cerco obt dell cpu 
    //    cpuhe->GetEntry(ci/4);
    hi++;
    //    cpuobt=ch->GetPscuHeader()->GetOrbitalTime();
    cpuobt=cpuhead[hi];
    obt0=0;
    obt1=0;
    obt2=0;
    obt3=0;
    //
    calib.iev=0;
    memset(calib.cstwerr,0,4*sizeof(Int_t));
    memset(calib.cperror,0,4*sizeof(Float_t));
    memset(calib.calped,0,2*22*96*sizeof(Float_t));
    memset(calib.calgood,0,2*22*96*sizeof(Float_t));
    memset(calib.calrms,0,2*22*96*sizeof(Float_t));
    memset(calib.calpuls,0,2*22*96*sizeof(Float_t));
    memset(calib.calthr,0,2*22*6*sizeof(Float_t));
    memset(calib.calvar,0,2*22*6*sizeof(Float_t));
    memset(calib.calbase,0,2*22*6*sizeof(Float_t));
    //
    //inizio loop su i 4 pacchetti per ogni calibrazione (scorre 4 successivi)
    //    for ( Int_t s=0 ; s<4 ;s++  ){
    Int_t s = 0;
    obt = cpuhead[hi];
    //    printf(" qui cpu header : %i hi %i entry %i \n",obt,hi,ci);
    if ( !obt ) break;
    while ( (labs((Int_t)(obt-cpuhead[hi])) < 100000 && ci < maxev) || !cpuobt ){

      tr->GetEntry(ci);//sceglie la entry (calibrazione)del tree in cui ho tutte le sottostrutture
      //      tr->GetEntry(ci+s);//sceglie la entry (calibrazione)del tree in cui ho tutte le sottostrutture
      
      //trovo l'OBT della entry (pacchetto)
      obt=eh->GetPscuHeader()->GetOrbitalTime();//cerca orbitaltime all'interno di Pscu 
      //
      //printf(" qui pkt header : %i  \n",obt);

      ci++;
      
      if ( labs((Int_t)(obt-cpuhead[hi])) < 100000 ){

	//	s++;
	if ( ce->cstwerr[0] ) s = 0;
	if ( ce->cstwerr[1] ) s = 1;
	if ( ce->cstwerr[2] ) s = 2;
	if ( ce->cstwerr[3] ) s = 3;
	//printf(" qua pkt header : %i s = %i hi %i \n",obt,s,hi);
	//
	calib.iev = ce->iev;
	cestw = 0;
	//cstwerr e' tutto l'header della sezione, mi interessano gli ultimi 2 Byte(errori del calorimetro)
	if ( ce->cstwerr[s] ){
	  cestw =  ce->cstwerr[s] & cmask ; //confronto con la maschera per tenere solo gli 
	  ver[s][16]++;//                     ultimi 2 Byte (assegnati a cestw)
	};
	if ( cestw ){//errori dal calorimetro
	  if ( cestw & (1 << 0) ) ver[s][6]++ ;//spostati di uno e confronto se diverso 0
	  if ( cestw & (1 << 1) ) ver[s][5]++ ;
	  if ( cestw & (1 << 2) )	ver[s][4]++ ;
	  if ( cestw & (1 << 3) ) ver[s][3]++ ;
	  if ( cestw & (1 << 4) ) ver[s][2]++ ;
	  if ( cestw & (1 << 5) ) ver[s][1]++ ;
	  if ( cestw & (1 << 6) ) ver[s][0]++ ;		
	};
	if ( ce->cperror[s] != 0. ){//errori dallo spacchettamento
	  if (ce->cperror[s] == 128) ver[s][7]++ ; 
	  if (ce->cperror[s] == 129) ver[s][8]++ ;
	  if (ce->cperror[s] == 130) {
	    ver[s][9]++ ;
	    ver[s][16]--;
	  };
	  if (ce->cperror[s] == 132) ver[s][11]++ ;
	  if (ce->cperror[s] == 140) ver[s][19]++ ; 
	  if (ce->cperror[s] == 141) ver[s][20]++ ; 
	  if (ce->cperror[s] == 142) ver[s][22]++ ; 
	};
	//lato oscuro :p
	for ( Int_t d=0 ; d<11 ;d++  ){
	  Int_t pre = -1;
	  for ( Int_t j=0; j<96 ;j++){
	    if ( j%16 == 0 ) pre++;
	    if ( s == 2 ){
	      //aggiungo obt del pacchetto che sta leggendo(obt)
	      obt2=obt;
	      calib.calped[0][2*d+1][j] = ce->calped[3][d][j];
	      calib.cstwerr[3] = ce->cstwerr[3];
	      calib.cperror[3] = ce->cperror[3];
	      calib.calgood[0][2*d+1][j] = ce->calgood[3][d][j];
	      calib.calthr[0][2*d+1][pre] = ce->calthr[3][d][pre];
	      calib.calrms[0][2*d+1][j] = ce->calrms[3][d][j];
	      calib.calbase[0][2*d+1][pre] = ce->calbase[3][d][pre];
	      calib.calvar[0][2*d+1][pre] = ce->calvar[3][d][pre];
	    };
	    if ( s == 3 ){
	      obt3=obt;
	      calib.calped[0][2*d][j] = ce->calped[1][d][j];
	      calib.cstwerr[1] = ce->cstwerr[1];
	      calib.cperror[1] = ce->cperror[1];
	      calib.calgood[0][2*d][j] = ce->calgood[1][d][j];
	      calib.calthr[0][2*d][pre] = ce->calthr[1][d][pre];
	      calib.calrms[0][2*d][j] = ce->calrms[1][d][j];
	      calib.calbase[0][2*d][pre] = ce->calbase[1][d][pre];
	      calib.calvar[0][2*d][pre] = ce->calvar[1][d][pre];
	    };
	    if ( s == 0 ){
	      obt0=obt;
	      calib.calped[1][2*d][j] = ce->calped[0][d][j];
	      calib.cstwerr[0] = ce->cstwerr[0];
	      calib.cperror[0] = ce->cperror[0];
	      calib.calgood[1][2*d][j] = ce->calgood[0][d][j];
	      calib.calthr[1][2*d][pre] = ce->calthr[0][d][pre];
	      calib.calrms[1][2*d][j] = ce->calrms[0][d][j];
	      calib.calbase[1][2*d][pre] = ce->calbase[0][d][pre];
	      calib.calvar[1][2*d][pre] = ce->calvar[0][d][pre];
	    };
	    if ( s == 1 ){
	      obt1=obt;
	      calib.calped[1][2*d+1][j] = ce->calped[2][d][j];
	      calib.cstwerr[2] = ce->cstwerr[2];
	      calib.cperror[2] = ce->cperror[2];
	      calib.calgood[1][2*d+1][j] = ce->calgood[2][d][j];
	      calib.calthr[1][2*d+1][pre] = ce->calthr[2][d][pre];
	      calib.calrms[1][2*d+1][j] = ce->calrms[2][d][j];
	      calib.calbase[1][2*d+1][pre] = ce->calbase[2][d][pre];
	      calib.calvar[1][2*d+1][pre] = ce->calvar[2][d][pre];
	    };
	
	  };      
	};//chiuso for su si(sezioni)
      } else {
	ci--;
      };
    };//chiuso for su ci(eventi)
    //
    //fine CHECK
    
    //
    // Book the histograms:
    //    Int_t i = (ci-minev)/4;
    Int_t i = hi;
    xviewev.str("");
    xviewev << "x-view event " << (i+1);
    yviewev.str("");
    yviewev << "y-view event " << (i+1);
    TH2F *Xview = new TH2F(xviewev.str().c_str(),"",96,-0.5,95.5,22,-0.5,21.5);
    TH2F *Yview = new TH2F(yviewev.str().c_str(),"",96,-0.5,95.5,22,-0.5,21.5);	
   


    //prepara gli istogrammi figures:
    gDirectory->Delete("C14");
    gDirectory->Delete("C15");
    gDirectory->Delete("C16");
    //TH1F *calped = new TH1F("C14","calped",4230,-3.5,4227.5);
    //	TH1F *calrms = new TH1F("C15","calrms",4230,-3.5,4228.5);
    TH1F *calped = new TH1F("C14","C14 calped",2112,-3.5,4227.5);        //istogramma unidimensionale con valori float
    //	TH1F *calrms = new TH1F("C15","calrms",264,-2.,4226.);
    TH1F *calrms = new TH1F("C15","C15 calrms",2112,-3.5,4228.5);
    TH1F *calbad = new TH1F("C16","C16 calgood",4230,-3.5,4228.5);
    //
    gDirectory->Delete("C17");
    gDirectory->Delete("C18");
    gDirectory->Delete("C19");
    TH1F *calthr = new TH1F("C17","C17 calthr",271,-4.5,268.5);
    TH1F *calvar = new TH1F("C18","C18 calvar",271,-4.5,268.5);
    TH1F *calbase = new TH1F("C19","C19 calbase",271,-4.5,268.5);
    //
    Int_t bgcolor = 10;
    TPad *pd1 = 0;
    TPad *pd2 = 0;
    TPad *palette = 0;
    TLatex *t=new TLatex();

    //
    //pagina visualizzata solo se ci sono problemi
    if ( figmatra ){//figmatra e' variabile in ingresso in main
      figura2 = new TCanvas("Calorimeter:_strip_RMS", "Calorimeter:_strip_RMS", 750, 650);
      figura2->SetFillColor(10);
      figura2->Range(0,0,100,100);
      bgcolor = 10;
      pd1 = new TPad("pd1","This is pad1",0.02,0.05,0.88,0.49,bgcolor);
      pd2 = new TPad("pd2","This is pad2",0.02,0.51,0.88,0.95,bgcolor);
      palette = new TPad("palette","This is palette",0.90,0.05,0.98,0.90,bgcolor);
      figura2->cd();
      gStyle->SetOptStat("");
      t=new TLatex();
      t->SetTextFont(32);
      t->SetTextColor(1);
      t->SetTextSize(0.03);
      t->SetTextAlign(12);
      t->DrawLatex(90.,92.5,"ADC ch.");
      pd1->Range(0,0,100,100);
      pd2->Range(0,0,100,100);
      palette->Range(0,0,100,100);
      pd1->SetTicks();
      pd2->SetTicks();
      pd1->Draw();
      pd2->Draw();
      palette->Draw();
      palette->cd();
      // palette
      TPaveLabel *box1 = new TPaveLabel(2,2,98,14,"OFF","");
      box1->SetTextFont(32);
      box1->SetTextColor(1);	
      box1->SetTextSize(0.25);	
      box1->SetFillColor(10);
      box1->Draw();
      TPaveLabel *box2 = new TPaveLabel(2,16,98,28,"0-1.5","");
      box2->SetTextFont(32);
      box2->SetTextColor(1);		
      box2->SetTextSize(0.25);	
      box2->SetFillColor(38);
      box2->Draw();
      TPaveLabel *box3 = new TPaveLabel(2,30,98,42,"1.5-4","");
      box3->SetTextFont(32);
      box3->SetTextColor(1);	
      box3->SetTextSize(0.25);	
      box3->SetFillColor(4);
      box3->Draw();
      TPaveLabel *box4 = new TPaveLabel(2,44,98,56,"4-6.5","");
      box4->SetTextFont(32);
      box4->SetTextColor(1);	
      box4->SetTextSize(0.25);	
      box4->SetFillColor(3);
      box4->Draw();
      TPaveLabel *box5 = new TPaveLabel(2,58,98,70,"6.5-11.5","");
      box5->SetTextFont(32);
      box5->SetTextColor(1);	
      box5->SetTextSize(0.25);	
      box5->SetFillColor(2);
      box5->Draw();
      TPaveLabel *box6 = new TPaveLabel(2,72,98,84,">11.5","");
      box6->SetTextFont(32);
      box6->SetTextColor(1);	
      box6->SetTextSize(0.25);	
      box6->SetFillColor(6);
      box6->Draw();
      TPaveLabel *box7 = new TPaveLabel(2,86,98,98,"BAD","");
      box7->SetTextFont(32);
      box7->SetTextColor(10);	
      box7->SetTextSize(0.25);	
      box7->SetFillColor(1);
      box7->Draw();
      //
      pd1->cd();	   
      gStyle->SetOptStat("");
      Xview->SetXTitle("strip");
      Xview->SetYTitle("X - plane");
      Xview->GetYaxis()->SetTitleOffset(0.5);
      Xview->SetFillColor(bgcolor);	    
      Xview->Fill(1.,1.,1.);	    
      Xview->Draw("box");
      pd1->Update();
      pd2->cd();
      gStyle->SetOptStat("");
      Yview->SetXTitle("strip");
      Yview->SetYTitle("Y - plane");
      Yview->GetYaxis()->SetTitleOffset(0.5);	
      Yview->SetFillColor(bgcolor);	    
      Yview->Fill(1.,1.,1.);	    
      Yview->Draw("box");
      pd2->Update();
    };
    //
    // run over views and planes
    //verifica quali strip sono state utilizzate per la calibrazione
    Int_t j = 0;
    Int_t g = 0;
    gStyle->SetOptStat("");
    for (Int_t m = 0; m < 22; m++){//loop sui piani
      for (Int_t l = 0; l < 2; l++){//loop x y
	for (Int_t n = 0; n < 96; n++){	//loop sulle strip
	  //controlla quante strip hanno piedistallo fuori dai limiti (escludendo quelle difettose)
	  calped->Fill((float)j,calib.calped[l][m][n]);		    		    
	  if ( (calib.calped[l][m][n] > 700. || calib.calped[l][m][n] < -700.) && (j < 4032 || j > 4048) ){
	    outcalped++;
	  } else {
	    incalped++;
	  };
	  //controlla quali strip hanno rms fuori dai limiti (ponendo un limite diverso(piu' alto) per quelle difettose
	  calrms->Fill((float)j,(calib.calrms[l][m][n]/4.));		    		    
	  if ( (((calib.calrms[l][m][n]/4.) > 10. || (calib.calrms[l][m][n]/4.) < 1.) && (j < 3440 || j > 3550)) || ( (j > 3439 && j < 3551)  && ((calib.calrms[l][m][n]/4.) > 150. || (calib.calrms[l][m][n]/4.) < 1.)) ){
	    outcalrms++;
	  } else {
	    incalrms++;
	  };//controlla (conta) quali strip sono state escluse dalla calibrazione
	  calbad->Fill((float)j,(float)calib.calgood[l][m][n]);		    		    
	  if ( calib.calgood[l][m][n] ) totcalbad++;//strip(orientazione(l),piano(m),numero(n))e' nulla, aumenta il
	  //  
	  //preamplificatori(soglia max di calvar portata a 9, prima era 8)
	  if ( n < 6 ){			
	    calthr->Fill((float)g,(float)calib.calthr[l][m][n]);//controlla quali strip hanno soglia al difuori del limite(esclude)
	                                                        //(quelle difettose)
	    if ( (calib.calthr[l][m][n] > 25. || calib.calthr[l][m][n] < 12.) && (g < 215 || g > 221) ){
	      outcalthr++;
	    } else {
	      incalthr++;
	    };
	    calvar->Fill((float)g,(float)calib.calvar[l][m][n]);//controlla la varianza (esclude le difettose)
	    if ( (calib.calvar[l][m][n] > 9. || calib.calvar[l][m][n] < 1. ) && (g < 215 || g > 221) ){
	      outcalvar++;
	    } else {
	      incalvar++;
	    };
	    calbase->Fill((float)g,(float)calib.calbase[l][m][n]);//controlla baseline		    		    			
	    if ( calib.calbase[l][m][n] > 5500. || calib.calbase[l][m][n] < 2000. ){
	      outcalbas++;
	    } else {
	      incalbas++;
	    };
	    g++;//contatore preamplificatoripassa alla strip successiva (0-286)
	  };
	  //
	  j++;//contatore strip
	  
	  //istogrammi (solo se ci sono stati problemi)
	  if ( figmatra ){			
	    figura2->cd();
	    xviewev.str("");
	    xviewev << "x-view " << i;
	    xviewev << " event " << n;
	    xviewev << " " << m;
	    xviewev << " " << l;
	    yviewev.str("");
	    yviewev << "y-view " << i;
	    yviewev << " event " << n;
	    yviewev << " " << m;
	    yviewev << " " << l;
	    TH2F *Xview = new TH2F(xviewev.str().c_str(),"",96,-0.5,95.5,22,-0.5,21.5);//istogramma 2d
	    TH2F *Yview = new TH2F(yviewev.str().c_str(),"",96,-0.5,95.5,22,-0.5,21.5);			   
	    if ( calib.calrms[l][m][n] > 0 ){
	      Xview->SetFillColor(38);
	      Yview->SetFillColor(38);
	    };
	    if ( calib.calrms[l][m][n] > 6 ){
	      Xview->SetFillColor(4);
	      Yview->SetFillColor(4);
	    };
	    if ( calib.calrms[l][m][n] > 16 ){
	      Xview->SetFillColor(3);
	      Yview->SetFillColor(3);
	    };
	    if ( calib.calrms[l][m][n] > 26 ){
	      Xview->SetFillColor(2);
	      Yview->SetFillColor(2);
	    };
	    if ( calib.calrms[l][m][n] > 46 ){
	      Xview->SetFillColor(6);
	      Yview->SetFillColor(6);
	    };
	    if ( calib.calrms[l][m][n] <= 0 || calib.calrms[l][m][n] >30000 || calib.calped[l][m][n]>25000){
	      Xview->SetFillColor(10);
	      Yview->SetFillColor(10);
	    };
	    if ( calib.calgood[l][m][n] != 0 ){
	      Xview->SetFillColor(1);
	      Yview->SetFillColor(1);
	    };
	    if ( l == 0 ) {
	      Xview->Fill(n,m,1.);
	      pd1->cd();				    
	      Xview->Draw("box same");
	    };				    
	    if ( l == 1 ) {
	      Yview->Fill(n,m,1.);
	      pd2->cd();
	      Yview->Draw("box same");
	    };		    
	  };//fine istogrammi
	};//fine loop strip per piano
      };//fine loop x y
    };//fine loop piani

    //disega la figura
    if ( figmatra ){
      figura2->cd();
      gStyle->SetOptStat("");
      gStyle->SetOptDate(0);
      t=new TLatex();
      t->SetTextFont(32);
      t->SetTextColor(1);
      t->SetTextSize(0.03);
      t->SetTextAlign(12);
      titolo.str("");
      titolo << "C13 - Calorimeter: strip RMS - file ";
      titolo << file;
      titolo << " - calibration number ";
      titolo << (i+1);
      t->DrawLatex(0.5,97.,titolo.str().c_str());
      pd1->Update();
      pd2->Update();
      figura2->Update();
    };
    //fine pagina visualizzata solo se ci sono problemi
    //

    //Prepara le finestre 
       //finestra con figure C14,C15,C16
    figura1 = new TCanvas("Calorimeter_calped_calrms_calgood", "Calorimeter_calped_calrms_calgood", 750, 950);//nuova finestra
    figura1->SetFillColor(10);
    figura1->Range(0,0,100,100);
    //
    ccalped = (float)incalped/((float)outcalped + (float)incalped);
    Int_t f1pd1col = 10;//costante=10
    if ( ccalped < ccalpedthr ) { //se % strip con piedistallo buono < numero minimo segna soglia  
      check = true;	//flag per segnalare errori
      f1pd1col = 45;    // (se ci sono problemi, cambia colore)
    };
    //
    ccalrms = (float)incalrms/((float)outcalrms + (float)incalrms);
    Int_t f1pd2col = 10;
    if ( ccalrms < ccalrmsthr ) { //se % strip con rms buono< numero minimo segna errore
      check = true;	
      f1pd2col = 45;
    };
    //
    ccalbad = (float)totcalbad/4224.;
    Int_t f1pd3col = 10;
    if ( ccalbad > ccalbadthr ) { //se il numero di strip escluse dalla calibrazione e' troppo alto segna errore
      check = true;	
      f1pd3col = 45;
    };
    //
    TPad *f1pd1 = new TPad("f1pd1","This is f1pad1",0.02,0.684,0.98,0.95,f1pd1col);//prepara le pad di figura1
    TPad *f1pd2 = new TPad("f1pd2","This is f1pad2",0.02,0.367,0.98,0.634,f1pd2col);
    TPad *f1pd3 = new TPad("f1pd3","This is f1pad3",0.02,0.05,0.98,0.317,f1pd3col);
    figura1->Clear();
    figura1->cd();
    f1pd1->SetTicks();
    f1pd2->SetTicks();
    f1pd3->SetTicks();
    f1pd1->Draw();
    f1pd2->Draw();
    f1pd3->Draw();
    figura1->Draw();

       //finestra con figure C17,C18,C19 
    figura3 = new TCanvas("Calorimeter_calthr_calvar_calbase", "Calorimeter_calthr_calvar_calbase", 750, 950);
    figura3->SetFillColor(10);
    figura3->Range(0,0,100,100);
    //
    ccalthr = (float)incalthr/((float)outcalthr + (float)incalthr);
    Int_t f3pd1col = 10;
    if ( ccalthr < ccalthrthr ) { //controlla % strip fuori soglia
      check = true;	
      f3pd1col = 45;
    };
    //
    ccalvar = (float)incalvar/((float)outcalvar + (float)incalvar);
    Int_t f3pd2col = 10;
    if ( ccalvar < ccalvarthr ) { //controlla strip con varianza fuori dai limiti
      check = true;	
      f3pd2col = 45;
    };
    //
    ccalbas = (float)incalbas/((float)outcalbas + (float)incalbas);
    Int_t f3pd3col = 10;
    if ( ccalbas < ccalbasthr ) { //controlla strip con baseline fuori dai limiti
      check = true;	
      f3pd3col = 45;
    };
    //
    TPad *f3pd1 = new TPad("f3pd1","This is f3pad1",0.02,0.684,0.98,0.95,f3pd1col);//prepara le pad di figura 3
    TPad *f3pd2 = new TPad("f3pd2","This is f3pad2",0.02,0.367,0.98,0.634,f3pd2col);
    TPad *f3pd3 = new TPad("f3pd3","This is f3pad3",0.02,0.05,0.98,0.317,f3pd3col);
    figura3->Clear();//cancella tutto in figura 3
    figura3->cd();
    f3pd1->SetTicks();
    f3pd2->SetTicks();
    f3pd3->SetTicks();
    f3pd1->Draw();
    f3pd2->Draw();
    f3pd3->Draw();
    figura3->Draw();       
    

    //mette i titoli nella figura 1
    gStyle->SetOptStat("N");
    figura1->cd();
    gStyle->SetNdivisions(322,"x");
    t=new TLatex();
    t->SetTextFont(32);
    t->SetTextColor(1);
    t->SetTextSize(0.025);
    t->SetTextAlign(12);
    titolo.str("");
    titolo << "EXPERT - Calorimeter: calped/calrms/calgood - file ";
    titolo << file;
    titolo << " - calibration number ";
    titolo << (i+1);
    sottotitolo.str("");
    sottotitolo << "CPU OBT:" <<cpuobt;
    sottotitolo << " | OBT pk1:" <<obt0;
    sottotitolo << " - OBT pk2:"<<obt1;
    sottotitolo << " - OBT pk3:"<<obt2;
    sottotitolo << " - OBT pk4:"<<obt3;
    t->DrawLatex(0.5,98.,titolo.str().c_str());
    t->SetTextSize(0.02);
    t->DrawLatex(0.5,96.,sottotitolo.str().c_str());
    t->SetTextSize(0.03);
    //
    f1pd1->cd();
    //titoli al grafico calped
    calped->GetXaxis()->SetNdivisions(322);
    calped->SetXTitle("strip");
    calped->SetYTitle("ADC channels");
    calped->SetMaximum(3000.);
    calped->SetMinimum(-3000.);
//disegna istogramma calped
    calped->Draw();
    //disegna la banda di accettazione
    TPolyLine *banda1;
    Double_t xc[4] = {0.,4224.,4224.,0.};
    Double_t yc[4] = {-700.,-700.,700.,700.};
    banda1 = new TPolyLine(4,xc,yc);
    banda1->SetLineColor(5);
    banda1->SetFillColor(5);
    banda1->SetLineWidth(1);
    banda1->Draw("fSAME");
    //banda per le strip difettose
    TPolyLine *banda2;
    Double_t xc2[4] = {4031.5,4047.5,4047.5,4031.5};
    //	Double_t yc2[4] = {-2500.,-2500.,28000.,28000.};
    Double_t yc2[4] = {-3000.,-3000.,3000.,3000.};
    banda2 = new TPolyLine(4,xc2,yc2);
    banda2->SetLineColor(5);
    banda2->SetFillColor(5);
    banda2->SetLineWidth(1);
    banda2->Draw("fSAME");

    calped->Draw("SAME");
    //
    f1pd2->cd();
    //prepara grafico calrms
    f1pd2->SetLogy();
    calrms->GetXaxis()->SetNdivisions(322);
//disegna istogramma calrms
    calrms->Draw();
    //banda di accettazione
    Double_t xd[4] = {0.,4224.,4224.,0.};
    Double_t yd[4] = {1.,1.,10.,10.};
    banda1 = new TPolyLine(4,xd,yd);
    banda1->SetLineColor(5);
    banda1->SetFillColor(5);
    banda1->SetLineWidth(1);
    banda1->Draw("fSAME");

    Float_t minrm = calrms->GetMinimum();
    Float_t maxrm = calrms->GetMaximum();
    Double_t xrm2[4] = {3449.,3551.,3551.,3449.};
    Double_t yrm2[4] = {minrm,minrm,maxrm,maxrm};
    //banda per strip difettose
    banda2 = new TPolyLine(4,xrm2,yrm2);
    banda2->SetLineColor(5);
    banda2->SetFillColor(5);
    banda2->SetLineWidth(1);
    banda2->Draw("fSAME");

    calrms->SetXTitle("strip");
    calrms->SetYTitle("ADC channels");

    calrms->Draw("SAME");
    //prepara grafico calbad
    f1pd3->cd();
    gStyle->SetNdivisions(344,"x");
    calbad->GetXaxis()->SetNdivisions(322);
//disegna calbad
    calbad->Draw();
    calbad->SetXTitle("strip");
    calbad->SetYTitle("0=good 255=bad");
    //
    f1pd1->Update();
    f1pd2->Update();
    f1pd3->Update();
    figura1->Update();
    //

    
//pagina con figure C17,C18,C19
    figura3->cd();
    gStyle->SetNdivisions(644,"x");
    t=new TLatex();
    t->SetTextFont(32);
    t->SetTextColor(1);
    t->SetTextSize(0.025);
    t->SetTextAlign(12);
    titolo.str("");
    titolo << "EXPERT - Calorimeter: calthr/calvar/calbase - file ";
    titolo << file;
    titolo << " - calibration number ";
    titolo << (i+1);
    t->DrawLatex(0.5,98.,titolo.str().c_str());
    t->SetTextSize(0.02);
    t->DrawLatex(0.5,96.,sottotitolo.str().c_str());
    t->SetTextSize(0.03);
    //
    f3pd1->cd();
    calthr->GetXaxis()->SetNdivisions(644);
    calthr->SetXTitle("pre-amplifier");
    calthr->SetYTitle("ADC channels");
    calthr->Draw();
    Double_t xe[4] = {0.,264.,264.,0.};
    Double_t ye[4] = {12.,12.,25.,25.};
    banda1 = new TPolyLine(4,xe,ye);
    banda1->SetLineColor(5);
    banda1->SetFillColor(5);
    banda1->SetLineWidth(1);
    banda1->Draw("fSAME");

    minrm = calthr->GetMinimum();
    maxrm = 1.05*calthr->GetMaximum();
    Double_t xth2[4] = {215.,221.,221.,215.};
    Double_t yth2[4] = {minrm,minrm,maxrm,maxrm};
    banda2 = new TPolyLine(4,xth2,yth2);
    banda2->SetLineColor(5);
    banda2->SetFillColor(5);
    banda2->SetLineWidth(1);
    banda2->Draw("fSAME");
    //
    calthr->Draw("SAME");


    f3pd2->cd();
    //	gPad->SetLogy();
    //banda di soglia per calvar portata a 9, prima era a 8)
    calvar->SetMaximum(25.);
    calvar->GetXaxis()->SetNdivisions(644);
    calvar->SetXTitle("pre-amplifier");
    calvar->SetYTitle("ADC channels");
    calvar->Draw();
    Double_t xt[4] = {0.,264.,264.,0.};
    Double_t yt[4] = {1.,1.,9.,9.};
    banda1 = new TPolyLine(4,xt,yt);
    banda1->SetLineColor(5);
    banda1->SetFillColor(5);
    banda1->SetLineWidth(1);
    banda1->Draw("fSAME");

    minrm = calvar->GetMinimum();
    maxrm = 1.05*calvar->GetMaximum();
    Double_t xva2[4] = {215.,221.,221.,215.};
    Double_t yva2[4] = {minrm,minrm,maxrm,maxrm};
    banda2 = new TPolyLine(4,xva2,yva2);
    banda2->SetLineColor(5);
    banda2->SetFillColor(5);
    banda2->SetLineWidth(1);
    banda2->Draw("fSAME");
    //
    calvar->Draw("SAME");


    f3pd3->cd();
    calbase->GetXaxis()->SetNdivisions(644);
    calbase->SetXTitle("pre-amplifier");
    calbase->SetYTitle("ADC channels");
    calbase->Draw();
    Double_t xg[4] = {0.,264.,264.,0.};
    Double_t yg[4] = {2000.,2000.,5500.,5500.};
    banda1 = new TPolyLine(4,xg,yg);
    banda1->SetLineColor(5);
    banda1->SetFillColor(5);
    banda1->SetLineWidth(1);
    banda1->Draw("fSAME");
    calbase->Draw("SAME");
    //
    f3pd1->Update();
    f3pd2->Update();
    f3pd3->Update();
    figura3->Update();
    //
    //file output
    if ( !strcmp(format,"ps") ) {
      if ( figmatra ) {
	figura2->Print(figsave.str().c_str(),"Portrait");
	if ( ci == minev ) {
	  figsave.str("");
	  figsave << outdir << "/" ;
	  figsave << figrec << "_CaloCHKCALIB.";
	  figsave << format;
	};
      };
      //
      figura1->Print(figsave.str().c_str(),"Portrait");
      if ( ci == minev ) {
	figsave.str("");
	figsave << outdir << "/" ;
	figsave << figrec << "_CaloCHKCALIB.";
	figsave << format;
      };
      //	    
      figura3->Print(figsave.str().c_str(),"Portrait");
      //
    } else {
      if ( figmatra ) {
	figsave.str("");
	figsave << outdir << "/" ;
	figsave << figrec << "_CaloCHKCALIB1_";
	figsave << (i+1) << ".";
	figsave << format;
	figura2->SaveAs(figsave.str().c_str());
      };
      //
      figsave1.str("");
      figsave1 << outdir << "/" ;
      figsave1 << figrec << "_CaloCHKCALIB2_";
      figsave1 << (i+1) << ".";
      figsave1 << format;
      figura1->SaveAs(figsave1.str().c_str());
      //
      figsave2.str("");
      figsave2 << outdir << "/" ;
      figsave2 << figrec << "_CaloCHKCALIB3_";
      figsave2 << (i+1) << ".";
      figsave2 << format;
      figura3->SaveAs(figsave2.str().c_str());
      //
    }; 
    if ( iactive && w4i ){
      while ( gROOT->GetListOfCanvases()->FindObject(figura2) || gROOT->GetListOfCanvases()->FindObject(figura1) || gROOT->GetListOfCanvases()->FindObject(figura3) ){
	gSystem->ProcessEvents();
	gSystem->Sleep(10);
      };
    };
  };//fine del loop sulle calibrazioni
  //
  //
  //
  //
  //  report sheet:
  //
  stringstream errore;
  rapporto= new TCanvas("Calorimeter calibration report", "Calorimeter calibration report", 750, 950);
  rapporto->cd();
  rapporto->SetFillColor(10);
  rapporto->Range(0,0,100,100);
  TLatex *t=new TLatex();
  t->SetTextFont(32);
  t->SetTextColor(1);
  t->SetTextSize(0.035);
  t->SetTextAlign(12);
  errore.str("");
  errore << "BASIC - C20 - Calibrations in file: " << file;
  errore << " ";
  t->SetTextSize(0.02);
  t->DrawLatex(2.,99.,errore.str().c_str());
  //
  TPad *pad1;
  TPad *pad2;
  TPad *pad3;
  TPad *pad4;
  pad1 = new TPad("pad1","This is pad1",0.02,0.47,0.49,0.90,19);
  pad2 = new TPad("pad2","This is pad2",0.51,0.47,0.98,0.90,19);
  pad3 = new TPad("pad3","This is pad3",0.02,0.02,0.49,0.45,19);
  pad4 = new TPad("pad4","This is pad4",0.51,0.02,0.98,0.45,19);
  pad1->Range(0,0,100,100);
  pad2->Range(0,0,100,100);
  pad3->Range(0,0,100,100);
  pad4->Range(0,0,100,100);
  //
  pad1->Draw();
  pad2->Draw();
  pad3->Draw();
  pad4->Draw();
  //
  const char *sezione = "";
  for (Int_t si = 0; si < 4; si++){
    if (si == 2) 
      { 
	pad1->cd() ; 
	sezione = "** Section YE (x even) **";
      }
    if (si == 3) 
      {
	pad2->cd();
	sezione = "** Section YO (x odd) **";
      }
    if (si == 0)
      {
	pad3->cd();
	sezione = "** Section XE (y odd) **";
      }
    if (si == 1)
      {
	pad4->cd();
	sezione = "** Section XO (y even) **";
      }
    t->SetTextFont(32);
    t->SetTextColor(1); 
    t->SetTextSize(0.05); 
    t->SetTextAlign(12);
    t->DrawLatex(33.,97.,sezione);
    t->SetTextSize(0.05); 

    //scorre ver cercando il j tipo di errore: 'si'=sezione   
    for (Int_t j = 0; j < 23; j++){
      if ( ver[si][j] ) {//controlla se le sezioni di ver[si][j] sonoe diverse da zero.
	t->SetTextColor(50); //controlla quali sono !=0 e assegna il rispettivo errore
	if (j == 0) {//del calorimetro
	  errore.str("");
	  errore << "* DSP ack error: " << ver[si][j];
	  errore << " time(s)";
	  t->DrawLatex(2.,30.,errore.str().c_str());
	  check = true;	
	}
	if (j == 1) {//calorimetro
	  errore.str("");
	  errore << "* Temperature alarm: " << ver[si][j];
	  errore << " time(s)";
	  t->DrawLatex(2.,74.,errore.str().c_str());
	  check = true;	
	}
	if (j == 2) {//calorimetro
	  errore.str("");
	  errore << "* Latch up alarm: " << ver[si][j];
	  errore << " time(s).";
	  t->DrawLatex(2.,65.,errore.str().c_str());
	  check = true;	
	}
	if (j == 3) {//calorimetro
	  errore.str("");
	  errore << "RAW mode: " << ver[si][j];
	  errore << " time(s)";
	  t->SetTextColor(38); 
	  t->DrawLatex(2.,90.,errore.str().c_str());
	}
	if (j == 4) {//calorimetro
	  errore.str("");
	  errore << "* CMD length error: " << ver[si][j];
	  errore << " time(s)";
	  t->DrawLatex(2.,66.,errore.str().c_str());
	  check = true;	
	}	       
	if (j == 5) {//calorimetro
	  errore.str("");
	  errore << "* Execution error: " << ver[si][j];
	  errore << " time(s)";
	  t->DrawLatex(2.,62.,errore.str().c_str());
	  check = true;	
	}
	if (j == 6) {//calorimetro
	  errore.str("");
	  errore << "* CRC error (st. word): " << ver[si][j];
	  errore << " time(s)";
	  t->DrawLatex(2.,58.,errore.str().c_str());
	  check = true;	
	}
	if (j == 7) {
	  errore.str("");
	  errore << "View or command not recognized: " << ver[si][j];
	  errore << " time(s)";
	  t->DrawLatex(2.,54.,errore.str().c_str());
	  check = true;	
	}
	//
	if (j == 8) {
	  errore.str("");
	  errore << "Missing section: " << ver[si][j];
	  errore << " time(s)";
	  t->DrawLatex(2.,50.,errore.str().c_str());
	  check = true;	
	}
	if (j == 9) {
	  errore.str("");
	  errore << "RAW MODE COMMAND: " << ver[si][j];
	  errore << " time(s)";
	  t->DrawLatex(2.,42.,errore.str().c_str());
	} 
	if (j == 11) {
	  errore.str("");
	  errore << "CRC error (data): " << ver[si][j];
	  errore << " time(s)";
	  t->DrawLatex(2.,38.,errore.str().c_str());
	  check = true;	
	}
	if (j == 16) {
	  errore.str("");
	  errore << "Number of calibrations: " << ver[si][j];
	  t->SetTextColor(38); 
	  t->DrawLatex(2.,86.,errore.str().c_str());
	}
	if (j == 19) {
	  errore.str("");
	  errore << "Pedestal checksum wrong: " << ver[si][j];
	  errore << " time(s)";
	  t->DrawLatex(2.,14.,errore.str().c_str());
	  check = true;	
	}
	if (j == 20) {
	  errore.str("");
	  errore << "Thresholds checksum wrong: " << ver[si][j];
	  errore << " time(s)";
	  t->DrawLatex(2.,10.,errore.str().c_str());
	  check = true;	
	}
	if (j == 22) { 
	  errore.str("");
	  errore << "Packet length is zero (YODA input error), skipped: " << ver[si][j];
	  errore << " time(s)";
	  t->DrawLatex(2.,3.,errore.str().c_str());
	  check = true;	
	};
      };
    }; 
  };
  rapporto->cd();
  t->SetTextFont(32);
  t->SetTextColor(1);
  t->SetTextSize(0.035);
  t->SetTextAlign(12);
  t->DrawLatex(7.,95.,"Calorimeter CALIBRATION quick look: ");
  printf(" ccalped %f ccalrms %f ccalbad %f ccalthr %f ccalvar %f ccalbas %f \n",ccalped,ccalrms,ccalbad,ccalthr,ccalvar,ccalbas);


  if ( check ) {
    t->SetTextColor(50);
    t->DrawLatex(65.,95.,"WARNING, CHECK!");		
    t->SetTextColor(1);
  } else {
    t->SetTextColor(38);
    t->DrawLatex(65.,95.,"OK!");
    t->SetTextColor(1);
  };     
  rapporto->Update();
  //
  if ( !strcmp(format,"ps") ) {
    figsave.str("");
    figsave << outdir << "/" ;
    figsave << figrec << "_CaloCHKCALIB.";
    figsave << format;
    figsave << ")";
    rapporto->Print(figsave.str().c_str(),"Portrait");
  } else {
    figsave.str("");
    figsave << outdir << "/" ;
    figsave << figrec << "_CaloCHKCALIB_report.";
    figsave << format;
    rapporto->SaveAs(figsave.str().c_str());
  };
  if ( iactive && w4i ){
    while ( gROOT->GetListOfCanvases()->FindObject(rapporto) ){
      gSystem->ProcessEvents();
      gSystem->Sleep(10);
    };
  };
  printf("\n");	
  return;
}
	
