***********************************************************************
*
C     
C     DBLSC AND DUBSC (LOOK AT THE ROUTINES FOR MORE EXPLANATIONS) , ROUTINES TO
C     CHECK FOR DOUBLE SHOWER . DBLS IS THE CONTROL FLAG . MEANING :
C     0  :  NO DOUBLE SHOWER
C     1  :  DOUBLE SHOWER ONLY ACCORDING TO DBLSC
C     3  :  TOO LITTLE BENDING FOR THE CHARGED PARTICLE AND SO NO DOUBLE SHOWER
C           ACCORDING TO DBLSC
C     10 :  DOUBLE SHOWER ONLY ACCORDING TO DUBSC
C     11 :  DOUBLE SHOWER ACCORDING TO DBLSC AND TO DUBSC
C     13 :  CASE 3 + CASE 10
C     
*
*****************************************************************************
      INTEGER FUNCTION GETDBLSH()
c
      IMPLICIT NONE
C
      INCLUDE 'INTEST.TXT'
C
C Normal variables definition
C
C
      DOUBLE PRECISION al_p(5),
     &     xout(nplav),yout(nplav),zin(nplav)
C
      REAL POS, ANGOL, DEVT
      REAL DIFX, EQQ,DBLS
      REAL DBLSQ,RIMP
      REAL CX,CY, PIANO(NPLAV)
      REAL BAR(2,NPLAV),DISTX,SHIFT
C
      INTEGER IBAR(2,NPLAV)
      INTEGER I,J,M,IFAIL,NN
      INTEGER INDIC
c      integer getdblsh
C
      COMMON /SDOUBLE/ POS,ANGOL,DBLSQ,DBLS
      SAVE /SDOUBLE/
C
      COMMON / WHERE / CX, CY, PIANO
      SAVE / WHERE /
C
      COMMON / ANGOLO / BAR, IBAR
      SAVE / ANGOLO /
C
C         
C Begin !
C     
      getdblsh = 0
      PIANO(1) = 0.
      DO I = 2, NPLA
         IF ( MOD(I,2).EQ.0 ) THEN 
            PIANO(I) = PIANO(I-1) - 8.09
         ELSE
            PIANO(I) = PIANO(I-1) - 10.09
         ENDIF 
      ENDDO
C
      CALL VZERO(BAR,2*NPLAV)
      CALL VZERO(IBAR,2*NPLAV)
      CALL VZERO(XOUT,NPLAV)
      CALL VZERO(YOUT,NPLAV)
      CALL VZERO(DEXY,2*LENSEV)
C
C     FILL THE DEXY MATRIX 
C
      DO I = 1,NPLA
         DO J = 1,96
            IF ( MOD(I,2).NE.0 ) THEN
               IF ( ESTRIP(2,I,J).GT.EMIN ) THEN
                  DEXY(2,I,J) = ESTRIP(2,I,J)
               ENDIF
               IF ( ESTRIP(1,I,J).GT.EMIN ) THEN
                  DEXY(1,I,J) = ESTRIP(1,I,J)
               ENDIF
            ENDIF
            IF ( MOD(I,2).EQ.0 ) THEN
               IF (ESTRIP(2,I,J).GT.EMIN) THEN
                  DEXY(2,I,J) = ESTRIP(2,I,J)
               ENDIF
               IF (ESTRIP(1,I,J).GT.EMIN) THEN
                  DEXY(1,I,J) = ESTRIP(1,I,J)
               ENDIF
            ENDIF
         ENDDO
      ENDDO
C
C     PROJECT TRACK INSIDE THE CALORIMETER
C
      do M = 1, 5
         al_p(M) = al_pp(1,M)
      enddo
      if (al_p(5).eq.0.) THEN
       PRINT *,' WARNING: track with R = 0, discarded'
       GOTO 50
      ENDIF
C
      RIMP = ABS(REAL(1./AL_P(5)))
C
      DO M = 1,2
         DO I = 1,NPLA     
            XOUT(I) = 0.
            YOUT(I) = 0.
            IF (MOD(M,2).EQ.0) THEN
               DISTX = PIANO(I) + ZALIG 
            ELSE
               DISTX = PIANO(I) - 5.81 + ZALIG 
            ENDIF               
            ZIN(I) = distx / 10.
         enddo
         IFAIL = 0
         call DOTRACK(NPLA,ZIN,XOUT,YOUT,AL_P,IFAIL)
         if(IFAIL.ne.0)then
            goto 50
         endif
         DO I = 1, NPLA
            NN = 0
            IF (M.EQ.2) NN = 1
            IF (MOD(I,2).EQ.NN) THEN
               SHIFT = +0.5
            ELSE
               SHIFT = -0.5               
            ENDIF
C     
C     CHECK IF XOUT OR YOUT ARE NaN
C     
            IF (XOUT(I).NE.XOUT(I).OR.YOUT(I).NE.YOUT(I)) THEN
               GOTO 50
            ENDIF
C     
            IF (M.EQ.1) THEN
               BAR(M,I) = REAL(XOUT(I))*10. + XALIG 
            ELSE
               BAR(M,I) = REAL(YOUT(I))*10. + YALIG                  
            ENDIF
C
            CALL LASTRISCIA(BAR(M,I),IBAR(M,I))
C
         ENDDO
      ENDDO 
C
C     CALL CLUSTER4 ROUTINE
C
      CALL CLUSTER4
C
C     CALL DOUBLE SHOWER FINDING ALGORITMHS
C
      DBLSQ = 0.
      EQQ = 0.
      INDIC = 0

C      DISTD = -870.06 - 0.68 - 5.81
C      POS(1) = -DISTD * TAN(THETA) * COS(PHI) + X0 * 10.  
C     &                    + 122.3 - 1.19 
C      ANGOL(1) = -TAN(THETA) * COS(PHI)

C
C     POS IS THE PROJECTION OF THE STRAIGHT TRACK FROM S1 TO THE FIRST PLANE OF THE CALO
C     ANGOL IS THE PROJECTION OF THE ANGLE ON THE X VIEW
C     BOTH THESE COME FROM THE C++ CODE
C
C
      DIFX = ABS(BAR(1,1) - POS)
C
C
C
      IF (DIFX.LE.10.OR.RIMP.GT.5) THEN
        INDIC = 3
        GO TO 125
      ENDIF
C
      DEVT = 0.
      CALL DBLSC(INDIC,EQQ,DEVT)
  125 CONTINUE
      DBLS = FLOAT(INDIC)
      IF (DBLS.EQ.1.) THEN
        DBLSQ = EQQ
      ENDIF
C
      INDIC = 0
      EQQ = 0.
      CALL DUBSC(INDIC,EQQ)
      IF (INDIC.EQ.1.AND.DBLS.NE.1) DBLSQ = EQQ
      DBLS = DBLS + 10. * FLOAT(INDIC)
C         
 50   CONTINUE
      RETURN
      END
      
