/**
 * \file CaloFranzini.h
 * \author Emiliano Mocchiutti (2007/12/03)
 */
#ifndef calofranzini_h
#define calofranzini_h

#include <PamLevel2.h>

#include <TTree.h>
#include <TFriendElement.h>
#include <TChain.h>
#include <TFile.h>
#include <TList.h>
#include <TKey.h>
#include <TSystemFile.h>
#include <TSystemDirectory.h>
#include <TSQLServer.h>
#include <TMatrixD.h>
#include <TArrayI.h>
#include <TArrayF.h>

#include <iostream>

using namespace std;

/**
 *
 * Class to store and calculate variables useful for analysis with the Franzini method
 */
class CaloFranzini : public TObject {

 private:
    //
    PamLevel2 *L2;
    Bool_t debug;
    TFile *file;
    Int_t nbin;
    TArrayF *brig;
    //
    // needed to avoid reprocessing the same event over and over to obtain the variables;
    //
    UInt_t OBT;
    UInt_t PKT;
    UInt_t atime;
    Int_t sntr;
    Float_t estrip[2][22][96];
    Float_t qplane[44];
    //
    Bool_t dofull;
    Bool_t dolong;
    Int_t degfre;
    //
    Float_t longtzeta; ///< longitudinal covariance parameter used for event selection
    Float_t fulltzeta; ///< full calorimeter covariance parameter used for event selection
    //

 public:
    //
    CaloFranzini();
    CaloFranzini(PamLevel2 *L2);
    ~CaloFranzini(){ Delete(); };
    //
    Float_t GetLongTZeta(){Process(); return longtzeta;}; ///< Returns longitudinal covariance parameter used for event selection
    Float_t GetFullTZeta(){Process(); return fulltzeta;}; ///< Returns full calorimeter covariance parameter used for event selection
    //
    Float_t GetNormLongTZeta(); ///< Returns longitudinal covariance parameter used for event selection
    Float_t GetNormFullTZeta(); ///< Returns full calorimeter covariance parameter used for event selection
    //
    TArrayF *LoadLongAverage(Float_t rig);
    TMatrixD *LoadCovarianceMatrix(Float_t rig);
    //
    Bool_t Open(TString matrixfile);
    //
    Bool_t CreateMatrixFile(TString matrixfile);
    void WriteNumBin(Int_t numbin);
    void WriteRigBin(TArrayF *rigbin);
    void WriteLongMean(TArrayF *qpl, Int_t bin);
    void WriteLongMatrix(TMatrixD *matrix, Int_t bin);
    void CloseMatrixFile();
    //
    void CalculateLongTZeta(){ dofull = false; dolong=true; };
    void CalculateFullTZeta(){ dolong = false; dofull=true; };
    void SetDebug(Bool_t d){ debug=d; };
    //
    void Clear();
    void Clear(Option_t *option){Clear();};
    void Delete();
    void Delete(Option_t *option){Delete();};
    //
    void Process(Int_t ntrack); ///< Process data track number ntrack
    void Process(); ///< Process data 
    void Print();
    void Print(Option_t *option){Print();};
    //
    ClassDef(CaloFranzini,1);
};

#endif

