/***************************************************************
 *
 * routine read_ev: routine to extract an event information 
 * from file acquired with Pamela acquisition programs
 *
 * June 2002
 *
 ***************************************************************/
/*
 * include needed system headers
 */
#include <stdio.h>       /* include standard i/o library */
#include <stdlib.h>      /* include standard library */
#include <string.h>      /* include string library */
#include <unistd.h>      /* include unix standard library */
#include <sys/types.h>   /* */
#include <sys/stat.h>    /* */
#include <fcntl.h>       /* */
#include <errno.h>       /* error simbol definitions */
#include <time.h>        /* system time definitions */
#include <math.h>        /* math library */

void readev_(long *evnum, long *systime, long *len, unsigned short *data, int *error, int *fd)
{
  long header;
  const char *hdr = (char *)&header;

  *error = 0;

/* search the header */ 

  *error = read(*fd,&header,sizeof(long)) == sizeof(long) ? 0 : -1;
  while (!(*error) && (header != 0xaaaaaaaa)) {
    header >>= 8;
    *error = read(*fd,hdr+3,sizeof(char)) == sizeof(char) ? 0 : -1;
  }
  if (*error) return;      /* file read error searching the header: exit */

/* read the event number */

  *error = read(*fd,evnum,sizeof(long)) == sizeof(long) ? 0 : -1;
  if (*error) return;      /* error reading the event number: exit */
  printf ("%d \n", evnum); 
/* read the system time */

  *error = read(*fd,systime,sizeof(long)) == sizeof(long) ? 0 : -1;
  if (*error) return;      /* error reading the system time: exit */
  printf ("%d \n", systime); 

/* read the event length */

  *error = read(*fd,len,sizeof(long)) == sizeof(long) ? 0 : -1;
  if (*error) return;      /* error reading the event length: exit */
  printf ("%d \n", len); 

/* read the packet */

  *error = read(*fd,data,sizeof(char)*(*len)) == sizeof(char)*(*len) ? 0 : -1;
  if (*error) return;      /* error reading the event length: exit */
  swab(data,data,*len);
  *error = 0;
}










