#ifndef MyDect2Level2_h
#define MyDect2Levev2_h
//
#include <TObject.h>
#include <TClonesArray.h>
//
// class which contains track related variables
//
class MyDect2TrkVar : public TObject {

private:

public:
    //
    Int_t trkseqno; // tracker entry coming from tracker, 100 if image track is used, -100 if the track is not consistent with MyDetector2 one
    Int_t mytrkvar; // my track related variable
    //
    MyDect2TrkVar();
    MyDect2TrkVar(const MyDect2TrkVar&);
    //
    ClassDef(MyDect2TrkVar,1);
    //
};

class MyDect2Level2 : public TObject {
 private:

 public:
    Int_t myvar1;   // my variable number three
    Int_t myvar2;   // my variable number three
    Float_t myvar3; // my variable number three
    TClonesArray *myTrk; // track related variable class
    //
    // inline method which returns for each event the number of track related variables entries
    //
    Int_t ntrk(){return myTrk->GetEntries();};
    //
    // methods to make life simplier during the analysis, returns a pointer to the MyDect2TrkVar class containing track related variables
    //
    MyDect2TrkVar *GetMyDect2TrkVar(Int_t notrack);  
    //
    // constructor
    //
    MyDect2Level2();
    //
    ClassDef(MyDect2Level2,1);
};

#endif
