#include <CaloEnergy.h>
#include <PamLevel2.h>

//--------------------------------------
/**
 * Default constructor 
 */
CaloEnergy::CaloEnergy(){
  Clear();
}

CaloEnergy::CaloEnergy(PamLevel2 *l2p){  
  //
  Clear();
  //
  L2 = l2p;
  //
  if ( !L2->IsORB() ) printf(" WARNING: OrbitalInfo Tree is needed, the plugin could not work properly without it \n");
  //
  OBT = 0;
  PKT = 0;
  atime = 0;
  sntr = "start";
  AOBT = 0;
  APKT = 0;
  aatime = 0;
  asntr = "start";
  //
  debug = false;
  //
  fLong = false;
  fSimu = false;
  fPl = 1;
  //
  this->DefineGeometry();
  fXosel = true;
  fXesel = true;
  fYosel = true;
  fYesel = true;
  fConv_r = 44.4;
  //
}

CaloEnergy::CaloEnergy(PamLevel2 *l2p, Bool_t simulation){  
  //
  Clear();
  //
  L2 = l2p;
  //
  if ( !L2->IsORB() ) printf(" WARNING: OrbitalInfo Tree is needed, the plugin could not work properly without it \n");
  //
  OBT = 0;
  PKT = 0;
  atime = 0;
  sntr = "start";
  //
  AOBT = 0;
  APKT = 0;
  aatime = 0;
  asntr = "start";
  //
  debug = false;
  //
  fLong = false;
  fSimu = simulation;
  fPl = 1;
  //
  this->DefineGeometry();
  fXosel =true;
  fXesel = true;
  fYosel = true;
  fYesel = true;
  fConv_r = 44.4;
  //
}

void CaloEnergy::DefineGeometry(){
  //
  fM = 2.;
  fM1 = fM - 0.122 -0.096;
  if ( fM1 < 0. ) fM1 = 0.;
  //
  CaloStrip *cs = new CaloStrip(fSimu);

  // vista y piano 0 striscia 0
  cs->Set(1,0,0);
  xe1= cs->GetY();
  z1= cs->GetZ();
  // vista y piano 0 striscia 31
  cs->Set(1,0,31);
  xe2= cs->GetY();
  // vista y piano 0 striscia 32
  cs->Set(1,0,32);
  xe3= cs->GetY();
  // vista y piano 0 striscia 63
  cs->Set(1,0,63);
  xe4= cs->GetY();
  // vista y piano 0 striscia 64
  cs->Set(1,0,64);
  xe5= cs->GetY();
  // vista y piano 0 striscia 95
  cs->Set(1,0,95);
  xe6= cs->GetY();

  // vista x piano 0 striscia 0
  cs->Set(0,0,0);
  yo1= cs->GetX();
  z2= cs->GetZ();
  // vista x piano 0 striscia 31
  cs->Set(0,0,31);
  yo2= cs->GetX();
  // vista x piano 0 striscia 32
  cs->Set(0,0,32);
  yo3= cs->GetX();
  // vista x piano 0 striscia 63
  cs->Set(0,0,63);
  yo4= cs->GetX();
  // vista x piano 0 striscia 64
  cs->Set(0,0,64);
  yo5= cs->GetX();
  // vista x piano 0 striscia 95
  cs->Set(0,0,95);
  yo6= cs->GetX();

  
  // vista y piano 1 striscia 0
  cs->Set(1,1,0);
  xo1= cs->GetY();
  z3= cs->GetZ();
  // vista y piano 1 striscia 31
  cs->Set(1,1,31);
  xo2= cs->GetY();
  // vista y piano 1 striscia 32
  cs->Set(1,1,32);
  xo3= cs->GetY();
  // vista y piano 1 striscia 63
  cs->Set(1,1,63);
  xo4= cs->GetY();
  // vista y piano 1 striscia 64
  cs->Set(1,1,64);
  xo5= cs->GetY();
  // vista y piano 1 striscia 95
  cs->Set(1,1,95);
  xo6= cs->GetY();
  
  // vista x piano 1 striscia 0
  cs->Set(0,1,0);
  ye1= cs->GetX();
  z4= cs->GetZ();
  // vista x piano 1 striscia 31
  cs->Set(0,1,31);
  ye2= cs->GetX();
  // vista x piano 1 striscia 32
  cs->Set(0,1,32);
  ye3= cs->GetX();
  // vista x piano 1 striscia 63
  cs->Set(0,1,63);
  ye4= cs->GetX();
  // vista x piano 1 striscia 64
  cs->Set(0,1,64);
  ye5= cs->GetX();
  // vista x piano 1 striscia 95
  cs->Set(0,1,95);
  ye6= cs->GetX();

  //
  for (Int_t p = 0; p<22; p ++){
    for (Int_t v = 0; v<2; v++ ){   
      cs->Set(v,p,0);
      trk_z[p][v]= cs->GetZ();                  // << cooordinata Z piano
    };
  };
  //
  delete cs;
  //
}

void CaloEnergy::Clear(){
  //
  fEnergy = 0.;
  memset(enstrip,0,2*22*96*(sizeof(Float_t)));  
  en = 0.;
  view = 0;
  plane = 0;
  strip = 0;
  energyxe = 0.; 
  energyyo = 0.; 
  energyxo = 0.; 
  energyye = 0.; 
  memset(en_xep,0,11*sizeof(Float_t));
  memset(en_yep,0,11*sizeof(Float_t));
  memset(en_xop,0,11*sizeof(Float_t));
  memset(en_yop,0,11*sizeof(Float_t));
  //
}

void CaloEnergy::Print(){
  //
  printf("========================================================================\n");
  printf(" OBT: %u PKT: %u ATIME: %u \n",OBT,PKT,atime);
  printf(" fEnergy :.............. %f \n",fEnergy);  
  printf(" fMax_plane :........... %i \n",fMax_plane); 
  printf(" fCount  :.............. %f \n",fCount); 
  printf(" fXesel  :.............. %i \n",fXesel); 
  printf(" fXosel  :.............. %i \n",fXosel); 
  printf(" fYesel  :.............. %i \n",fYesel); 
  printf(" fYosel  :.............. %i \n",fYosel); 
  printf(" fSimu   :.............. %i \n",fSimu); 
  printf(" fM      :.............. %f \n",fM); 
  printf(" fM1     :.............. %f \n",fM1); 
  printf(" fPl     :.............. %f \n",fPl); 
  printf(" fConv_r :.............. %f \n",fConv_r); 
  printf(" fLong   :.............. %i \n",fLong); 
  printf(" energyxe:.............. %f \n",energyxe); 
  printf(" energyxo:.............. %f \n",energyxo); 
  printf(" energyye:.............. %f \n",energyye); 
  printf(" energyyo:.............. %f \n",energyyo); 
  printf(" debug   :.............. %i \n",debug); 

  printf("========================================================================\n");
  //
}

void CaloEnergy::Delete(){
  Clear();
}


Bool_t CaloEnergy::IsInsideAcceptance(TString section){
  return(this->IsInsideAcceptance(section,true));  
}

Bool_t CaloEnergy::IsInsideAcceptance(TString section, Bool_t fast){
  //
  //  
  TString ntr = section;
  if ( !L2 ){
    printf(" ERROR: cannot find PamLevel2 object, use the correct constructor or check your program!\n");
    printf(" ERROR: CaloEnergy variables not filled \n");
    return false;
  };
  //
  Bool_t newentry = false;
  //
  if ( L2->IsORB() ){
    if ( L2->GetOrbitalInfo()->pkt_num != APKT || L2->GetOrbitalInfo()->OBT != AOBT || L2->GetOrbitalInfo()->absTime != aatime || strcmp(ntr.Data(),asntr.Data()) ){
      newentry = true;
      AOBT = L2->GetOrbitalInfo()->OBT;
      APKT = L2->GetOrbitalInfo()->pkt_num;
      aatime = L2->GetOrbitalInfo()->absTime;
      asntr = ntr;
    };
  } else {
    newentry = true;
  };
  //
  if ( !newentry ) return fSel;
  //
  if ( debug ) printf(" ########## IsInsideAcceptance ######### \n");
  //
  fSel = false;
  section.ToUpper();
  fXosel = false;
  fXesel = false;
  fYosel = false;
  fYesel = false;
  fCount = 0.;
  //
  Int_t ss = Int_t(section.Contains("XO"))+Int_t(section.Contains("XE"))+Int_t(section.Contains("YO"))+Int_t(section.Contains("YE"));
  if ( ss > 1 ) fast = false;
  if ( !ss ){
    printf(" ERROR: section must be XO or XE or YO or YE while it is %s \n",section.Data());
  };
  //
  Float_t  track_coordx[22][2];
  Float_t  track_coordy[22][2];
  //
  Float_t tgx_cl2;
  Float_t tgy_cl2;  
  tgx_cl2 = L2->GetCaloLevel2()->tanx[0];
  tgy_cl2 = L2->GetCaloLevel2()->tany[0];
  //
  for (Int_t p=0; p<22; p++){    
    track_coordy[p][1] = L2->GetCaloLevel2()->cbar[p][1]; 
    track_coordx[p][1] = L2->GetCaloLevel2()->cbar[p][0] - fabs(trk_z[p][1]-trk_z[p][0])*tgx_cl2;
    track_coordx[p][0] = L2->GetCaloLevel2()->cbar[p][0];
    track_coordy[p][0] = L2->GetCaloLevel2()->cbar[p][1] - fabs(trk_z[p][1]-trk_z[p][0])*tgy_cl2;
    if ( debug ) printf(" p %i track_coordy[p][1] %f track_coordx[p][1] %f track_coordx[p][0] %f  track_coordy[p][0] %f \n",p,track_coordy[p][1],track_coordx[p][1],track_coordx[p][0],track_coordy[p][0]);
  };
  //
  if ( debug ) printf(" acceptance fast %i ss %i tgx %f tgy %f\n",fast,ss,tgx_cl2,tgy_cl2);
  //
  if ( section.Contains("XO") ){
    for (Int_t i=0; i<11; i++) {
      if
	(
	 (((track_coordx[2*i+1][1]>=(-12.054+fM))&&
	   (track_coordx[2*i+1][1]<=(-4.246-fM)))&&
	  (((L2->GetCaloLevel2()->cbar[2*i+1][1]>=xo1 + fM1)&&
	    (L2->GetCaloLevel2()->cbar[2*i+1][1]<=xo2 - fM1 ))||
	   ((L2->GetCaloLevel2()->cbar[2*i+1][1]>=xo3 + fM1)&&
	    (L2->GetCaloLevel2()->cbar[2*i+1][1]<=xo4 - fM1 ))||
	   ((L2->GetCaloLevel2()->cbar[2*i+1][1]>=xo5 + fM1)&&
	    (L2->GetCaloLevel2()->cbar[2*i+1][1]<=xo6 - fM1 ))))||
	 
	 (((track_coordx[2*i+1][1]>=(-4.004+fM))&&
	   (track_coordx[2*i+1][1]<=(3.804-fM)))&&
	  (((L2->GetCaloLevel2()->cbar[2*i+1][1]>=xo1 + fM1)&&
	    (L2->GetCaloLevel2()->cbar[2*i+1][1]<=xo2 - fM1 ))||
	   ((L2->GetCaloLevel2()->cbar[2*i+1][1]>=xo3 + fM1)&&
	    (L2->GetCaloLevel2()->cbar[2*i+1][1]<=xo4 - fM1))||
	   ((L2->GetCaloLevel2()->cbar[2*i+1][1]>=xo5 + fM1)&&
	    (L2->GetCaloLevel2()->cbar[2*i+1][1]<=xo6 - fM1 ))))||
	 
	 (((track_coordx[2*i+1][1]>=(4.046+fM))&&
	   (track_coordx[2*i+1][1]<=(11.854-fM)))&&
	  (((L2->GetCaloLevel2()->cbar[2*i+1][1]>=xo1 + fM1)&&
	    (L2->GetCaloLevel2()->cbar[2*i+1][1]<=xo2 - fM1))||
	   ((L2->GetCaloLevel2()->cbar[2*i+1][1]>=xo3 + fM1)&&
	    (L2->GetCaloLevel2()->cbar[2*i+1][1]<=xo4 - fM1 ))||
	   ((L2->GetCaloLevel2()->cbar[2*i+1][1]>=xo5 + fM1)&&
	    (L2->GetCaloLevel2()->cbar[2*i+1][1]<=xo6 - fM1 ))))
	 ){
	fXosel = true;
      } else {
	if ( fast ) return false; 	  
	fXosel = false;
	break;
      };
    };
  };
  //
  if ( section.Contains("XE") ){
    for (Int_t i=0; i<11; i++) {
      if
	(
	 (((track_coordx[2*i][1]>=(-11.854+fM))&& 
	   (track_coordx[2*i][1]<=(-4.046-fM)))&&
	  (((L2->GetCaloLevel2()->cbar[2*i][1]>=xe1 + fM1)&&
	    (L2->GetCaloLevel2()->cbar[2*i][1]<=xe2 - fM1 ))||
	   ((L2->GetCaloLevel2()->cbar[2*i][1]>=xe3 + fM1)&&
	    (L2->GetCaloLevel2()->cbar[2*i][1]<=xe4 - fM1 ))||
	   ((L2->GetCaloLevel2()->cbar[2*i][1]>=xe5 + fM1)&&
	    (L2->GetCaloLevel2()->cbar[2*i][1]<=xe6 - fM1 ))))||
	 
	 (((track_coordx[2*i][1]>=(-3.804+fM))&&
	   (track_coordx[2*i][1]<=(4.004-fM)))&&
	  (((L2->GetCaloLevel2()->cbar[2*i][1]>=xe1 + fM1)&&
	    (L2->GetCaloLevel2()->cbar[2*i][1]<=xe2 - fM1 ))||
	   ((L2->GetCaloLevel2()->cbar[2*i][1]>=xe3 + fM1)&&
	    (L2->GetCaloLevel2()->cbar[2*i][1]<=xe4 - fM1))||
	   ((L2->GetCaloLevel2()->cbar[2*i][1]>=xe5 + fM1)&&
	    (L2->GetCaloLevel2()->cbar[2*i][1]<=xe6 - fM1 ))))||
	 
	 (((track_coordx[2*i][1]>=(4.246+fM))&&
	   (track_coordx[2*i][1]<=(12.054-fM)))&&
	  (((L2->GetCaloLevel2()->cbar[2*i][1]>=xe1 + fM1)&&
	    (L2->GetCaloLevel2()->cbar[2*i][1]<=xe2 - fM1))||
	   ((L2->GetCaloLevel2()->cbar[2*i][1]>=xe3 + fM1)&&
	    (L2->GetCaloLevel2()->cbar[2*i][1]<=xe4 - fM1 ))||
	   ((L2->GetCaloLevel2()->cbar[2*i][1]>=xe5 + fM1)&&
	    (L2->GetCaloLevel2()->cbar[2*i][1]<=xe6 - fM1 ))))
	 ){
	fXesel = true;
      } else {
	if ( fast ) return false; 	  
	fXesel = false;
	break;
      };
    };
  };  
  //
  if ( section.Contains("YE") ){
    for (Int_t i=0; i<11; i++) {
      if
	(
	 (((track_coordy[2*i+1][0]>=(-12.154+fM))&& 
	   (track_coordy[2*i+1][0]<=(-4.346-fM)))&&
	  (((L2->GetCaloLevel2()->cbar[2*i+1][0]>=ye1 + fM1)&&
	    (L2->GetCaloLevel2()->cbar[2*i+1][0]<=ye2 - fM1 ))||
	   ((L2->GetCaloLevel2()->cbar[2*i+1][0]>=ye3 + fM1)&&
	    (L2->GetCaloLevel2()->cbar[2*i+1][0]<=ye4 - fM1 ))||
	   ((L2->GetCaloLevel2()->cbar[2*i+1][0]>=ye5 + fM1)&&
	    (L2->GetCaloLevel2()->cbar[2*i+1][0]<=ye6 - fM1 ))))||
	 
	 (((track_coordy[2*i+1][0]>=(-4.104+fM))&&
	   (track_coordy[2*i+1][0]<=(3.704-fM)))&&
	  (((L2->GetCaloLevel2()->cbar[2*i+1][0]>=ye1 + fM1)&&
	    (L2->GetCaloLevel2()->cbar[2*i+1][0]<=ye2 - fM1 ))||
	   ((L2->GetCaloLevel2()->cbar[2*i+1][0]>=ye3 + fM1)&&
	    (L2->GetCaloLevel2()->cbar[2*i+1][0]<=ye4 - fM1))||
	   ((L2->GetCaloLevel2()->cbar[2*i+1][0]>=ye5 + fM1)&&
	    (L2->GetCaloLevel2()->cbar[2*i+1][0]<=ye6 - fM1 ))))||
	 
	 (((track_coordy[2*i+1][0]>=(3.946+fM))&&
	   (track_coordy[2*i+1][0]<=(11.754-fM)))&&
	  (((L2->GetCaloLevel2()->cbar[2*i+1][0]>=ye1 + fM1)&&
	    (L2->GetCaloLevel2()->cbar[2*i+1][0]<=ye2 - fM1))||
	   ((L2->GetCaloLevel2()->cbar[2*i+1][0]>=ye3 + fM1)&&
	    (L2->GetCaloLevel2()->cbar[2*i+1][0]<=ye4 - fM1 ))||
	   ((L2->GetCaloLevel2()->cbar[2*i+1][0]>=ye5 + fM1)&&
	    (L2->GetCaloLevel2()->cbar[2*i+1][0]<=ye6 - fM1 ))))
	 ){
	fYesel = true;
      } else {
	if ( fast ) return false; 	  
	fYesel = false;
	break;
      };
    };
  };  
  //
  if ( section.Contains("YO") ){
    for (Int_t i=0; i<11; i++) {
      if ( debug ) printf(" i %i track_coordy[2*i][0] %f L2->GetCaloLevel2()->cbar[2*i][0] %f \n",i,track_coordy[2*i][0],L2->GetCaloLevel2()->cbar[2*i][0]);
      if ( debug ) printf(" i %i fm %f fm1 %f yo1 %g yo2 %f yo3 %f yo4 %f yo5 %f yo6 %f \n",i,fM,fM1,yo1,yo2,yo3,yo4,yo5,yo6);
      if
	(
	 (((track_coordy[2*i][0]>=(-11.954+fM))&& 
	   (track_coordy[2*i][0]<=(-4.146-fM)))&&
	  (((L2->GetCaloLevel2()->cbar[2*i][0]>=yo1 + fM1)&&
	    (L2->GetCaloLevel2()->cbar[2*i][0]<=yo2 - fM1 ))||
	   ((L2->GetCaloLevel2()->cbar[2*i][0]>=yo3 + fM1)&&
	    (L2->GetCaloLevel2()->cbar[2*i][0]<=yo4 - fM1 ))||
	   ((L2->GetCaloLevel2()->cbar[2*i][0]>=yo5 + fM1)&&
	    (L2->GetCaloLevel2()->cbar[2*i][0]<=yo6 - fM1 ))))||
	 
	 (((track_coordy[2*i][0]>=(-3.904+fM))&&
	   (track_coordy[2*i][0]<=(+3.904-fM)))&&
	  (((L2->GetCaloLevel2()->cbar[2*i][0]>=yo1 + fM1)&&
	    (L2->GetCaloLevel2()->cbar[2*i][0]<=yo2 - fM1 ))||
	   ((L2->GetCaloLevel2()->cbar[2*i][0]>=yo3 + fM1)&&
	    (L2->GetCaloLevel2()->cbar[2*i][0]<=yo4 - fM1))||
	   ((L2->GetCaloLevel2()->cbar[2*i][0]>=yo5 + fM1)&&
	    (L2->GetCaloLevel2()->cbar[2*i][0]<=yo6 - fM1 ))))||
	 
	 (((track_coordy[2*i][0]>=(4.146+fM))&&
	   (track_coordy[2*i][0]<=(11.954-fM)))&&
	  (((L2->GetCaloLevel2()->cbar[2*i][0]>=yo1 + fM1)&&
	    (L2->GetCaloLevel2()->cbar[2*i][0]<=yo2 - fM1))||
	   ((L2->GetCaloLevel2()->cbar[2*i][0]>=yo3 + fM1)&&
	    (L2->GetCaloLevel2()->cbar[2*i][0]<=yo4 - fM1 ))||
	   ((L2->GetCaloLevel2()->cbar[2*i][0]>=yo5 + fM1)&&
	    (L2->GetCaloLevel2()->cbar[2*i][0]<=yo6 - fM1 ))))
	 ){
	fYosel = true;
      } else {
	if ( fast ) return false; 	  
	fYosel = false;
	break;
      };
    };
  };  
  //
  fSel = ( fXesel || fYesel || fXosel || fYosel );
  fCount = (Float_t)((Int_t)fXesel+(Int_t)fXosel+(Int_t)fYesel+(Int_t)fYosel);
  if ( debug ) printf(" IsInside XE %i XO %i YE %i YO %i => SEL %i \n",fXesel,fXosel,fYesel,fYosel,fSel);
  //
  return fSel;
  // 
}

void CaloEnergy::Process(){
  TString xo = "XO";
  this->Process(xo);
}


void CaloEnergy::Process(TString section){
  //  
  TString ntr = section;
  if ( !L2 ){
    printf(" ERROR: cannot find PamLevel2 object, use the correct constructor or check your program!\n");
    printf(" ERROR: CaloEnergy variables not filled \n");
    return;
  };
  //
  Bool_t newentry = false;
  //
  if ( L2->IsORB() ){
    if ( L2->GetOrbitalInfo()->pkt_num != PKT || L2->GetOrbitalInfo()->OBT != OBT || L2->GetOrbitalInfo()->absTime != atime || strcmp(ntr.Data(),sntr.Data()) ){
      newentry = true;
      OBT = L2->GetOrbitalInfo()->OBT;
      PKT = L2->GetOrbitalInfo()->pkt_num;
      atime = L2->GetOrbitalInfo()->absTime;
      sntr = ntr;
    };
  } else {
    newentry = true;
  };
  //
  if ( !newentry ) return;
  //
  if ( debug ) printf(" Processing event at OBT %u PKT %u time %u section %s\n",OBT,PKT,atime,section.Data());
  //
  Clear();
  //
  if ( fLong ){
    // use long fit to measure energy
  } else {
    //
    if ( this->IsInsideAcceptance(section) ){
      //
      for (Int_t ch=0; ch< L2->GetCaloLevel1()->istrip; ch++){
	en = L2->GetCaloLevel1()->DecodeEstrip(ch,view,plane,strip);
	enstrip[view][plane][strip]=en;
      };
      for (Int_t i=0;i<11;i++){
	for(strip=0; strip<96; strip++) {
	  en_xep[i] += enstrip[1][2*i][strip];
	  en_yop[i] += enstrip[0][2*i][strip];
	  en_xop[i] += enstrip[1][2*i+1][strip];
	  en_yep[i] += enstrip[0][2*i+1][strip];
	};
	energyxe += en_xep[i];
	energyyo += en_yop[i];
	energyxo += en_xop[i];
	energyye += en_yep[i];
      };
      fMax_plane = 0;
      Float_t en_maxplane = 0.;  
      Float_t max_en= 0.; 
      if ( fXosel ){
	max_en = 0.;
	for (Int_t ipl =0; ipl < 11; ipl ++) {
	  if(en_xop[ipl] > max_en) {
	    max_en = en_xop[ipl];
	    fMax_plane = ipl;
	  };
	};
	//
	for (Int_t iplm=0;iplm<=(fMax_plane+fPl) ;iplm++) en_maxplane += en_xop[iplm]; 
      };
      if ( fXesel ){
	max_en = 0.;
	for (Int_t ipl =0; ipl < 11; ipl ++) {
	  if(en_xep[ipl] > max_en) {
	    max_en = en_xep[ipl];
	    fMax_plane = ipl;
	  };
	};
	//
	for (Int_t iplm=0;iplm<=(fMax_plane+fPl) ;iplm++) en_maxplane += en_xep[iplm]; 
      };
      if ( fYosel ){
	max_en = 0.;
	for (Int_t ipl =0; ipl < 11; ipl ++) {
	  if(en_yop[ipl] > max_en) {
	    max_en = en_yop[ipl];
	    fMax_plane = ipl;
	  };
	};
	//
	for (Int_t iplm=0;iplm<=(fMax_plane+fPl) ;iplm++) en_maxplane += en_yop[iplm]; 
      };
      if ( fYesel ){
	max_en = 0.;
	for (Int_t ipl =0; ipl < 11; ipl ++) {
	  if(en_yep[ipl] > max_en) {
	    max_en = en_yep[ipl];
	    fMax_plane = ipl;
	  };
	};
	//
	for (Int_t iplm=0;iplm<=(fMax_plane+fPl) ;iplm++) en_maxplane += en_yep[iplm]; 
      };
      //
      fEnergy = en_maxplane/fCount/fConv_r;
      //
      if ( debug ) printf(" fMax_plane %i conv_r %f en_maxplane %f encalo %f  \n",fMax_plane,fConv_r,en_maxplane,fEnergy);
      if ( debug ) printf(" XE %i XO %i YE %i YO %i \n",fXesel,fXosel,fYesel,fYosel);
      //
    } else {
      if ( debug ) printf(" Outside acceptance \n");
      fEnergy = -1.;
    };
  };
  //
}
