#ifndef calohough_h
#define calohough_h


#if !defined(__CINT__) || defined(__MAKECINT__)

#include <PamLevel2.h>

#include <TMinuit.h>
#include <TPaveStats.h>
#include <TStyle.h>
#include <TSystem.h>
#include <TCanvas.h>
#include <TGraphErrors.h>
#include <TH1F.h>
#include <TGraphErrors.h>
#include <TF2.h>
#include <TH2F.h>

#include <iostream>
#include <iomanip>
using namespace std;

#endif
///////////////////////////////////////////////////
///
///
///  CLASS FOR INITIALIZATIONS & PARAMETERS
///
///
///////////////////////////////////////////////////
class CaloHough_parameters : public TObject{

 private:
    
    CaloHough_parameters(){ SetDefault(); };
    
    static CaloHough_parameters * _parameters;

 public:

    static CaloHough_parameters *Get(){
	if(_parameters==0) {
//	    cout << "**NEW**"<<endl;
	    _parameters = new CaloHough_parameters();
	}
	return _parameters;
    }
    
    // ------
    //general
    // ------

    int isimu;

    float Q_UP;
    float Q_DN;
    int   M_UP;
    int   M_DN;

    TH2F *h_qtot[2]; // hit pattern (q>qth)
    TH2F *h_par[2];  // parameter space
    TH2F *h_par_fine[2];  // parameter space (finer binning)

    TH1F *h_par1[2];  //
    TH1F *h_par2[2];  //
    

    void SetSimulation(int isetsimu){isimu = isetsimu;};
    void SetQUpThreshold(float setqth) {Q_UP  = setqth;};
    void SetMUpThreshold(int   setmth) {M_UP  = setmth;};
    void SetQDnThreshold(float setqth) {Q_DN  = setqth;};
    void SetMDnThreshold(int   setmth) {M_DN  = setmth;};
    void SetDefault();

    ClassDef(CaloHough_parameters,1);

};
///////////////////////////////////////////////////
///
///
///  CLASS INPLEMENTATION
///
///
///////////////////////////////////////////////////
class CaloHough : public TObject{

 private:
    
 public:

    CaloHough(){ Reset(); };
    CaloHough(CaloLevel1 *l1){ Reset(); Set(l1); }; 

    ~CaloHough(){ Reset(); };
    
    void Reset();
    void Clear(){ Reset(); };
    void Delete(){ Reset(); };

    bool Set(CaloLevel1*);

    ClassDef(CaloHough,1);

};

#endif
