#include <stdlib.h>
#include <iostream>

#include <TTree.h>
#include <TChain.h>
#include <TFile.h>
#include <TList.h>
#include <TROOT.h>
#include <TString.h>
#include <TBenchmark.h>
#include <TFriendElement.h>
#include <TObjectTable.h>

#include <PamLevel2.h>
#include <CaloREPCore.h>

using namespace std;


//===================================
// global variables
//===================================
Bool_t    DEBUG;
TString   DIR;
TString   LIST;
TString   OPTIONS;
TString   OUTFILE;

void usage(){

    cout << "------------------------------------------------------------"<<endl;
    cout << "USAGE:"<<endl;
    cout << "-processDir  DIR     -  Level2 data directory \n";
    cout << "-processList LIST    -  list  of files (.txt) or single file (.root) to be analysed \n";
    cout << "-outputFile  PATH    -  path and name (no .root!) of the output file \n";
    cout << "--debug, -g          -  debug mode \n";
    cout << "--help, -h           -  print this help \n";
    cout << "-options [ options ] -  options: \n";
    cout << "                        +(-)ALL    --> inlcude(exclude) all trees and branches \n "   ;
    cout << "                        +(-)TRK1 +(-)TRK2 +(-)CAL1 +(-)CAL2 +(-)TOF +(-)TRG +(-)ND +(-)S4 +(-)ORB --> inlcude(exclude) trees and branches  \n"  ; 
    cout << "------------------------------------------------------------"<<endl;
}
//
int HandleInputPar(int argc, char **argv){

  if(argc>1){
		
    if(!strcmp(argv[1], "-h") || !strcmp(argv[1], "--help") ){
      usage();
      return(1);
    };
    // -----------------------
    // Read input parameters
    // -----------------------  
    DEBUG   = false;
    DIR     = gSystem->WorkingDirectory();
    LIST    = "";
    OUTFILE = "";
    OPTIONS = "-ALL +TRK2 +TOF +TRG +AC +ND +S4 +ORB";
    //    MAXEV   = 0;	
		

    for (int i = 1; i < argc; i++){		
      // -----------------------------------------------------//
      if (!strcmp(argv[i], "-processDir")){
	if (++i >= argc) throw -1;
	DIR = argv[i];
	cout << "processDir "<<DIR<<endl;
	continue;
      }
      // -----------------------------------------------------//
      else if (!strcmp(argv[i], "-processList")){
	if (++i >= argc) throw -1;
	LIST = argv[i];
	cout << "processList "<<LIST<<endl;
	continue;
      }  
      // -----------------------------------------------------//
      else if (!strcmp(argv[i], "-outputFile")){
	if (++i >= argc) throw -1;
	OUTFILE = argv[i];
	cout << "outputFile "<<OUTFILE<<endl;
	continue;
      }  
      // -----------------------------------------------------//
      else if (!strcmp(argv[i], "-options")){
	if (++i >= argc) throw -1;
	OPTIONS = argv[i];
	if( OPTIONS.Contains("[") ){
	  do{
	    if (++i >= argc) throw -1;
	    OPTIONS.Append(argv[i]);
	  }while(!OPTIONS.Contains("]"));
	}else cout << "wrong option format --> ignoring " << endl;
      }
      // -----------------------------------------------------//
      else if (!strcmp(argv[i], "--debug") || !strcmp(argv[i], "-g")){
	DEBUG = true;
	continue;	
      }
      // -----------------------------------------------------//
      else{
	cout << "Unidentified input parameter. Ignored."<< endl;
      };
    };
  }else{
    usage();
    return(1);
  };
  // -----------------------
  // Check input parameters
  // -----------------------  
  //		
  return(0);
	
};
// 

int main(int argc, char **argv)
{
	
  if( HandleInputPar(argc,argv) )return(1);
	
  printf(" Options: %s \n",OPTIONS.Data());

  CaloREPCore(DIR,LIST,OPTIONS,OUTFILE);
    
  printf("Finished, exiting...\n");
    
  return 0;
	
};

