/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  test routines
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


void RootTest(TString filename){
    Long64_t ntimes = 0;
 inizio: TFile       *calheadFile = 0;
    TFile       *calcalibFile = 0;
    calheadFile = getFile(filename, "CalibCalPed", "Header");
    calcalibFile = getFile(filename, "CalibCalPed");    
    //Takes the tree of the header file
    char *filen = 0;
    filen = filename;
    //gObjectTable->Print();
    if ( !calheadFile || !calcalibFile ) {
	if ( calheadFile ) calheadFile->Close();
	if ( calcalibFile ) calcalibFile->Close();
	printf(" Not able to open file! %s \n",filen);
	printf(" ntimes = %i\n",(int)ntimes);
	ntimes++;
	goto inizio;
	return;
    };
    TTree *tr = (TTree*)calheadFile->Get("Pscu");
    tr->AddFriend("CalibCalPed", calcalibFile);
    //    pamela::calorimeter::CalibCalPedEvent *ce = 0;
    pamela::CalibCalPedEvent *ce = 0;
    pamela::PscuHeader *cph = 0;
    pamela::EventHeader *ceh = 0;
    tr->SetBranchAddress("Header", &ceh);
    tr->SetBranchAddress("Event", &ce);
    Long64_t ncalibs    = tr->GetEntries();
    calheadFile->Close();
    calcalibFile->Close();
    printf(" ntimes = %i\n",(int)ntimes);
    ntimes++;
    goto inizio;
}

void RootTestE(TString filename){
    Long64_t ntimes = 0;
 inizio: 
    TString scalheadFile;
    TString scalcalibFile;
    scalheadFile = getEmiFile(filename, "CalibCalPed", "Header");
    scalcalibFile = getEmiFile(filename, "CalibCalPed","Event");    
    char *prova;
    prova = scalheadFile;
    if ( prova == "nofile" ){
	printf("nofile\n");
	goto inizio;
	return;
    };
    TFile *calheadFile = 0;
    calheadFile = new TFile(scalheadFile);
    TFile *calcalibFile = 0;
    calcalibFile = new TFile(scalcalibFile);
    //    TFile *calheadFile = 0;
    //calheadFile = new TFile(scalheadFile);
    //TFile *calcalibFile = 0;
    //calcalibFile = new TFile(scalcalibFile);
    //
    if ( calheadFile->IsZombie() || calcalibFile->IsZombie() ) {
	if ( !calheadFile->IsZombie() ) calheadFile->Close();
	if ( !calcalibFile->IsZombie() ) calcalibFile->Close();
	printf(" Not able to open file! \n");
	printf(" ntimes = %i\n",ntimes);
	ntimes++;
	goto inizio;
	return;
    };
    TTree *tr = (TTree*)calheadFile->Get("Pscu");
    tr->AddFriend("CalibCalPed", calcalibFile);
    //    pamela::calorimeter::CalibCalPedEvent *ce = 0;
    pamela::CalibCalPedEvent *ce = 0;
    pamela::PscuHeader *cph = 0;
    pamela::EventHeader *ceh = 0;
    tr->SetBranchAddress("Header", &ceh);
    tr->SetBranchAddress("Event", &ce);
    Long64_t ncalibs    = tr->GetEntries();
    calheadFile->Close();
    calcalibFile->Close();
    printf(" ntimes = %i\n",ntimes);
    ntimes++;
    goto inizio;
}

void RootTest2(TString filename){
    Long64_t ntimes = 0;
 inizio: TFile calcalibFile(filename);
    if ( calcalibFile.IsZombie() ) {
	if ( !calcalibFile.IsZombie() ) calheadFile.Close();
	printf(" Not able to open file! \n");
	printf(" ntimes = %i\n",ntimes);
	ntimes++;
	goto inizio;
    };
    printf(" ntimes = %i\n",ntimes);
    ntimes++;
    goto inizio;
}

void RootTest3(TString filename){
    Long64_t ntimes = 0;
 inizio:      TFile *calcalibFile = 0;
    calcalibFile = new TFile(filename);
    if ( !calcalibFile ) {
	if ( calcalibFile ) calheadFile.Close();
	printf(" Not able to open file! \n");
	printf(" ntimes = %i\n",ntimes);
	ntimes++;
	goto inizio;
    };
    printf(" ntimes = %i\n",ntimes);
    ntimes++;
    goto inizio;
}


TString getEmiFile2(TString base, TString packetType, TString subType){
    Int_t debug = 0;
    //
    TString newfile;
    stringcopy(newfile,base);
    //
    string fil = base;
    Int_t posiz = fil.find("dw_");
    Int_t upper = 0;
    if ( posiz == -1 ) {
	posiz = fil.find("DW_");
	upper = 1;
    };
    if ( posiz == -1 ) return "";    
    TString fullname;
    stringcopy(fullname,base,posiz,posiz+15);
    stringappend(fullname,".");
    stringappend(fullname,packetType);
    stringappend(fullname,".");
    stringappend(fullname,subType);
    stringappend(fullname,".root");
    //
    stringappend(newfile,"/");
    stringappend(newfile,packetType);
    stringappend(newfile,"/");
    stringappend(newfile,fullname);
    //    char *vediamo;
    //vediamo = newfile;
    //printf("filename: %s \n",vediamo);
    //return;
    TFile retfile(newfile);
    if ( retfile.IsZombie() ) {
	return "nofile";      
    } else {
	retfile.Close();
	return newfile;      
    };
}



void RootTestE2(TString filename){
    Long64_t ntimes = 0;
    Long64_t ncalibs = 0;
    Int_t forever = 1;
    while ( forever ){
	printf(" ntimes = %i\n",(int)ntimes);
	TFile *calheadFile = 0;
	calheadFile = getEmiFile(filename, "CalibCalPed","Header");    
	TFile *calcalibFile = 0;
	calcalibFile = getEmiFile(filename, "CalibCalPed");    
	//
	//gObjectTable->Print();
	//
	if ( !calcalibFile || !calheadFile ) {	    
	    printf(" -> not able to open file \n");
	    if ( calheadFile ) calheadFile->Close();
	    if ( calcalibFile ) calcalibFile->Close();
	} else {
	    TTree *tr = (TTree*)calheadFile->Get("Pscu");
	    tr->AddFriend("CalibCalPed", calcalibFile);
	    //	    pamela::calorimeter::CalibCalPedEvent *ce = 0;
	    pamela::CalibCalPedEvent *ce = 0;
	    pamela::PscuHeader *cph = 0;
	    pamela::EventHeader *ceh = 0;
	    tr->SetBranchAddress("Header", &ceh);
	    tr->SetBranchAddress("Event", &ce);
	    ncalibs    = tr->GetEntries();
	    printf(" -> ncalibs = %i \n",(int)ncalibs);
	    calheadFile->Close();
	    calcalibFile->Close();	    
	};
	ntimes++;
    };
}

void trktesting(TString filename){    
    TString startingdir = gSystem->WorkingDirectory();
    char *bdir;
    char *sdir=gSystem->Getenv("PAM_LIB");
    bdir = Form("%s/liboptrklev1.so",sdir);
    gSystem->Load(bdir);
    bdir = Form("%s/liboptrklev1_C.so",sdir);
    gSystem->Load(bdir);
    bdir = Form("%s/libretrklev1.so",sdir);
    gSystem->Load(bdir);
    bdir = Form("%s/libretrklev1_C.so",sdir);
    gSystem->Load(bdir);
    bdir = Form("%s/libcltrklev1.so",sdir);
    gSystem->Load(bdir);
    bdir = Form("%s/libcltrklev1_C.so",sdir);
    gSystem->Load(bdir);   
    Int_t trnev = 0;
    struct Tracklev1 trklev1;
    char *name;
    name = filename;
    //char *name2;
    //name2 = filename;
    ////    name = Form("%s",filename);
    //name = name2;
    //trnev = 123;
    //printf("name = %s \n",name);
    //printf("filename = %s \n",name2);
    coptrklev1(name,trklev1,trnev);
    //coptrklev1();
    printf("The tracker ntuple contains %i events\n",trnev);
    for ( Int_t i = 1; i < trnev+1; i++){
	cretrklev1(i,trklev1);
	printf("Event number %i ---> OBT %i \n",i,trklev1.obt1);
	printf("                ---> PKTnum %i \n",trklev1.pkt_num1);
	printf("                ---> PKTtype %x \n",trklev1.pkt_type1);
	printf("                ---> nev1 %i \n",trklev1.nev1);
	printf("                ---> good %i \n",trklev1.good1);
	printf("                ---> nclstr %i \n",trklev1.nclstr1);
    };
    ccltrklev1(trklev1);        
    //ccltrklev1(); 
}

void trktesting2(TString filename){    
    TString startingdir = gSystem->WorkingDirectory();
    char *bdir;
    char *sdir;
    sdir = startingdir;
    bdir = Form("%s/tracker/liboptrklev2.so",sdir);
    gSystem->Load(bdir);
    bdir = Form("%s/tracker/coptrklev2_C.so",sdir);
    gSystem->Load(bdir);
    bdir = Form("%s/tracker/libretrklev2.so",sdir);
    gSystem->Load(bdir);
    bdir = Form("%s/tracker/cretrklev2_C.so",sdir);
    gSystem->Load(bdir);
    bdir = Form("%s/tracker/libcltrklev2.so",sdir);
    gSystem->Load(bdir);
    bdir = Form("%s/tracker/ccltrklev2_C.so",sdir);
    gSystem->Load(bdir);
    Int_t trnev = 0;
    struct Tracklev2 trklev2;
    char *name;
    name = filename;
    coptrklev2(name,trklev2,trnev);
    printf("The tracker ntuple contains %i events\n",trnev);
    for ( Int_t i = 1; i < trnev+1; i++){
	cretrklev2(i,trklev2);
	printf("Event number %i ---> OBT %i \n",i,trklev2.obt);
	printf("                ---> PKTnum %i \n",trklev2.pkt_num);
	printf("                ---> PKTtype %x \n",trklev2.pkt_type);
	printf("                ---> nev2 %i \n",trklev2.nev2);
	printf("                ---> good2 %i \n",trklev2.good2);
	printf("                ---> ntrk %i \n",trklev2.ntrk);
	if ( trklev2.ntrk == 1 && trklev2.al[0][4] != 0. ) printf("c-> RIG = %.9f \n",1./trklev2.al[0][4]);
    };
    ccltrklev2(trklev2);        
    //ccltrklev1(); 
}

void trkhtestlev2(TString filename){
    //    char *name;
    //name = filename;
    //char *nome;
    //nome = Form("%s/Physics/Level1/",name);
    //    TFile *f = new TFile(nome);
    TFile *f = getFile(filename,"Physics.Level2","Tracker");
    TFile *caloFile;
    caloFile = getFile(filename, "Physics.Level2", "Calorimeter");
    TTree *tr = (TTree*) f->Get("TrkLevel2");
    tr->AddFriend("CaloLevel2", caloFile);
    struct Tracklev2 trk;
    struct CTracklev2 track;
    settrklev2(tr,trk);
    Int_t nevents = tr->GetEntries();    
    CalorimeterLevel2 *calo = new CalorimeterLevel2();
    tr->SetBranchAddress("CaloLevel2.Event",&calo);
    for ( Int_t i = 0; i<nevents ; i++){
	tr->GetEntry(i);
	accesstrklev2(trk,track);
	printf("Event %i tracker OBT = %i \n",i,track.obt);
	if ( track.ntrk>0 ) printf("Event %i tracker RIG = %f \n",i,1./track.al[4][0]);
	//	Float_t obt = (float)trk.obt1;
	//printf("Event %i tracker OBT1 = %f \n",i,obt);
	printf("Event %i calo OBT = %i \n",i,calo->OBT);
    };
}

void trkhtest(TString filename){
    //    char *name;
    //name = filename;
    //char *nome;
    //nome = Form("%s/Physics/Level1/",name);
    //    TFile *f = new TFile(nome);
    TFile *f = getFile(filename,"Physics.Level1","Tracker");
    TFile *caloFile;
    caloFile = getFile(filename, "Physics.Level2", "Calorimeter");
    TTree *tr = (TTree*) f->Get("TrkLevel1");
    tr->AddFriend("CaloLevel2", caloFile);
    struct Tracklev1 trk;
    struct CTracklev1 track;
    settrklev1(tr,trk);
    Int_t nevents = tr->GetEntries();    
    CalorimeterLevel2 *calo = new CalorimeterLevel2();
    tr->SetBranchAddress("CaloLevel2.Event",&calo);
    for ( Int_t i = 0; i<nevents ; i++){
	tr->GetEntry(i);
	accesstrklev1(trk,track);
	printf("Event %i tracker OBT1 = %i \n",i,track.obt1);
	//	Float_t obt = (float)trk.obt1;
	//printf("Event %i tracker OBT1 = %f \n",i,obt);
	printf("Event %i calo OBT1 = %i \n",i,calo->OBT);
    };
}


void trkhtest2(TString filename){
    TFile *f = new TFile(filename);
    TTree *tr = (TTree*) f->Get("TrkLevel1");
    TrackerLevel1 *trk = new TrackerLevel1();
    //struct Tracklev1 trk;
    tr->SetBranchAddress("good1", &trk->good1);                
    tr->SetBranchAddress("obt1", &trk->obt1);                
    tr->SetBranchAddress("pkt_num1", &trk->pkt_num1);                
    //tr->SetBranchAddress("obt1", &trk.obt1);                
    Int_t nevents = tr->GetEntries();    
    for ( Int_t i = 0; i<nevents ; i++){
	tr->GetEntry(i);
	printf("Event %i GOOD1 = %i \n",i,trk->good1);
	printf("Event %i PKT_NUM1 = %i \n",i,trk->pkt_num1);
	printf("Event %i OBT1 = %i \n",i,trk->obt1);
    };
}
