//
//   Graph calorimeter values vs time OBT - Giovanna Jerse

//      creation date : 02/01/2008
//   
//
//   The only input needed is the path to the directory created by YODA for the data file you want to analyze.
//
//  



#include <iostream>
#include <fstream>
//
#include <TTree.h>
#include <TObject.h>
#include <TString.h>
#include <TFile.h>
#include <TCanvas.h>
#include <TH1.h>
#include <TPolyLine.h>
#include <TH2F.h>
#include <TH2D.h>
#include <TLatex.h>
#include <TPad.h>
#include <TPaveLabel.h>
#include <TStyle.h>
#include <TSystem.h>
#include <TApplication.h>
#include <TLegend.h>
//
#include <CalibCalPedEvent.h>
#include <PamelaRun.h>
#include <PhysEndRunEvent.h>
#include <CaloEndRun.h>

//

UInt_t minimo (UInt_t vet[], Long64_t n );


UInt_t massimo (UInt_t vet[], Long64_t n);



using namespace std;
//
void stringcopy(TString& s1, const TString& s2, Int_t from=0, Int_t to=0){    
  if ( to == 0 ){
    Int_t t2length = s2.Length();
    s1 = "";
    to = t2length;
  };
  for (Int_t i = from; i<to; i++){



    s1.Append(s2[i],1);
  };
}
void stringappend(TString& s1, const TString& s2){    
  Int_t t2length = s2.Length();
  for (Int_t i = 0; i<t2length; i++){
    s1.Append(s2[i],1);
  };
}

TString getFilename(const TString filename){
  //
  const string fil = gSystem->BaseName(filename.Data());
  Int_t posiz = fil.find(".root");
  //
  TString file2;
  if ( posiz == -1 ){
    file2 = gSystem->BaseName(filename.Data());
  } else {
    Int_t posiz2 = 0;
    stringcopy(file2,gSystem->BaseName(filename.Data()),posiz2,posiz);
    TString pdat(".dat");
    stringappend(file2,pdat);  
  };
  return file2;
}
 

UInt_t minimo (UInt_t vet[], Long64_t n )  {

   UInt_t min;

   min = vet[0];

   for(Int_t i = 0; i <n; i++) 
 
   if(vet[i]<=min) min = vet[i];  

   return (min);

     }   



UInt_t massimo (UInt_t vet[], Long64_t n ) {

      UInt_t max;

      max = vet[0];

      for(Int_t i = 0; i < n; i++) 
 
      if(vet[i] >= max) max = vet[i]; 

      return (max);

}


 


void qlook_cal(TString filename, TString outDir="", TString saveas = "png", Bool_t iactive =false, Bool_t w4i=false) {


  gStyle->SetPaperSize(19.,25.);
  const char* startingdir = gSystem->WorkingDirectory();
  if ( !strcmp(outDir.Data(),"") ) outDir = startingdir; 

  //TApplication *app = 0; //crea un ambiente root (app)
  // app = new TApplication("app",0,0);//verifica se deve essere interattivo
  
  //nome del file 
  TString fififile =  getFilename(filename);
  const char *file;
  file = fififile;
  
  //verifica se esiste il file
  ifstream myfile;
  myfile.open(filename.Data());
  if ( !myfile ){
    printf(" %s :no such file, exiting...\n\n",filename.Data());
    return;
  };
  myfile.close();
//

  //apre il file in 'File'
  TFile *File = new TFile(filename.Data());
 

  
  //crea struttura tree (tr) con il tree "PhysEndRun" in File
  TTree *tr = (TTree*)File->Get("PhysEndRun");

  //crea struttura tree (cppuhe) con il tree "Header" in File
  //  TTree *header = (TTree*)File->Get("Header");

  if ( !tr ) {
    printf(" PhysEndRun : no such tree in %s \n",filename.Data());
    printf(" Exiting, are you sure this is a LEVEL0 not corrupted file? \n\n");
    return;
  };

  pamela::PhysEndRunEvent *pher= new pamela::PhysEndRunEvent();

   tr->SetBranchAddress("PhysEndRun", &pher);                                       //dichiaro in che ramo trovare quello che voglio puntare con ph
   
 
   pamela::EventHeader *he = new pamela::EventHeader;                               //definisco variabili di tipo header
 
   tr->SetBranchAddress("Header", &he);                                             //dichiaro dove trovare quello che voglio in eh
 
  

   Long64_t  n_entries = tr->GetEntries();                                        //define number of entries  (valori di tensione e corrente)
   
   
   //   UInt_t obt = (UInt_t)he->GetPscuHeader()->GetOrbitalTime();                    // definisce l'orbital time
   
   UInt_t time_obt[n_entries]; 


   
   for(Int_t i = 0; i < n_entries; i++)   {
     
     tr->GetEntry(i);

     time_obt[i] = (UInt_t)he->GetPscuHeader()->GetOrbitalTime();
     
   }
      

  

   
   UInt_t max_obt = massimo(time_obt, n_entries);
     
   UInt_t min_obt = minimo(time_obt, n_entries);


     

    // create Histograms

   // grafici corrente xe

   
   TH2F *hITS1_1 = new TH2F("hITS1_1","Current:Section xe ",1000,min_obt,max_obt*1.006,1000,-500., 500.);

   //   hITS1_1->SetBit(TH2::kCanRebin);

   hITS1_1->SetStats(0);

   hITS1_1->SetFillColor(42);

   hITS1_1->GetXaxis()->SetTitle("time");

   hITS1_1->GetYaxis()->SetTitle("current [micronA]");

   hITS1_1->GetYaxis()->SetTitleOffset(1.2);
   
   hITS1_1->SetMarkerColor(1);

   hITS1_1->SetMarkerStyle(21);

   hITS1_1->SetMarkerSize(0.8);


   TH2F *hITS1_2 = new TH2F("hITS1_2","Current:Section xe ",1000,min_obt,max_obt,1000,-500., 500.);

   // hITS1_2->SetBit(TH2::kCanRebin);

   hITS1_2->SetStats(0);

   hITS1_2->SetFillColor(42);

   hITS1_2->GetXaxis()->SetTitle("time");

   hITS1_2->GetYaxis()->SetTitle("current [micronA]");
   
   hITS1_2->SetMarkerColor(2);

   hITS1_2->SetMarkerStyle(21);

   hITS1_2->SetMarkerSize(0.8);


   TH2F *hITS1_3 = new TH2F("hITS1_3","Current:Section xe plane 3",1000,min_obt,max_obt,1000,-500., 500.);

   //hITS1_3->SetBit(TH2::kCanRebin);

   hITS1_3->SetStats(0);

   hITS1_3->SetFillColor(42);

   hITS1_3->GetXaxis()->SetTitle("time");

   hITS1_3->GetYaxis()->SetTitle("current [micronA]");
   
   hITS1_3->SetMarkerColor(3);

   hITS1_3->SetMarkerStyle(21);

   hITS1_3->SetMarkerSize(0.8);


   TH2F *hITS1_4 = new TH2F("hITS1_4","Current:Section xe plane 4",1000,min_obt,max_obt,1000,-500., 500.);

   //hITS1_4->SetBit(TH2::kCanRebin);

   hITS1_4->SetStats(0);

   hITS1_4->SetFillColor(42);

   hITS1_4->GetXaxis()->SetTitle("time");

   hITS1_4->GetYaxis()->SetTitle("current [micronA]");
   
   hITS1_4->SetMarkerColor(4);

   hITS1_4->SetMarkerStyle(21);

   hITS1_4->SetMarkerSize(0.8);


   TH2F *hITS1_5 = new TH2F("hITS1_5","Current:Section xe plane 5",1000,min_obt,max_obt,1000,-500., 500.);

   //hITS1_5->SetBit(TH2::kCanRebin);

   hITS1_5->SetStats(0);

   hITS1_5->SetFillColor(42);

   hITS1_5->GetXaxis()->SetTitle("time");

   hITS1_5->GetYaxis()->SetTitle("current [micronA]");
   
   hITS1_5->SetMarkerColor(5);

   hITS1_5->SetMarkerStyle(21);

   hITS1_5->SetMarkerSize(0.8);


   TH2F *hITS1_6 = new TH2F("hITS1_6","Current:Section xe plane 6",1000,min_obt,max_obt,1000,-500., 500.);

   //hITS1_6->SetBit(TH2::kCanRebin);

   hITS1_6->SetStats(0);

   hITS1_6->SetFillColor(42);

   hITS1_6->GetXaxis()->SetTitle("time");

   hITS1_6->GetYaxis()->SetTitle("current [micronA]");
   
   hITS1_6->SetMarkerColor(6);

   hITS1_6->SetMarkerStyle(21);

   hITS1_6->SetMarkerSize(0.8);


   TH2F *hITS1_7 = new TH2F("hITS1_7","Current:Section xe plane 7",1000,min_obt,max_obt,1000,-500., 500.);

 //hITS1_7->SetBit(TH2::kCanRebin);

   hITS1_7->SetStats(0);

   hITS1_7->SetFillColor(42);

   hITS1_7->GetXaxis()->SetTitle("time");

   hITS1_7->GetYaxis()->SetTitle("current [micronA]");
   
   hITS1_7->SetMarkerColor(7);

   hITS1_7->SetMarkerStyle(21);

   hITS1_7->SetMarkerSize(0.8);


   TH2F *hITS1_8 = new TH2F("hITS1_8","Current:Section xe plane 8",1000,min_obt,max_obt,1000,-500., 500.);

   //hITS1_8->SetBit(TH2::kCanRebin);

   hITS1_8->SetStats(0);

   hITS1_8->SetFillColor(42);

   hITS1_8->GetXaxis()->SetTitle("time");

   hITS1_8->GetYaxis()->SetTitle("current [micronA]");
   
   hITS1_8->SetMarkerColor(8);

   hITS1_8->SetMarkerStyle(21);

   hITS1_8->SetMarkerSize(0.8);


   TH2F *hITS1_9 = new TH2F("hITS1_9","Current:Section xe plane 9",1000,min_obt,max_obt,1000,-1.0, 10.);

   hITS1_9->SetBit(TH2::kCanRebin);

   hITS1_9->SetStats(0);

   hITS1_9->SetFillColor(42);

   hITS1_9->GetXaxis()->SetTitle("time");

   hITS1_9->GetYaxis()->SetTitle("current [micronA]");
   
   hITS1_9->SetMarkerColor(9);

   hITS1_9->SetMarkerStyle(21);

   hITS1_9->SetMarkerSize(0.8);


   TH2F *hITS1_10 = new TH2F("hITS1_10","Current:Section xe plane 10",1000,min_obt,max_obt,1000,-1.0, 10.);

   hITS1_10->SetBit(TH2::kCanRebin);

   hITS1_10->SetStats(0);

   hITS1_10->SetFillColor(42);

   hITS1_10->GetXaxis()->SetTitle("time");

   hITS1_10->GetYaxis()->SetTitle("current [micronA]");
   
   hITS1_10->SetMarkerColor(11);

   hITS1_10->SetMarkerStyle(21);

   hITS1_10->SetMarkerSize(0.8);


   TH2F *hITS1_11 = new TH2F("hITS1_11","Current:Section xe plane 11",1000,min_obt,max_obt,1000,-1.0, 10.);

   hITS1_11->SetBit(TH2::kCanRebin);

   hITS1_11->SetStats(0);

   hITS1_11->SetFillColor(42);

   hITS1_11->GetXaxis()->SetTitle("time");

   hITS1_11->GetYaxis()->SetTitle("current [micronA]");
   
   hITS1_11->SetMarkerColor(12);

   hITS1_11->SetMarkerStyle(21);

   hITS1_11->SetMarkerSize(0.8);




   


   // grafici prima  canvas  seconda  pad


   // grafici corrente xo

   
   TH2F *hITS2_1 = new TH2F("hITS2_1","Current:Section xo ",1000,min_obt,max_obt*1.006,1000,-500., 500.);

   //  hITS2_1->SetBit(TH2::kCanRebin);

   hITS2_1->SetStats(0);

   hITS2_1->SetFillColor(42);

   hITS2_1->GetXaxis()->SetTitle("time");

   hITS2_1->GetYaxis()->SetTitle("current [micronA]");

   hITS2_1->GetYaxis()->SetTitleOffset(1.2);
   
   hITS2_1->SetMarkerColor(1);

   hITS2_1->SetMarkerStyle(3);

   hITS2_1->SetMarkerSize(0.8);


   TH2F *hITS2_2 = new TH2F("hITS2_2","Current:Section xo plane 2",1000,min_obt,max_obt,1000,-1.0, 10.);

   hITS2_2->SetBit(TH2::kCanRebin);

   hITS2_2->SetStats(0);

   hITS2_2->SetFillColor(42);

   hITS2_2->GetXaxis()->SetTitle("time");

   hITS2_2->GetYaxis()->SetTitle("current [micronA]");
   
   hITS2_2->SetMarkerColor(2);

   hITS2_2->SetMarkerStyle(3);

   hITS2_2->SetMarkerSize(0.8);


   TH2F *hITS2_3 = new TH2F("hITS2_3","Current:Section xo plane 3",1000,min_obt,max_obt,1000,-1.0, 10.);

   hITS2_3->SetBit(TH2::kCanRebin);

   hITS2_3->SetStats(0);

   hITS2_3->SetFillColor(42);

   hITS2_3->GetXaxis()->SetTitle("time");

   hITS2_3->GetYaxis()->SetTitle("current [micronA]");
   
   hITS2_3->SetMarkerColor(3);

   hITS2_3->SetMarkerStyle(3);

   hITS2_3->SetMarkerSize(0.8);


   TH2F *hITS2_4 = new TH2F("hITS2_4","Current:Section xo plane 4",1000,min_obt,max_obt,1000,-1.0, 10.);

   hITS2_4->SetBit(TH2::kCanRebin);

   hITS2_4->SetStats(0);

   hITS2_4->SetFillColor(42);

   hITS2_4->GetXaxis()->SetTitle("time");

   hITS2_4->GetYaxis()->SetTitle("current [micronA]");
   
   hITS2_4->SetMarkerColor(4);

   hITS2_4->SetMarkerStyle(3);

   hITS2_4->SetMarkerSize(0.8);


   TH2F *hITS2_5 = new TH2F("hITS_5","Current:Section xo plane 5",1000,min_obt,max_obt,1000,-1.0, 10.);

   hITS2_5->SetBit(TH2::kCanRebin);

   hITS2_5->SetStats(0);

   hITS2_5->SetFillColor(42);

   hITS2_5->GetXaxis()->SetTitle("time");

   hITS2_5->GetYaxis()->SetTitle("current [micronA]");
   
   hITS2_5->SetMarkerColor(5);

   hITS2_5->SetMarkerStyle(3);

   hITS2_5->SetMarkerSize(0.8);


   TH2F *hITS2_6 = new TH2F("hITS2_6","Current:Section xo plane 6",1000,min_obt,max_obt,1000,-1.0, 10.);

   hITS2_6->SetBit(TH2::kCanRebin);

   hITS2_6->SetStats(0);

   hITS2_6->SetFillColor(42);

   hITS2_6->GetXaxis()->SetTitle("time");

   hITS2_6->GetYaxis()->SetTitle("current [micronA]");
   
   hITS2_6->SetMarkerColor(6);

   hITS2_6->SetMarkerStyle(3);

   hITS2_6->SetMarkerSize(0.8);


   TH2F *hITS2_7 = new TH2F("hITS2_7","Current:Section xo plane 7",1000,min_obt,max_obt,1000,-1.0, 10.);

   hITS2_7->SetBit(TH2::kCanRebin);

   hITS2_7->SetStats(0);

   hITS2_7->SetFillColor(42);

   hITS2_7->GetXaxis()->SetTitle("time");

   hITS2_7->GetYaxis()->SetTitle("current [micronA]");
   
   hITS2_7->SetMarkerColor(7);

   hITS2_7->SetMarkerStyle(3);

   hITS2_7->SetMarkerSize(0.8);


   TH2F *hITS2_8 = new TH2F("hITS2_8","Current:Section xo plane 8",1000,min_obt,max_obt,1000,-1.0, 10.);

   hITS2_8->SetBit(TH2::kCanRebin);

   hITS2_8->SetStats(0);

   hITS2_8->SetFillColor(42);

   hITS2_8->GetXaxis()->SetTitle("time");

   hITS2_8->GetYaxis()->SetTitle("current [micronA]");
   
   hITS2_8->SetMarkerColor(8);

   hITS2_8->SetMarkerStyle(3);

   hITS2_8->SetMarkerSize(0.8);


   TH2F *hITS2_9 = new TH2F("hITS2_9","Current:Section xo plane 9",1000,min_obt,max_obt,1000,-1.0, 10.);

   hITS2_9->SetBit(TH2::kCanRebin);

   hITS2_9->SetStats(0);

   hITS2_9->SetFillColor(42);

   hITS2_9->GetXaxis()->SetTitle("time");

   hITS2_9->GetYaxis()->SetTitle("current [micronA]");
   
   hITS2_9->SetMarkerColor(9);

   hITS2_9->SetMarkerStyle(3);

   hITS2_9->SetMarkerSize(0.8);


   TH2F *hITS2_10 = new TH2F("hITS2_10","Current:Section xo plane 10 ",1000,min_obt,max_obt,1000,-1.0, 10.);

   hITS2_10->SetBit(TH2::kCanRebin);

   hITS2_10->SetStats(0);

   hITS2_10->SetFillColor(42);

   hITS2_10->GetXaxis()->SetTitle("time");

   hITS2_10->GetYaxis()->SetTitle("current [micronA]");
   
   hITS2_10->SetMarkerColor(11);

   hITS2_10->SetMarkerStyle(3);

   hITS2_10->SetMarkerSize(0.8);


   TH2F *hITS2_11 = new TH2F("hITS2_11","Current:Section xo plane 11",1000,min_obt,max_obt,1000,-1.0, 10.);

   hITS2_11->SetBit(TH2::kCanRebin);

   hITS2_11->SetStats(0);

   hITS2_11->SetFillColor(42);

   hITS2_11->GetXaxis()->SetTitle("time");

   hITS2_11->GetYaxis()->SetTitle("current [micronA]");
   
   hITS2_11->SetMarkerColor(12);

   hITS2_11->SetMarkerStyle(3);

   hITS2_11->SetMarkerSize(0.8);


 // grafici prima  canvas  terza  pad


   // grafici corrente ye

   
   TH2F *hITS3_1 = new TH2F("hITS3_1","Current:Section ye ",1000,min_obt,max_obt*1.006,1000,-500., 500.);

   //  hITS3_1->SetBit(TH2::kCanRebin);

   hITS3_1->SetStats(0);

   hITS3_1->SetFillColor(42);

   hITS3_1->GetXaxis()->SetTitle("time");

   hITS3_1->GetYaxis()->SetTitle("current [micronA]");

   hITS3_1->GetYaxis()->SetTitleOffset(1.2);
   
   hITS3_1->SetMarkerColor(1);

   hITS3_1->SetMarkerStyle(22);

   hITS3_1->SetMarkerSize(0.8);


   TH2F *hITS3_2 = new TH2F("hITS3_2","Current:Section ye plane 2",1000,min_obt,max_obt,1000,-1.0, 10.);

   hITS3_2->SetBit(TH2::kCanRebin);

   hITS3_2->SetStats(0);

   hITS3_2->SetFillColor(42);

   hITS3_2->GetXaxis()->SetTitle("time");

   hITS3_2->GetYaxis()->SetTitle("current [micronA]");
   
   hITS3_2->SetMarkerColor(2);

   hITS3_2->SetMarkerStyle(22);

   hITS3_2->SetMarkerSize(0.8);


   TH2F *hITS3_3 = new TH2F("hITS3_3","Current:Section ye plane 3",1000,min_obt,max_obt,1000,-1.0, 10.);

   hITS3_3->SetBit(TH2::kCanRebin);

   hITS3_3->SetStats(0);

   hITS3_3->SetFillColor(42);

   hITS3_3->GetXaxis()->SetTitle("time");

   hITS3_3->GetYaxis()->SetTitle("current [micronA]");
   
   hITS3_3->SetMarkerColor(3);

   hITS3_3->SetMarkerStyle(22);

   hITS3_3->SetMarkerSize(0.8);


   TH2F *hITS3_4 = new TH2F("hITS3_4","Current:Section ye plane 4",1000,min_obt,max_obt,1000,-1.0, 10.);

   hITS3_4->SetBit(TH2::kCanRebin);

   hITS3_4->SetStats(0);

   hITS3_4->SetFillColor(42);

   hITS3_4->GetXaxis()->SetTitle("time");

   hITS3_4->GetYaxis()->SetTitle("current [micronA]");
   
   hITS3_4->SetMarkerColor(4);

   hITS3_4->SetMarkerStyle(22);

   hITS3_4->SetMarkerSize(0.8);


   TH2F *hITS3_5 = new TH2F("hITS3_5","Current:Section ye plane 5",1000,min_obt,max_obt,1000,-1.0, 10.);

   hITS3_5->SetBit(TH2::kCanRebin);

   hITS3_5->SetStats(0);

   hITS3_5->SetFillColor(42);

   hITS3_5->GetXaxis()->SetTitle("time");

   hITS3_5->GetYaxis()->SetTitle("current [micronA]");
   
   hITS3_5->SetMarkerColor(5);

   hITS3_5->SetMarkerStyle(22);

   hITS3_5->SetMarkerSize(0.8);


   TH2F *hITS3_6 = new TH2F("hITS3_6","Current:Section ye plane 6",1000,min_obt,max_obt,1000,-1.0, 10.);

   hITS3_6->SetBit(TH2::kCanRebin);

   hITS3_6->SetStats(0);

   hITS3_6->SetFillColor(42);

   hITS3_6->GetXaxis()->SetTitle("time");

   hITS3_6->GetYaxis()->SetTitle("current [micronA]");
   
   hITS3_6->SetMarkerColor(6);

   hITS3_6->SetMarkerStyle(22);

   hITS3_6->SetMarkerSize(0.8);


   TH2F *hITS3_7 = new TH2F("hITS3_7","Current:Section ye plane 7",1000,min_obt,max_obt,1000,-1.0, 10.);

   hITS3_7->SetBit(TH2::kCanRebin);

   hITS3_7->SetStats(0);

   hITS3_7->SetFillColor(42);

   hITS3_7->GetXaxis()->SetTitle("time");

   hITS3_7->GetYaxis()->SetTitle("current [micronA]");
   
   hITS3_7->SetMarkerColor(7);

   hITS3_7->SetMarkerStyle(22);

   hITS3_7->SetMarkerSize(0.8);


   TH2F *hITS3_8 = new TH2F("hITS3_8","Current:Section ye plane 8",1000,min_obt,max_obt,1000,-1.0, 10.);

   hITS3_8->SetBit(TH2::kCanRebin);

   hITS3_8->SetStats(0);

   hITS3_8->SetFillColor(42);

   hITS3_8->GetXaxis()->SetTitle("time");

   hITS3_8->GetYaxis()->SetTitle("current [micronA]");
   
   hITS3_8->SetMarkerColor(8);

   hITS3_8->SetMarkerStyle(22);

   hITS3_8->SetMarkerSize(0.8);


   TH2F *hITS3_9 = new TH2F("hITS3_9","Current:Section ye plane 9",1000,min_obt,max_obt,1000,-1.0, 10.);

   hITS3_9->SetBit(TH2::kCanRebin);

   hITS3_9->SetStats(0);

   hITS3_9->SetFillColor(42);

   hITS3_9->GetXaxis()->SetTitle("time");

   hITS3_9->GetYaxis()->SetTitle("current [micronA]");
   
   hITS3_9->SetMarkerColor(9);

   hITS3_9->SetMarkerStyle(22);

   hITS3_9->SetMarkerSize(0.8);


   TH2F *hITS3_10 = new TH2F("hITS3_10","Current:Section ye plane 10",1000,min_obt,max_obt,1000,-1.0, 10.);

   hITS3_10->SetBit(TH2::kCanRebin);

   hITS3_10->SetStats(0);

   hITS3_10->SetFillColor(42);

   hITS3_10->GetXaxis()->SetTitle("time");

   hITS3_10->GetYaxis()->SetTitle("current [micronA]");
   
   hITS3_10->SetMarkerColor(11);

   hITS3_10->SetMarkerStyle(22);

   hITS3_10->SetMarkerSize(0.8);


   TH2F *hITS3_11 = new TH2F("hITS3_11","Current:Section ye plane 11",1000,min_obt,max_obt,1000,-1.0, 10.);

   hITS3_11->SetBit(TH2::kCanRebin);

   hITS3_11->SetStats(0);

   hITS3_11->SetFillColor(42);

   hITS3_11->GetXaxis()->SetTitle("time");

   hITS3_11->GetYaxis()->SetTitle("current [micronA]");
   
   hITS3_11->SetMarkerColor(12);

   hITS3_11->SetMarkerStyle(22);

   hITS3_11->SetMarkerSize(0.8);




  

 // grafici prima  canvas  quarta  pad


   // grafici corrente yo


   TH2F *hITS4_1 = new TH2F("hITS4_1","Current:Section yo",1000,min_obt,max_obt*1.006,1000,-500., 500.);

   //  hITS4_1->SetBit(TH2::kCanRebin);

   hITS4_1->SetStats(0);

   hITS4_1->SetFillColor(42);

   hITS4_1->GetXaxis()->SetTitle("time");

   hITS4_1->GetYaxis()->SetTitle("current [micronA]");

   hITS4_1->GetYaxis()->SetTitleOffset(1.2);
   
   hITS4_1->SetMarkerColor(1);

   hITS4_1->SetMarkerStyle(25);

   hITS4_1->SetMarkerSize(0.8);


   TH2F *hITS4_2 = new TH2F("hITS4_2","Current:Section yo plane 2",1000,min_obt,max_obt,1000,-1.0, 10.);

   hITS4_2->SetBit(TH2::kCanRebin);

   hITS4_2->SetStats(0);

   hITS4_2->SetFillColor(42);

   hITS4_2->GetXaxis()->SetTitle("time");

   hITS4_2->GetYaxis()->SetTitle("current [micronA]");
   
   hITS4_2->SetMarkerColor(2);

   hITS4_2->SetMarkerStyle(25);

   hITS4_2->SetMarkerSize(0.8);


   TH2F *hITS4_3 = new TH2F("hITS4_3","Current:Section yo plane 3",1000,min_obt,max_obt,1000,-1.0, 10.);

   hITS4_3->SetBit(TH2::kCanRebin);

   hITS4_3->SetStats(0);

   hITS4_3->SetFillColor(42);

   hITS4_3->GetXaxis()->SetTitle("time");

   hITS4_3->GetYaxis()->SetTitle("current [micronA]");
   
   hITS4_3->SetMarkerColor(3);

   hITS4_3->SetMarkerStyle(25);

   hITS4_3->SetMarkerSize(0.8);


   TH2F *hITS4_4 = new TH2F("hITS4_4","Current:Section yo plane 4",1000,min_obt,max_obt,1000,-1.0, 10.);

   hITS4_4->SetBit(TH2::kCanRebin);

   hITS4_4->SetStats(0);

   hITS4_4->SetFillColor(42);

   hITS4_4->GetXaxis()->SetTitle("time");

   hITS4_4->GetYaxis()->SetTitle("current [micronA]");
   
   hITS4_4->SetMarkerColor(4);

   hITS4_4->SetMarkerStyle(25);

   hITS4_4->SetMarkerSize(0.8);


   TH2F *hITS4_5 = new TH2F("hITS4_5","Current:Section yo plane 5",1000,min_obt,max_obt,1000,-1.0, 10.);

   hITS4_5->SetBit(TH2::kCanRebin);

   hITS4_5->SetStats(0);

   hITS4_5->SetFillColor(42);

   hITS4_5->GetXaxis()->SetTitle("time");

   hITS4_5->GetYaxis()->SetTitle("current [micronA]");
   
   hITS4_5->SetMarkerColor(5);

   hITS4_5->SetMarkerStyle(25);

   hITS4_5->SetMarkerSize(0.8);


   TH2F *hITS4_6 = new TH2F("hITS4_6","Current:Section yo plane 6",1000,min_obt,max_obt,1000,-1.0, 10.);

   hITS4_6->SetBit(TH2::kCanRebin);

   hITS4_6->SetStats(0);

   hITS4_6->SetFillColor(42);

   hITS4_6->GetXaxis()->SetTitle("time");

   hITS4_6->GetYaxis()->SetTitle("current [micronA]");
   
   hITS4_6->SetMarkerColor(6);

   hITS4_6->SetMarkerStyle(25);

   hITS4_6->SetMarkerSize(0.8);


   TH2F *hITS4_7 = new TH2F("hITS4_7","Current:Section yo plane 7",1000,min_obt,max_obt,1000,-1.0, 10.);

   hITS4_7->SetBit(TH2::kCanRebin);

   hITS4_7->SetStats(0);

   hITS4_7->SetFillColor(42);

   hITS4_7->GetXaxis()->SetTitle("time");

   hITS4_7->GetYaxis()->SetTitle("current [micronA]");
   
   hITS4_7->SetMarkerColor(7);

   hITS4_7->SetMarkerStyle(25);

   hITS4_7->SetMarkerSize(0.8);


   TH2F *hITS4_8 = new TH2F("hITS4_8","Current:Section y0 plane 8",1000,min_obt,max_obt,1000,-1.0, 10.);

   hITS4_8->SetBit(TH2::kCanRebin);

   hITS4_8->SetStats(0);

   hITS4_8->SetFillColor(42);

   hITS4_8->GetXaxis()->SetTitle("time");

   hITS4_8->GetYaxis()->SetTitle("current [micronA]");
   
   hITS4_8->SetMarkerColor(8);

   hITS4_8->SetMarkerStyle(25);

   hITS4_8->SetMarkerSize(0.8);


   TH2F *hITS4_9 = new TH2F("hITS4_9","Current:Section yo plane 9",1000,min_obt,max_obt,1000,-1.0, 10.);

   hITS4_9->SetBit(TH2::kCanRebin);

   hITS4_9->SetStats(0);

   hITS4_9->SetFillColor(42);

   hITS4_9->GetXaxis()->SetTitle("time");

   hITS4_9->GetYaxis()->SetTitle("current [micronA]");
   
   hITS4_9->SetMarkerColor(9);

   hITS4_9->SetMarkerStyle(25);

   hITS4_9->SetMarkerSize(0.8);


   TH2F *hITS4_10 = new TH2F("hITS4_10","Current:Section yo plane 10",1000,min_obt,max_obt,1000,-1.0, 10.);

   hITS4_10->SetBit(TH2::kCanRebin);

   hITS4_10->SetStats(0);

   hITS4_10->SetFillColor(42);

   hITS4_10->GetXaxis()->SetTitle("time");

   hITS4_10->GetYaxis()->SetTitle("current [micronA]");
   
   hITS4_10->SetMarkerColor(11);

   hITS4_10->SetMarkerStyle(25);

   hITS4_10->SetMarkerSize(0.8);


   TH2F *hITS4_11 = new TH2F("hITS4_11","Current:Section yo plane 11",1000,min_obt,max_obt,1000,-1.0, 10.);

   hITS4_11->SetBit(TH2::kCanRebin);

   hITS4_11->SetStats(0);

   hITS4_11->SetFillColor(42);

   hITS4_11->GetXaxis()->SetTitle("time");

   hITS4_11->GetYaxis()->SetTitle("current [micronA]");
   
   hITS4_11->SetMarkerColor(12);

   hITS4_11->SetMarkerStyle(25);

   hITS4_11->SetMarkerSize(0.8);



   // grafici temperatura

   TH2F *hITS5 = new TH2F("hITS5","Temperature ",1000,min_obt,max_obt*1.006,1000,30,40);

   hITS5->SetStats(0);
   
   hITS5->SetBit(TH2::kCanRebin);

   hITS5->SetFillColor(42);

   hITS5->GetXaxis()->SetTitle("time");

   hITS5->GetYaxis()->SetTitle("Temperature [C]");
   
   hITS5->SetMarkerColor(1);

   hITS5->SetMarkerStyle(21);

   hITS5->SetMarkerSize(0.8);


   TH2F *hITS6 = new TH2F("hITS6","Temperature section xo plane 2 ",1000,min_obt,max_obt,1000,30,40);
   
   hITS6->SetStats(0);

   hITS6->SetBit(TH2::kCanRebin);

   hITS6->SetFillColor(42);

   hITS6->GetXaxis()->SetTitle("time");

   hITS6->GetYaxis()->SetTitle("Temperature [C]");
   
   hITS6->SetMarkerColor(1);

   hITS6->SetMarkerStyle(3);

   hITS6->SetMarkerSize(0.8);




   TH2F *hITS7 = new TH2F("hITS7","Temperature section xo plane 3",1000,min_obt,max_obt,1000,30,40);
   
   hITS7->SetStats(0);

   hITS7->SetBit(TH2::kCanRebin);

   hITS7->SetFillColor(42);

   hITS7->GetXaxis()->SetTitle("time");

   hITS7->GetYaxis()->SetTitle("Temperature [C]");
   
   hITS7->SetMarkerColor(2);

   hITS7->SetMarkerStyle(3);

   hITS7->SetMarkerSize(0.8);



   TH2F *hITS8 = new TH2F("hITS8","Temperature section xo plane 5",1000,min_obt,max_obt,1000,30,40);
   
   hITS8->SetStats(0);  

   hITS8->SetBit(TH2::kCanRebin);

   hITS8->SetFillColor(42);

   hITS8->GetXaxis()->SetTitle("time");

   hITS8->GetYaxis()->SetTitle("Temperature [C]");
   
   hITS8->SetMarkerColor(4);

   hITS8->SetMarkerStyle(3);

   hITS8->SetMarkerSize(0.8);


   TH2F *hITS9 = new TH2F("hITS9","Temperature section ye plane 4",1000,min_obt,max_obt,1000,30,40);
   
   hITS9->SetStats(0);

   hITS9->SetBit(TH2::kCanRebin);

   hITS9->SetFillColor(42);

   hITS9->GetXaxis()->SetTitle("time");

   hITS9->GetYaxis()->SetTitle("Temperature [C]");
   
   hITS9->SetMarkerColor(1);

   hITS9->SetMarkerStyle(22);

   hITS9->SetMarkerSize(0.8);



   TH2F *hITS10 = new TH2F("hITS10","Temperature section ye plane 5",1000,min_obt,max_obt,1000,30,40);
   
   hITS10->SetStats(0);

   hITS10->SetBit(TH2::kCanRebin);

   hITS10->SetFillColor(42);

   hITS10->GetXaxis()->SetTitle("time");

   hITS10->GetYaxis()->SetTitle("Temperature [C]");
   
   hITS10->SetMarkerColor(2);

   hITS10->SetMarkerStyle(22);

   hITS10->SetMarkerSize(0.8);



   TH2F *hITS11 = new TH2F("hITS11","Temperature section ye plane 8",1000,min_obt,max_obt,1000,30,40);
   
   hITS11->SetStats(0);

   hITS11->SetBit(TH2::kCanRebin);

   hITS11->SetFillColor(42);

   hITS11->GetXaxis()->SetTitle("time");

   hITS11->GetYaxis()->SetTitle("Temperature [C]");
   
   hITS11->SetMarkerColor(4);

   hITS11->SetMarkerStyle(22);

   hITS11->SetMarkerSize(0.8);


   TH2F *hITS12 = new TH2F("hITS12","Temperature section yo plane 6",1000,min_obt,max_obt,1000,30,40);
   
   hITS12->SetStats(0);

   hITS12->SetBit(TH2::kCanRebin);

   hITS12->SetFillColor(42);

   hITS12->GetXaxis()->SetTitle("time");

   hITS12->GetYaxis()->SetTitle("Temperature [C]");
   
   hITS12->SetMarkerColor(1);

   hITS12->SetMarkerStyle(25);

   hITS12->SetMarkerSize(0.8);


   TH2F *hITS13 = new TH2F("hITS13","Temperature section yo plane 10",1000,min_obt,max_obt,1000,30,40);
   
   hITS13->SetStats(0);

   hITS13->SetBit(TH2::kCanRebin);

   hITS13->SetFillColor(42);

   hITS13->GetXaxis()->SetTitle("time");

   hITS13->GetYaxis()->SetTitle("Temperature [C]");
   
   hITS13->SetMarkerColor(2);

   hITS13->SetMarkerStyle(25);

   hITS13->SetMarkerSize(0.8);



   TH2F *hITS14 = new TH2F("hITS14","Temperature section yo plane 11",1000,min_obt,max_obt,1000,30,40);
   
   hITS14->SetStats(0);

   hITS14->SetBit(TH2::kCanRebin);

   hITS14->SetFillColor(42);

   hITS14->GetXaxis()->SetTitle("time");

   hITS14->GetYaxis()->SetTitle("Temperature [C]");
   
   hITS14->SetMarkerColor(4);

   hITS14->SetMarkerStyle(25);

   hITS14->SetMarkerSize(0.8);






   // grafici Vcall

   TH2F *hITS15 = new TH2F("hITS15","V_call: calibration voltage",1000,min_obt,max_obt*1.006,1000,0.0, 100.);

   hITS15->SetStats(0);
   
   hITS15->SetBit(TH2::kCanRebin);

   hITS15->SetFillColor(42);

   hITS15->GetXaxis()->SetTitle("time");

   hITS15->GetYaxis()->SetTitle("V call [mV]");
   
   hITS15->SetMarkerColor(1);

   hITS15->SetMarkerStyle(21);

   hITS15->SetMarkerSize(0.8);


   TH2F *hITS16 = new TH2F("hITS16","V_call section xe plane 4 ",1000,min_obt,max_obt,1000,0.0, 100.);

   hITS16->SetStats(0);
   
   hITS16->SetBit(TH2::kCanRebin);

   hITS16->SetFillColor(42);

   hITS16->GetXaxis()->SetTitle("time");

   hITS16->GetYaxis()->SetTitle("V call [mV]");
   
   hITS16->SetMarkerColor(2);

   hITS16->SetMarkerStyle(21);

   hITS16->SetMarkerSize(0.8);


   TH2F *hITS17 = new TH2F("hITS17","V_call section xe plane 6",1000,min_obt,max_obt,1000,0.0, 100.);

   hITS17->SetStats(0);
   
   hITS17->SetBit(TH2::kCanRebin);

   hITS17->SetFillColor(42);

   hITS17->GetXaxis()->SetTitle("time");

   hITS17->GetYaxis()->SetTitle("V call [mV]");
   
   hITS17->SetMarkerColor(4);

   hITS17->SetMarkerStyle(21);

   hITS17->SetMarkerSize(0.8);


   TH2F *hITS18 = new TH2F("hITS18","V_call section ",1000,min_obt,max_obt,1000,0.0, 100.);

   hITS18->SetStats(0);
   
   hITS18->SetBit(TH2::kCanRebin);

   hITS18->SetFillColor(42);

   hITS18->GetXaxis()->SetTitle("time");

   hITS18->GetYaxis()->SetTitle("V call [mV]");
   
   hITS18->SetMarkerColor(8);

   hITS18->SetMarkerStyle(21);

   hITS18->SetMarkerSize(0.8);


   TH2F *hITS19 = new TH2F("hITS19","V_call",1000,min_obt,max_obt,1000,0.0, 100.);

   hITS19->SetStats(0);
   
   hITS19->SetBit(TH2::kCanRebin);

   hITS19->SetFillColor(42);

   hITS19->GetXaxis()->SetTitle("time");

   hITS19->GetYaxis()->SetTitle("V call [mV]");
   
   hITS19->SetMarkerColor(6);

   hITS19->SetMarkerStyle(21);

   hITS19->SetMarkerSize(0.8);


   TH2F *hITS20 = new TH2F("hITS20","V_call",1000,min_obt,max_obt,1000,0.0, 100.);

   hITS20->SetStats(0);
   
   hITS20->SetBit(TH2::kCanRebin);

   hITS20->SetFillColor(42);

   hITS20->GetXaxis()->SetTitle("time");

   hITS20->GetYaxis()->SetTitle("V call [mV]");
   
   hITS20->SetMarkerColor(7);

   hITS20->SetMarkerStyle(21);

   hITS20->SetMarkerSize(0.8);


   TH2F *hITS21 = new TH2F("hITS21","V_call",1000,min_obt,max_obt,1000,0.0, 100.);

   hITS21->SetStats(0);
   
   hITS21->SetBit(TH2::kCanRebin);

   hITS21->SetFillColor(42);

   hITS21->GetXaxis()->SetTitle("time");

   hITS21->GetYaxis()->SetTitle("V call [mV]");
   
   hITS21->SetMarkerColor(46);

   hITS21->SetMarkerStyle(21);

   hITS21->SetMarkerSize(0.8);


   TH2F *hITS22 = new TH2F("hITS22","V_call",1000,min_obt,max_obt,1000,0.0, 100.);

   hITS22->SetStats(0);
   
   hITS22->SetBit(TH2::kCanRebin);

   hITS22->SetFillColor(42);

   hITS22->GetXaxis()->SetTitle("time");

   hITS22->GetYaxis()->SetTitle("V call [mV]");
   
   hITS22->SetMarkerColor(1);

   hITS22->SetMarkerStyle(3);

   hITS22->SetMarkerSize(0.8);


   TH2F *hITS23 = new TH2F("hITS23","V_call",1000,min_obt,max_obt,1000,0.0, 100.);

   hITS23->SetStats(0);
   
   hITS23->SetBit(TH2::kCanRebin);

   hITS23->SetFillColor(42);

   hITS23->GetXaxis()->SetTitle("time");

   hITS23->GetYaxis()->SetTitle("V call [mV]");
   
   hITS23->SetMarkerColor(2);

   hITS23->SetMarkerStyle(3);

   hITS23->SetMarkerSize(0.8);


   TH2F *hITS24 = new TH2F("hITS24","V_call",1000,min_obt,max_obt,1000,0.0, 100.);

   hITS24->SetStats(0);
   
   hITS24->SetBit(TH2::kCanRebin);

   hITS24->SetFillColor(42);

   hITS24->GetXaxis()->SetTitle("time");

   hITS24->GetYaxis()->SetTitle("V call [mV]");
   
   hITS24->SetMarkerColor(4);

   hITS24->SetMarkerStyle(3);

   hITS24->SetMarkerSize(0.8);


   TH2F *hITS25 = new TH2F("hITS25","V_call",1000,min_obt,max_obt,1000,0.0, 100.);

   hITS25->SetStats(0);
   
   hITS25->SetBit(TH2::kCanRebin);

   hITS25->SetFillColor(42);

   hITS25->GetXaxis()->SetTitle("time");

   hITS25->GetYaxis()->SetTitle("V call [mV]");
   
   hITS25->SetMarkerColor(8);

   hITS25->SetMarkerStyle(3);

   hITS25->SetMarkerSize(0.8);


   
   TH2F *hITS26 = new TH2F("hITS26","V_call",1000,min_obt,max_obt,1000,0.0, 100.);

   hITS26->SetStats(0);
   
   hITS26->SetBit(TH2::kCanRebin);

   hITS26->SetFillColor(42);

   hITS26->GetXaxis()->SetTitle("time");

   hITS26->GetYaxis()->SetTitle("V call [mV]");
   
   hITS26->SetMarkerColor(6);

   hITS26->SetMarkerStyle(3);

   hITS26->SetMarkerSize(0.8);





   TH2F *hITS27 = new TH2F("hITS27","V_call",1000,min_obt,max_obt,1000,0.0, 100.);

   hITS27->SetStats(0);
   
   hITS27->SetBit(TH2::kCanRebin);

   hITS27->SetFillColor(42);

   hITS27->GetXaxis()->SetTitle("time");

   hITS27->GetYaxis()->SetTitle("V call [mV]");
   
   hITS27->SetMarkerColor(1);

   hITS27->SetMarkerStyle(22);

   hITS27->SetMarkerSize(0.8);


   TH2F *hITS28 = new TH2F("hITS28","V_call",1000,min_obt,max_obt,1000,0.0, 100.);

   hITS28->SetStats(0);
   
   hITS28->SetBit(TH2::kCanRebin);

   hITS28->SetFillColor(42);

   hITS28->GetXaxis()->SetTitle("time");

   hITS28->GetYaxis()->SetTitle("V call [mV]");
   
   hITS28->SetMarkerColor(2);

   hITS28->SetMarkerStyle(22);

   hITS28->SetMarkerSize(0.8);


   TH2F *hITS29 = new TH2F("hITS29","V_call",1000,min_obt,max_obt,1000,0.0, 100.);

   hITS29->SetStats(0);
   
   hITS29->SetBit(TH2::kCanRebin);

   hITS29->SetFillColor(42);

   hITS29->GetXaxis()->SetTitle("time");

   hITS29->GetYaxis()->SetTitle("V call [mV]");
   
   hITS29->SetMarkerColor(4);

   hITS29->SetMarkerStyle(22);

   hITS29->SetMarkerSize(0.8);


   TH2F *hITS30 = new TH2F("hITS30","V_call",1000,min_obt,max_obt,1000,0.0, 100.);

   hITS30->SetStats(0);
   
   hITS30->SetBit(TH2::kCanRebin);

   hITS30->SetFillColor(42);

   hITS30->GetXaxis()->SetTitle("time");

   hITS30->GetYaxis()->SetTitle("V call [mV]");
   
   hITS30->SetMarkerColor(8);

   hITS30->SetMarkerStyle(22);

   hITS30->SetMarkerSize(0.8);


   TH2F *hITS31 = new TH2F("hITS31","V_call",1000,min_obt,max_obt,1000,0.0, 100.);

   hITS31->SetStats(0);
   
   hITS31->SetBit(TH2::kCanRebin);

   hITS31->SetFillColor(42);

   hITS31->GetXaxis()->SetTitle("time");

   hITS31->GetYaxis()->SetTitle("V call [mV]");
   
   hITS31->SetMarkerColor(6);

   hITS31->SetMarkerStyle(22);

   hITS31->SetMarkerSize(0.8);



   TH2F *hITS32 = new TH2F("hITS32","V_call",1000,min_obt,max_obt,1000,0.0, 100.);

   hITS32->SetStats(0);
   
   hITS32->SetBit(TH2::kCanRebin);

   hITS32->SetFillColor(42);

   hITS32->GetXaxis()->SetTitle("time");

   hITS32->GetYaxis()->SetTitle("V call [mV]");
   
   hITS32->SetMarkerColor(1);

   hITS32->SetMarkerStyle(25);

   hITS32->SetMarkerSize(0.8);


   TH2F *hITS33 = new TH2F("hITS33","V_call",1000,min_obt,max_obt,1000,0.0, 100.);

   hITS33->SetStats(0);
   
   hITS33->SetBit(TH2::kCanRebin);

   hITS33->SetFillColor(42);

   hITS33->GetXaxis()->SetTitle("time");

   hITS33->GetYaxis()->SetTitle("V call [mV]");
   
   hITS33->SetMarkerColor(2);

   hITS33->SetMarkerStyle(22);

   hITS33->SetMarkerSize(0.8);


   TH2F *hITS34 = new TH2F("hITS34","V_call",1000,min_obt,max_obt,1000,0.0, 100.);

   hITS34->SetStats(0);
   
   hITS34->SetBit(TH2::kCanRebin);

   hITS34->SetFillColor(42);

   hITS34->GetXaxis()->SetTitle("time");

   hITS34->GetYaxis()->SetTitle("V call [mV]");
   
   hITS34->SetMarkerColor(4);

   hITS34->SetMarkerStyle(22);

   hITS34->SetMarkerSize(0.8);



   TH2F *hITS35 = new TH2F("hITS35","V_call",1000,min_obt,max_obt,1000,0.0, 100.);

   hITS35->SetStats(0);
   
   hITS35->SetBit(TH2::kCanRebin);

   hITS35->SetFillColor(42);

   hITS35->GetXaxis()->SetTitle("time");

   hITS35->GetYaxis()->SetTitle("V call [mV]");
   
   hITS35->SetMarkerColor(8);

   hITS35->SetMarkerStyle(22);

   hITS35->SetMarkerSize(0.8);



   TH2F *hITS36 = new TH2F("hITS36","V_call",1000,min_obt,max_obt,1000,0.0, 100.);

   hITS36->SetStats(0);
   
   hITS36->SetBit(TH2::kCanRebin);

   hITS36->SetFillColor(42);

   hITS36->GetXaxis()->SetTitle("time");

   hITS36->GetYaxis()->SetTitle("V call [mV]");
   
   hITS36->SetMarkerColor(6);

   hITS36->SetMarkerStyle(22);

   hITS36->SetMarkerSize(0.8);


   // grafici terza pad

   // V_SS

   TH2F *hITS37 = new TH2F("hITS37","V_SS: negative voltage CR-1.4P",1000,min_obt,max_obt*1.006,1000,-4950., -4800.);

   hITS37->SetStats(0);
   
   hITS37->SetBit(TH2::kCanRebin);

   hITS37->SetFillColor(42);

   hITS37->GetXaxis()->SetTitle("time");

   hITS37->GetYaxis()->SetTitle("V_SS [mV]");

   hITS37->GetYaxis()->SetTitleOffset(1.2);
   
   hITS37->SetMarkerColor(1);

   hITS37->SetMarkerStyle(21);

   hITS37->SetMarkerSize(0.8);


   TH2F *hITS38 = new TH2F("hITS38","V_SS",1000,min_obt,max_obt,1000,-4950.,-4800.);

   hITS38->SetStats(0);
   
   hITS38->SetBit(TH2::kCanRebin);

   hITS38->SetFillColor(42);

   hITS38->GetXaxis()->SetTitle("time");

   hITS38->GetYaxis()->SetTitle("V_SS [mV]");
   
   hITS38->SetMarkerColor(1);

   hITS38->SetMarkerStyle(3);

   hITS38->SetMarkerSize(0.8);


   TH2F *hITS39 = new TH2F("hITS39","V_SS",1000,min_obt,max_obt,1000,-4950.,-4800.);

   hITS39->SetStats(0);
   
   hITS39->SetBit(TH2::kCanRebin);

   hITS39->SetFillColor(42);

   hITS39->GetXaxis()->SetTitle("time");

   hITS39->GetYaxis()->SetTitle("V_SS [mV]");
   
   hITS39->SetMarkerColor(2);

   hITS39->SetMarkerStyle(3);

   hITS39->SetMarkerSize(0.8);



   TH2F *hITS40 = new TH2F("hITS40","V_SS",1000,min_obt,max_obt,1000,-4950., -4800);

   hITS40->SetStats(0);
   
   hITS40->SetBit(TH2::kCanRebin);

   hITS40->SetFillColor(42);

   hITS40->GetXaxis()->SetTitle("time");

   hITS40->GetYaxis()->SetTitle("V_SS [mV]");
   
   hITS40->SetMarkerColor(1);

   hITS40->SetMarkerStyle(22);

   hITS40->SetMarkerSize(0.8);


   TH2F *hITS41 = new TH2F("hITS41","V_SS",1000,min_obt,max_obt,1000,-4950., -4800.);

   hITS41->SetStats(0);
   
   hITS41->SetBit(TH2::kCanRebin);

   hITS41->SetFillColor(42);

   hITS41->GetXaxis()->SetTitle("time");

   hITS41->GetYaxis()->SetTitle("V_SS [mV]");
   
   hITS41->SetMarkerColor(2);

   hITS41->SetMarkerStyle(22);

   hITS41->SetMarkerSize(0.8);



   TH2F *hITS42 = new TH2F("hITS42","V_SS",1000,min_obt,max_obt,1000,-4950., -4800.);

   hITS42->SetStats(0);
   
   hITS42->SetBit(TH2::kCanRebin);

   hITS42->SetFillColor(42);

   hITS42->GetXaxis()->SetTitle("time");

   hITS42->GetYaxis()->SetTitle("V_SS [mV]");
   
   hITS42->SetMarkerColor(1);

   hITS42->SetMarkerStyle(25);

   hITS42->SetMarkerSize(0.8);



   // 4 pad

   TH2F *hITS43 = new TH2F("hITS43","V_DD: positive voltage CR-1.4P",1000,min_obt,max_obt*1.006,1000,4500.,5000.);

   hITS43->SetStats(0);
   
   hITS43->SetBit(TH2::kCanRebin);

   hITS43->SetFillColor(42);

   hITS43->GetXaxis()->SetTitle("time");

   hITS43->GetYaxis()->SetTitle("V_DD [mV]");

   hITS43->GetYaxis()->SetTitleOffset(1.2);
   
   hITS43->SetMarkerColor(1);

   hITS43->SetMarkerStyle(21);

   hITS43->SetMarkerSize(0.8);


   TH2F *hITS44 = new TH2F("hITS44","V_DD",1000,min_obt,max_obt,1000,4500.,5000.);

   hITS44->SetStats(0);
   
   hITS44->SetBit(TH2::kCanRebin);

   hITS44->SetFillColor(42);

   hITS44->GetXaxis()->SetTitle("time");

   hITS44->GetYaxis()->SetTitle("V_DD [mV]");
   
   hITS44->SetMarkerColor(2);

   hITS44->SetMarkerStyle(21);

   hITS44->SetMarkerSize(0.8);


   TH2F *hITS45 = new TH2F("hITS45","V_DD",1000,min_obt,max_obt,1000,4500.,5000.);

   hITS45->SetStats(0);
   
   hITS45->SetBit(TH2::kCanRebin);

   hITS45->SetFillColor(42);

   hITS45->GetXaxis()->SetTitle("time");

   hITS45->GetYaxis()->SetTitle("V_DD [mV]");
   
   hITS45->SetMarkerColor(1);

   hITS45->SetMarkerStyle(3);

   hITS45->SetMarkerSize(0.8);


   TH2F *hITS46 = new TH2F("hITS46","V_DD",1000,min_obt,max_obt,1000,4500., 5000.);

   hITS46->SetStats(0);
   
   hITS46->SetBit(TH2::kCanRebin);

   hITS46->SetFillColor(42);

   hITS46->GetXaxis()->SetTitle("time");

   hITS46->GetYaxis()->SetTitle("V_DD [mV]");
   
   hITS46->SetMarkerColor(1);

   hITS46->SetMarkerStyle(22);

   hITS46->SetMarkerSize(0.8);




   TH2F *hITS47 = new TH2F("hITS47","V_DD",1000,min_obt,max_obt,1000,4500.,5000.);

   hITS47->SetStats(0);
   
   hITS47->SetBit(TH2::kCanRebin);

   hITS47->SetFillColor(42);

   hITS47->GetXaxis()->SetTitle("time");

   hITS47->GetYaxis()->SetTitle("V_DD [mV]");
   
   hITS47->SetMarkerColor(1);

   hITS47->SetMarkerStyle(25);

   hITS47->SetMarkerSize(0.8);


   TH2F *hITS48 = new TH2F("hITS48","V_DD",1000,min_obt,max_obt,1000,4500.,5000.);

   hITS48->SetStats(0);
   
   hITS48->SetBit(TH2::kCanRebin);

   hITS48->SetFillColor(42);

   hITS48->GetXaxis()->SetTitle("time");

   hITS48->GetYaxis()->SetTitle("V_DD [mV]");
   
   hITS48->SetMarkerColor(2);

   hITS48->SetMarkerStyle(25);

   hITS48->SetMarkerSize(0.8);



   for(Int_t i = 0; i <= n_entries; i++)   {

     tr->GetEntry(i);

     UInt_t obt = (UInt_t)he->GetPscuHeader()->GetOrbitalTime(); // definisce l'orbital time

    
    
       
      Double_t  current_xe0_adc = pher->CALO_ENDRUN[0].CALO_HK0[0];

      Double_t current_xe0 = current_xe0_adc/1.7348 - 9444. ; // micron A

      Double_t  current_xe1_adc = pher->CALO_ENDRUN[0].CALO_HK0[1];

      Double_t current_xe1 = current_xe1_adc/1.7348 - 9444. ; // micron A

      Double_t  current_xe2_adc = pher->CALO_ENDRUN[0].CALO_HK0[2];

      Double_t current_xe2 = current_xe2_adc/1.7348 - 9444. ; // micron A

      Double_t  current_xe3_adc = pher->CALO_ENDRUN[0].CALO_HK0[3];

      Double_t current_xe3 = current_xe3_adc/1.7348 - 9444. ; // micron A

      Double_t  current_xe4_adc = pher->CALO_ENDRUN[0].CALO_HK0[4];

      Double_t current_xe4 = current_xe4_adc/1.7348 - 9444. ; // micron A

      Double_t  current_xe5_adc = pher->CALO_ENDRUN[0].CALO_HK0[5];

      Double_t current_xe5 = current_xe5_adc/1.7348 - 9444. ; // micron A

      Double_t  current_xe6_adc = pher->CALO_ENDRUN[0].CALO_HK0[6];

      Double_t current_xe6 = current_xe6_adc/1.7348 - 9444. ; // micron A

      Double_t  current_xe7_adc = pher->CALO_ENDRUN[0].CALO_HK0[7];

      Double_t current_xe7 = current_xe7_adc/1.7348 - 9444. ; // micron A

      Double_t  current_xe8_adc = pher->CALO_ENDRUN[0].CALO_HK0[8];

      Double_t current_xe8 = current_xe8_adc/1.7348 - 9444. ; // micron A

      Double_t  current_xe9_adc = pher->CALO_ENDRUN[0].CALO_HK0[9];

      Double_t current_xe9 = current_xe9_adc/1.7348 - 9444. ; // micron A

      Double_t  current_xe10_adc = pher->CALO_ENDRUN[0].CALO_HK0[10];

      Double_t current_xe10 = current_xe10_adc/1.7348 - 9444. ; // micron A

     

       hITS1_1->Fill(obt,current_xe0);
       hITS1_2->Fill(obt,current_xe1);
       hITS1_3->Fill(obt,current_xe2);
       hITS1_4->Fill(obt,current_xe3);
       hITS1_5->Fill(obt,current_xe4);
       hITS1_6->Fill(obt,current_xe5);
       hITS1_7->Fill(obt,current_xe6);
       hITS1_8->Fill(obt,current_xe7);
       hITS1_9->Fill(obt,current_xe8);
       hITS1_10->Fill(obt,current_xe9);
       hITS1_11->Fill(obt,current_xe10);


      Double_t  current_xo0_adc = pher->CALO_ENDRUN[1].CALO_HK0[0];

      Double_t current_xo0 = current_xo0_adc/1.7348 - 9444. ; // micron A

      Double_t  current_xo1_adc = pher->CALO_ENDRUN[1].CALO_HK0[1];

      Double_t current_xo1 = current_xo1_adc/1.7348 - 9444. ; // micron A

      Double_t  current_xo2_adc = pher->CALO_ENDRUN[1].CALO_HK0[2];

      Double_t current_xo2 = current_xo2_adc/1.7348 - 9444. ; // micron A

      Double_t  current_xo3_adc = pher->CALO_ENDRUN[1].CALO_HK0[3];

      Double_t current_xo3 = current_xo3_adc/1.7348 - 9444. ; // micron A

      Double_t  current_xo4_adc = pher->CALO_ENDRUN[1].CALO_HK0[4];

      Double_t current_xo4 = current_xo4_adc/1.7348 - 9444. ; // micron A

      Double_t  current_xo5_adc = pher->CALO_ENDRUN[1].CALO_HK0[5];

      Double_t current_xo5 = current_xo5_adc/1.7348 - 9444. ; // micron A

      Double_t  current_xo6_adc = pher->CALO_ENDRUN[1].CALO_HK0[6];

      Double_t current_xo6 = current_xo6_adc/1.7348 - 9444. ; // micron A

      Double_t  current_xo7_adc = pher->CALO_ENDRUN[1].CALO_HK0[7];

      Double_t current_xo7 = current_xo7_adc/1.7348 - 9444. ; // micron A

      Double_t  current_xo8_adc = pher->CALO_ENDRUN[1].CALO_HK0[8];

      Double_t current_xo8 = current_xo8_adc/1.7348 - 9444. ; // micron A

      Double_t  current_xo9_adc = pher->CALO_ENDRUN[1].CALO_HK0[9];

      Double_t current_xo9 = current_xo9_adc/1.7348 - 9444. ; // micron A

      Double_t  current_xo10_adc = pher->CALO_ENDRUN[1].CALO_HK0[10];

      Double_t current_xo10 = current_xo10_adc/1.7348 - 9444. ; // micron A

     

       hITS2_1->Fill(obt,current_xo0);
       hITS2_2->Fill(obt,current_xo1);
       hITS2_3->Fill(obt,current_xo2);
       hITS2_4->Fill(obt,current_xo3);
       hITS2_5->Fill(obt,current_xo4);
       hITS2_6->Fill(obt,current_xo5);
       hITS2_7->Fill(obt,current_xo6);
       hITS2_8->Fill(obt,current_xo7);
       hITS2_9->Fill(obt,current_xo8);
       hITS2_10->Fill(obt,current_xo9);
       hITS2_11->Fill(obt,current_xo10);


      Double_t  current_ye0_adc = pher->CALO_ENDRUN[2].CALO_HK0[0];

      Double_t current_ye0 = current_ye0_adc/1.7348 - 9444. ; // micron A

      Double_t  current_ye1_adc = pher->CALO_ENDRUN[2].CALO_HK0[1];

      Double_t current_ye1 = current_ye1_adc/1.7348 - 9444. ; // micron A

      Double_t  current_ye2_adc = pher->CALO_ENDRUN[2].CALO_HK0[2];

      Double_t current_ye2 = current_ye2_adc/1.7348 - 9444. ; // micron A

      Double_t  current_ye3_adc = pher->CALO_ENDRUN[2].CALO_HK0[3];

      Double_t current_ye3 = current_ye3_adc/1.7348 - 9444. ; // micron A

      Double_t  current_ye4_adc = pher->CALO_ENDRUN[2].CALO_HK0[4];

      Double_t current_ye4 = current_ye4_adc/1.7348 - 9444. ; // micron A

      Double_t  current_ye5_adc = pher->CALO_ENDRUN[2].CALO_HK0[5];

      Double_t current_ye5 = current_ye5_adc/1.7348 - 9444. ; // micron A

      Double_t  current_ye6_adc = pher->CALO_ENDRUN[2].CALO_HK0[6];

      Double_t current_ye6 = current_ye6_adc/1.7348 - 9444. ; // micron A

      Double_t  current_ye7_adc = pher->CALO_ENDRUN[2].CALO_HK0[7];

      Double_t current_ye7 = current_ye7_adc/1.7348 - 9444. ; // micron A

      Double_t  current_ye8_adc = pher->CALO_ENDRUN[2].CALO_HK0[8];

      Double_t current_ye8 = current_ye8_adc/1.7348 - 9444. ; // micron A

      Double_t  current_ye9_adc = pher->CALO_ENDRUN[2].CALO_HK0[9];

      Double_t current_ye9 = current_ye9_adc/1.7348 - 9444. ; // micron A

      Double_t  current_ye10_adc = pher->CALO_ENDRUN[2].CALO_HK0[10];

      Double_t current_ye10 = current_ye10_adc/1.7348 - 9444. ; // micron A

     

       hITS3_1->Fill(obt,current_ye0);
       hITS3_2->Fill(obt,current_ye1);
       hITS3_3->Fill(obt,current_ye2);
       hITS3_4->Fill(obt,current_ye3);
       hITS3_5->Fill(obt,current_ye4);
       hITS3_6->Fill(obt,current_ye5);
       hITS3_7->Fill(obt,current_ye6);
       hITS3_8->Fill(obt,current_ye7);
       hITS3_9->Fill(obt,current_ye8);
       hITS3_10->Fill(obt,current_ye9);
       hITS3_11->Fill(obt,current_ye10);




      Double_t  current_yo0_adc = pher->CALO_ENDRUN[3].CALO_HK0[0];

      Double_t current_yo0 = current_yo0_adc/1.7348 - 9444. ; // micron A

      Double_t  current_yo1_adc = pher->CALO_ENDRUN[3].CALO_HK0[1];

      Double_t current_yo1 = current_yo1_adc/1.7348 - 9444. ; // micron A

      Double_t  current_yo2_adc = pher->CALO_ENDRUN[3].CALO_HK0[2];

      Double_t current_yo2 = current_yo2_adc/1.7348 - 9444. ; // micron A

      Double_t  current_yo3_adc = pher->CALO_ENDRUN[3].CALO_HK0[3];

      Double_t current_yo3 = current_yo3_adc/1.7348 - 9444. ; // micron A

      Double_t  current_yo4_adc = pher->CALO_ENDRUN[3].CALO_HK0[4];

      Double_t current_yo4 = current_yo4_adc/1.7348 - 9444. ; // micron A

      Double_t  current_yo5_adc = pher->CALO_ENDRUN[3].CALO_HK0[5];

      Double_t current_yo5 = current_yo5_adc/1.7348 - 9444. ; // micron A

      Double_t  current_yo6_adc = pher->CALO_ENDRUN[3].CALO_HK0[6];

      Double_t current_yo6 = current_yo6_adc/1.7348 - 9444. ; // micron A

      Double_t  current_yo7_adc = pher->CALO_ENDRUN[3].CALO_HK0[7];

      Double_t current_yo7 = current_yo7_adc/1.7348 - 9444. ; // micron A

      Double_t  current_yo8_adc = pher->CALO_ENDRUN[3].CALO_HK0[8];

      Double_t current_yo8 = current_yo8_adc/1.7348 - 9444. ; // micron A

      Double_t  current_yo9_adc = pher->CALO_ENDRUN[3].CALO_HK0[9];

      Double_t current_yo9 = current_yo9_adc/1.7348 - 9444. ; // micron A

      Double_t  current_yo10_adc = pher->CALO_ENDRUN[3].CALO_HK0[10];

      Double_t current_yo10 = current_yo10_adc/1.7348 - 9444. ; // micron A

     

       hITS4_1->Fill(obt,current_yo0);
       hITS4_2->Fill(obt,current_yo1);
       hITS4_3->Fill(obt,current_yo2);
       hITS4_4->Fill(obt,current_yo3);
       hITS4_5->Fill(obt,current_yo4);
       hITS4_6->Fill(obt,current_yo5);
       hITS4_7->Fill(obt,current_yo6);
       hITS4_8->Fill(obt,current_yo7);
       hITS4_9->Fill(obt,current_yo8);
       hITS4_10->Fill(obt,current_yo9);
       hITS4_11->Fill(obt,current_yo10);

       
   
       
       

       

       // calo_hk1 : temperature and tensions

       // temperature - section - plane


   

       //  UInt_t obt = (UInt_t)he->GetPscuHeader()->GetOrbitalTime(); // definisce l'orbital time

     Double_t  temp_adc_xe6 = pher->CALO_ENDRUN[0].CALO_HK1[6];

     Double_t  temp_xe6 = temp_adc_xe6/331.124 - 29.35;   // [°C]

     Double_t  temp_adc_xo1 = pher->CALO_ENDRUN[1].CALO_HK1[1];

     Double_t  temp_xo1 = temp_adc_xo1/331.124 - 29.35;   // [°C]

     Double_t  temp_adc_xo2 = pher->CALO_ENDRUN[1].CALO_HK1[2];

     Double_t  temp_xo2 = temp_adc_xo2/331.124 - 29.35;   // [°C]
     
     Double_t  temp_adc_xo4 = pher->CALO_ENDRUN[1].CALO_HK1[4];

     Double_t  temp_xo4 = temp_adc_xo4/331.124 - 29.35;   // [°C]

     Double_t  temp_adc_ye3 = pher->CALO_ENDRUN[2].CALO_HK1[3];

     Double_t  temp_ye3 = temp_adc_ye3/331.124 - 29.35;   // [°C]

     Double_t  temp_adc_ye4 = pher->CALO_ENDRUN[2].CALO_HK1[4];

     Double_t  temp_ye4 = temp_adc_ye4/331.124 - 29.35;   // [°C]

     Double_t  temp_adc_ye7 = pher->CALO_ENDRUN[2].CALO_HK1[7];

     Double_t  temp_ye7 = temp_adc_ye7/331.124 - 29.35;   // [°C]

     Double_t  temp_adc_yo5 = pher->CALO_ENDRUN[3].CALO_HK1[5];

     Double_t  temp_yo5 = temp_adc_yo5/331.124 - 29.35;   // [°C]

     Double_t  temp_adc_yo9 = pher->CALO_ENDRUN[3].CALO_HK1[9];

     Double_t  temp_yo9 = temp_adc_yo9/331.124 - 29.35;   // [°C]

     Double_t  temp_adc_yo10 = pher->CALO_ENDRUN[3].CALO_HK1[10];

     Double_t  temp_yo10 = temp_adc_yo10/331.124 - 29.35;   // [°C]


     hITS5->Fill(obt,temp_xe6);

     hITS6->Fill(obt,temp_xo1);

     hITS7->Fill(obt,temp_xo2);

     hITS8->Fill(obt,temp_xo4);

     hITS9->Fill(obt,temp_ye3);

     hITS10->Fill(obt,temp_ye4);

     hITS11->Fill(obt,temp_ye7);

     hITS12->Fill(obt,temp_yo5); 

     hITS13->Fill(obt,temp_yo9);

     hITS14->Fill(obt,temp_yo10);

   
       


 

       // V_call - section - plane

 

     // UInt_t obt = (UInt_t)he->GetPscuHeader()->GetOrbitalTime(); // definisce l'orbital time

     // section xe

     Double_t  vcall_adc_xe0 = pher->CALO_ENDRUN[0].CALO_HK1[0];

     Double_t  vcall_xe0 = vcall_adc_xe0/4.92 - 3330;   // [mV]

     Double_t  vcall_adc_xe3 = pher->CALO_ENDRUN[0].CALO_HK1[3];
     
     Double_t  vcall_xe3 = vcall_adc_xe3/4.92 - 3330;   // [mV]

     Double_t  vcall_adc_xe5 = pher->CALO_ENDRUN[0].CALO_HK1[5];

     Double_t  vcall_xe5 = vcall_adc_xe5/4.92 - 3330;   // [mV]

     Double_t  vcall_adc_xe7 = pher->CALO_ENDRUN[0].CALO_HK1[7];

     Double_t  vcall_xe7 = vcall_adc_xe7/4.92 - 3330;   // [mV]

     Double_t  vcall_adc_xe8 = pher->CALO_ENDRUN[0].CALO_HK1[8];

     Double_t  vcall_xe8 = vcall_adc_xe8/4.92 - 3330;   // [mV]

     Double_t  vcall_adc_xe9 = pher->CALO_ENDRUN[0].CALO_HK1[9];

     Double_t  vcall_xe9 = vcall_adc_xe9/4.92 - 3330;   // [mV]

     Double_t  vcall_adc_xe10 = pher->CALO_ENDRUN[0].CALO_HK1[10];

     Double_t  vcall_xe10 = vcall_adc_xe10/4.92 - 3330;   // [mV]

     
     // section xo


     Double_t  vcall_adc_xo3 = pher->CALO_ENDRUN[1].CALO_HK1[3];

     Double_t  vcall_xo3 = vcall_adc_xo3/4.92 - 3330;   // [mV]

     Double_t  vcall_adc_xo5 = pher->CALO_ENDRUN[1].CALO_HK1[5];

     Double_t  vcall_xo5 = vcall_adc_xo5/4.92 - 3330;   // [mV]
     
     Double_t  vcall_adc_xo7 = pher->CALO_ENDRUN[1].CALO_HK1[7];

     Double_t  vcall_xo7 = vcall_adc_xo7/4.92 - 3330;   // [mV]

     Double_t  vcall_adc_xo9 = pher->CALO_ENDRUN[1].CALO_HK1[9];

     Double_t  vcall_xo9 = vcall_adc_xo9/4.92 - 3330;   // [mV]

     Double_t  vcall_adc_xo10 = pher->CALO_ENDRUN[1].CALO_HK1[10];

     Double_t  vcall_xo10 = vcall_adc_xo10/4.92 - 3330;   // [mV]

     // section ye

     Double_t  vcall_adc_ye0 = pher->CALO_ENDRUN[2].CALO_HK1[0];

     Double_t  vcall_ye0 = vcall_adc_ye0/4.92 - 3330;   // [mV]

     Double_t  vcall_adc_ye1 = pher->CALO_ENDRUN[2].CALO_HK1[1];

     Double_t  vcall_ye1 = vcall_adc_ye1/4.92 - 3330;   // [mV]

     Double_t  vcall_adc_ye2 = pher->CALO_ENDRUN[2].CALO_HK1[2];

     Double_t  vcall_ye2 = vcall_adc_ye2/4.92 - 3330;   // [mV]

     Double_t  vcall_adc_ye6 = pher->CALO_ENDRUN[2].CALO_HK1[6];

     Double_t  vcall_ye6 = vcall_adc_ye6/4.92 - 3330;   // [mV]

     Double_t  vcall_adc_ye8 = pher->CALO_ENDRUN[2].CALO_HK1[8];

     Double_t  vcall_ye8 = vcall_adc_ye8/4.92 - 3330;   // [mV]

     // section yo

     Double_t  vcall_adc_yo1 = pher->CALO_ENDRUN[3].CALO_HK1[1];

     Double_t  vcall_yo1 = vcall_adc_yo1/4.92 - 3330;   // [mV]

     Double_t  vcall_adc_yo2 = pher->CALO_ENDRUN[3].CALO_HK1[2];

     Double_t  vcall_yo2 = vcall_adc_yo2/4.92 - 3330;   // [mV]

     Double_t  vcall_adc_yo4 = pher->CALO_ENDRUN[3].CALO_HK1[4];

     Double_t  vcall_yo4 = vcall_adc_yo4/4.92 - 3330;   // [mV]

     Double_t  vcall_adc_yo6 = pher->CALO_ENDRUN[3].CALO_HK1[6];

     Double_t  vcall_yo6 = vcall_adc_yo6/4.92 - 3330;   // [mV]

     Double_t  vcall_adc_yo8 = pher->CALO_ENDRUN[3].CALO_HK1[8];

     Double_t  vcall_yo8 = vcall_adc_yo8/4.92 - 3330;   // [mV]


     

     hITS15->Fill(obt,vcall_xe0);

     hITS16->Fill(obt,vcall_xe3);

     hITS17->Fill(obt,vcall_xe5);

     hITS18->Fill(obt,vcall_xe7);

     hITS19->Fill(obt,vcall_xe8);

     hITS20->Fill(obt,vcall_xe9);

     hITS21->Fill(obt,vcall_xe10);


     hITS22->Fill(obt,vcall_xo3);

     hITS23->Fill(obt,vcall_xo5);

     hITS24->Fill(obt,vcall_xo7);

     hITS25->Fill(obt,vcall_xo9);

     hITS26->Fill(obt,vcall_xo10);


     hITS27->Fill(obt,vcall_ye0);

     hITS28->Fill(obt,vcall_ye1);

     hITS29->Fill(obt,vcall_ye2);

     hITS30->Fill(obt,vcall_ye6);

     hITS31->Fill(obt,vcall_ye8);


     hITS32->Fill(obt,vcall_yo1);

     hITS33->Fill(obt,vcall_yo2);

     hITS34->Fill(obt,vcall_yo4);

     hITS35->Fill(obt,vcall_yo6);

     hITS36->Fill(obt,vcall_yo8);
   
      




 // V_SS - section - plane

 

     //  UInt_t obt = (UInt_t)he->GetPscuHeader()->GetOrbitalTime(); // definisce l'orbital time

     // section xe

     Double_t  vss_adc_xe4 = pher->CALO_ENDRUN[0].CALO_HK1[4];

     Double_t  vss_xe4 = vss_adc_xe4/2.46 - 6660.;   // [mV]

     

     // section xo

     Double_t  vss_adc_xo0 = pher->CALO_ENDRUN[1].CALO_HK1[0];

     Double_t  vss_xo0 = vss_adc_xo0/2.46 - 6660.;   // [mV]

     Double_t  vss_adc_xo6 = pher->CALO_ENDRUN[1].CALO_HK1[6];

     Double_t  vss_xo6 = vss_adc_xo6/2.46 - 6660.;   // [mV]
     

     // section ye

     Double_t  vss_adc_ye9 = pher->CALO_ENDRUN[2].CALO_HK1[9];

     Double_t  vss_ye9 = vss_adc_ye9/2.46 - 6660.;   // [mV] 

     Double_t  vss_adc_ye10 = pher->CALO_ENDRUN[2].CALO_HK1[10];

     Double_t  vss_ye10 = vss_adc_ye10/2.46 - 6660.;   // [mV]     

     // section yo

     Double_t  vss_adc_yo7 = pher->CALO_ENDRUN[3].CALO_HK1[7];

     Double_t  vss_yo7 = vss_adc_yo7/2.46 - 6660.;   // [mV] 




     

     hITS37->Fill(obt,vss_xe4);

     hITS38->Fill(obt,vss_xo0);

     hITS39->Fill(obt,vss_xo6);

     hITS40->Fill(obt,vss_ye9);

     hITS41->Fill(obt,vss_ye10);

     hITS42->Fill(obt,vss_yo7);

    
   
       




   // V_DD - section - plane



     // UInt_t obt = (UInt_t)he->GetPscuHeader()->GetOrbitalTime(); // definisce l'orbital time

     // section xe

     Double_t  vdd_adc_xe1 = pher->CALO_ENDRUN[0].CALO_HK1[1];

     Double_t  vdd_xe1 = vdd_adc_xe1/2.46 - 6660.;   // [mV]

     Double_t  vdd_adc_xe2 = pher->CALO_ENDRUN[0].CALO_HK1[2];

     Double_t  vdd_xe2 = vdd_adc_xe2/2.46 - 6660.;   // [mV]

     

     // section xo

     Double_t  vdd_adc_xo8 = pher->CALO_ENDRUN[1].CALO_HK1[8];

     Double_t  vdd_xo8 = vdd_adc_xo8/2.46 - 6660.;   // [mV]

    

     // section ye

     Double_t  vdd_adc_ye5 = pher->CALO_ENDRUN[2].CALO_HK1[5];

     Double_t  vdd_ye5 = vdd_adc_ye5/2.46 - 6660.;   // [mV] 

        

     // section yo

     Double_t  vdd_adc_yo0 = pher->CALO_ENDRUN[3].CALO_HK1[0];

     Double_t  vdd_yo0 = vdd_adc_yo0/2.46 - 6660.;   // [mV] 

     Double_t  vdd_adc_yo3 = pher->CALO_ENDRUN[3].CALO_HK1[3];

     Double_t  vdd_yo3 = vdd_adc_yo3/2.46 - 6660.;   // [mV] 




     

     hITS43->Fill(obt,vdd_xe1);

     hITS44->Fill(obt,vdd_xe2);

     hITS45->Fill(obt,vdd_xo8);

     hITS46->Fill(obt,vdd_ye5);

     hITS47->Fill(obt,vdd_yo0);

     hITS48->Fill(obt,vdd_yo3);

    
   
       }
      
       
     // output figures, first  sheet

    TCanvas *fig1 = new TCanvas("fig1","Calorimeter Quicklook Current",1100, 900) ;      //finestra grafica che posso suddividere in piu' aree (pads)

   
    fig1->Range(0,0,100,100);
    
    TPad * pd1 = new TPad("pd1","This is pad1",0.02,0.51,0.49,0.98);
    TPad * pd2 = new TPad("pd2","This is pad2",0.51,0.51,0.98,0.98);
    TPad * pd3 = new TPad("pd3","This is pad3",0.02,0.02,0.49,0.49);
    TPad * pd4 = new TPad("pd4","This is pad4",0.51,0.02,0.98,0.49);
    fig1->cd();
    pd1->Range(0,0,100,100);
    pd2->Range(0,0,100,100);
    pd3->Range(0,0,100,100);
    pd4->Range(0,0,100,100);       
    pd1->SetTicks();
    pd2->SetTicks();
    pd3->SetTicks();
    pd4->SetTicks();
    pd1->Draw();
    pd2->Draw();
    pd3->Draw();
    pd4->Draw();

    // first pad

    pd1->cd();
 
 
   hITS1_1->Draw();
   hITS1_2->Draw("same");
   hITS1_3->Draw("same");
   hITS1_4->Draw("same");
   hITS1_5->Draw("same");
   hITS1_6->Draw("same");
   hITS1_7->Draw("same");
   hITS1_8->Draw("same");
   hITS1_9->Draw("same");
   hITS1_10->Draw("same");
   hITS1_11->Draw("same");


   // legenda

   TLegend *leg1_1 = new TLegend(0.65,0.25,0.80,0.80);
   leg1_1->SetHeader("Sections and planes");
   leg1_1->SetBorderSize(0);
   leg1_1->SetTextAlign(12);
   leg1_1->AddEntry( hITS1_1,"xe 1 plane","p");
   leg1_1->AddEntry( hITS1_2,"xe 2 plane","p");
   leg1_1->AddEntry( hITS1_3,"xe 3 plane","p");
   leg1_1->AddEntry( hITS1_4,"xe 4 plane","p");
   leg1_1->AddEntry( hITS1_5,"xe 5 plane","p");
   leg1_1->AddEntry( hITS1_6,"xe 6 plane","p");
   leg1_1->AddEntry( hITS1_7,"xe 7 plane","p");
   leg1_1->AddEntry( hITS1_8,"xe 8 plane","p");
   leg1_1->AddEntry( hITS1_9,"xe 9 plane","p");
   leg1_1->AddEntry( hITS1_10,"xe 10 plane","p");
   leg1_1->AddEntry( hITS1_11,"xe 11 plane","p");
   leg1_1->SetTextSize(0.04);
   leg1_1->Draw();

   // second pad

   pd2->cd();
   hITS2_1->Draw();
   hITS2_2->Draw("same");
   hITS2_3->Draw("same");
   hITS2_4->Draw("same");
   hITS2_5->Draw("same");
   hITS2_6->Draw("same");
   hITS2_7->Draw("same");
   hITS2_8->Draw("same");
   hITS2_9->Draw("same");
   hITS2_10->Draw("same");
   hITS2_11->Draw("same");


   // legenda

   TLegend *leg1_2 = new TLegend(0.65,0.25,0.80,0.80);
   leg1_2->SetHeader("Sections and planes");
   leg1_2->SetBorderSize(0);
   leg1_2->SetTextAlign(12);
   leg1_2->AddEntry( hITS2_1,"xo 1 plane","p");
   leg1_2->AddEntry( hITS2_2,"xo 2 plane","p");
   leg1_2->AddEntry( hITS2_3,"xo 3 plane","p");
   leg1_2->AddEntry( hITS2_4,"xo 4 plane","p");
   leg1_2->AddEntry( hITS2_5,"xo 5 plane","p");
   leg1_2->AddEntry( hITS2_6,"xo 6 plane","p");
   leg1_2->AddEntry( hITS2_7,"xo 7 plane","p");
   leg1_2->AddEntry( hITS2_8,"xo 8 plane","p");
   leg1_2->AddEntry( hITS2_9,"xo 9 plane","p");
   leg1_2->AddEntry( hITS2_10,"xo 10 plane","p");
   leg1_2->AddEntry( hITS2_11,"xo 11 plane","p");
   leg1_2->SetTextSize(0.04);
   leg1_2->Draw();

   // third pad

   pd3->cd();
   hITS3_1->Draw();
   hITS3_2->Draw("same");
   hITS3_3->Draw("same");
   hITS3_4->Draw("same");
   hITS3_5->Draw("same");
   hITS3_6->Draw("same");
   hITS3_7->Draw("same");
   hITS3_8->Draw("same");
   hITS3_9->Draw("same");
   hITS3_10->Draw("same");
   hITS3_11->Draw("same");


   // legenda

   TLegend *leg1_3 = new TLegend(0.65,0.25,0.80,0.80);
   leg1_3->SetHeader("Sections and planes");
   leg1_3->SetBorderSize(0);
   leg1_3->SetTextAlign(12);
   leg1_3->AddEntry( hITS3_1,"ye 1 plane","p");
   leg1_3->AddEntry( hITS3_2,"ye 2 plane","p");
   leg1_3->AddEntry( hITS3_3,"ye 3 plane","p");
   leg1_3->AddEntry( hITS3_4,"ye 4 plane","p");
   leg1_3->AddEntry( hITS3_5,"ye 5 plane","p");
   leg1_3->AddEntry( hITS3_6,"ye 6 plane","p");
   leg1_3->AddEntry( hITS3_7,"ye 7 plane","p");
   leg1_3->AddEntry( hITS3_8,"ye 8 plane","p");
   leg1_3->AddEntry( hITS3_9,"ye 9 plane","p");
   leg1_3->AddEntry( hITS3_10,"ye 10 plane","p");
   leg1_3->AddEntry( hITS3_11,"ye 11 plane","p");
   leg1_3->SetTextSize(0.04);
   leg1_3->Draw();

   // fourth pad

   pd4->cd();
   hITS4_1->Draw();
   hITS4_2->Draw("same");
   hITS4_3->Draw("same");
   hITS4_4->Draw("same");
   hITS4_5->Draw("same");
   hITS4_6->Draw("same");
   hITS4_7->Draw("same");
   hITS4_8->Draw("same");
   hITS4_9->Draw("same");
   hITS4_10->Draw("same");
   hITS4_11->Draw("same");


   // legenda

   TLegend *leg1_4 = new TLegend(0.65,0.25,0.80,0.80);
   leg1_4->SetHeader("Sections and planes");
   leg1_4->SetBorderSize(0);
   leg1_4->SetTextAlign(12);
   leg1_4->AddEntry( hITS4_1,"yo 1 plane","p");
   leg1_4->AddEntry( hITS4_2,"yo 2 plane","p");
   leg1_4->AddEntry( hITS4_3,"yo 3 plane","p");
   leg1_4->AddEntry( hITS4_4,"yo 4 plane","p");
   leg1_4->AddEntry( hITS4_5,"yo 5 plane","p");
   leg1_4->AddEntry( hITS4_6,"yo 6 plane","p");
   leg1_4->AddEntry( hITS4_7,"yo 7 plane","p");
   leg1_4->AddEntry( hITS4_8,"yo 8 plane","p");
   leg1_4->AddEntry( hITS4_9,"yo 9 plane","p");
   leg1_4->AddEntry( hITS4_10,"yo 10 plane","p");
   leg1_4->AddEntry( hITS4_11,"yo 11 plane","p");
   leg1_4->SetTextSize(0.04);
   leg1_4->Draw();


   // output figures , second sheet
 
   
   TCanvas *fig2 = new TCanvas("fig2","Calorimeter Quicklook Temperature and Voltage",1100,900) ;      //finestra grafica che posso suddividere in piu' aree (pads)

  
   fig2->Range(0,0,100,100);
   
   TPad *pad1 = new TPad("pad1","This is pad1",0.02,0.51,0.49,0.98);
   TPad * pad2 = new TPad("pad2","This is pad2",0.51,0.51,0.98,0.98);
   TPad * pad3 = new TPad("pad3","This is pad3",0.02,0.02,0.49,0.49);
   TPad * pad4 = new TPad("pad4","This is pad4",0.51,0.02,0.98,0.49);
   fig2->cd();
   pad1->Range(0,0,100,100);
   pad2->Range(0,0,100,100);
   pad3->Range(0,0,100,100);
   pad4->Range(0,0,100,100);       
   pad1->SetTicks();
   pad2->SetTicks();
   pad3->SetTicks();
   pad4->SetTicks();
   pad1->Draw();
   pad2->Draw();
   pad3->Draw();
   pad4->Draw();

    pad1->cd();

   hITS5->Draw();
   hITS6->Draw("same");
   hITS7->Draw("same");
   hITS8->Draw("same");
   hITS9->Draw("same");
   hITS10->Draw("same");
   hITS11->Draw("same");
   hITS12->Draw("same");
   hITS13->Draw("same");
   hITS14->Draw("same");


   // legenda

   TLegend *leg = new TLegend(0.65,0.25,0.80,0.80);
   leg->SetHeader("Sections and planes");
   leg->SetBorderSize(0);
   leg->SetTextAlign(12);
   leg->AddEntry( hITS5,"xe 5 plane","p");
   leg->AddEntry(hITS6,"xo 2 plane","p");
   leg->AddEntry(hITS7,"xo 3 plane","p");
   leg->AddEntry(hITS8,"xo 5 plane","p");
   leg->AddEntry(hITS9,"ye 4 plane","p");
   leg->AddEntry(hITS10,"ye 5 plane","p");
   leg->AddEntry(hITS11,"ye 8 plane","p");
   leg->AddEntry(hITS12,"yo 6 plane","p");
   leg->AddEntry(hITS13,"yo 10 plane","p");
   leg->AddEntry(hITS14,"yo 11 plane","p");
   leg->SetTextSize(0.04);
   leg->Draw();

   
   // pad 2

   pad2->cd();
   hITS15->Draw();
   hITS16->Draw("same");
   hITS17->Draw("same");
   hITS18->Draw("same");
   hITS19->Draw("same");
   hITS20->Draw("same");
   hITS21->Draw("same");
   hITS22->Draw("same");
   hITS23->Draw("same");
   hITS24->Draw("same");
   hITS25->Draw("same");
   hITS26->Draw("same");
   hITS27->Draw("same");
   hITS28->Draw("same");
   hITS29->Draw("same");
   hITS30->Draw("same");
   hITS31->Draw("same");
   hITS32->Draw("same");
   hITS33->Draw("same");
   hITS34->Draw("same");
   hITS35->Draw("same");
   hITS36->Draw("same");

 // legenda

   TLegend *leg2 = new TLegend(0.65,0.25,0.80,0.80);
   leg2->SetHeader("Sections and planes");
   leg2->SetBorderSize(0);
   leg2->SetTextAlign(12);
   leg2->AddEntry(hITS15,"xe 1 plane","p");
   leg2->AddEntry(hITS16,"xe 4 plane","p");
   leg2->AddEntry(hITS17,"xe 6 plane","p");
   leg2->AddEntry(hITS18,"xe 8 plane","p");
   leg2->AddEntry(hITS19,"xe 9 plane","p");
   leg2->AddEntry(hITS20,"xe 10 plane","p");
   leg2->AddEntry(hITS21,"xe 11 plane","p");
   leg2->AddEntry(hITS22,"xo 4 plane","p");
   leg2->AddEntry(hITS23,"xo 6 plane","p");
   leg2->AddEntry(hITS24,"xo 8 plane","p");
   leg2->AddEntry(hITS25,"xo 10 plane","p");
   leg2->AddEntry(hITS26,"xo 11 plane","p");
   leg2->AddEntry(hITS27,"ye 1 plane","p");
   leg2->AddEntry(hITS28,"ye 2 plane","p");
   leg2->AddEntry(hITS29,"ye 3 plane","p");
   leg2->AddEntry(hITS30,"ye 7 plane","p");
   leg2->AddEntry(hITS31,"ye 9 plane","p");
   leg2->AddEntry(hITS32,"yo 2 plane","p");
   leg2->AddEntry(hITS33,"yo 3 plane","p");
   leg2->AddEntry(hITS34,"yo 5 plane","p");
   leg2->AddEntry(hITS35,"yo 7 plane","p");
   leg2->AddEntry(hITS36,"yo 9 plane","p");
   leg2->SetTextSize(0.02);
   leg2->Draw();

   

   // pad 3

   pad3->cd();
   hITS37->Draw();
   hITS38->Draw("same");
   hITS39->Draw("same");
   hITS40->Draw("same");
   hITS41->Draw("same");
   hITS42->Draw("same");


   TLegend *leg3 = new TLegend(0.65,0.25,0.80,0.80);
   leg3->SetHeader("Sections and planes");
   leg3->SetBorderSize(0);
   leg3->SetTextAlign(12);
   leg3->AddEntry( hITS37,"xe 5 plane","p");
   leg3->AddEntry(hITS38,"xo 1 plane","p");
   leg3->AddEntry(hITS39,"xo 7 plane","p");
   leg3->AddEntry(hITS40,"ye 10 plane","p");
   leg3->AddEntry(hITS41,"ye 11 plane","p");
   leg3->AddEntry(hITS42,"yo 8 plane","p");
   leg3->SetTextSize(0.04);
   leg3->Draw();
  

   // pad 4

   pad4->cd();
   hITS43->Draw();
   hITS44->Draw("same");
   hITS45->Draw("same");
   hITS46->Draw("same");
   hITS47->Draw("same");
   hITS48->Draw("same");


   TLegend *leg4 = new TLegend(0.65,0.25,0.80,0.80);
   leg4->SetHeader("Sections and planes");
   leg4->SetBorderSize(0);
   leg4->SetTextAlign(12);
   leg4->AddEntry( hITS43,"xe 2 plane","p");
   leg4->AddEntry(hITS44,"xe 3 plane","p");
   leg4->AddEntry(hITS45,"xo 9 plane","p");
   leg4->AddEntry(hITS46,"ye 6 plane","p");
   leg4->AddEntry(hITS47,"yo 1 plane","p");
   leg4->AddEntry(hITS48,"yo 4 plane","p");
   leg4->SetTextSize(0.04);
   leg4->Draw();
   





   const string fil = gSystem->BaseName(filename.Data());
   Int_t posiz = fil.find(".root");
   //
   TString file2;
   if ( posiz == -1 ){
     file2 = gSystem->BaseName(filename.Data());
   } else {
     Int_t posiz2 = 0;
     stringcopy(file2,gSystem->BaseName(filename.Data()),posiz2,posiz);
   };
   const char *figrec = file2;
  //
   const char *outdir = outDir;  
   stringstream figsave1;    
   stringstream figsave2;    
   const char *format = saveas;
   
   
     figsave1 << outdir << "/" ;
     figsave1 << figrec << "_CaloHK1.";
     figsave1 << format;
     fig1->SaveAs(figsave1.str().c_str());
     figsave2.str("");
     figsave2 << outdir << "/" ;
     figsave2 << figrec << "_CaloHK2.";
     figsave2 << format;
     fig2->SaveAs(figsave2.str().c_str());
        
    

   if ( iactive && w4i ){
     while ( gROOT->GetListOfCanvases()->FindObject(fig1) || gROOT->GetListOfCanvases()->FindObject(fig2)  ){
       gSystem->ProcessEvents();
       gSystem->Sleep(10);
     };
   };


}














    

  

   
   
      

   
   
  

    
   
      
      
   
	   
   


   
	
