C-----------------------------------------------------------------------
C     Subroutines to book and fill ntuples for Level2 variables
C-----------------------------------------------------------------------
      
C-----------------------------------------------------------------------
C     Tracker ntupla
C-----------------------------------------------------------------------

      function booktrackerntupla()
 
      include './common/common_level2.f'


      call HBNT(trkntp,'TRACKER',' ')
      
      call HBNAME(trkntp,'tracker',good2,'good2:I::[0,1]
     $     ,crc(12):I::[0,2],nclsx:I::[0,100],planex(nclsx):I::[0,6]
     $     ,xs(2,nclsx):R,sgnlxs(nclsx):R,nclsy:I::[0,100]
     $     ,planey(nclsy):I::[0,6],ys(2,nclsy):R,sgnlys(nclsy):R
     $     ,ntrk:I::[0,10],image(ntrk):I::[0,10],xm_nt(6,ntrk):R
     $     ,ym_nt(6,ntrk):R,zm_nt(6,ntrk):R,resx_nt(6,ntrk):R
     $     ,resy_nt(6,ntrk):R,al_nt(5,ntrk):R,coval(5,5,ntrk):R
     $     ,chi2_nt(ntrk):R,xgood_nt(6,ntrk):I::[0,1]
     $     ,ygood_nt(6,ntrk):I::[0,1],xv_nt(6,ntrk):R
     $     ,yv_nt(6,ntrk):R,zv_nt(6,ntrk):R,axv_nt(6,ntrk):R
     $     ,ayv_nt(6,ntrk):R,dedx_x(6,ntrk):R
     $     ,dedx_y(6,ntrk):R,bdl(ntrk):R')

      return
      end

C-----------------------------------------------------------------------
      function filltrackerntupla()

      include './common/common_level2.f'

      call HFNT(trkntp)

      return
      end
C-----------------------------------------------------------------------
      function closetrackerntupla()

      include './common/common_level2.f'
      
      call HROUT(trkntp,ICYCLE,' ')

      return
      end
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C     Anticounter ntupla
C-----------------------------------------------------------------------

      function bookanticntupla()
 
      include './common/common_level2.f'

      call HBNT(acntp,'ANTICOUNTER',' ')
      
      call HBNAME(acntp,'antic',status,'status(2):I::[0,65535]
     $     ,hitmap(2):I::[0,65535],hitstatus(2):I::[0,65535]
     $     ,trigger(2):I::[0,65535]')

      return
      end

C-----------------------------------------------------------------------
      function fillanticntupla()

      include './common/common_level2.f'

      call HFNT(acntp)

      return
      end
C-----------------------------------------------------------------------
      function closeanticntupla()

      include './common/common_level2.f'
      
      call HROUT(acntp,ICYCLE,' ')

      return
      end
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C     ToF ntupla
C-----------------------------------------------------------------------

      function booktofntupla()
 
      include './common/common_level2.f'

      call HBNT(tofntp,'TOF',' ')
      
      call HBNAME(tofntp,'tof',tof_j_flag,'tof_j_flag(6):I
     $     ,ntoftrk:I::[0,10],toftrkseqno(ntoftrk):I
     $     ,npmttdc(ntoftrk):I::[0,48],pmttdc(48,ntoftrk):I::[0,48]
     $     ,beta(13,ntoftrk):R,npmtadc(ntoftrk):I::[0,48]
     $     ,pmtadc(48,ntoftrk):I::[0,48]
     $     ,dedx(48,ntoftrk):R,xtofpos(3,ntoftrk):R
     $     ,ytofpos(3,ntoftrk):R,npmt:I::[0,48],pmt_id(npmt):I::[0,48]
     $     ,adc(npmt):R,tdc_tw(npmt):R')

      return
      end

C-----------------------------------------------------------------------
      function filltofntupla()

      include './common/common_level2.f'
    
      call HFNT(tofntp)

      return
      end
C-----------------------------------------------------------------------
      function closetofntupla()

      include './common/common_level2.f'
      
      call HROUT(tofntp,ICYCLE,' ')

      return
      end
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C    Trigger ntupla
C-----------------------------------------------------------------------

      function booktriggerntupla()
 
      include './common/common_level2.f'

      call HBNT(trigntp,'TRIGGER',' ')
      
      call HBNAME(trigntp,'trigger',evcount,'evcount:I
     $     ,pmtpl(3):I,trigrate(6):I,dltime(2):I
     $     ,s4calcount(2):I,pmtcount1(24):I
     $     ,pmtcount2(24):I,patternbusy(3):I
     $     ,patterntrig(6):I,trigconf:I')

      return
      end

C-----------------------------------------------------------------------
      function filltriggerntupla()

      include './common/common_level2.f'

      call HFNT(trigntp)

      return
      end
C-----------------------------------------------------------------------
      function closetriggerntupla()

      include './common/common_level2.f'
      
      call HROUT(trigntp,ICYCLE,' ')

      return
      end
C-----------------------------------------------------------------------

C-----------------------------------------------------------------------
C    S4 ntupla
C-----------------------------------------------------------------------

      function books4ntupla()
 
      include './common/common_level2.f'

      call HBNT(s4ntp,'S4',' ')
      
      call HBNAME(s4ntp,'s4',s4calibrated,'s4calibrated:R
     $     ,s4adc:R')

      return
      end

C-----------------------------------------------------------------------
      function fills4ntupla()

      include './common/common_level2.f'

      call HFNT(s4ntp)

      return
      end
C-----------------------------------------------------------------------
      function closes4ntupla()

      include './common/common_level2.f'
      
      call HROUT(s4ntp,ICYCLE,' ')

      return
      end
C-----------------------------------------------------------------------

C-----------------------------------------------------------------------
C    ND ntupla
C-----------------------------------------------------------------------

      function bookndntupla()
 
      include './common/common_level2.f'

      call HBNT(ndntp,'ND',' ')
      
      call HBNAME(ndntp,'nd',upperback,'upperback:R
     $     ,bottomback:R,trigphysics:R')

      return
      end

C-----------------------------------------------------------------------
      function fillndntupla()

      include './common/common_level2.f'

      call HFNT(ndntp)

      return
      end
C-----------------------------------------------------------------------
      function closendntupla()

      include './common/common_level2.f'
      
      call HROUT(ndntp,ICYCLE,' ')

      return
      end
C-----------------------------------------------------------------------

C-----------------------------------------------------------------------
C    OrbitalInfo ntupla
C-----------------------------------------------------------------------

      function bookorbitalinfontupla()
 
      include './common/common_level2.f'

      call HBNT(orbntp,'ORBINFO',' ')
      
      call HBNAME(orbntp,'orbinfo',abstime,'abstime:I*8
     $     ,obt:I*8,pkt_num:I*8')

      return
      end

C-----------------------------------------------------------------------
      function fillorbitalinfontupla()

      include './common/common_level2.f'

      call HFNT(orbntp)

      return
      end
C-----------------------------------------------------------------------
      function closeorbitalinfontupla()

      include './common/common_level2.f'
      
      call HROUT(orbntp,ICYCLE,' ')

      return
      end
C-----------------------------------------------------------------------

C-----------------------------------------------------------------------
C    RunInfo and SoftInfo ntupla
C-----------------------------------------------------------------------

      function bookruninfontupla()
 
      include './common/common_level2.f'

      call HBNT(runntp,'RUNINFO',' ')
      
      call HBNAME(runntp,'glrun',id,'id:I*8
     $     ,id_reg_run:I*8,id_reg_run_l2:I*8   
     $     ,runheader_time:I*8,runtrailer_time:I*8
     $     ,ev_reg_phys_from:I,ev_reg_phys_to :I   
     $     ,ev_reg_runheader:I,ev_reg_runtraile:I 
     $     ,trk_calib_used:I,eff_wrk_schedule:I
     $     ,prh_var_trg_mode_a:I,prh_var_trg_mode_b:I
     $     ,acq_build_info:I,acq_var_info:I')

      call HBNAMC(runntp,'softinfo',trig_ver,'trig_ver:C*8
     $     ,tof_ver:C*8,ac_ver:C*8,trk_ver:C*8,cal_ver:C*8
     $     ,s4_ver:C*8,nd_ver:C*8,orb_ver:C*8')
      return
      end

C-----------------------------------------------------------------------
      function fillruninfontupla()

      include './common/common_level2.f'

      call HFNT(runntp)

      return
      end
C-----------------------------------------------------------------------
      function closeruninfontupla()

      include './common/common_level2.f'
      
      call HROUT(runntp,ICYCLE,' ')

      return
      end
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C     Calorimeter ntupla
C-----------------------------------------------------------------------

      function bookcalontupla()
 
      include './common/common_level2.f'

      call HBNT(calontp,'CALO',' ')
      
      call HBNAME(calontp,'calo',calntrk,'calntrk:I::[0,51]
     $     ,caltrkseqno(calntrk):I::[-1,11],ncore(calntrk):I::[0,500000]
     $     ,noint(calntrk):I::[0,2000],ncyl(calntrk):I::[0,2000]
     $     ,nlast(calntrk):I::[0,2000],npre(calntrk):I::[0,2000]
     $     ,npresh(calntrk):I::[0,2000],ntr(calntrk):I::[0,2000]
     $     ,planetot(calntrk):I::[0,45],nlow(calntrk):I::[0,4225]
     $     ,qcore(calntrk):R,qcyl(calntrk):R,qlast(calntrk):R
     $     ,qpre(calntrk):R,qpresh(calntrk):R,qtr(calntrk):R
     $     ,qtrack(calntrk):R,qtrackx(calntrk):R,qtracky(calntrk):R
     $     ,dxtrack(calntrk):R,dytrack(calntrk):R,qmean(calntrk):R
     $     ,qlow(calntrk):R,dX0l(calntrk):R,good:I::[0,1],perr(4)
     $     :I::[0,500],swerr(4):I::[0,65535],calcrc(4):I::[0,1]
     $     ,selftrigger:I::[0,1],nstrip:I::[0,4225],nx22:I::[0,97]
     $     ,planemax(2):I::[0,45],qtot:R,qx22:R,qmax:R,qq(4):R
     $     ,npcfit(2):I::[0,45],impx:R,impy:R,tanx:R,tany:R
     $     ,varcfit(2):R,elen:R,selen:R')

      return
      end

C-----------------------------------------------------------------------
      function fillcalontupla()

      include './common/common_level2.f'
    
      call HFNT(calontp)

      return
      end
C-----------------------------------------------------------------------
      function closecalontupla()

      include './common/common_level2.f'
      
      call HROUT(calontp,ICYCLE,' ')

      return
      end
C-----------------------------------------------------------------------
