C-----------------------------------------------------------------------
C     Common for Level2 variables
C-----------------------------------------------------------------------

C-----------------------------------------------------------------------
C     ntuples ID are set in rzfile.f into the OPENLEV2 function
C-----------------------------------------------------------------------
      integer trkntp
      integer acntp
      integer trigntp
      integer calontp
      integer tofntp
      integer s4ntp
      integer ndntp
      integer orbntp
      integer runntp
      
      common/ntp/trkntp,acntp,trigntp,calontp,tofntp,s4ntp
     $     ,ndntp,orbntp,runntp
      save/ntp/
      
C-----------------------------------------------------------------------
C     Tracker variables
C-----------------------------------------------------------------------
      
      parameter(nplanes=6)
      parameter(NTRKMAX=10)
      parameter(NSINGMAX=100)
      
      integer good2             !flag to mark good or noise events
      integer crc               !DSP crc controll
c----------------------------------------------------------------
      integer nclsx             !# unassociated clusters  X views
      integer planex            !plane of single x
      real xs                   !center coord of single x
      real sgnlxs               !signal in MIP of single x
c----------------------------------------------------------------
      integer nclsy             !     "            "      Y views
      integer planey            !plane of single y
      real ys                   !center coord of single y
      real sgnlys               !signal in MIP of single y
c----------------------------------------------------------------
      integer ntrk              !# identified tracks
      integer image             !flag to tag track-images
      real al_nt                !track state vector
      real coval                !covariance matrix
      integer xgood_nt             !mask of used planes
      integer ygood_nt             !*
      real xm_nt                   !measured points
      real ym_nt                   !*
      real zm_nt                   !*
      real resx_nt                 !spatial resolution
      real resy_nt                 !*
      real chi2_nt                 !chi2
      real xv_nt                   !calculated points
      real yv_nt                  !*
      real zv_nt                  !*
      real axv_nt                 !calculated angles (deg)
      real ayv_nt                  !*
      real dedx_x               !signal in MIP scaled to 300 micrometer
      real dedx_y               !signal in MIP scaled to 300 micrometer
      real bdl


      common/tracker/
     $     good2,crc(12)
     $     ,nclsx,planex(NSINGMAX),xs(2,NSINGMAX),sgnlxs(NSINGMAX) 
     $     ,nclsy,planey(NSINGMAX),ys(2,NSINGMAX),sgnlys(NSINGMAX) 
     $     ,ntrk
     $     ,image(NTRKMAX)
     $     ,xm_nt(nplanes,NTRKMAX)
     $     ,ym_nt(nplanes,NTRKMAX)
     $     ,zm_nt(nplanes,NTRKMAX)
     $     ,resx_nt(nplanes,NTRKMAX)
     $     ,resy_nt(nplanes,NTRKMAX)
     $     ,al_nt(5,NTRKMAX)
     $     ,coval(5,5,NTRKMAX)
     $     ,chi2_nt(NTRKMAX)
     $     ,xgood_nt(nplanes,NTRKMAX)
     $     ,ygood_nt(nplanes,NTRKMAX)
     $     ,xv_nt(nplanes,NTRKMAX)
     $     ,yv_nt(nplanes,NTRKMAX)
     $     ,zv_nt(nplanes,NTRKMAX)
     $     ,axv_nt(nplanes,NTRKMAX)
     $     ,ayv_nt(nplanes,NTRKMAX)
     $     ,dedx_x(nplanes,NTRKMAX)
     $     ,dedx_y(nplanes,NTRKMAX)
     $     ,bdl(NTRKMAX)
      
      SAVE/tracker/
C------------------------------------------------------------------------

C-----------------------------------------------------------------------
C     Anticounter variables
C-----------------------------------------------------------------------
     
      integer status(2)
      integer hitmap(2)
      integer hitstatus(2)
      integer trigger(2)

      common/antic/status,hitmap,hitstatus,trigger
      save/antic/
C------------------------------------------------------------------------

C-----------------------------------------------------------------------
C     ToF variables
C-----------------------------------------------------------------------
  

      integer tof_j_flag(6)
c-----------------------------------
      integer ntoftrk
      integer toftrkseqno(10)  
      integer npmttdc(10) 
      integer pmttdc(10,48) 
      real beta(10,13)     
      
      integer npmtadc(10)  
      integer pmtadc(10,48)  
      real dedx(10,48)    
      
      real xtofpos(10,3)
      real ytofpos(10,3)
c-----------------------------------      
      integer npmt
      integer pmt_id(48)
      real adc(48)
      real tdc_tw(48)
      
      common/tof/tof_j_flag,ntoftrk,toftrkseqno,npmttdc,pmttdc,beta
     $     ,npmtadc,pmtadc,dedx,xtofpos,ytofpos,npmt,pmt_id
     $     ,adc,tdc_tw
      save/tof/
C----------------------------------------------------------------------

C-----------------------------------------------------------------------
C     ToF variables
C-----------------------------------------------------------------------
 
      integer evcount
      integer pmtpl(3)
      integer trigrate(6)
      integer dltime(2)
      integer s4calcount(2)
      integer pmtcount1(24)
      integer pmtcount2(24)
      integer patternbusy(3)
      integer patterntrig(6)
      integer trigconf

      common/trigger/evcount,pmtpl,trigrate,dltime
     $     ,s4calcount,pmtcount1,pmtcount2,patternbusy
     $     ,patterntrig,trigconf
      save/trigger/
C----------------------------------------------------------------------

C-----------------------------------------------------------------------
C     S4 variables
C-----------------------------------------------------------------------
 
      real s4calibrated;
      real s4adc;
      
      common/s4/s4calibrated,s4adc
      save/s4/
C----------------------------------------------------------------------

C-----------------------------------------------------------------------
C     ND variables
C-----------------------------------------------------------------------
 
      real upperback
      real bottomback
      real trigphysics

      common/nd/upperback,bottomback,trigphysics
      save/nd/
C----------------------------------------------------------------------

C-----------------------------------------------------------------------
C     OrbitalInfo variables
C-----------------------------------------------------------------------
 
      integer*8 abstime
      integer*8 obt
      integer*8 pkt_num

      common/orbinfo/abstime,obt,pkt_num
      save/orbinfo/
C----------------------------------------------------------------------

C-----------------------------------------------------------------------
C     RunInfo and SoftInfo variables
C-----------------------------------------------------------------------

      integer*8 id
      integer*8 id_reg_run
      integer*8 id_reg_run_l2   
      integer*8 runheader_time  
      integer*8 runtrailer_time 
      integer ev_reg_phys_from 
      integer ev_reg_phys_to    
      integer ev_reg_runheader  
      integer ev_reg_runtraile  
      integer trk_calib_used  
      integer eff_wrk_schedule
      integer prh_var_trg_mode_a
      integer prh_var_trg_mode_b
      integer acq_build_info  
      integer acq_var_info
      
      common/glrun/id,id_reg_run,id_reg_run_l2   
     $     ,runheader_time,runtrailer_time 
     $     ,ev_reg_phys_from,ev_reg_phys_to    
     $     ,ev_reg_runheader,ev_reg_runtraile  
     $     ,trk_calib_used,eff_wrk_schedule
     $     ,prh_var_trg_mode_a,prh_var_trg_mode_b
     $     ,acq_build_info,acq_var_info
      save/glrun/


      character*8 trig_ver
      character*8 tof_ver
      character*8 ac_ver
      character*8 trk_ver
      character*8 cal_ver
      character*8 s4_ver
      character*8 nd_ver
      character*8 orb_ver

      common/softinfo/trig_ver,tof_ver
     $     ,ac_ver,trk_ver
     $     ,cal_ver,s4_ver
     $     ,nd_ver,orb_ver
      save/softinfo/
      
C-----------------------------------------------------------------------------------

C-----------------------------------------------------------------------
C     Calorimeter variables
C-----------------------------------------------------------------------

      integer calntrk           ![0,51]
      integer caltrkseqno (51)  ![ntrk] (come il numero di tracce del tracker + 1)
      integer ncore(51)         ![0,500000]
      integer noint(51)         ![0,2000]
      integer ncyl(51)          ![0,2000]
      integer nlast(51)         ![0,2000]
      integer npre(51)          ![0,2000]
      integer npresh(51)        ![0,2000]
      integer ntr(51)           ![0,2000]
      integer planetot(51)      ![0,45]
      integer nlow(51)          ![0,4225]
      real qcore(51)            ![0,5*10^8]
      real qcyl(51)             ![0,5*10^8] 
      real qlast(51)            ![0,5*10^8] 
      real qpre(51)             ![0,5*10^8] 
      real qpresh(51)           ![0,5*10^8] 
      real qtr(51)              ![0,5*10^8] 
      real qtrack(51)           ![0,5*10^8] 
      real qtrackx(51)          ![0,5*10^8] 
      real qtracky(51)          ![0,5*10^8] 
      real dxtrack(51)          ![0,5*10^8] 
      real dytrack(51)          ![0,5*10^8] 
      real qmean(51)            ![0,2000] 
      real qlow(51)             ![0,5*10^8] 
      real dX0l(51)             ![0,2000]
c--------------------------------------------------
      !common variables , una per evento
      
      integer good              ![0,1]
      integer perr(4)           ![0,500]
      integer swerr(4)          ![0,65535]
      integer calcrc(4)         ![0,1]
      integer selftrigger       ![0,1]
      
      integer nstrip            ![0,4225]
      integer nx22              ![0,97]
      integer planemax(2)       ![0,45]
      real qtot                 ![0,5*10^8]
      real qx22                 ![0,5*10^8]
      real qmax                 ![0,10^4]
      real qq(4)                ![0,5*10^8]
      
      integer npcfit(2)         ![0,45]
      real impx                 ![-1000,1000]
      real impy                 ![-1000,1000]
      real tanx                 ![-100,100]
      real tany                 ![-100,100]       
      real varcfit(2)           ![0,10^10]
      
      real elen                 ![0,10^5]
      real selen                ![0,10^5]
      common/calo/calntrk,caltrkseqno,ncore,noint,ncyl,nlast,npre
     $     ,npresh,ntr,planetot,nlow,qcore,qcyl,qlast,qpre
     $     ,qpresh,qtr,qtrack,qtrackx,qtracky,dxtrack
     $     ,dytrack,qmean,qlow,dX0l,good,perr,swerr
     $     ,calcrc,selftrigger,nstrip,nx22,planemax,qtot
     $     ,qx22,qmax,qq,npcfit,impx,impy,tanx,tany
     $     ,varcfit,elen,selen
      save/calo/
C-----------------------------------------------------------------------------------
