//
// TEMPLATE.cc -- standalone program to call the TEMPLATEEXE program. 
//    by Emiliano Mocchiutti
//
//   Version 2.00 (2006/01/13)
//
// Changelog:
//
// 1.00 - 2.00 : use ROOT class to connect to the DB. No more FORCE and framework input variables (assume "ROOT" and FORCE=1).
//
// 0.00 - 1.00 : working.
//
#include <iostream>
#include <TSQLServer.h>
#include <TString.h>
//
extern short int ACEXE(int, TSQLServer *);
//
// the "info" subroutines is created by the makefile during the compilation and contains infos about the compiling environment
// it is added at the end of this file during compilation 
//
extern void info();
//
using namespace std;
//
int main(int numinp, char *inps[]){
  int error = 0;
  int run = 0;
  TSQLServer *dbc = 0;
  if ( numinp > 1 ){
    if ( !strcmp(inps[1],"--version") ){
      info();
      return(0);
    };
    if ( !strcmp(inps[1],"-h") || !strcmp(inps[1],"--help") ){
      printf("\nUsage:\n\n ACL2 run_id \n");
      printf("\n - run_id : ID number of the run to be processed \n");
      printf("\nExample: \n\nACL2 1085 \n\n");
      return(0);
    };
  };
  if ( numinp == 1 ){
    printf("\n Welcome to the AC LEVEL2 flight software! \n");
    //
    char input[256];
    //
    printf("\n\n Enter ID of the run to be processed: \n ");
    cin.getline(input,256);
    run = atoi(input);      
    //
  } else {
    printf("\n Welcome to the AC LEVEL2 flight software! \n");
    run = atoi(inps[1]);
  };
  //
  //
  //
  printf("\nConnecting to database... \n"); 
  //
  dbc = TSQLServer::Connect("mysql://localhost/pamela_test","anonymous","");
  bool connect = dbc->IsConnected();
  //
  if( !connect ) {
    printf("Problems connecting to the DB (check username and passwd), exiting...\n\n");
    return(2);    
  };
  printf("...connected! \n\n");
  //
  error = ACEXE(run,dbc);
  //
  //
  //
  printf("\nClose the connection to the database... \n");
  dbc->Close();
  printf("...connection terminated!\n\n");   
  //
  return(error);
}
