/**
 * \file GLTables.cpp
 * \author Elena Vannuccini
 * 
 * The file contains implementation of the methods to query the DB.
 */
//
#include <sstream>
#include <iostream>
//
#include <TFile.h>
#include <TTree.h>
#include <TTimeStamp.h>
#include <EventHeader.h>
#include <PscuHeader.h>
//
#include <GLTables.h>
#include <sgp4.h>
//
ClassImp(GL_TABLES);
ClassImp(GL_TRK_CALIB);
ClassImp(GL_RUN);
ClassImp(GL_ROOT);
ClassImp(GL_PARAM);
ClassImp(GL_S4_CALIB);
ClassImp(GL_CALO_CALIB);
ClassImp(GL_TIMESYNC);
ClassImp(GL_TLE);
//
using namespace std;

GL_TABLES::GL_TABLES(){
};

GL_TABLES::GL_TABLES(TString host, TString user, TString psw){
  fHost = new TString(host.Data());
  fUser = new TString(user.Data());
  fPsw = new TString(psw.Data());
  fSet = true;
  fNquery = 0;
};


void GL_TABLES::Set(TString host, TString user, TString psw){
  fHost = new TString(host.Data());
  fUser = new TString(user.Data());
  fPsw = new TString(psw.Data());
  fSet = true;
  fNquery = 0;
};

Bool_t GL_TABLES::IsConnected(TSQLServer *dbc){
  //
  // 
  //
  if ( !fSet ){
    return true;
  };
  //
  //
  //
  //  printf(" host is %s \n",fHost->Data());
  //
  stringstream myquery;  
  myquery.str("");
  myquery << "show databases;";
  dbc->Query(myquery.str().c_str());
  fNquery++;
  //
  if ( dbc->GetErrorCode() != 2013 && dbc->GetErrorCode() != 2006 ){
    // is connected
    return true;
  } else {
    //
    printf(" WARNING: Lost connection to DB! try to recover... \n");
    //
    TString host = fHost->Data();
    TString user = fUser->Data();
    TString psw = fPsw->Data();
    delete dbc;
    dbc = TSQLServer::Connect(host.Data(),user.Data(),psw.Data());
    //
    myquery.str("");
    myquery << "show databases;";
    dbc->Query(myquery.str().c_str());
    fNquery++;
    //
    if ( dbc->GetErrorCode() != 2013 && dbc->GetErrorCode() != 2006 ){
      //
      printf(" ...connection recovered, I can continue! \n");
      //
      myquery.str("");
      myquery << "SET time_zone='+0:00'";
      dbc->Query(myquery.str().c_str());
      fNquery++;
      myquery.str("");
      myquery << "SET wait_timeout=173000;";
      dbc->Query(myquery.str().c_str());      
      fNquery++;
      return true;
    };
  };
  //
  printf(" GLTABLES: connection is gone away, query will fail\n");
  //
  return false;
  //
};

void GL_TABLES::ResetCounters(){
  fNquery = 0;
};

void GL_TABLES::AddQ(){
  if ( fSet ) fNquery++;
};

UInt_t GL_TABLES::GetNqueries(){
   UInt_t rn = 0;
   rn += (UInt_t&)fNquery;
   return(rn);
};

GL_RUN::GL_RUN() {
  ID                         = 0;
  ID_RUN_FRAG                = 0;
  ID_ROOT_L0                 = 0;
  ID_ROOT_L2                 = 0;
  RUNHEADER_TIME             = 0;
  RUNTRAILER_TIME            = 0;
  EV_FROM                    = 0; 
  EV_TO                      = 0; 
  TRK_CALIB_USED             = 0;
  EFF_WRK_SCHEDULE           = 0;
  PRH_VAR_TRG_MODE_A         = 0;
  PRH_VAR_TRG_MODE_B         = 0;
  ACQ_BUILD_INFO             = 0;
  ACQ_VAR_INFO               = 0;
  RUNHEADER_OBT              = 0;
  RUNTRAILER_OBT             = 0;
  RUNHEADER_PKT              = 0;
  RUNTRAILER_PKT             = 0;
  NEVENTS                    = 0;
  LAST_TIMESYNC              = 0;
  OBT_TIMESYNC               = 0;
  COMPILATIONTIMESTAMP       = 0;
  FAV_WRK_SCHEDULE           = 0;
  RM_ACQ_AFTER_CALIB         = 0;
  RM_ACQ_SETTING_MODE        = 0;
  PKT_COUNTER                = 0;
  PKT_READY_COUNTER          = 0;
  TRK_CALIB_USED             = 0;
  CAL_DSP_MASK               = 0;
  BOOT_NUMBER                = 0;
  VALIDATION                 = 0;
}


void GL_RUN::Clear() {
  ID                         = 0;
  ID_RUN_FRAG                = 0;
  ID_ROOT_L0                 = 0;
  ID_ROOT_L2                 = 0;
  RUNHEADER_TIME             = 0;
  RUNTRAILER_TIME            = 0;
  EV_FROM                    = 0; 
  EV_TO                      = 0; 
  TRK_CALIB_USED             = 0;
  EFF_WRK_SCHEDULE           = 0;
  PRH_VAR_TRG_MODE_A         = 0;
  PRH_VAR_TRG_MODE_B         = 0;
  ACQ_BUILD_INFO             = 0;
  ACQ_VAR_INFO               = 0;
  RUNHEADER_OBT              = 0;
  RUNTRAILER_OBT             = 0;
  RUNHEADER_PKT              = 0;
  RUNTRAILER_PKT             = 0;
  NEVENTS                    = 0;
  LAST_TIMESYNC              = 0;
  OBT_TIMESYNC               = 0;
  COMPILATIONTIMESTAMP       = 0;
  FAV_WRK_SCHEDULE           = 0;
  RM_ACQ_AFTER_CALIB         = 0;
  RM_ACQ_SETTING_MODE        = 0;
  PKT_COUNTER                = 0;
  PKT_READY_COUNTER          = 0;
  TRK_CALIB_USED             = 0;
  CAL_DSP_MASK               = 0;
  BOOT_NUMBER                = 0;
  VALIDATION                 = 0;
}

GL_ROOT::GL_ROOT(){
  ID     = 0;
  ID_RAW = 0;
  ID_TIMESYNC = 0;
  PATH   = "";
  NAME   = "";
}

GL_PARAM::GL_PARAM(){
  ID     = 0;
  PATH   = "";
  NAME   = "";
  DESCR  = "";
  FROM_TIME = 0;
  TO_TIME   = 0;
  TYPE = 0;
}


GL_TRK_CALIB::GL_TRK_CALIB(){
  ID               = 0;
  ID_ROOT_L0       = 0;
  EV_ROOT_CALIBTRK1 = 0;
  EV_ROOT_CALIBTRK2 = 0;
  FROM_TIME = 0;
  TO_TIME   = 0;
  OBT1 = 0;
  OBT2 = 0;
  PKT1 = 0;
  PKT2 = 0;
  BOOT_NUMBER                = 0;
  VALIDATION                 = 0;
}

GL_CALO_CALIB::GL_CALO_CALIB(){
  ID        = 0;
  ID_ROOT_L0  = 0;
  EV_ROOT = 0;
  FROM_TIME = 0;
  TO_TIME   = 0;
  SECTION   = 0;
}

GL_S4_CALIB::GL_S4_CALIB(){
  ID        = 0;
  ID_ROOT_L0 = 0;
  EV_ROOT = 0;
  FROM_TIME = 0;
  TO_TIME   = 0;
  PARAM_FIT0 = 0.;
  PARAM_FIT1 = 0.;
}

GL_TIMESYNC::GL_TIMESYNC(){
  obtfirst = 0;
  pktfirst = 0;
  toffset  = 0;
  //  ID       = 0;
  //  ID_RAW   = 0;
  OBT0     = 0;
  TIMESYNC = 0;
  TYPE     = 0;
}

// ****************************************************

void GL_RUN::SetEV_FROM(UInt_t evfrom){
  EV_FROM = evfrom;
};

void GL_RUN::SetEV_TO(UInt_t evto){
  EV_TO = evto;
};

void GL_RUN::SetNEVENTS(UInt_t nev){
  NEVENTS = nev;
};

void GL_RUN::SetBOOTNUMBER(UInt_t boot){
  BOOT_NUMBER = boot;
};

void GL_RUN::SetRUNHEADER_TIME(UInt_t absth){
  RUNHEADER_TIME = absth;
};

void GL_RUN::SetRUNTRAILER_TIME(UInt_t abstt){
  RUNTRAILER_TIME = abstt;
};

void GL_RUN::SetRUNHEADER_PKT(UInt_t absth){
  RUNHEADER_PKT = absth;
};

void GL_RUN::SetRUNTRAILER_PKT(UInt_t abstt){
  RUNTRAILER_PKT = abstt;
};

void GL_RUN::SetRUNHEADER_OBT(UInt_t absth){
  RUNHEADER_OBT = absth;
};

void GL_RUN::SetRUNTRAILER_OBT(UInt_t abstt){
  RUNTRAILER_OBT = abstt;
};

void GL_RUN::SetID_ROOT_L2(UInt_t idl2){
  ID_ROOT_L2 = idl2;
};

void GL_RUN::SetID_ROOT_L0(UInt_t idroot){
  ID_ROOT_L0 = idroot;
};

void GL_RUN::SetID_RUN_FRAG(UInt_t idfrag){
  ID_RUN_FRAG = idfrag;
};

void GL_RUN::SetVALIDATION(UInt_t valid){
  VALIDATION = valid;
};

void GL_RUN::SetLAST_TIMESYNC(UInt_t ts){
  LAST_TIMESYNC = ts;
};

void GL_RUN::SetOBT_TIMESYNC(UInt_t ts){
  OBT_TIMESYNC = ts;
};

void GL_RUN:: SetPKT_COUNTER(UInt_t value){
  PKT_COUNTER = value;
};

void GL_RUN:: SetPKT_READY_COUNTER(UInt_t value){
  PKT_READY_COUNTER = value;
};

void GL_RUN:: SetCOMPILATIONTIMESTAMP(UInt_t value){
  COMPILATIONTIMESTAMP = value;
};

void GL_RUN:: SetFAV_WRK_SCHEDULE(UInt_t value){
  FAV_WRK_SCHEDULE = value;
};

void GL_RUN:: SetEFF_WRK_SCHEDULE(UInt_t value){
  EFF_WRK_SCHEDULE = value;
};

void GL_RUN:: SetPRH_VAR_TRG_MODE_A(UInt_t value){
  PRH_VAR_TRG_MODE_A = value;
};

void GL_RUN:: SetPRH_VAR_TRG_MODE_B(UInt_t value){
  PRH_VAR_TRG_MODE_B = value;
};

void GL_RUN:: SetACQ_BUILD_INFO(UInt_t value){
  ACQ_BUILD_INFO = value;
};

void GL_RUN:: SetACQ_VAR_INFO(UInt_t value){
  ACQ_VAR_INFO = value;
};

void GL_RUN:: SetRM_ACQ_AFTER_CALIB(UInt_t value){
  RM_ACQ_AFTER_CALIB = value;
};

void GL_RUN:: SetRM_ACQ_SETTING_MODE(UInt_t value){
  RM_ACQ_SETTING_MODE = value;
};

void GL_RUN:: SetTRK_CALIB_USED(UInt_t value){
  TRK_CALIB_USED = value;
};

void GL_RUN:: SetCAL_DSP_MASK(UInt_t value){
  CAL_DSP_MASK = value;
};

void GL_RUN:: SetID(UInt_t value){
  ID = value;
};

void GL_RUN::Set_GL_RUNT(RunTrailerEvent *runt, PscuHeader *pht){
  PKT_COUNTER                = runt->PKT_COUNTER;
  PKT_READY_COUNTER          = runt->PKT_ReadyCounter;
  RUNTRAILER_OBT             = pht->GetOrbitalTime(); 
  RUNTRAILER_PKT             = pht->GetCounter();
};

void GL_RUN::Set_GL_RUNH(RunHeaderEvent *runh, PscuHeader *phh){
  TRK_CALIB_USED             = runh->TRK_CALIB_USED;
  PRH_VAR_TRG_MODE_A         = runh->PRH_VAR_TRIGGER_MODE_A;
  PRH_VAR_TRG_MODE_B         = runh->PRH_VAR_TRIGGER_MODE_B;
  ACQ_BUILD_INFO             = runh->ACQ_BUILD_INFO;
  ACQ_VAR_INFO               = runh->ACQ_VAR_INFO;
  RUNHEADER_OBT              = phh->GetOrbitalTime(); 
  RUNHEADER_PKT              = phh->GetCounter(); 
  LAST_TIMESYNC              = runh->LAST_TIME_SYNC_INFO;
  OBT_TIMESYNC               = runh->OBT_TIME_SYNC; 
  COMPILATIONTIMESTAMP       = runh->COMPILATIONTIMESTAMP;
  FAV_WRK_SCHEDULE           = runh->FAVOURITE_WORKING_SCHEDULE;
  EFF_WRK_SCHEDULE           = runh->EFFECTIVE_WORKING_SCHEDULE;
  RM_ACQ_AFTER_CALIB         = runh->RM_ACQ_AFTER_CALIB;
  RM_ACQ_SETTING_MODE        = runh->RM_ACQ_SETTING_MODE;
  TRK_CALIB_USED             = runh->TRK_CALIB_USED;
  CAL_DSP_MASK              = runh->CAL_DSP_MASK;
};

void GL_RUN::Set_GL_RUNT0(){
  PKT_COUNTER                = 0;
  PKT_READY_COUNTER          = 0;
  RUNTRAILER_OBT             = 0;
  RUNTRAILER_PKT             = 0;
};

void GL_RUN::Set_GL_RUNH0(){
  TRK_CALIB_USED             = 0;
  PRH_VAR_TRG_MODE_A         = 0;
  PRH_VAR_TRG_MODE_B         = 0;
  ACQ_BUILD_INFO             = 0;
  ACQ_VAR_INFO               = 0;
  RUNHEADER_OBT              = 0;
  RUNHEADER_PKT              = 0;
  LAST_TIMESYNC              = 0;
  OBT_TIMESYNC               = 0;
  COMPILATIONTIMESTAMP       = 0;
  FAV_WRK_SCHEDULE           = 0;
  EFF_WRK_SCHEDULE           = 0;
  RM_ACQ_AFTER_CALIB         = 0;
  RM_ACQ_SETTING_MODE        = 0;
  TRK_CALIB_USED             = 0;
  CAL_DSP_MASK              = 0;
};

void GL_RUN::Set_GL_RUN(TSQLRow *Row){
	for( Int_t t = 0; t < 30; t++){ 
		if (t== 0) ID                = (UInt_t)atoll(Row->GetField(t));
		if (t== 1) ID_RUN_FRAG       = (UInt_t)atoll(Row->GetField(t));
		if (t== 2) ID_ROOT_L0        = (UInt_t)atoll(Row->GetField(t));
		if (t== 3) ID_ROOT_L2        = (UInt_t)atoll(Row->GetField(t));
		if (t== 4) RUNHEADER_TIME    = (UInt_t)atoll(Row->GetField(t)); 
		if (t== 5) RUNTRAILER_TIME   = (UInt_t)atoll(Row->GetField(t)); 
		if (t== 6) RUNHEADER_OBT     = (UInt_t)atoll(Row->GetField(t));
		if (t== 7) RUNTRAILER_OBT    = (UInt_t)atoll(Row->GetField(t));
		if (t== 8) RUNHEADER_PKT     = (UInt_t)atoll(Row->GetField(t));
		if (t== 9) RUNTRAILER_PKT    = (UInt_t)atoll(Row->GetField(t));
		if (t==10) BOOT_NUMBER       = (UInt_t)atoll(Row->GetField(t));
		if (t==11) EV_FROM           = (UInt_t)atoll(Row->GetField(t));
		if (t==12) EV_TO             = (UInt_t)atoll(Row->GetField(t));
		if (t==13) NEVENTS           = (UInt_t)atoll(Row->GetField(t));
		if (t==14) PKT_COUNTER       = (UInt_t)atoll(Row->GetField(t));
		if (t==15) PKT_READY_COUNTER = (UInt_t)atoll(Row->GetField(t));
		if (t==16) COMPILATIONTIMESTAMP = (UInt_t)atoll(Row->GetField(t));
		if (t==17) FAV_WRK_SCHEDULE  = (UInt_t)atoll(Row->GetField(t));
		if (t==18) EFF_WRK_SCHEDULE  = (UInt_t)atoll(Row->GetField(t));
		if (t==19) PRH_VAR_TRG_MODE_A= (UInt_t)atoll(Row->GetField(t));
		if (t==20) PRH_VAR_TRG_MODE_B= (UInt_t)atoll(Row->GetField(t));
		if (t==21) ACQ_BUILD_INFO    = (UInt_t)atoll(Row->GetField(t));
		if (t==22) ACQ_VAR_INFO      = (UInt_t)atoll(Row->GetField(t));
		if (t==23) RM_ACQ_AFTER_CALIB= (UInt_t)atoll(Row->GetField(t));
		if (t==24) RM_ACQ_SETTING_MODE = (UInt_t)atoll(Row->GetField(t));
		if (t==25) TRK_CALIB_USED    = (UInt_t)atoll(Row->GetField(t));
		if (t==26) CAL_DSP_MASK      = (UInt_t)atoll(Row->GetField(t));
		if (t==27) LAST_TIMESYNC     = (UInt_t)atoll(Row->GetField(t));
		if (t==28) OBT_TIMESYNC      = (UInt_t)atoll(Row->GetField(t));
		if (t==29) VALIDATION        = (UInt_t)atoll(Row->GetField(t));
	};

}

/**
 * This method delete the run from the "FromTable" table and store it in the GL_RUN_TRASH table
 * If IDRUN is 0 "this->ID" run is used.
 *
 **/
Int_t GL_RUN::DeleteRun(TSQLServer *dbc,UInt_t IDRUN,TString FromTable){
  // MySQL variables
  TSQLResult *pResult;
  TSQLRow *Row;
  stringstream myquery;
  //
  if ( !IDRUN ) IDRUN = ID;
  if ( !IDRUN ) return 1;
  // ----------------
  myquery.str("");
  myquery << " INSERT INTO GL_RUN_TRASH (";  
  myquery << "ID";
  myquery << ",ID_RUN_FRAG";
  myquery << ",ID_ROOT_L0";
  myquery << ",ID_ROOT_L2";
  myquery << ",RUNHEADER_TIME";
  myquery << ",RUNTRAILER_TIME";
  myquery << ",RUNHEADER_OBT";
  myquery << ",RUNTRAILER_OBT";
  myquery << ",RUNHEADER_PKT";
  myquery << ",RUNTRAILER_PKT";
  myquery << ",BOOT_NUMBER";
  myquery << ",EV_FROM";
  myquery << ",EV_TO";
  myquery << ",NEVENTS";
  myquery << ",PKT_COUNTER";
  myquery << ",PKT_READY_COUNTER";
  myquery << ",COMPILATIONTIMESTAMP";
  myquery << ",FAV_WRK_SCHEDULE";
  myquery << ",EFF_WRK_SCHEDULE";
  myquery << ",PRH_VAR_TRG_MODE_A";
  myquery << ",PRH_VAR_TRG_MODE_B";
  myquery << ",ACQ_BUILD_INFO";
  myquery << ",ACQ_VAR_INFO";
  myquery << ",RM_ACQ_AFTER_CALIB";
  myquery << ",RM_ACQ_SETTING_MODE";
  myquery << ",TRK_CALIB_USED";
  myquery << ",CAL_DSP_MASK";
  myquery << ",LAST_TIMESYNC";
  myquery << ",OBT_TIMESYNC";
  myquery << ",VALIDATION";
  myquery << ",INSERT_TIME";
  myquery << ") SELECT * FROM ";
  myquery << FromTable.Data();
  myquery << " WHERE ID=";
  myquery << (UInt_t)IDRUN << ";";
  //
  //  printf("1myquery is %s \n",myquery.str().c_str());
  //
  if ( !this->GetGLTABLES()->IsConnected(dbc) ) return -57;  
  this->GetGLTABLES()->AddQ();
  dbc->Query(myquery.str().c_str());
  //
  // retrieve this ID_TRASH
  //
  myquery.str("");
  myquery << " SELECT ID_TRASH,ID_ROOT_L0,ID_ROOT_L2 FROM GL_RUN_TRASH ORDER BY ID_TRASH DESC LIMIT 1";  
  if ( !this->GetGLTABLES()->IsConnected(dbc) ) return -57;  
  this->GetGLTABLES()->AddQ();
  pResult = dbc->Query(myquery.str().c_str());
  //
  UInt_t idtrash = 0;
  UInt_t idl0 = 0;
  UInt_t idl2 = 0;
  //
  Row = pResult->Next();      
  if( Row != NULL ){
    idtrash = (UInt_t)atoll(Row->GetField(0));
    idl0 = (UInt_t)atoll(Row->GetField(1));
    idl2 = (UInt_t)atoll(Row->GetField(2));    
  };
  //
  TString fileL0 = "";
  TString fileL2 = "";
  myquery.str("");
  myquery << " SELECT NAME FROM GL_ROOT WHERE ID=";
  myquery <<  idl0 << ";";
  //
  //  printf("2myquery is %s \n",myquery.str().c_str());
  //
  if ( !this->GetGLTABLES()->IsConnected(dbc) ) return -57;  
  this->GetGLTABLES()->AddQ();
  pResult = dbc->Query(myquery.str().c_str());
  //
  Row = pResult->Next();      
  if( Row != NULL ){
    fileL0 = (TString)Row->GetField(0);
  };
  //
  //
  //
  myquery.str("");
  myquery << " SELECT NAME FROM GL_ROOT WHERE ID=";
  myquery << idl2 << ";";
  //
  //  printf("3myquery is %s \n",myquery.str().c_str());
  //
  if ( !this->GetGLTABLES()->IsConnected(dbc) ) return -57;  
  this->GetGLTABLES()->AddQ();
  pResult = dbc->Query(myquery.str().c_str());
  //
  Row = pResult->Next();      
  if( Row != NULL ){
    fileL2 = (TString)Row->GetField(0);
  };
  //
  //
  //
  myquery.str("");
  myquery << " UPDATE GL_RUN_TRASH SET FILENAMEL0='";
  myquery <<  fileL0.Data() << "' where ID_TRASH=";
  myquery << idtrash << ";";
  //
  //  printf("4myquery is %s \n",myquery.str().c_str());
  //
  if ( !this->GetGLTABLES()->IsConnected(dbc) ) return -57;  
  this->GetGLTABLES()->AddQ();
  dbc->Query(myquery.str().c_str());
  //
  myquery.str("");
  myquery << " UPDATE GL_RUN_TRASH SET FILENAMEL2='";
  myquery <<  fileL2.Data() << "' where ID_TRASH=";
  myquery << idtrash << ";";
  //
  //  printf("4myquery is %s \n",myquery.str().c_str());
  //
  if ( !this->GetGLTABLES()->IsConnected(dbc) ) return -57;  
  this->GetGLTABLES()->AddQ();
  dbc->Query(myquery.str().c_str());
  //
  myquery.str("");
  myquery << " UPDATE GL_RUN_TRASH SET BELONGED_TO='";
  myquery <<  FromTable.Data() << "' where ID_TRASH=";
  myquery << idtrash << ";";
  //
  //  printf("4myquery is %s \n",myquery.str().c_str());
  //
  //
  if ( !this->GetGLTABLES()->IsConnected(dbc) ) return -57;  
  this->GetGLTABLES()->AddQ();
  dbc->Query(myquery.str().c_str());
  //
  myquery.str("");
  myquery << " DELETE FROM ";
  myquery <<  FromTable.Data() << " where ID=";
  myquery << IDRUN << ";";
  //
  //  printf("5myquery is %s \n",myquery.str().c_str());
  //
  //
  if ( !this->GetGLTABLES()->IsConnected(dbc) ) return -57;  
  this->GetGLTABLES()->AddQ();
  dbc->Query(myquery.str().c_str());
  //
  return 0;
};



/**
 * This method restore a run from the GL_RUN_TRASH table.
 * If ID is 0 "this->ID" is used; if "ToTable" is empty BELONG_TO field of GL_RUN_TRASH is used.
 *
 **/
Int_t GL_RUN::RestoreRun(TSQLServer *dbc,UInt_t IDRUN,TString ToTable){
  // insert into GL_RUN_FRAGMENTS select * FROM GL_RUN where ID=11;
  //insert into GL_RUN_TRASH VALUES (ID , ID_RUN_FRAG , ID_ROOT_L0 , ID_ROOT_L2 , RUNHEADER_TIME , RUNTRAILER_TIME , RUNHEADER_OBT , RUNTRAILER_OBT , RUNHEADER_PKT , RUNTRAILER_PKT , BOOT_NUMBER , EV_FROM , EV_TO  , NEVENTS , PKT_COUNTER , PKT_READY_COUNTER , COMPILATIONTIMESTAMP , FAV_WRK_SCHEDULE , EFF_WRK_SCHEDULE , PRH_VAR_TRG_MODE_A , PRH_VAR_TRG_MODE_B , ACQ_BUILD_INFO , ACQ_VAR_INFO , RM_ACQ_AFTER_CALIB , RM_ACQ_SETTING_MODE, TRK_CALIB_USED,CAL_DSP_MASK, LAST_TIMESYNC, OBT_TIMESYNC, VALIDATION, INSERT_TIME) select * FROM GL_RUN where ID=11;
  // MySQL variables
  TSQLResult *pResult;
  TSQLRow *Row;
  stringstream myquery;
  //
  if ( !IDRUN ) IDRUN = ID;
  if ( !IDRUN ) return 1;
  //
  if ( !strcmp(ToTable.Data(),"") ){
    //    
    myquery.str("");
    myquery << " SELECT BELONGED_TO FROM GL_RUN_TRASH WHERE ID=";
    myquery << (UInt_t)IDRUN << ";";
    //
    printf(" qui? myquery is %s \n",myquery.str().c_str());
    //
    if ( !this->GetGLTABLES()->IsConnected(dbc) ) return -57;  
    this->GetGLTABLES()->AddQ();
    pResult = dbc->Query(myquery.str().c_str());
    //
    Row = pResult->Next();      
    if( Row != NULL ){
     ToTable = (TString)Row->GetField(0);
    } else {
      return 1;
    };
  };
  // ----------------
  myquery.str("");
  myquery << " INSERT INTO ";
  myquery << ToTable.Data();
  myquery << " (";  
  myquery << "ID";
  myquery << ",ID_RUN_FRAG";
  myquery << ",ID_ROOT_L0";
  myquery << ",ID_ROOT_L2";
  myquery << ",RUNHEADER_TIME";
  myquery << ",RUNTRAILER_TIME";
  myquery << ",RUNHEADER_OBT";
  myquery << ",RUNTRAILER_OBT";
  myquery << ",RUNHEADER_PKT";
  myquery << ",RUNTRAILER_PKT";
  myquery << ",BOOT_NUMBER";
  myquery << ",EV_FROM";
  myquery << ",EV_TO";
  myquery << ",NEVENTS";
  myquery << ",PKT_COUNTER";
  myquery << ",PKT_READY_COUNTER";
  myquery << ",COMPILATIONTIMESTAMP";
  myquery << ",FAV_WRK_SCHEDULE";
  myquery << ",EFF_WRK_SCHEDULE";
  myquery << ",PRH_VAR_TRG_MODE_A";
  myquery << ",PRH_VAR_TRG_MODE_B";
  myquery << ",ACQ_BUILD_INFO";
  myquery << ",ACQ_VAR_INFO";
  myquery << ",RM_ACQ_AFTER_CALIB";
  myquery << ",RM_ACQ_SETTING_MODE";
  myquery << ",TRK_CALIB_USED";
  myquery << ",CAL_DSP_MASK";
  myquery << ",LAST_TIMESYNC";
  myquery << ",OBT_TIMESYNC";
  myquery << ",VALIDATION";
  myquery << ",INSERT_TIME";
  myquery << ") SELECT ";
  myquery << "ID";
  myquery << ",ID_RUN_FRAG";
  myquery << ",ID_ROOT_L0";
  myquery << ",ID_ROOT_L2";
  myquery << ",RUNHEADER_TIME";
  myquery << ",RUNTRAILER_TIME";
  myquery << ",RUNHEADER_OBT";
  myquery << ",RUNTRAILER_OBT";
  myquery << ",RUNHEADER_PKT";
  myquery << ",RUNTRAILER_PKT";
  myquery << ",BOOT_NUMBER";
  myquery << ",EV_FROM";
  myquery << ",EV_TO";
  myquery << ",NEVENTS";
  myquery << ",PKT_COUNTER";
  myquery << ",PKT_READY_COUNTER";
  myquery << ",COMPILATIONTIMESTAMP";
  myquery << ",FAV_WRK_SCHEDULE";
  myquery << ",EFF_WRK_SCHEDULE";
  myquery << ",PRH_VAR_TRG_MODE_A";
  myquery << ",PRH_VAR_TRG_MODE_B";
  myquery << ",ACQ_BUILD_INFO";
  myquery << ",ACQ_VAR_INFO";
  myquery << ",RM_ACQ_AFTER_CALIB";
  myquery << ",RM_ACQ_SETTING_MODE";
  myquery << ",TRK_CALIB_USED";
  myquery << ",CAL_DSP_MASK";
  myquery << ",LAST_TIMESYNC";
  myquery << ",OBT_TIMESYNC";
  myquery << ",VALIDATION";
  myquery << ",INSERT_TIME";
  myquery << " FROM GL_RUN_TRASH ";
  myquery << " WHERE BELONGED_TO='GL_RUN_FRAGMENTS' AND ID=";
  myquery << (UInt_t)IDRUN << ";";
  //
  //  printf("5myquery is %s \n",myquery.str().c_str());
  //
  if ( !this->GetGLTABLES()->IsConnected(dbc) ) return -57;  
  this->GetGLTABLES()->AddQ();
  dbc->Query(myquery.str().c_str());
  //
  //
  myquery.str("");
  myquery << " DELETE FROM GL_RUN_TRASH where BELONGED_TO='GL_RUN_FRAGMENTS' AND ID=";
  myquery << IDRUN << ";";
  //
  if ( !this->GetGLTABLES()->IsConnected(dbc) ) return -57;  
  this->GetGLTABLES()->AddQ();
  dbc->Query(myquery.str().c_str());
  //
  return 0;
};

/**
 * Function to fill the GL_RUN  table of the DB.
 *
 * \param  
 *
 */
Int_t GL_RUN::Fill_GL_RUN(TSQLServer *dbc){
  // MySQL variables
  stringstream myquery;
  // ----------------
  myquery.str("");
  myquery << " INSERT INTO GL_RUN (";  
  myquery << "ID";
  myquery << ",ID_RUN_FRAG";
  myquery << ",ID_ROOT_L0";
  myquery << ",ID_ROOT_L2";
  myquery << ",RUNHEADER_TIME";
  myquery << ",RUNTRAILER_TIME";
  myquery << ",RUNHEADER_OBT";
  myquery << ",RUNTRAILER_OBT";
  myquery << ",RUNHEADER_PKT";
  myquery << ",RUNTRAILER_PKT";
  myquery << ",EV_FROM";
  myquery << ",EV_TO";
  myquery << ",NEVENTS";
  myquery << ",LAST_TIMESYNC";
  myquery << ",OBT_TIMESYNC";
  myquery << ",COMPILATIONTIMESTAMP";
  myquery << ",FAV_WRK_SCHEDULE";
  myquery << ",EFF_WRK_SCHEDULE";
  myquery << ",PRH_VAR_TRG_MODE_A";
  myquery << ",PRH_VAR_TRG_MODE_B";
  myquery << ",ACQ_BUILD_INFO";
  myquery << ",ACQ_VAR_INFO";
  myquery << ",RM_ACQ_AFTER_CALIB";
  myquery << ",RM_ACQ_SETTING_MODE";
  myquery << ",PKT_COUNTER";
  myquery << ",PKT_READY_COUNTER";
  myquery << ",TRK_CALIB_USED";
  myquery << ",CAL_DSP_MASK";
  myquery << ",BOOT_NUMBER";
  myquery << ",VALIDATION";
  myquery << ") VALUES ('";

  myquery << (UInt_t)ID << "','";
  myquery << (UInt_t)ID_RUN_FRAG << "','";
  myquery << (UInt_t)ID_ROOT_L0 << "','";
  myquery << (UInt_t)ID_ROOT_L2 << "','";
  myquery << (UInt_t)RUNHEADER_TIME << "','";
  myquery << (UInt_t)RUNTRAILER_TIME << "','";
  myquery << (UInt_t)RUNHEADER_OBT << "','";
  myquery << (UInt_t)RUNTRAILER_OBT << "','";
  myquery << (UInt_t)RUNHEADER_PKT << "','";
  myquery << (UInt_t)RUNTRAILER_PKT << "','";
  myquery << (UInt_t)EV_FROM << "','";
  myquery << (UInt_t)EV_TO << "','";
  myquery << (UInt_t)NEVENTS << "','";
  myquery << (UInt_t)LAST_TIMESYNC << "','";
  myquery << (UInt_t)OBT_TIMESYNC << "','";
  myquery << (UInt_t)COMPILATIONTIMESTAMP << "','";
  myquery << (UInt_t)FAV_WRK_SCHEDULE << "','";
  myquery << (UInt_t)EFF_WRK_SCHEDULE << "','";
  myquery << (UInt_t)PRH_VAR_TRG_MODE_A << "','";
  myquery << (UInt_t)PRH_VAR_TRG_MODE_B << "','";
  myquery << (UInt_t)ACQ_BUILD_INFO << "','";
  myquery << (UInt_t)ACQ_VAR_INFO << "','";
  myquery << (UInt_t)RM_ACQ_AFTER_CALIB << "','";
  myquery << (UInt_t)RM_ACQ_SETTING_MODE << "','";
  myquery << (UInt_t)PKT_COUNTER << "','";
  myquery << (UInt_t)PKT_READY_COUNTER << "','";
  myquery << (UInt_t)TRK_CALIB_USED << "','";
  myquery << (UInt_t)CAL_DSP_MASK << "','";
  myquery << (UInt_t)BOOT_NUMBER << "','";
  myquery << (UInt_t)VALIDATION << "');";
  //
  //  printf("myquery is %s \n",myquery.str().c_str());
  //
  if ( !this->GetGLTABLES()->IsConnected(dbc) ) return -57;  
  this->GetGLTABLES()->AddQ();
  dbc->Query(myquery.str().c_str());
  //
  return 0;

};// ****************************************************

/**
 * Function to fill the GL_RUN  table of the DB.
 *
 * \param  
 *
 */
Int_t GL_RUN::Fill_GL_RUN_FRAGMENTS(TSQLServer *dbc){
  // MySQL variables
  stringstream myquery;
  // ----------------
  myquery.str("");
  myquery << " INSERT INTO GL_RUN_FRAGMENTS (";  
  myquery << "ID";
  myquery << ",ID_ROOT_L0";
  myquery << ",RUNHEADER_TIME";
  myquery << ",RUNTRAILER_TIME";
  myquery << ",RUNHEADER_OBT";
  myquery << ",RUNTRAILER_OBT";
  myquery << ",RUNHEADER_PKT";
  myquery << ",RUNTRAILER_PKT";
  myquery << ",EV_FROM";
  myquery << ",EV_TO";
  myquery << ",NEVENTS";
  myquery << ",LAST_TIMESYNC";
  myquery << ",OBT_TIMESYNC";
  myquery << ",COMPILATIONTIMESTAMP";
  myquery << ",FAV_WRK_SCHEDULE";
  myquery << ",EFF_WRK_SCHEDULE";
  myquery << ",PRH_VAR_TRG_MODE_A";
  myquery << ",PRH_VAR_TRG_MODE_B";
  myquery << ",ACQ_BUILD_INFO";
  myquery << ",ACQ_VAR_INFO";
  myquery << ",RM_ACQ_AFTER_CALIB";
  myquery << ",RM_ACQ_SETTING_MODE";
  myquery << ",PKT_COUNTER";
  myquery << ",PKT_READY_COUNTER";
  myquery << ",TRK_CALIB_USED";
  myquery << ",CAL_DSP_MASK";
  myquery << ",BOOT_NUMBER";
  myquery << ") VALUES ('";
  myquery << (UInt_t)ID << "','";
  myquery << (UInt_t)ID_ROOT_L0 << "','";
  myquery << (UInt_t)RUNHEADER_TIME << "','";
  myquery << (UInt_t)RUNTRAILER_TIME << "','";
  myquery << (UInt_t)RUNHEADER_OBT << "','";
  myquery << (UInt_t)RUNTRAILER_OBT << "','";
  myquery << (UInt_t)RUNHEADER_PKT << "','";
  myquery << (UInt_t)RUNTRAILER_PKT << "','";
  myquery << (UInt_t)EV_FROM << "','";
  myquery << (UInt_t)EV_TO << "','";
  myquery << (UInt_t)NEVENTS << "','";
  myquery << (UInt_t)LAST_TIMESYNC << "','";
  myquery << (UInt_t)OBT_TIMESYNC << "','";
  myquery << (UInt_t)COMPILATIONTIMESTAMP << "','";
  myquery << (UInt_t)FAV_WRK_SCHEDULE << "','";
  myquery << (UInt_t)EFF_WRK_SCHEDULE << "','";
  myquery << (UInt_t)PRH_VAR_TRG_MODE_A << "','";
  myquery << (UInt_t)PRH_VAR_TRG_MODE_B << "','";
  myquery << (UInt_t)ACQ_BUILD_INFO << "','";
  myquery << (UInt_t)ACQ_VAR_INFO << "','";
  myquery << (UInt_t)RM_ACQ_AFTER_CALIB << "','";
  myquery << (UInt_t)RM_ACQ_SETTING_MODE << "','";
  myquery << (UInt_t)PKT_COUNTER << "','";
  myquery << (UInt_t)PKT_READY_COUNTER << "','";
  myquery << (UInt_t)TRK_CALIB_USED << "','";
  myquery << (UInt_t)CAL_DSP_MASK << "','";
  myquery << (UInt_t)BOOT_NUMBER << "');";
  //
  // printf("myquery is %s \n",myquery.str().c_str());
  //
  if ( !this->GetGLTABLES()->IsConnected(dbc) ) return -57;  
  this->GetGLTABLES()->AddQ();
  dbc->Query(myquery.str().c_str());
  //
  return 0;

};// ****************************************************


/**
 * Function to query the GL_RUN  table of the DB.
 *
 * \param  RUN id
 * \return struct of type GL_RUN _data, which stores the query result
 *
 */
Int_t GL_RUN::Query_GL_RUN(UInt_t run, TSQLServer *dbc){
  // MySQL variables
  TSQLResult *pResult;
  TSQLRow *Row;
  int t;
  int r;
  stringstream myquery;
  // ----------------
  myquery.str("");
  myquery << " select ";
  myquery << "ID";
  myquery << ",ID_RUN_FRAG";
  myquery << ",ID_ROOT_L0";
  myquery << ",ID_ROOT_L2";
  myquery << ",RUNHEADER_TIME";
  myquery << ",RUNTRAILER_TIME";
  myquery << ",RUNHEADER_OBT";
  myquery << ",RUNTRAILER_OBT";
  myquery << ",RUNHEADER_PKT";
  myquery << ",RUNTRAILER_PKT";
  myquery << ",EV_FROM";
  myquery << ",EV_TO";
  myquery << ",NEVENTS";
  myquery << ",LAST_TIMESYNC";
  myquery << ",OBT_TIMESYNC";
  myquery << ",COMPILATIONTIMESTAMP";
  myquery << ",FAV_WRK_SCHEDULE";
  myquery << ",EFF_WRK_SCHEDULE";
  myquery << ",PRH_VAR_TRG_MODE_A";
  myquery << ",PRH_VAR_TRG_MODE_B";
  myquery << ",ACQ_BUILD_INFO";
  myquery << ",ACQ_VAR_INFO";
  myquery << ",RM_ACQ_AFTER_CALIB";
  myquery << ",RM_ACQ_SETTING_MODE";
  myquery << ",PKT_COUNTER";
  myquery << ",PKT_READY_COUNTER";
  myquery << ",TRK_CALIB_USED";
  myquery << ",CAL_DSP_MASK";
  myquery << ",BOOT_NUMBER";
  myquery << ",VALIDATION";
  myquery << " from GL_RUN where ID=" << run << ";";
  //
  //  printf(" myquery is %s \n",myquery.str().c_str());
  if ( !this->IsConnected(dbc) ) return -57;  
  this->AddQ();
  pResult = dbc->Query(myquery.str().c_str());
  //
  //  printf(" getrowcount %i \n",pResult->GetRowCount());
  //
  if( !pResult->GetRowCount() ) return(-50);
  //
  for( r=0; r < 1000; r++){ 
      Row = pResult->Next();      
      if( Row == NULL ) break;
//	  Set_GL_RUN(Row);
      for( t = 0; t < pResult->GetFieldCount(); t++){ 
	if (t== 0) ID                = (UInt_t)atoll(Row->GetField(t));
	if (t== 1) ID_RUN_FRAG       = (UInt_t)atoll(Row->GetField(t));
	if (t== 2) ID_ROOT_L0        = (UInt_t)atoll(Row->GetField(t));
	if (t== 3) ID_ROOT_L2        = (UInt_t)atoll(Row->GetField(t));
	if (t== 4) RUNHEADER_TIME    = (UInt_t)atoll(Row->GetField(t)); 
	if (t== 5) RUNTRAILER_TIME   = (UInt_t)atoll(Row->GetField(t)); 
	if (t== 6) RUNHEADER_OBT     = (UInt_t)atoll(Row->GetField(t));
	if (t== 7) RUNTRAILER_OBT    = (UInt_t)atoll(Row->GetField(t));
	if (t== 8) RUNHEADER_PKT     = (UInt_t)atoll(Row->GetField(t));
	if (t== 9) RUNTRAILER_PKT    = (UInt_t)atoll(Row->GetField(t));
	if (t==10) EV_FROM           = (UInt_t)atoll(Row->GetField(t));
	if (t==11) EV_TO             = (UInt_t)atoll(Row->GetField(t));
	if (t==12) NEVENTS           = (UInt_t)atoll(Row->GetField(t));
	if (t==13) LAST_TIMESYNC     = (UInt_t)atoll(Row->GetField(t));
	if (t==14) OBT_TIMESYNC      = (UInt_t)atoll(Row->GetField(t));
	if (t==15) COMPILATIONTIMESTAMP = (UInt_t)atoll(Row->GetField(t));
	if (t==16) FAV_WRK_SCHEDULE  = (UInt_t)atoll(Row->GetField(t));
	if (t==17) EFF_WRK_SCHEDULE  = (UInt_t)atoll(Row->GetField(t));
	if (t==18) PRH_VAR_TRG_MODE_A= (UInt_t)atoll(Row->GetField(t));
	if (t==19) PRH_VAR_TRG_MODE_B= (UInt_t)atoll(Row->GetField(t));
	if (t==20) ACQ_BUILD_INFO    = (UInt_t)atoll(Row->GetField(t));
	if (t==21) ACQ_VAR_INFO      = (UInt_t)atoll(Row->GetField(t));
	if (t==22) RM_ACQ_AFTER_CALIB= (UInt_t)atoll(Row->GetField(t));
	if (t==23) RM_ACQ_SETTING_MODE = (UInt_t)atoll(Row->GetField(t));
	if (t==24) PKT_COUNTER       = (UInt_t)atoll(Row->GetField(t));
	if (t==25) PKT_READY_COUNTER = (UInt_t)atoll(Row->GetField(t));
	if (t==26) TRK_CALIB_USED    = (UInt_t)atoll(Row->GetField(t));
	if (t==27) CAL_DSP_MASK      = (UInt_t)atoll(Row->GetField(t));
	if (t==28) BOOT_NUMBER       = (UInt_t)atoll(Row->GetField(t));
	if (t==29) VALIDATION        = (UInt_t)atoll(Row->GetField(t));
      };
  };
  //  delete pResult;
  return(0);
};

/**
 * Function to query the GL_RUN  table of the DB.
 *
 * \param  where = condition string
 * \return struct of type GL_RUN _data, which stores the query result
 *
 */
Int_t GL_RUN::Query_GL_RUN_FRAGMENTS(TString where, TSQLServer *dbc){
  // MySQL variables
  TSQLResult *pResult;
  TSQLRow *Row;
  int t;
  int r;
  stringstream myquery;
  // ----------------
  myquery.str("");
  myquery << " select ";
  myquery << "ID";
  myquery << ",ID_RUN_FRAG";
  myquery << ",ID_ROOT_L0";
  myquery << ",ID_ROOT_L2";
  myquery << ",RUNHEADER_TIME";
  myquery << ",RUNTRAILER_TIME";
  myquery << ",RUNHEADER_OBT";
  myquery << ",RUNTRAILER_OBT";
  myquery << ",RUNHEADER_PKT";
  myquery << ",RUNTRAILER_PKT";
  myquery << ",EV_FROM";
  myquery << ",EV_TO";
  myquery << ",NEVENTS";
  myquery << ",LAST_TIMESYNC";
  myquery << ",OBT_TIMESYNC";
  myquery << ",COMPILATIONTIMESTAMP";
  myquery << ",FAV_WRK_SCHEDULE";
  myquery << ",EFF_WRK_SCHEDULE";
  myquery << ",PRH_VAR_TRG_MODE_A";
  myquery << ",PRH_VAR_TRG_MODE_B";
  myquery << ",ACQ_BUILD_INFO";
  myquery << ",ACQ_VAR_INFO";
  myquery << ",RM_ACQ_AFTER_CALIB";
  myquery << ",RM_ACQ_SETTING_MODE";
  myquery << ",PKT_COUNTER";
  myquery << ",PKT_READY_COUNTER";
  myquery << ",TRK_CALIB_USED";
  myquery << ",CAL_DSP_MASK";
  myquery << ",BOOT_NUMBER";
  myquery << ",VALIDATION";
  myquery << " from GL_RUN_FRAGMENTS where " << where.Data() << ";";
  //
  //  printf(" query is %s \n",myquery.str().c_str());
  //
  if ( !this->GetGLTABLES()->IsConnected(dbc) ) return -57;  
  this->GetGLTABLES()->AddQ();
  pResult = dbc->Query(myquery.str().c_str());
  if(!pResult->GetRowCount())return(-50);
  for( r=0; r < 1000; r++){ 
    Row = pResult->Next();      
    if( Row == NULL ) break;
    for( t = 0; t < pResult->GetFieldCount(); t++){ 
      if (t== 0) ID                = (UInt_t)atoll(Row->GetField(t));
      if (t== 1) ID_RUN_FRAG       = (UInt_t)atoll(Row->GetField(t));
      if (t== 2) ID_ROOT_L0        = (UInt_t)atoll(Row->GetField(t));
      if (t== 3) ID_ROOT_L2        = (UInt_t)atoll(Row->GetField(t));
      if (t== 4) RUNHEADER_TIME    = (UInt_t)atoll(Row->GetField(t)); 
      if (t== 5) RUNTRAILER_TIME   = (UInt_t)atoll(Row->GetField(t)); 
      if (t== 6) RUNHEADER_OBT     = (UInt_t)atoll(Row->GetField(t));
      if (t== 7) RUNTRAILER_OBT    = (UInt_t)atoll(Row->GetField(t));
      if (t== 8) RUNHEADER_PKT     = (UInt_t)atoll(Row->GetField(t));
      if (t== 9) RUNTRAILER_PKT    = (UInt_t)atoll(Row->GetField(t));
      if (t==10) EV_FROM           = (UInt_t)atoll(Row->GetField(t));
      if (t==11) EV_TO             = (UInt_t)atoll(Row->GetField(t));
      if (t==12) NEVENTS           = (UInt_t)atoll(Row->GetField(t));
      if (t==13) LAST_TIMESYNC     = (UInt_t)atoll(Row->GetField(t));
      if (t==14) OBT_TIMESYNC      = (UInt_t)atoll(Row->GetField(t));
      if (t==15) COMPILATIONTIMESTAMP = (UInt_t)atoll(Row->GetField(t));
      if (t==16) FAV_WRK_SCHEDULE  = (UInt_t)atoll(Row->GetField(t));
      if (t==17) EFF_WRK_SCHEDULE  = (UInt_t)atoll(Row->GetField(t));
      if (t==18) PRH_VAR_TRG_MODE_A= (UInt_t)atoll(Row->GetField(t));
      if (t==19) PRH_VAR_TRG_MODE_B= (UInt_t)atoll(Row->GetField(t));
      if (t==20) ACQ_BUILD_INFO    = (UInt_t)atoll(Row->GetField(t));
      if (t==21) ACQ_VAR_INFO      = (UInt_t)atoll(Row->GetField(t));
      if (t==22) RM_ACQ_AFTER_CALIB= (UInt_t)atoll(Row->GetField(t));
      if (t==23) RM_ACQ_SETTING_MODE = (UInt_t)atoll(Row->GetField(t));
      if (t==24) PKT_COUNTER       = (UInt_t)atoll(Row->GetField(t));
      if (t==25) PKT_READY_COUNTER = (UInt_t)atoll(Row->GetField(t));
      if (t==26) TRK_CALIB_USED    = (UInt_t)atoll(Row->GetField(t));
      if (t==27) CAL_DSP_MASK      = (UInt_t)atoll(Row->GetField(t));
      if (t==28) BOOT_NUMBER       = (UInt_t)atoll(Row->GetField(t));
      if (t==29) VALIDATION        = (UInt_t)atoll(Row->GetField(t));
    };
  };
  //  delete pResult;
  return(0);
};// ****************************************************

/**
 * Function to query the GL_ROOT table of the DB.
 *
 * \param  entry ID
 * \return struct of type GL_ROOT_data, which stores the query result
 */
Int_t GL_ROOT::Query_GL_ROOT(UInt_t id, TSQLServer *dbc){
  // MySQL variables
  TSQLResult *pResult;
  TSQLRow *Row;
  int t;
  int r;
  stringstream myquery;
  // ----------------
  myquery.str("");
  myquery << "select ";
  myquery << " ID"; 
  myquery << ",ID_RAW"; 
  myquery << ",ID_TIMESYNC"; 
  myquery << ",PATH"; 
  myquery << ",NAME"; 
  myquery << " from GL_ROOT where ID=" << id << ";";    
  //
  if ( !this->GetGLTABLES()->IsConnected(dbc) ) return -57;  
  this->GetGLTABLES()->AddQ();
  pResult = dbc->Query(myquery.str().c_str());
  if(!pResult->GetRowCount())return (-51);
  for( r=0; r < 1000; r++){ 
      Row = pResult->Next();      
      if( Row == NULL ) break;
      for( t = 0; t < pResult->GetFieldCount(); t++){ 
	  if(t==0) ID     = (UInt_t)atoll(Row->GetField(t));
	  if(t==1) ID_RAW = (UInt_t)atoll(Row->GetField(t));
	  if(t==2) ID_TIMESYNC = (UInt_t)atoll(Row->GetField(t));
	  if(t==3) PATH   = Row->GetField(t);
	  if(t==4) NAME   = Row->GetField(t);
      };
  };
  delete pResult;   
  return 0;
};
// ****************************************************
/**
 * Function to query the GL_TRK_CALIB table of the DB.
 *
 * \param  run starting time
 * \param  dbc DB server
 * \return struct of type GL_TRK_CALIB_data, which stores the query result
 */
Int_t GL_TRK_CALIB::Query_GL_TRK_CALIB(UInt_t time, TSQLServer *dbc){
  // MySQL variables
  TSQLResult *pResult;
  TSQLRow *Row;
  int t;
  int r;
  stringstream myquery;
  // ----------------
  myquery.str("");
  myquery << "select ID,ID_ROOT_L0,EV_ROOT_CALIBTRK1,EV_ROOT_CALIBTRK2,FROM_TIME,TO_TIME,OBT1,OBT2,PKT1,PKT2,BOOT_NUMBER,VALIDATION from GL_TRK_CALIB where FROM_TIME <= "<< time;
  myquery << " AND VALIDATION=1 ORDER BY FROM_TIME DESC LIMIT 1;";      
  //  myquery << " ORDER BY FROM_TIME DESC LIMIT 1;";      
  if ( !this->GetGLTABLES()->IsConnected(dbc) ) return -57;  
  this->GetGLTABLES()->AddQ();
  pResult = dbc->Query(myquery.str().c_str()); 
  if(!pResult->GetRowCount())return (-53);
  for( r=0; r < 1000; r++){ 
      Row = pResult->Next();     
      if( Row == NULL ) break;
      for( t = 0; t < pResult->GetFieldCount(); t++){ 
	  stringstream row;
	  row.str("");
	  row << "0" << Row->GetField(t); // add leading 0 since we have two fields that could be "null" and we want to avoid crashes due to atoll
	  if (t==0) ID                = (UInt_t)atoll(Row->GetField(t));
	  if (t==1) ID_ROOT_L0        = (UInt_t)atoll(Row->GetField(t));
	  if (t==2) EV_ROOT_CALIBTRK1 = (UInt_t)atoll(row.str().c_str());
	  if (t==3) EV_ROOT_CALIBTRK2 = (UInt_t)atoll(row.str().c_str());
	  if (t==4) FROM_TIME         = (UInt_t)atoll(Row->GetField(t));
	  if (t==5) TO_TIME           = (UInt_t)atoll(Row->GetField(t));
	  //
	  if (t==6) OBT1              = (UInt_t)atoll(Row->GetField(t));
	  if (t==7) OBT2              = (UInt_t)atoll(Row->GetField(t));
	  if (t==8) PKT1              = (UInt_t)atoll(Row->GetField(t));
	  if (t==9) PKT2              = (UInt_t)atoll(Row->GetField(t));
	  if (t==10) BOOT_NUMBER      = (UInt_t)atoll(Row->GetField(t));
	  if (t==11) VALIDATION       = (UInt_t)atoll(Row->GetField(t));
	  };
  };
  delete pResult;
  //
//  if ( TO_TIME < time ) return(51);
  //
  if ( (!OBT1 && !PKT1 ) || (!OBT2 && !PKT2) ) return(52); // ONE CALIBRATION PACKET IS MISSING!
  //
  return 0;
};

// ****************************************************
/**
 * Function to query the GL_CALO_CALIB table of the DB.
 *
 * \param  run starting time
 * \return struct of type GL_CALO_CALIB_data, which stores the query result
 */
Int_t GL_CALO_CALIB::Query_GL_CALO_CALIB(UInt_t time, UInt_t &uptime,  UInt_t section, TSQLServer *dbc){
  // MySQL variables
  TSQLResult *pResult;
  TSQLRow *Row;
  int t;
  stringstream myquery;
  uptime = 0;
  //
  // select the correct calibration
  //
  myquery.str("");
  myquery << "select ID_ROOT_L0, FROM_TIME, TO_TIME, EV_ROOT,VALIDATION from GL_CALO_CALIB where SECTION=" << section;
  myquery << " and FROM_TIME <= " << time;
  myquery << " and TO_TIME > " << time;
  myquery << " ;";
  //myquery << " and VALIDATION=1;";
  //
  if ( !this->GetGLTABLES()->IsConnected(dbc) ) return -57;  
  this->GetGLTABLES()->AddQ();
  pResult = dbc->Query(myquery.str().c_str());
  //  printf(" mysquery is %s\n",myquery.str().c_str());
  //
  if( !pResult->GetRowCount() ) return(-54);
  Row = pResult->Next();
  if( Row == NULL ) return (-54);
  //
  uptime = (UInt_t)atoll(Row->GetField(2));
  //
  // if it is corrupted validation is 0 and we have no results from the query...
  //
  if( atoi(Row->GetField(4)) == 0 ){ // if validation = 0
    //
    // in this case take relax the conditions and take the valid calibration that preceed the correct one
    //
    myquery.str("");
    myquery << "select ID_ROOT_L0, FROM_TIME, TO_TIME, EV_ROOT,VALIDATION from GL_CALO_CALIB where SECTION=" << section;
    myquery << " and FROM_TIME <= " << time;
    myquery << " and VALIDATION=1 ORDER BY FROM_TIME DESC LIMIT 1;";
    if ( !this->GetGLTABLES()->IsConnected(dbc) ) return -57;  
    this->GetGLTABLES()->AddQ();
    pResult = dbc->Query(myquery.str().c_str());
    //    printf(" mysquery is %s\n",myquery.str().c_str());
    //
    // if no results yet quit with error
    //
    if( !pResult->GetRowCount() ) return (-54);
    //
    Row = pResult->Next();
    //
  };
  //
  // store infos and exit
  //
  if( Row == NULL ) return (-54);
  for( t = 0; t < pResult->GetFieldCount(); t++){
    if (t==0) ID_ROOT_L0  = (UInt_t)atoll(Row->GetField(t));
    if (t==1) FROM_TIME = (UInt_t)atoll(Row->GetField(t));
    if (t==2) TO_TIME   = (UInt_t)atoll(Row->GetField(t));	      
    if (t==3) EV_ROOT = (UInt_t)atoll(Row->GetField(t));
  };
  pResult->Delete();
  return 0;
};
// ****************************************************
/**
 * Function to query the GL_S4_CALIB table of the DB.
 *
 * \param  run starting time
 * \return struct of type GL_S4_CALIB_data, which stores the query result
 */
Int_t GL_S4_CALIB::Query_GL_S4_CALIB(UInt_t time, TSQLServer *dbc){
  // MySQL variables
  TSQLResult *pResult;
  TSQLRow *Row;
  int t;
  int r;
  stringstream myquery;
  // ----------------
  myquery.str("");
  myquery << "select * from GL_S4_CALIB where FROM_TIME <= "<< time;
  myquery << " ORDER BY FROM_TIME DESC LIMIT 1;";      
  //  myquery << " ORDER BY FROM_TIME DESC LIMIT 1;";      
  if ( !this->GetGLTABLES()->IsConnected(dbc) ) return -57;  
  this->GetGLTABLES()->AddQ();
  pResult = dbc->Query(myquery.str().c_str()); 
  if(!pResult->GetRowCount())return (-55);//throw -55;
  for( r=0; r < 1000; r++){ 
      Row = pResult->Next();     
      if( Row == NULL ) break;
      for( t = 0; t < pResult->GetFieldCount(); t++){ 
	if (t==0) ID               = (UInt_t)atoll(Row->GetField(t));
	  if (t==1) ID_ROOT_L0  = (UInt_t)atoll(Row->GetField(t));
	  if (t==2) EV_ROOT    = (UInt_t)atoll(Row->GetField(t));
	  if (t==3) FROM_TIME = (UInt_t)atoll(Row->GetField(t));
	  if (t==4) TO_TIME   = (UInt_t)atoll(Row->GetField(t));
	  if (t==5) PARAM_FIT0   = atof(Row->GetField(t));
	  if (t==6) PARAM_FIT1   = atof(Row->GetField(t));
      };
  };
  delete pResult;     
  //
  if(TO_TIME < time)return(51);
  //
  return 0;
};
// ****************************************************
/**
 * Function to query the GL_PARAM table of the DB.
 *
 * \param  run starting time
 * \param  parameter description (DESCR)
 * \return struct of type GL_ROOT_data, which stores the query result
 */
Int_t GL_PARAM::Query_GL_PARAM(UInt_t time, UInt_t type, TSQLServer *dbc){
  //    Bool_t debug = 1;
  // MySQL variables
  TSQLResult *pResult;
  TSQLRow *Row;
  int t;
  int r;
  stringstream myquery;
  // ----------------    
  myquery.str("");
  myquery << " select ";
  myquery << " ID, PATH, NAME, DESCR, TYPE, FROM_TIME,TO_TIME ";
  myquery << " from GL_PARAM ";
  myquery << " where TYPE = '"<<type<<"' ";
  myquery << " and FROM_TIME <= " << time; 
  myquery << " ORDER BY TO_TIME DESC LIMIT 1;";  
  //
  if ( !this->GetGLTABLES()->IsConnected(dbc) ) return -57;  
  this->GetGLTABLES()->AddQ();
  pResult = dbc->Query(myquery.str().c_str()); 
  if(!pResult->GetRowCount())return (-52);
  for( r=0; r < 1000; r++){ 
      Row = pResult->Next();     
      if( Row == NULL ) break;
      for( t = 0; t < pResult->GetFieldCount(); t++){ 
	if (t==0) ID        = (UInt_t)atoll(Row->GetField(t));
	  if (t==1) PATH      = Row->GetField(t);// put in fpath the path to that file
	  if (t==2) NAME      = Row->GetField(t);
	  if (t==3) DESCR     = Row->GetField(t);
	  if (t==4) FROM_TIME = (UInt_t)atoll(Row->GetField(t));
	  if (t==5) TO_TIME   = (UInt_t)atoll(Row->GetField(t));	      
	  if (t==6) TYPE     = (UInt_t)atoll(Row->GetField(t));
      };
  };
  delete pResult; 
  //
  if(TO_TIME==0) TO_TIME = numeric_limits<UInt_t>::max();
  //
  if(TO_TIME < time) return(51);
  //        
  return 0;   
};


/**
 * Fills a struct cGLRun with values from a GLRun object (to put data into a F77 common).
 */

void GL_RUN::GetLevel2Struct(cGLRun *l2) const{
    l2->id                 = ID;
    l2->id_reg_run         = ID_ROOT_L0;
    l2->id_reg_run_l2      = ID_ROOT_L2;
    l2->runheader_time     = RUNHEADER_TIME;
    l2->runtrailer_time    = RUNTRAILER_TIME;
    l2->ev_from   = EV_FROM; 
    l2->trk_calib_used     = TRK_CALIB_USED;
    l2->eff_wrk_schedule   = EFF_WRK_SCHEDULE;
    l2->prh_var_trg_mode_a = PRH_VAR_TRG_MODE_A;
    l2->prh_var_trg_mode_b = PRH_VAR_TRG_MODE_B;
    l2->acq_build_info     = ACQ_BUILD_INFO;
    l2->acq_var_info       = ACQ_VAR_INFO;
};

GL_TIMESYNC::GL_TIMESYNC(UInt_t id, TString type, TSQLServer *dbc){
  // MySQL variables
  TFile *file = 0;
  UInt_t idraw = 0;
  //
  TSQLResult *pResult;
  TSQLRow *Row;
  stringstream myquery;
  stringstream rname;
  rname.str("");
  // ----------------
  myquery.str("");
  myquery << "select ";
  myquery << "PATH"; 
  myquery << ",NAME,ID_RAW"; 
  myquery << " from GL_ROOT where ";
  myquery << type.Data();
  myquery << "=" << id << ";";    
  //
  if ( !this->GetGLTABLES()->IsConnected(dbc) ) return;  
  this->GetGLTABLES()->AddQ();
  pResult = dbc->Query(myquery.str().c_str());
  if( pResult->GetRowCount() ){
    Row = pResult->Next();      
    if( Row ){
      stringstream fname;
      fname.str("");
      fname << Row->GetField(0) << "/" << Row->GetField(1);
      rname << Row->GetField(1);
      file = new TFile(fname.str().c_str(),"READ");
      idraw = (UInt_t)atoll(Row->GetField(2));
    };
  };
  //
  if ( file && file->IsOpen() ){
    TTree *T=(TTree*)file->Get("Physics");
    pamela::EventHeader *eh = 0;
    pamela::PscuHeader *ph = 0;
    T->SetBranchAddress("Header", &eh);
    //
    T->GetEntry(0);
    ph = eh->GetPscuHeader();
    pktfirst = ph->GetCounter();
    obtfirst = ph->GetOrbitalTime();  
  };
  //
  // look for Resurs offset
  //
  T0 = 0;
  //
  //
  stringstream oss;
  oss.str("");
  oss << "SELECT YEAR(OFFSET_DATE),MONTH(OFFSET_DATE),DAY(OFFSET_DATE),HOUR(OFFSET_DATE),MINUTE(OFFSET_DATE),SECOND(OFFSET_DATE) FROM GL_RESURS_OFFSET WHERE SPECIAL_FILE='" 
      << rname.str().c_str() << "';";
  if ( !this->GetGLTABLES()->IsConnected(dbc) ) return;  
  this->GetGLTABLES()->AddQ();
  pResult = dbc->Query(oss.str().c_str());
  Row = pResult->Next();
  //
  TString name=rname.str().c_str();
  UInt_t dworbit = 0;
  Int_t nlength = name.Length();
  if ( nlength < 5 ) return;
  TString dwo = 0;
  for (Int_t i = 0; i<5; i++){
    dwo.Append(name[i],1);
  };
  if ( dwo.IsDigit() ){
    dworbit = (UInt_t)dwo.Atoi();
  } else {
    dwo="";
    for (Int_t i = 8; i<13; i++){
      dwo.Append(name[i],1);
    };     
    if ( dwo.IsDigit() ) dworbit = (UInt_t)dwo.Atoi();
  };
  //
  if ( !Row ){
    oss.str("");
    oss << "SELECT YEAR(OFFSET_DATE),MONTH(OFFSET_DATE),DAY(OFFSET_DATE),HOUR(OFFSET_DATE),MINUTE(OFFSET_DATE),SECOND(OFFSET_DATE) FROM GL_RESURS_OFFSET WHERE FROM_ORBIT< " 
	<< dworbit << " order by FROM_ORBIT desc limit 1;";
    if ( !this->GetGLTABLES()->IsConnected(dbc) ) return;  
    this->GetGLTABLES()->AddQ();
    pResult = dbc->Query(oss.str().c_str());
    Row = pResult->Next();
    if ( !Row ){
      printf(" ERROR FROM GLTables! cannot determine Resurs offset \n");
      return;
    };
  };
  //
  TTimeStamp tu = TTimeStamp((UInt_t)atoi(Row->GetField(0)),(UInt_t)atoi(Row->GetField(1)),(UInt_t)atoi(Row->GetField(2)),(UInt_t)atoi(Row->GetField(3)),(UInt_t)atoi(Row->GetField(4)),(UInt_t)atoi(Row->GetField(5)),0,true,0);
  T0 = (UInt_t)tu.GetSec();
  //
  // look for the correct timesync entry
  //
  myquery.str("");
  myquery << " SELECT OBT0,TIMESYNC,TYPE FROM GL_TIMESYNC "
      << " WHERE ID_RAW = " << idraw 
      << ";";
  if ( !this->GetGLTABLES()->IsConnected(dbc) ) return;  
  this->GetGLTABLES()->AddQ();
  pResult = dbc->Query(myquery.str().c_str());
  if ( pResult ){
    Row = pResult->Next();
    if ( (Row != NULL) && ((UInt_t)atoll(Row->GetField(0)) > 0 ) ){
      OBT0 = (UInt_t)atoll(Row->GetField(0));
      TIMESYNC = (UInt_t)atoll(Row->GetField(1));
      TYPE = (UInt_t)atoll(Row->GetField(2));
      toffset = (UInt_t)atoll(Row->GetField(1)) - (UInt_t)(this->DBobt((UInt_t)atoll(Row->GetField(0)))/1000) + T0;
    };
  };
  //
  file->Close();
  delete pResult;       
};

/**
 * 
 * Returns the DB absolute time needed to associate calibrations to data
 * 
 */
UInt_t GL_TIMESYNC::DBabsTime(UInt_t OBT){  
  //
  return(((UInt_t)(this->DBobt(OBT)/1000)+toffset));
  //
};

/**
 * 
 * Returns the Resurs time given the OBT needed to process inclination and orbital infos
 * 
 */
UInt_t GL_TIMESYNC::ResursTime(UInt_t OBT){  
  //
  return(((UInt_t)((Int_t)(this->DBobt(OBT)-this->DBobt(OBT0))/1000)+TIMESYNC));
  //
};


/**
 * Return the correct packet number if we went back to zero
 */
Long64_t GL_TIMESYNC::DBpkt(UInt_t pkt_num){  
  //
  if ( pkt_num < (pktfirst/2) && pktfirst > (16777214/2)  ){
    return((Long64_t)pkt_num+16777215LL);
  };
  //
  if ( pkt_num > pktfirst*2 && pkt_num > (16777214/2) ){
    return((Long64_t)pkt_num-16777215LL);
  };
  //
  return((Long64_t)pkt_num);
  //
};

/**
 * Return the correct On Board Time if we went back to zero
 */
Long64_t GL_TIMESYNC::DBobt(UInt_t obt){  
  //
  if ( obt < (obtfirst/2) && obtfirst > (numeric_limits<UInt_t>::max()/2) ) return((Long64_t)(obt+numeric_limits<UInt_t>::max()));
  //
  if ( obt > (obtfirst*2) && obt > (numeric_limits<UInt_t>::max()/2) ){
    return((Long64_t)obt-(Long64_t)numeric_limits<UInt_t>::max());
  };
  //
  return((Long64_t)obt);
};



// ULong64_t GL_TIMESYNC::DBobt(UInt_t obt){  
//   //
//   if ( obt < (obtfirst/2) && obtfirst > (numeric_limits<UInt_t>::max()/2) ) return((ULong64_t)(obt+numeric_limits<UInt_t>::max()));
//   //
//   if ( obt > (obtfirst*2) && obt > (numeric_limits<UInt_t>::max()/2) ){
//     if ( (obt-numeric_limits<UInt_t>::max()) < 0  ){
//       return((ULong64_t)(numeric_limits<UInt_t>::max()-obt));
//     } else {
//       return((ULong64_t)(obt-numeric_limits<UInt_t>::max()));
//     };
//   };
//   //
//   return((ULong64_t)obt);
//   //
// };

// UInt_t GL_TIMESYNC::DBpkt(UInt_t pkt_num){  
//   //
//   if ( pkt_num < (pktfirst/2) && pktfirst > (16777214/2)  ) return((pkt_num+16777215));
//   //
//   if ( pkt_num > pktfirst*2 && pkt_num > (16777214/2) ){
//     if ( (pkt_num-16777215) < 0 ){
//       return((16777215-pkt_num));
//     } else {
//       return((pkt_num-16777215));
//     };
//   };
//   //
//   return(pkt_num);
//   //
// };

/*
 *
 * Convert the time in the DB from UInt_t to a string
 * 
 * @param dbt time in the DB
 * @param tzone Time Zone, can be UTC,GMT,CET,CEST,MSD default is MSK
 *
 */
TString GL_TIMESYNC::ConvertTime(TString &tzone, UInt_t dbt){
  //
  Int_t offset = 0;
  TString rtime;
  Bool_t found = false;
  //
  if ( !strcmp(tzone.Data(),"MSK") || !strcmp(tzone.Data(),"MWT") ){
    //
    offset = 60*60*3; // UTC (Coordinated Universal Time) + 3hs = Moscow Winter Time 
    found = true;
    //
  };
  //
  if ( !strcmp(tzone.Data(),"CET") ){
    //
    offset = 60*60*1; // CET (Central European Time) = UTC + 1 hs 
    found = true;
    //
  };
  //
  if ( !strcmp(tzone.Data(),"CEST") ){
    //
    offset = 60*60*2; // CEST (Central European Summer Time) = UTC + 2 h
    found = true;
    //
  };
  //
  if ( !strcmp(tzone.Data(),"MSD") || !strcmp(tzone.Data(),"MST")){
    //
    offset = 60*60*4; // MSD (Moscow Summer Time) = UTC + 4 h
    found = true;
    //
  };
  //
  if ( !found && strcmp(tzone.Data(),"UTC") && strcmp(tzone.Data(),"GMT") && strcmp(tzone.Data(),"") ){
    printf("\n Unknown time zone %s using UTC \n",tzone.Data());
    tzone = "UTC";
  };
  //
  dbt += offset;
  //
  TTimeStamp *time = new TTimeStamp((time_t)dbt,0);
  //
  rtime = time->AsString("s");
  //
  delete time;
  //
  return(rtime);
}

/*
 *
 * Convert the time from TZONE to UTC
 * 
 * @param dbt time in the DB
 * @param tzone Time Zone, can be UTC,GMT,CET,CEST,MSD default is MSK
 *
 */
TString GL_TIMESYNC::UnConvertTime(TString &tzone, UInt_t dbt){
  //
  Int_t offset = 0;
  TString rtime;
  //
  Bool_t found = false;
  //
  if ( !strcmp(tzone.Data(),"MSK") || !strcmp(tzone.Data(),"MWT") ){
    //
    offset = -60*60*3; // UTC (Coordinated Universal Time) = Moscow Winter Time - 3hs
    found = true;
    //
  };
  //
  if ( !strcmp(tzone.Data(),"CET") ){
    //
    offset = -60*60*1; // CET (Central European Time) - 1 hs = UTC  
    found = true;
    //
  };
  //
  if ( !strcmp(tzone.Data(),"CEST") ){
    //
    offset = -60*60*2; // CEST (Central European Summer Time) - 2 h = UTC
    found = true;
    //
  };
  //
  if ( !strcmp(tzone.Data(),"MSD") || !strcmp(tzone.Data(),"MST") ){
    //
    offset = -60*60*4; // MSD (Moscow Summer Time) - 4 h = UTC
    found = true;
    //
  };
  //
  if ( !found && strcmp(tzone.Data(),"UTC") && strcmp(tzone.Data(),"GMT") && strcmp(tzone.Data(),"") ){
    //
    offset = 0;
    printf("\n Unknown time zone %s using UTC \n",tzone.Data());
    tzone = "UTC";
  };
  //
  dbt += offset;
  TTimeStamp *time = new TTimeStamp((time_t)dbt,0);
  //
  rtime = time->AsString("s");
  //
  return(rtime);
}


//
// Build a query and call DoQuery.
//
// date it's an SQL datetime date and dbc is the connection to be
// used.  It will query for the tle with the nearest but previous date
// and the immediatly next one.
//
Int_t GL_TLE::Query(TString date, TSQLServer *dbc){
  stringstream myquery;
  myquery.str("");

  myquery << "(SELECT ID, TLE1, TLE2, TLE3, UNIX_TIMESTAMP(FROM_TIME) FROM GL_TLE "
	  << "WHERE FROM_TIME <= '" << date.Data()
	  << "' ORDER BY FROM_TIME DESC LIMIT 1) "
	  << "UNION "
	  << "(SELECT ID, TLE1, TLE2, TLE3, UNIX_TIMESTAMP(FROM_TIME) FROM GL_TLE "
	  << "WHERE FROM_TIME > '" << date.Data()
	  << "' ORDER BY FROM_TIME ASC LIMIT 1)";

  return DoQuery(myquery.str().c_str(), dbc);
}


//
// Build a query and call DoQuery.
//
// time is the UTC date in unix time (UTC) and dbc is the connection
// to be used.  It will query for the tle with the nearest but
// previous date and the immediatly next one.
//
// Returns the value returned by DoQuery().
//
Int_t GL_TLE::Query(UInt_t time, TSQLServer *dbc){
  stringstream myquery;
  myquery.str("");

  myquery << "(SELECT ID, TLE1, TLE2, TLE3, UNIX_TIMESTAMP(FROM_TIME) FROM GL_TLE "
	  << "WHERE FROM_TIME <= FROM_UNIXTIME('" << time
	  << "') ORDER BY FROM_TIME DESC LIMIT 1) "
	  << "UNION "
	  << "(SELECT ID, TLE1, TLE2, TLE3, UNIX_TIMESTAMP(FROM_TIME) FROM GL_TLE "
	  << "WHERE FROM_TIME > FROM_UNIXTIME('" << time
	  << "') ORDER BY FROM_TIME ASC LIMIT 1)";

  return DoQuery(myquery.str().c_str(), dbc);
}


//
// Do the query myquery on the connectio dbc.  Initialize tle,
// tleFromTime and tleToTime.
//
// We should have two rows (unless the table is old).  From the last
// one we only take tleToTime.
//
// Returns 0 for success, 1 for failure.
//
Int_t GL_TLE::DoQuery(TString myquery, TSQLServer *dbc){
  TSQLResult *result;
  TSQLRow *row;

  // Set the right time_zone (otherwise horrible things will occur! :)
  dbc->Query("SET time_zone = '+0:00'");

  // Do the query
  if ( !this->GetGLTABLES()->IsConnected(dbc) ) return -57;  
  this->GetGLTABLES()->AddQ();
  result = dbc->Query(myquery.Data());
  if(! result->GetRowCount() ) {
    cerr << "GL_TLE: query failed: " << myquery.Data() << endl;
    return 1;
  }

  // Get results
  row = result->Next(); // first tle row
  tle = GiveTle(row);

  tleFromTime = strtol(row->GetField(4), NULL, 10);

  row = result->Next(); // second tle row
  if(row)
    tleToTime = strtol(row->GetField(4), NULL, 10);
  else {
    cerr << "GL_TLE: Warning: using last avaible TLE. Please update GL_TLE table!\n";
    tleToTime = UINT_MAX;
  }

  delete row;
  delete result;

  return 0;
}


//
// Build a cTle object from the GL_TLE row.
//
cTle* GL_TLE::GiveTle(TSQLRow *row) {
  cTle *thistle = NULL;
  string tle1, tle2, tle3;

  // Build cTle object
  tle1 = row->GetField(1);
  tle2 = row->GetField(2);
  tle3 = row->GetField(3);

  thistle = new cTle(tle1, tle2, tle3);

  return thistle;
}
