#ifndef gltables_h
#define gltables_h

#include <TString.h>
#include <TObject.h>
#include <TSQLServer.h>
#include <TSQLRow.h>
#include <TSQLResult.h>
#include <TSystem.h>
#include <GLTablesStruct.h>
#include <EventHeader.h>
#include <PscuHeader.h>
#include <RunHeaderEvent.h>
#include <RunTrailerEvent.h>
#include <sgp4.h>
//

using namespace pamela;
//

static const TString *fHost;
static const TString *fUser;
static const TString *fPsw;
static UInt_t fNquery;
static Bool_t fSet;

// ==================================================================
/**
 * \brief Class to store GL_RUN data
 */
class GL_TABLES : public TObject {
 private:

 public:
    //
    TString mh;
    TString mp;
    TString mu;
    GL_TABLES();   
    GL_TABLES(TString, TString, TString);
    //
    void Set(TString, TString, TString);
    //
    Bool_t IsConnected(TSQLServer *&);
    //
    void ResetCounters();
    void AddQ();
    //
    const TString* GetHost(){return(fHost);};
    const TString* GetUser(){return(fUser);};
    const TString* GetPsw(){return(fPsw);};
    TString CGetHost(){return(mh);};
    TString CGetUser(){return(mu);};
    TString CGetPsw(){return(mp);};
    UInt_t GetfNquery(){return(fNquery);};
    UInt_t GetNqueries();
    Bool_t IsSet(){return(fSet);};
    //
    GL_TABLES *GetGLTABLES(){return this;};
    //
    ClassDef(GL_TABLES,1);
};

// ==================================================================
/**
 * \brief Class to store GL_RUN data
 */
//class GL_RUN : public TObject {
class GL_RUN : public GL_TABLES {
 private:
    
 public:
    //
    UInt_t ID; 
    UInt_t ID_RUN_FRAG;
    UInt_t ID_ROOT_L0;
    UInt_t ID_ROOT_L2;
    UInt_t RUNHEADER_TIME;
    UInt_t RUNTRAILER_TIME;
    UInt_t RUNHEADER_OBT;
    UInt_t RUNTRAILER_OBT;
    UInt_t RUNHEADER_PKT;
    UInt_t RUNTRAILER_PKT;
    UInt_t BOOT_NUMBER;
    UInt_t EV_FROM;
    UInt_t EV_TO;
    UInt_t NEVENTS;
    UInt_t PKT_COUNTER;
    UInt_t PKT_READY_COUNTER;
    UInt_t COMPILATIONTIMESTAMP;
    UInt_t FAV_WRK_SCHEDULE;
    UInt_t EFF_WRK_SCHEDULE;
    UInt_t PRH_VAR_TRG_MODE_A; 
    UInt_t PRH_VAR_TRG_MODE_B; 
    UInt_t ACQ_BUILD_INFO;
    UInt_t ACQ_VAR_INFO;
    UInt_t RM_ACQ_AFTER_CALIB;
    UInt_t RM_ACQ_SETTING_MODE;
    UInt_t TRK_CALIB_USED;
    UInt_t CAL_DSP_MASK;
    UInt_t LAST_TIMESYNC;
    UInt_t OBT_TIMESYNC;
    UInt_t VALIDATION;
    //
    //
    //
    GL_RUN();
    //
    // functions
    //
    Int_t Query_GL_RUN(UInt_t, TSQLServer*);
    Int_t Fill_GL_RUN(TSQLServer*);
    Int_t Query_GL_RUN_FRAGMENTS(TString, TSQLServer*);
    Int_t Fill_GL_RUN_FRAGMENTS(TSQLServer*);
    Int_t DeleteRun(TSQLServer*, UInt_t, TString);
    Int_t RestoreRun(TSQLServer*, UInt_t, TString);
    void Clear();
    //
    // SETTERS
    //
    void Set_GL_RUNT(RunTrailerEvent *runt, PscuHeader *pht);
    void Set_GL_RUNH(RunHeaderEvent *runt, PscuHeader *pht);
    void Set_GL_RUNT0();
    void Set_GL_RUNH0();
    //
    void Set_GL_RUN(TSQLRow *row);
    //
    void SetRUNHEADER_TIME(UInt_t abst);
    void SetRUNTRAILER_TIME(UInt_t abst);
    void SetRUNHEADER_PKT(UInt_t abst);
    void SetRUNTRAILER_PKT(UInt_t abst);
    void SetRUNHEADER_OBT(UInt_t abst);
    void SetRUNTRAILER_OBT(UInt_t abst);
    void SetBOOTNUMBER(UInt_t abst);
    void SetID(UInt_t);
    void SetID_ROOT_L2(UInt_t L2);
    void SetID_ROOT_L0(UInt_t L0);
    void SetID_RUN_FRAG(UInt_t RUN);
    void SetVALIDATION(UInt_t valid);
    void SetEV_FROM(UInt_t evfrom);
    void SetEV_TO(UInt_t evto);
    void SetNEVENTS(UInt_t nev);
    void SetLAST_TIMESYNC(UInt_t ts);
    void SetOBT_TIMESYNC(UInt_t ts);
    void SetPKT_COUNTER(UInt_t);
    void SetPKT_READY_COUNTER(UInt_t);
    void SetCOMPILATIONTIMESTAMP(UInt_t);
    void SetFAV_WRK_SCHEDULE(UInt_t);
    void SetEFF_WRK_SCHEDULE(UInt_t);
    void SetPRH_VAR_TRG_MODE_A(UInt_t);
    void SetPRH_VAR_TRG_MODE_B(UInt_t);
    void SetACQ_BUILD_INFO(UInt_t);
    void SetACQ_VAR_INFO(UInt_t);
    void SetRM_ACQ_AFTER_CALIB(UInt_t);
    void SetRM_ACQ_SETTING_MODE(UInt_t);
    void SetTRK_CALIB_USED(UInt_t);
    void SetCAL_DSP_MASK(UInt_t);
    //
    // GETTERS
    //
    void GetLevel2Struct(cGLRun *l2) const;
    UInt_t GetID(){return(ID);};
    UInt_t GetRUNHEADER_PKT(){return(RUNHEADER_PKT);};
    UInt_t GetRUNTRAILER_PKT(){return(RUNTRAILER_PKT);};
    UInt_t GetRUNHEADER_TIME(){return(RUNHEADER_TIME);};
    UInt_t GetRUNTRAILER_TIME(){return(RUNTRAILER_TIME);};
    UInt_t GetRUNHEADER_OBT(){return(RUNHEADER_OBT);};
    UInt_t GetRUNTRAILER_OBT(){return(RUNTRAILER_OBT);};
    UInt_t GetNEVENTS(){return(NEVENTS);};
    UInt_t GetBOOT_NUMBER(){return(BOOT_NUMBER);};
    UInt_t GetTRK_CALIB(){return(TRK_CALIB_USED);};
    UInt_t GetPKT_COUNTER(){return(PKT_COUNTER);};
    UInt_t GetLAST_TIMESYNC(){return(LAST_TIMESYNC);};
    UInt_t GetOBT_TIMESYNC(){return(OBT_TIMESYNC);};
    UInt_t GetPKT_READY_COUNTER(){return(PKT_READY_COUNTER);};
    UInt_t GetCOMPILATIONTIMESTAMP(){return(COMPILATIONTIMESTAMP);};
    UInt_t GetFAV_WRK_SCHEDULE(){return(FAV_WRK_SCHEDULE);};
    UInt_t GetEFF_WRK_SCHEDULE(){return(EFF_WRK_SCHEDULE);};
    UInt_t GetPRH_VAR_TRG_MODE_A(){return(PRH_VAR_TRG_MODE_A);};
    UInt_t GetPRH_VAR_TRG_MODE_B(){return(PRH_VAR_TRG_MODE_B);};
    UInt_t GetACQ_BUILD_INFO(){return(ACQ_BUILD_INFO);};
    UInt_t GetACQ_VAR_INFO(){return(ACQ_VAR_INFO);};
    UInt_t GetRM_ACQ_AFTER_CALIB(){return(RM_ACQ_AFTER_CALIB);};
    UInt_t GetRM_ACQ_SETTING_MODE(){return(RM_ACQ_SETTING_MODE);};
    UInt_t GetTRK_CALIB_USED(){return(TRK_CALIB_USED);};
    UInt_t GetCAL_DSP_MASK(){return(CAL_DSP_MASK);};
    //
    GL_RUN* GetGL_RUN(){return this;};
    //
    ClassDef(GL_RUN,1);
};

// ==================================================================
/**
 * \brief Class to store GL_ROOT 
 */
class GL_ROOT : public GL_TABLES {
    //class GL_ROOT : public TObject{
 private:
    
 public:
    //
    UInt_t ID;
    UInt_t ID_RAW;
    UInt_t ID_TIMESYNC;
    TString   PATH;
    TString   NAME;

    GL_ROOT();

    Int_t Query_GL_ROOT(UInt_t id, TSQLServer *dbc);

    ClassDef(GL_ROOT,1);
};
// ==================================================================
/**
 * \brief Class to store GL_PARAM data
 */
class GL_PARAM : public GL_TABLES {
    //class GL_PARAM : public TObject{
 private:
    
 public:
    //
    UInt_t ID;
    TString   PATH;
    TString   NAME;
    UInt_t FROM_TIME;
    UInt_t TO_TIME;
    UInt_t TYPE;
    TString   DESCR;

    GL_PARAM();

    Int_t Query_GL_PARAM(UInt_t time, UInt_t type, TSQLServer *dbc);
 
    ClassDef(GL_PARAM,1);
};
// ==================================================================
/**
 * \brief Class to store GL_TRK_CALIB data
 */
//class GL_TRK_CALIB : public TObject{
class GL_TRK_CALIB : public GL_TABLES {
 private:
    
 public:
    //
    UInt_t ID;
    UInt_t ID_ROOT_L0;
    UInt_t EV_ROOT_CALIBTRK1 ;
    UInt_t EV_ROOT_CALIBTRK2 ;
    UInt_t FROM_TIME;
    UInt_t TO_TIME;
    UInt_t OBT1;
    UInt_t OBT2;
    UInt_t PKT1;
    UInt_t PKT2;
	UInt_t BOOT_NUMBER;
	UInt_t VALIDATION;

    GL_TRK_CALIB();

    Int_t Query_GL_TRK_CALIB(UInt_t time, TSQLServer *dbc);

    ClassDef(GL_TRK_CALIB,1);
};

// ==================================================================
/**
 * \brief Class to store GL_CALO_CALIB data
 */
class GL_CALO_CALIB : public GL_TABLES {
    //class GL_CALO_CALIB : public TObject{
 private:
    
 public:
    //
    UInt_t ID;
    UInt_t ID_ROOT_L0;
    UInt_t     EV_ROOT;
    UInt_t FROM_TIME;
    UInt_t TO_TIME;
    UInt_t     SECTION;

    GL_CALO_CALIB();

    Int_t Query_GL_CALO_CALIB(UInt_t time, UInt_t &uptime, UInt_t section, TSQLServer *dbc);

    ClassDef(GL_CALO_CALIB,1);
};
// ==================================================================
/**
 * \brief Class to store GL_S4_CALIB data
 */
class GL_S4_CALIB : public GL_TABLES {
    //class GL_S4_CALIB : public TObject{
 private:
    
 public:
    //
    UInt_t ID;
    UInt_t ID_ROOT_L0;
    UInt_t     EV_ROOT;
    UInt_t FROM_TIME;
    UInt_t TO_TIME;
    Float_t PARAM_FIT0;
    Float_t PARAM_FIT1;

    GL_S4_CALIB();

    Int_t Query_GL_S4_CALIB(UInt_t time, TSQLServer *dbc);

    ClassDef(GL_S4_CALIB,1);
};

// ==================================================================
/**
 * \brief Class to store TIMESYNC data
 */
class GL_TIMESYNC : public GL_TABLES {
    //class GL_TIMESYNC : public TObject{
 private:
    UInt_t obtfirst;
    UInt_t pktfirst;
    UInt_t toffset;
    //
    //    UInt_t ID;
    //    UInt_t ID_RAW;
    UInt_t OBT0;
    UInt_t TIMESYNC;
    UInt_t TYPE;
    UInt_t T0;
    
 public:
    //
    GL_TIMESYNC();
    GL_TIMESYNC(UInt_t ID, TString TYPE, TSQLServer *dbc);
    //
    UInt_t DBabsTime(UInt_t OBT);
    UInt_t ResursTime(UInt_t OBT);
    //
    Long64_t DBpkt(UInt_t PKT);
    Long64_t DBobt(UInt_t OBT);
    //
    TString ConvertTime(TString &tzone, UInt_t dbt);
    TString UnConvertTime(TString &tzone, UInt_t dbt);
    //
    UInt_t GetTimesync() { return TIMESYNC; };
    UInt_t GetObt0() { return OBT0; };
    UInt_t GetT0() { return T0; };
    UInt_t GetType() { return TYPE; };
    //
    ClassDef(GL_TIMESYNC,2);
};


/* 
 * Class to query a TLE from the db.
 *
 * Two non default constructor are avaiable.  It is the same to call
 * the Query method.
 * 
 * The class looks for a TLE in the GL_TLE table using the connection
 * dbc.  You need to pass an UTC date in SQL datetime format or in
 * unix time (UTC) and it will look for the tle with the nearest and
 * previous date.  Then it initialize tle to a cTle object,
 * tleFromTime to the UTC unix time of the tle and tleToTime to the
 * UTC unix time of the next avaible tle.
 */
class GL_TLE : public GL_TABLES {
    //class GL_TLE : public TObject{
 private:
  Int_t DoQuery(TString query, TSQLServer *dbc);
  cTle* GiveTle(TSQLRow*);

  cTle *tle; // the requested tle
  UInt_t tleFromTime; // unix time (UTC) of the tle
  UInt_t tleToTime; // unix time (UTC) of the next tle

 public:
  GL_TLE(){
    tle = NULL;
    tleFromTime = 0;
    tleToTime = 0;
  };

  GL_TLE(UInt_t unixtime, TSQLServer *dbc) {
    Query(unixtime, dbc);
  };

  GL_TLE(TString date, TSQLServer *dbc) {
    Query(date, dbc);
  };

  Int_t Query(UInt_t unixtime, TSQLServer *dbc);
  Int_t Query(TString date, TSQLServer *dbc);

  cTle* GetTle() const { return tle; }
  UInt_t GetFromTime() const { return tleFromTime; }
  UInt_t GetToTime() const { return tleToTime; }

  ClassDef(GL_TLE,1);
};

#endif

