#ifndef PAMELA_DB_OPERATIONS_H
#define PAMELA_DB_OPERATIONS_H

#include <iostream>
#include <list>
//
#include <TSQLServer.h>
#include <TArrayD.h>
//
#include <EventHeader.h>
#include <PscuHeader.h>
#include <mcmd/McmdEvent.h>
#include <mcmd/McmdRecord.h>
#include <RunHeaderEvent.h>
#include <RunTrailerEvent.h>
#include <CalibCalPedEvent.h>
#include <CalibS4Event.h>
#include <CalibTrk1Event.h>
#include <CalibTrk2Event.h>
#include <varDump/VarDumpEvent.h>
#include <varDump/VarDumpRecord.h>
#include <physics/S4/S4Event.h>
//
#include <GLTables.h>

using namespace pamela;


/**
 * Collections of Pamela specific operations over a database
 */
class PamelaDBOperations {

 private:
    TSQLServer *conn;
    TFile *file;
    //
    RunHeaderEvent *runh;
    EventHeader *ehh;
    PscuHeader *phh;
    RunTrailerEvent *runt;
    EventHeader *eht;
    PscuHeader *pht;
    //
    GL_RUN *glrun;
    //
    TString filerawname;
    TString filerootname;
    //
    UInt_t tsync;
    UInt_t toffset;
    //
    UInt_t BOOTNO;
    UInt_t obt0;
    UInt_t id;
    UInt_t idroot;
    UInt_t pktfirst;
    ULong64_t obtfirst;
    ULong64_t upperobt;
    UInt_t upperpkt;
    UInt_t upperentry;
    Int_t rtev;
    Int_t rhev;
    //
    // calibration variables
    //
    Int_t t1;
    Int_t t2;
    UInt_t fromtime;
    UInt_t obt1;
    UInt_t pkt1;
    UInt_t obt2;
    UInt_t pkt2;
    UInt_t valid;
    //
    //
    Bool_t NOBOOT;
    Bool_t debug;
    //
    typedef std::list<const char*> pcksList;
    static void getPacketsNames(pcksList &pcksNames){
	pcksNames.push_back("PhysEndRun");
	pcksNames.push_back("CalibCalPulse1");
	pcksNames.push_back("CalibCalPulse2");
	pcksNames.push_back("Physics");
	pcksNames.push_back("CalibTrkBoth");
	pcksNames.push_back("CalibTrk1");
	pcksNames.push_back("CalibTrk2");
	pcksNames.push_back("CalibTof");
	pcksNames.push_back("CalibS4");
	pcksNames.push_back("CalibCalPed");
	pcksNames.push_back("Calib1_Ac1");
	pcksNames.push_back("Calib2_Ac1");
	pcksNames.push_back("Calib1_Ac2");
	pcksNames.push_back("Calib2_Ac2");
	pcksNames.push_back("CalibCal");
	pcksNames.push_back("RunHeader");
	pcksNames.push_back("RunTrailer");
	pcksNames.push_back("CalibHeader");
	pcksNames.push_back("CalibTrailer");
	pcksNames.push_back("InitHeader");
	pcksNames.push_back("InitTrailer");
	pcksNames.push_back("EventTrk");
	pcksNames.push_back("Log");
	pcksNames.push_back("VarDump");
	pcksNames.push_back("ArrDump");
	pcksNames.push_back("TabDump");
	pcksNames.push_back("Tmtc");
	pcksNames.push_back("Mcmd");
	pcksNames.push_back("ForcedFECmd");
	pcksNames.push_back("Ac1Init");
	pcksNames.push_back("CalInit");
	pcksNames.push_back("TrkInit");
	pcksNames.push_back("TofInit");
	pcksNames.push_back("TrgInit");
	pcksNames.push_back("NdInit");
	pcksNames.push_back("S4Init");
	pcksNames.push_back("Ac2Init");
	pcksNames.push_back("CalAlarm");
	pcksNames.push_back("Ac1Alarm");
	pcksNames.push_back("TrkAlarm");
	pcksNames.push_back("TrgAlarm");
	pcksNames.push_back("TofAlarm");
	pcksNames.push_back("S4Alarm");
	pcksNames.push_back("Ac2Alarm");	    	
	pcksNames.push_back("TsbT");
	pcksNames.push_back("TsbB");
    };
    //
    // Functions
    //
    void HandleRun();
    void HandleRunFragments(Bool_t mishead, Bool_t mistrail, UInt_t firstev, UInt_t lastev);
    void HandleMissingHoT(Bool_t mishead, Bool_t mistrail, UInt_t firstev, UInt_t lastev);
    void HandleSuspiciousRun();
    void FillClass();
    void FillClass(Bool_t mishead, Bool_t mistrail, UInt_t firstev, UInt_t lastev);
    void HandleTRK_CALIB(Bool_t pk1, Bool_t pk2);
    //
    Bool_t IsDebug(){return(debug);};
    Bool_t IsRunAlreadyInserted();
    Bool_t IsRunConsistent(Bool_t mishead, Bool_t mistrail, UInt_t &firstev, UInt_t &lastev);
    //
    UInt_t PKT(UInt_t pkt_num);
    //
    ULong64_t OBT(UInt_t obt);
    //
    TArrayD S4_paramfit(pamela::CalibS4Event *S4CalibEvent);
    //

 public: 
    //
    PamelaDBOperations(TString host, TString user, TString password, TString filerawname, TString filerootname, UInt_t boot, UInt_t tsync, UInt_t obt0, Bool_t debug); // constructor
    //
    void Close(); // destructor
    //
    //
    // Setters
    //
    void SetConnection(TString host, TString user, TString password);
    void SetBOOTnumber(UInt_t boot);
    void SetRawName(TString str);
    void SetRootName(TString str);
    void SetDebugFlag(Bool_t debug);
    void SetID_RAW(UInt_t idr);
    void SetID_ROOT(UInt_t idr);
    void SetTsync(UInt_t ts);
    void SetObt0(UInt_t ts); 
    void SetCommonGLRUN(UInt_t absth, UInt_t abstt);
    void SetNOBOOT(Bool_t noboot);
    //
    Bool_t SetID_RAW();
    //
    Int_t SetUpperLimits();
    //
    // Getters
    //
    Bool_t GetNOBOOT(){return(NOBOOT);};
    //
    UInt_t GetID_RAW(){return(id);};     
    UInt_t GetID_ROOT(){return(idroot);};
    UInt_t GetBOOTnumber(){return(BOOTNO);};
    //
    UInt_t GetAbsTime(UInt_t obt);
    UInt_t GetTsync(){return(tsync);};
    //
    const PacketType* GetPacketType(const char* type);
    //
    TString GetRawFile(){return((TString)gSystem->BaseName(filerawname.Data()));};
    TString GetRawPath(){return((TString)gSystem->DirName(filerawname.Data())+'/');};
    TString GetRootFile(){return((TString)gSystem->BaseName(filerootname.Data()));};
    TString GetRootPath(){return((TString)gSystem->DirName(filerootname.Data())+'/');};
    TString GetRootName(){return(filerootname);};
    TString GetRawName(){return(filerawname);};
    //
    // Functions
    //
    Int_t assignBOOT_NUMBER();
    Int_t insertPamelaRootFile();
    Int_t insertPamelaRawFile();
    Int_t insertPamelaGL_TIMESYNC(); 
    Int_t insertPamelaRUN(); 
    Int_t insertCALO_CALIB(); 
    Int_t insertTRK_CALIB(); 
    Int_t insertS4_CALIB(); 
    //
    void OpenFile();
    void CheckFile();
    //
};
#endif /* PAMELA_DB_OPERATIONS_H */
