DROP DATABASE IF EXISTS dbname;

CREATE DATABASE dbname;

USE dbname;

SET time_zone='+0:00';

CREATE TABLE `_RUNID_GEN` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  PRIMARY KEY  (`ID`)
) ENGINE=InnoDB;

CREATE TABLE `GL_RAW` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `PATH` varchar(255) NOT NULL default '',
  `NAME` varchar(255) NOT NULL default '',
  `BOOT_NUMBER` smallint(5) unsigned default NULL,
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID`),
  KEY `BOOTNUMBER_index` (`BOOT_NUMBER`),
  KEY `PATH_index` (`PATH`)
) ENGINE=InnoDB;

INSERT INTO GL_RAW VALUES(0,'$PAM_L2','level2 files',NULL,NULL);

CREATE TABLE `GL_ROOT` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_RAW` int(10) unsigned NOT NULL default '0',
  `ID_TIMESYNC` int(10) unsigned NOT NULL default '0',
  `PATH` varchar(255) NOT NULL default '',
  `NAME` varchar(255) NOT NULL default '',
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID`),
  KEY `ID_RAW_index` (`ID_RAW`),
  KEY `PATH_index` (`PATH`),
  CONSTRAINT `ROOT_fk` FOREIGN KEY (`ID_RAW`) REFERENCES `GL_RAW` (`ID`) ON DELETE CASCADE
) ENGINE=InnoDB;

CREATE TABLE `GL_RESURS_OFFSET` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `FROM_ORBIT` int(10) unsigned NOT NULL default '0',
  `SPECIAL_FILE` varchar(255) NOT NULL default '',
  `OFFSET_DATE` timestamp default '0000-00-00 00:00:00',
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID`)
) ENGINE=InnoDB;

INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','','2006-06-14 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'1619','','2006-09-28 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'2797','','2006-12-12 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'3221','','2007-01-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','04584_002_001_cln1.pam','2007-01-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','04584_003_001_cln1.pam','2007-01-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','04586_002_001_cln1.pam','2007-01-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','04586_003_001_cln1.pam','2007-01-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'4576','','2007-04-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'5960','','2007-07-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','07408_003_001_cln1.pam','2007-07-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'7382','','2007-10-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'8580','','2007-12-25 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','08591_002_001_cln1.pam','2007-10-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','08591_003_001_cln1.pam','2007-10-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','08592_004_001_cln1.pam','2007-10-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','08592_004_003_cln1.pam','2007-10-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'9908','','2008-03-20 21:00:00',NULL);


CREATE TABLE `GL_TIMESYNC` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_RAW` int(10) unsigned NOT NULL default '0',
  `ID_RESURS_OFFSET` int(10) unsigned NOT NULL default '0',
  `OBT0` int(10) unsigned NOT NULL default '0',
  `TIMESYNC` int(10) unsigned NOT NULL default '0',
  `TYPE` smallint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  KEY `ID_RAW_index` (`ID_RAW`),
  KEY `TYPE_index` (`TYPE`),
  CONSTRAINT `TIME_RAW_fk` FOREIGN KEY (`ID_RAW`) REFERENCES `GL_RAW` (`ID`) ON DELETE CASCADE
) ENGINE=InnoDB;

CREATE TABLE `GL_PARAM` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `PATH` varchar(255) NOT NULL default '',
  `NAME` varchar(255) NOT NULL default '',
  `FROM_TIME` int(10) unsigned NOT NULL default '0',
  `TO_TIME` int(10) unsigned NOT NULL default '0',
  `TYPE` smallint(5) unsigned NOT NULL default '0',
  `DESCR` varchar(255) NOT NULL default '',
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID`),
  KEY `PATH_index` (`PATH`),
  KEY `NAME_index` (`NAME`),
  KEY `TYPE_index` (`TYPE`),
  KEY `DESCR_index` (`DESCR`)
) ENGINE=InnoDB;

insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","field_param-0/",0,0,1,"field",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mip_param-0/",0,0,2,"trk mip",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","charge_param-1/",0,0,3,"trk charge",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","eta_param-2/",0,0,4,"trk pfa",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","align_param-FinalQ/",0,0,5,"trk alignment",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id0/",1,1152684877,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id1/",1152684877,1153111322,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id2/",1153111322,1153324544,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id3/",1153324544,1154177434,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id4/",1154177434,1154390000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id5/",1154390000,1154922496,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id6/",1154922496,1155720256,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id7/",1155720256,1155986176,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id8/",1155986176,1157090000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id9/",1157090000,1157338867,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id10/",1157338867,1158595763,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id11/",1158595763,1158847142,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id12/",1158847142,1159349901,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id13/",1159349901,1160439027,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id14/",1160439027,1163570000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id15/",1163570000,1164654694,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id16/",1164654694,1164790515,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id17/",1164790515,1164932864,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id18/",1164932864,1165200550,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id19/",1165200550,1165735923,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id20/",1165735923,1166003610,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id21/",1166003610,1166271296,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id22/",1166271296,1166806669,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id23/",1166806669,1167074355,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id24/",1167074355,1167342042,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id25/",1167342042,1167610000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id26/",1167610000,1168413402,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id27/",1168413402,1168681293,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id28/",1168681293,1168949184,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id29/",1168949184,1169217075,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id30/",1169217075,1169484966,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id31/",1169484966,1170020749,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id32/",1170020749,1170290000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id33/",1170290000,1170530522,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id34/",1170530522,1170772403,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id35/",1170772403,1171014285,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id36/",1171014285,1171498048,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id37/",1171498048,1171739930,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id38/",1171739930,1172223693,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id39/",1172223693,1172465574,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id40/",1172465574,1172710000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id41/",1172710000,1172975398,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id42/",1172975398,1173243213,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id43/",1173243213,1173511027,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id44/",1173511027,1173778842,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id45/",1173778842,1174046656,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id46/",1174046656,1174314470,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id47/",1174314470,1174850099,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id48/",1174850099,1175117914,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id49/",1175117914,1175390000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id50/",1175390000,1175904256,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id51/",1175904256,1176163456,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id52/",1176163456,1176681856,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id53/",1176681856,1176941056,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id54/",1176941056,1177200256,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id55/",1177200256,1177718656,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id54/",1177718656,1177980000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id56/",1177980000,1178245069,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id57/",1178245069,1178512154,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id58/",1178512154,1178779238,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id59/",1178779238,1179313408,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id60/",1179313408,1179580493,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id61/",1179580493,1179847578,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id62/",1179847578,1180114662,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id63/",1180114662,1180381747,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id64/",1180381747,1180670000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id65/",1180670000,1180925389,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id66/",1180925389,1181183514,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id65/",1181183514,1181957888,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id67/",1181957888,1182732262,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id68/",1182732262,1182990387,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id69/",1182990387,1183250000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id70/",1183250000,1183516314,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id71/",1183516314,1183784115,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id72/",1183784115,1184051917,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id73/",1184051917,1184319718,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id72/",1184319718,1184587520,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id74/",1184587520,1184855322,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id71/",1184855322,1185123123,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id71/",1185123123,1185390925,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id75/",1185390925,1185658726,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id76/",1185658726,1185930000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id77/",1185930000,1186178522,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id78/",1186178522,1186430515,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id79/",1186430515,1187186496,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id80/",1187186496,1187438490,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id81/",1187438490,1187690483,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id82/",1187690483,1187942477,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id83/",1187942477,1188194470,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id84/",1188194470,4294967295,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","default_calib/",0,0,7,"default calibration",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloADC2MIP-dws2000.dat",1,1,101,"Calorimeter ADC to MIP from flight data dw serie 2000",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloADC2MIP.dat",1,1,101,"Calorimeter ADC to MIP from ground data",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloADC2MIPfc.dat",2,4294967295,101,"Calorimeter ADC to MIP from flight, relativistic particles",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloAlign.dat",1,1,102,"Calorimeter alignement",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloAlign-flight.dat",1,1,102,"Calorimeter alignement with flight data",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloAlign-flightEMS.dat",1,1,102,"Calorimeter alignement with flight data EM showers",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloAlign-flightINCp.dat",2,4294967295,102,"Calorimeter alignement with flight data, protons, Z alignment changed",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloBadMask.dat",0,0,103,"Calorimeter bad strip offline mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloDefaultCalib.root",0,0,104,"Calorimeter default calibration",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloBadPulsePre0.dat",1,1169000000,105," <0701 Calorimeter bad pre-amplifiers when pulsing offline mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloBadPulsePre1.dat",1169000001,4294967295,105," >0701 Calorimeter bad pre-amplifiers when pulsing offline mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_1.rz",1,1153660000,201," 0 - 07-23      -                       A       A       standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_2.rz",1153660001,1154375000,201," 07-23 - 07-31   HV_D problems           B       B       july            Parameters_jul24-31.txt",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_3.rz",1154375001,1155850000,201," 07-31 - 08-17   -                       C       C       standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_4.rz",1155850001,1156280000,201," 08-17 - 08-22   HV_H&HV_N problems      D       D       august          Parameters_aug18-22.txt",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_5.rz",1156280001,1165400000,201," 08-22 - 12-06                           E       E       standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_6.rz",1165400001,1168490000,201," 12-06 - 01-11   December Tracker off/on F       F       standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_7.rz",1168490001,1168940000,201," 01-11 - 01-16   HV_D problems           G       G       january         calper02.txt",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_8.rz",1168940001,1169580000,201," 01-16 - 01-23   HV_F & HV_M problems    G       G       january         calper03.txt",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_9.rz",1169580001,1170200000,201," 01-23 - 01-30                           H       H       .               calper04.txt",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_10.rz",1170200001,1171000000,201," 01-30 - 02-09   30.1. Threshold changed I       I       standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_11.rz",1171000001,1174665000,201," 02-09 - 03-23   09.2. Threshold changed J       J       standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_12.rz",1174665001,1175000000,201," 03-23 - 03-27   HV_B problems           K       K       .               calper05.txt",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_13.rz",1175000001,1176120000,201," 03-27 - 04-09                           L       L       standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_14.rz",1176120001,1176800000,201," 04-09 - 04-17   HV_H problems           M       M       .               calper06.txt",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_15.rz",1176800001,1178330000,201," 04-17 - 05-05   HV_E problems           N       N       .               calper08.txt",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_16.rz",1178330001,1181322000,201," 05-05 - 06-08   HV_H problems           O       O       .               calper09.txt",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_17.rz",1181322001,1182100000,201," 06-08 - 06-17                           P       P       standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_18.rz",1182100001,1183030000,201," 06-17 - 06-28   HV_A problems (~2 days) Q       Q       ?",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_19.rz",1183030001,1184000000,201," 06-28 - 07-09                           R       R       standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_20.rz",1184000001,1184570000,201," 07-09 - 07-16   HV_H problems           S       S       .               calper10.txt",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_21.rz",1184570001,1185090000,201," 07-16 - 07-22                           T       T       standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_22.rz",1185090001,1185212000,201," 07-22 - 07-23   HV_D problems           U       U       .               calper11.txt",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_23.rz",1185212001,4294967295,201," > 07-23                                 V       V       standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","TofCalibParam.txt",1,4294967295,202," GP ToF parameters ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/orb-param/","igrf05.dat",0,0,301,"igrf 2005",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/orb-param/","igrf05s.dat",0,0,302,"igrf 2010",NULL);

CREATE TABLE `GL_TLE` (
  `ID` int(10) NOT NULL auto_increment,
  `TLE1` varchar(255) NOT NULL default '',
  `TLE2` varchar(255) NOT NULL default '',
  `TLE3` varchar(255) NOT NULL default '',
  `FROM_TIME` datetime NOT NULL default '0000-00-00 00:00:00',
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID`)
) ENGINE=InnoDB;

CREATE TABLE `GL_RUN` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_RUN_FRAG` int(10) unsigned NOT NULL default '0',
  `ID_ROOT_L0` int(10) unsigned NOT NULL default '0',
  `ID_ROOT_L2` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_TIME` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_TIME` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_OBT` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_OBT` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_PKT` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_PKT` int(10) unsigned NOT NULL default '0',
  `BOOT_NUMBER` smallint(5) unsigned NOT NULL default '0',
  `EV_FROM` int(10) unsigned NOT NULL default '0',
  `EV_TO` int(10) unsigned NOT NULL default '0',
  `NEVENTS` int(10) unsigned NOT NULL default '0',
  `PKT_COUNTER` int(10) unsigned NOT NULL default '0',
  `PKT_READY_COUNTER` int(10) unsigned NOT NULL default '0',
  `COMPILATIONTIMESTAMP` int(10) unsigned NOT NULL default '0',
  `FAV_WRK_SCHEDULE` tinyint(3) unsigned NOT NULL default '0',
  `EFF_WRK_SCHEDULE` tinyint(3) unsigned NOT NULL default '0',
  `PRH_VAR_TRG_MODE_A` int(10) unsigned NOT NULL default '0',
  `PRH_VAR_TRG_MODE_B` int(10) unsigned NOT NULL default '0',
  `ACQ_BUILD_INFO` int(10) unsigned NOT NULL default '0',
  `ACQ_VAR_INFO` smallint(5) unsigned NOT NULL default '0',
  `RM_ACQ_AFTER_CALIB` tinyint(3) NOT NULL default '0',	  
  `RM_ACQ_SETTING_MODE` tinyint(3) NOT NULL default '0',
  `TRK_CALIB_USED` int(10) unsigned NOT NULL default '0',
  `CAL_DSP_MASK` tinyint(3) unsigned NOT NULL default '0',
  `LAST_TIMESYNC` int(10) unsigned NOT NULL default '0',
  `OBT_TIMESYNC` int(10) unsigned NOT NULL default '0',
  `VALIDATION` tinyint(3) unsigned NOT NULL default '0',
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID`),
  KEY `ID_RUN_FRAG_index` (`ID_RUN_FRAG`),
  KEY `ID_ROOT_L0_index` (`ID_ROOT_L0`),
  KEY `ID_ROOT_L2_index` (`ID_ROOT_L2`),
  KEY `COMPILATIONTS_index` (`COMPILATIONTIMESTAMP`),
  KEY `VALID_index` (`VALIDATION`),
  KEY `TRKCALIB_index` (`TRK_CALIB_USED`),
  KEY `CALDSPMASK_index` (`CAL_DSP_MASK`),
  KEY `EFF_WS_index` (`EFF_WRK_SCHEDULE`),
  KEY `FAV_WS_index` (`FAV_WRK_SCHEDULE`),
  KEY `RM_ACQ_AFTER_CALIB_index` (`RM_ACQ_AFTER_CALIB`),
  KEY `RM_ACQ_SETTING_MODE_index` (`RM_ACQ_SETTING_MODE`),
  KEY `ACQ_VAR_INFO_index` (`ACQ_VAR_INFO`),
  KEY `TRG_MODE_A_index` (`PRH_VAR_TRG_MODE_A`),
  KEY `TRG_MODE_B_index` (`PRH_VAR_TRG_MODE_B`),
  KEY `NEVENTS_index` (`NEVENTS`),
  KEY `BOOTNUMBER_index` (`BOOT_NUMBER`),
  KEY `ID_RUN_fk_constraint` (`ID_ROOT_L0`),
  KEY `ID_RUN_L2_fk_constraint` (`ID_ROOT_L2`)
) ENGINE=InnoDB;

CREATE TABLE `GL_RUN_FRAGMENTS` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_RUN_FRAG` int(10) unsigned NOT NULL default '0',
  `ID_ROOT_L0` int(10) unsigned NOT NULL default '0',
  `ID_ROOT_L2` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_TIME` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_TIME` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_OBT` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_OBT` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_PKT` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_PKT` int(10) unsigned NOT NULL default '0',
  `BOOT_NUMBER` smallint(5) unsigned NOT NULL default '0',
  `EV_FROM` int(10) unsigned NOT NULL default '0',
  `EV_TO` int(10) unsigned NOT NULL default '0',
  `NEVENTS` int(10) unsigned NOT NULL default '0',
  `PKT_COUNTER` int(10) unsigned NOT NULL default '0',
  `PKT_READY_COUNTER` int(10) unsigned NOT NULL default '0',
  `COMPILATIONTIMESTAMP` int(10) unsigned NOT NULL default '0',
  `FAV_WRK_SCHEDULE` tinyint(3) unsigned NOT NULL default '0',
  `EFF_WRK_SCHEDULE` tinyint(3) unsigned NOT NULL default '0',
  `PRH_VAR_TRG_MODE_A` int(10) unsigned NOT NULL default '0',
  `PRH_VAR_TRG_MODE_B` int(10) unsigned NOT NULL default '0',
  `ACQ_BUILD_INFO` int(10) unsigned NOT NULL default '0',
  `ACQ_VAR_INFO` smallint(5) unsigned NOT NULL default '0',
  `RM_ACQ_AFTER_CALIB` tinyint(3) NOT NULL default '0',	  
  `RM_ACQ_SETTING_MODE` tinyint(3) NOT NULL default '0',
  `TRK_CALIB_USED` int(10) unsigned NOT NULL default '0',
  `CAL_DSP_MASK` tinyint(3) unsigned NOT NULL default '0',
  `LAST_TIMESYNC` int(10) unsigned NOT NULL default '0',
  `OBT_TIMESYNC` int(10) unsigned NOT NULL default '0',
  `VALIDATION` tinyint(3) unsigned NOT NULL default '0',
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID`),
  KEY `ID_RUN_FRAG_index` (`ID_RUN_FRAG`),
  KEY `ID_ROOT_L0_index` (`ID_ROOT_L0`),
  KEY `BOOTNUMBER_index` (`BOOT_NUMBER`),
  KEY `TRKCALIB_index` (`TRK_CALIB_USED`),
  KEY `NID_RUN_fk_constraint` (`ID_ROOT_L0`)
) ENGINE=InnoDB;

CREATE TABLE `GL_RUN_TRASH` (
  `ID_TRASH` int(10) unsigned NOT NULL auto_increment,
  `ID` int(10) unsigned NOT NULL default '0',
  `ID_RUN_FRAG` int(10) unsigned NOT NULL default '0',
  `ID_ROOT_L0` int(10) unsigned NOT NULL default '0',
  `ID_ROOT_L2` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_TIME` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_TIME` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_OBT` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_OBT` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_PKT` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_PKT` int(10) unsigned NOT NULL default '0',
  `BOOT_NUMBER` smallint(5) unsigned NOT NULL default '0',
  `EV_FROM` int(10) unsigned NOT NULL default '0',
  `EV_TO` int(10) unsigned NOT NULL default '0',
  `NEVENTS` int(10) unsigned NOT NULL default '0',
  `PKT_COUNTER` int(10) unsigned NOT NULL default '0',
  `PKT_READY_COUNTER` int(10) unsigned NOT NULL default '0',
  `COMPILATIONTIMESTAMP` int(10) unsigned NOT NULL default '0',
  `FAV_WRK_SCHEDULE` tinyint(3) unsigned NOT NULL default '0',
  `EFF_WRK_SCHEDULE` tinyint(3) unsigned NOT NULL default '0',
  `PRH_VAR_TRG_MODE_A` int(10) unsigned NOT NULL default '0',
  `PRH_VAR_TRG_MODE_B` int(10) unsigned NOT NULL default '0',
  `ACQ_BUILD_INFO` int(10) unsigned NOT NULL default '0',
  `ACQ_VAR_INFO` smallint(5) unsigned NOT NULL default '0',
  `RM_ACQ_AFTER_CALIB` tinyint(3) NOT NULL default '0',	  
  `RM_ACQ_SETTING_MODE` tinyint(3) NOT NULL default '0',
  `TRK_CALIB_USED` int(10) unsigned NOT NULL default '0',
  `CAL_DSP_MASK` tinyint(3) unsigned NOT NULL default '0',
  `LAST_TIMESYNC` int(10) unsigned NOT NULL default '0',
  `OBT_TIMESYNC` int(10) unsigned NOT NULL default '0',
  `VALIDATION` tinyint(3) unsigned NOT NULL default '0',
  `FILENAMEL0` varchar(255) NOT NULL default '',
  `FILENAMEL2` varchar(255) NOT NULL default '',
  `BELONGED_TO` varchar(255) NOT NULL default '',
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID_TRASH`),
  KEY `TID_RUN_FRAG_index` (`ID_RUN_FRAG`),
  KEY `TID_ROOT_L0_index` (`ID_ROOT_L0`),
  KEY `TBOOTNUMBER_index` (`BOOT_NUMBER`),
  KEY `TTRKCALIB_index` (`TRK_CALIB_USED`),
  KEY `TFNAME0_index` (`FILENAMEL0`),
  KEY `TFNAME2_index` (`FILENAMEL2`),
  KEY `TBELONG_index` (`BELONGED_TO`)
) ENGINE=InnoDB;

CREATE TABLE `GL_CALO_CALIB` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_ROOT_L0` int(10) unsigned NOT NULL default '0',
  `EV_ROOT` int(10) unsigned NOT NULL default '0',
  `FROM_TIME` int(10) unsigned NOT NULL default '0',
  `TO_TIME` int(10) unsigned NOT NULL default '0',
  `SECTION` tinyint(3) unsigned NOT NULL default '0',
  `OBT` int(10) unsigned NOT NULL default '0',
  `PKT` int(10) unsigned NOT NULL default '0',
  `BOOT_NUMBER` smallint(5) unsigned NOT NULL default '0',
  `VALIDATION` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  KEY `SECTION_index` (`SECTION`),
  KEY `EV_ROOT_index` (`EV_ROOT`),
  KEY `ID_ROOT_index` (`ID_ROOT_L0`),
  KEY `BOOTNUMBER_index` (`BOOT_NUMBER`),
  KEY `VALID1_index` (`VALIDATION`)
) ENGINE=InnoDB;

CREATE TABLE `GL_CALOPULSE_CALIB` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_ROOT_L0` int(10) unsigned NOT NULL default '0',
  `EV_ROOT` int(10) unsigned NOT NULL default '0',
  `FROM_TIME` int(10) unsigned NOT NULL default '0',
  `TO_TIME` int(10) unsigned NOT NULL default '0',
  `SECTION` tinyint(3) unsigned NOT NULL default '0',
  `PULSED_STRIP` tinyint(3) unsigned default NULL,
  `PULSE_AMPLITUDE` tinyint(3) unsigned default NULL,
  `OBT` int(10) unsigned NOT NULL default '0',
  `PKT` int(10) unsigned NOT NULL default '0',
  `BOOT_NUMBER` smallint(5) unsigned NOT NULL default '0',
  `VALIDATION` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  KEY `PSECTION_index` (`SECTION`),
  KEY `PULSEDSTRIP_index` (`PULSED_STRIP`),
  KEY `PULSEAMPL_index` (`PULSE_AMPLITUDE`),
  KEY `PEV_ROOT_index` (`EV_ROOT`),
  KEY `PID_ROOT_index` (`ID_ROOT_L0`),
  KEY `PBOOTNUMBER_index` (`BOOT_NUMBER`),
  KEY `PVALID1_index` (`VALIDATION`)
) ENGINE=InnoDB;


CREATE TABLE `GL_TRK_CALIB` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_ROOT_L0` int(10) unsigned NOT NULL default '0',
  `EV_ROOT_CALIBTRK1` int(10) unsigned default NULL,
  `EV_ROOT_CALIBTRK2` int(10) unsigned default NULL,
  `FROM_TIME` int(10) unsigned NOT NULL default '0',
  `TO_TIME` int(10) unsigned NOT NULL default '0',
  `OBT1` int(10) unsigned NOT NULL default '0',
  `PKT1` int(10) unsigned NOT NULL default '0',
  `OBT2` int(10) unsigned NOT NULL default '0',
  `PKT2` int(10) unsigned NOT NULL default '0',
  `BOOT_NUMBER` smallint(5) unsigned NOT NULL default '0',
  `VALIDATION` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  KEY `ID_ROOT_index` (`ID_ROOT_L0`),
  KEY `EV_ROOT_CALIBTRK1index` (`EV_ROOT_CALIBTRK1`),
  KEY `EV_ROOT_CALIBTRK2index` (`EV_ROOT_CALIBTRK2`),
  KEY `BOOTNUMBER_index` (`BOOT_NUMBER`),
  KEY `VALID2_index` (`VALIDATION`)
) ENGINE=InnoDB;

CREATE TABLE `GL_S4_CALIB` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_ROOT_L0` int(10) unsigned NOT NULL default '0',
  `EV_ROOT` int(10) unsigned NOT NULL default '0',
  `FROM_TIME` int(10) unsigned NOT NULL default '0',
  `TO_TIME` int(10) unsigned NOT NULL default '0',
  `OBT` int(10) unsigned NOT NULL default '0',
  `PKT` int(10) unsigned NOT NULL default '0',  
  `BOOT_NUMBER` smallint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  KEY `ID_ROOT_index` (`ID_ROOT_L0`),
  KEY `BOOTNUMBER_index` (`BOOT_NUMBER`)
) ENGINE=InnoDB;


