#!/bin/bash --norc 
THISDIR=`pwd`
USERNAME=${PAM_DBUSER}
HOST=""
DBNAME=""
FORCE="no"
COUNT=0;for word in `echo ${PAM_DBHOST} | tr [\/] [" "] |sed 's/mysql://g' `; do if [ $COUNT -eq 0 ]; then HOST=`echo $word`; fi; if [ $COUNT -eq 1 ]; then DBNAME=`echo $word`; fi; let COUNT=$COUNT+1; done
PASSWORD=${PAM_DBPSW}
if [ $# -gt 0 ]; then
    for INPUT in $*; do 
	if [ $INPUT == "--help" ] || [ $INPUT == "-h" ]; then
	    echo ""
	    echo " Usage: ./install_DB.sh [options] "
	    echo ""
	    echo " Options: "
	    echo ""
	    echo " --user=username : MySQL username. "
	    echo ""
	    echo " --host=mysql://localhost/pamelaprod : MySQL host and DB name."
	    echo ""
	    echo " --psw=password :  MySQL password"
	    echo ""
	    echo " --force :  do not wait [default: wait]"
	    echo ""
	    exit 0
	fi
	TEST=`echo $INPUT | sed 's/--user=//g'`
	if [ $TEST != $INPUT  ]; then
	    USERNAME=`echo $TEST`
	    export USERNAME;
	fi
	TEST=`echo $INPUT | sed 's/--host=//g'`
	if [ $TEST != $INPUT  ]; then
	    COUNT=0;for word in `echo $TEST | tr [\/] [" "] |sed 's/mysql://g' `; do if [ $COUNT -eq 0 ]; then HOST=`echo $word`; fi; if [ $COUNT -eq 1 ]; then DBNAME=`echo $word`; fi; let COUNT=$COUNT+1; done
	    export DBNAME;
	    export HOST;
	fi
	TEST=`echo $INPUT | sed 's/--psw=//g'`
	if [ $TEST != $INPUT  ]; then
	    PASSWORD=`echo $TEST`
	    export PASSWORD;
	fi
	if [ "$INPUT" == "--force" ]; then
	    FORCE="yes";
	    export FORCE;
	fi
    done
else
    if [ "$USERNAME" == "" ] || [ "$HOST" == "" ] || [ "$DBNAME" == "" ]; then
	echo ""
	echo " Usage: ./install_GL_PARAM.sh [options] "
	echo ""
	echo " Options: "
	echo ""
	echo " --user=username : MySQL username. "
	echo ""
	echo " --host=mysql://localhost/pamelaprod : MySQL host and DB name."
	echo ""
	echo " --psw=password :  MySQL password"
	echo ""    
	exit 0
    fi
fi;
echo ""
echo " Installing DB $DBNAME on $HOST with user $USERNAME and password $PASSWORD  "
echo ""
if [ "$FORCE" == "no" ]; then
    echo " WARNING: if already existing the DB will be RECREATED and you will LOSE all data! "
    echo ""
    echo "    =======>   You have 30 seconds to stop me using CTRL+c  <=======    "
    echo ""
    sleep 30;
fi;
#
rm -rf ${THISDIR}/temp.sql
#
cat ${THISDIR}/PAMELAProductionDB.sql | sed 's/dbname/'${DBNAME}'/g' >> ${THISDIR}/temp.sql
mysql --user=$USERNAME --password=$PASSWORD --host=$HOST < ${THISDIR}/temp.sql 
echo " done! "
echo ""
rm -rf ${THISDIR}/temp.sql
