DROP DATABASE IF EXISTS dbname;

CREATE DATABASE dbname;

USE dbname;

SET time_zone='+0:00';

CREATE TABLE `_RUNID_GEN` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  PRIMARY KEY  (`ID`)
) ENGINE=InnoDB;

CREATE TABLE `GL_RAW` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `PATH` varchar(255) NOT NULL default '',
  `NAME` varchar(255) NOT NULL default '',
  `BOOT_NUMBER` smallint(5) unsigned default NULL,
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID`),
  KEY `BOOTNUMBER_index` (`BOOT_NUMBER`),
  KEY `PATH_index` (`PATH`)
) ENGINE=InnoDB;

INSERT INTO GL_RAW VALUES(0,'path to','level2 files',NULL,NULL);

CREATE TABLE `GL_ROOT` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_RAW` int(10) unsigned NOT NULL default '0',
  `ID_TIMESYNC` int(10) unsigned NOT NULL default '0',
  `PATH` varchar(255) NOT NULL default '',
  `NAME` varchar(255) NOT NULL default '',
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID`),
  KEY `ID_RAW_index` (`ID_RAW`),
  KEY `PATH_index` (`PATH`),
  CONSTRAINT `ROOT_fk` FOREIGN KEY (`ID_RAW`) REFERENCES `GL_RAW` (`ID`) ON DELETE CASCADE
) ENGINE=InnoDB;

CREATE TABLE `GL_RESURS_OFFSET` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `FROM_ORBIT` int(10) unsigned NOT NULL default '0',
  `SPECIAL_FILE` varchar(255) NOT NULL default '',
  `OFFSET_DATE` timestamp default '0000-00-00 00:00:00',
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID`)
) ENGINE=InnoDB;

INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','','2006-06-14 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'1619','','2006-09-28 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'2797','','2006-12-12 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'3221','','2007-01-08 21:00:00',NULL);

CREATE TABLE `GL_TIMESYNC` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_RAW` int(10) unsigned NOT NULL default '0',
  `OBT0` int(10) unsigned NOT NULL default '0',
  `TIMESYNC` int(10) unsigned NOT NULL default '0',
  `TYPE` smallint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  KEY `ID_RAW_index` (`ID_RAW`),
  KEY `TYPE_index` (`TYPE`),
  CONSTRAINT `TIME_RAW_fk` FOREIGN KEY (`ID_RAW`) REFERENCES `GL_RAW` (`ID`) ON DELETE CASCADE
) ENGINE=InnoDB;

CREATE TABLE `GL_PARAM` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `PATH` varchar(255) NOT NULL default '',
  `NAME` varchar(255) NOT NULL default '',
  `FROM_TIME` int(10) unsigned NOT NULL default '0',
  `TO_TIME` int(10) unsigned NOT NULL default '0',
  `TYPE` smallint(5) unsigned NOT NULL default '0',
  `DESCR` varchar(255) NOT NULL default '',
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID`),
  KEY `PATH_index` (`PATH`),
  KEY `NAME_index` (`NAME`),
  KEY `TYPE_index` (`TYPE`),
  KEY `DESCR_index` (`DESCR`)
) ENGINE=InnoDB;

CREATE TABLE `GL_TLE` (
  `ID` int(10) NOT NULL auto_increment,
  `TLE1` varchar(255) NOT NULL default '',
  `TLE2` varchar(255) NOT NULL default '',
  `TLE3` varchar(255) NOT NULL default '',
  `FROM_TIME` datetime NOT NULL default '0000-00-00 00:00:00',
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID`)
) ENGINE=InnoDB;

CREATE TABLE `GL_RUN` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_RUN_FRAG` int(10) unsigned NOT NULL default '0',
  `ID_ROOT_L0` int(10) unsigned NOT NULL default '0',
  `ID_ROOT_L2` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_TIME` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_TIME` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_OBT` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_OBT` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_PKT` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_PKT` int(10) unsigned NOT NULL default '0',
  `BOOT_NUMBER` smallint(5) unsigned NOT NULL default '0',
  `EV_FROM` int(10) unsigned NOT NULL default '0',
  `EV_TO` int(10) unsigned NOT NULL default '0',
  `NEVENTS` int(10) unsigned NOT NULL default '0',
  `PKT_COUNTER` int(10) unsigned NOT NULL default '0',
  `PKT_READY_COUNTER` int(10) unsigned NOT NULL default '0',
  `COMPILATIONTIMESTAMP` int(10) unsigned NOT NULL default '0',
  `FAV_WRK_SCHEDULE` tinyint(3) unsigned NOT NULL default '0',
  `EFF_WRK_SCHEDULE` tinyint(3) unsigned NOT NULL default '0',
  `PRH_VAR_TRG_MODE_A` int(10) unsigned NOT NULL default '0',
  `PRH_VAR_TRG_MODE_B` int(10) unsigned NOT NULL default '0',
  `ACQ_BUILD_INFO` int(10) unsigned NOT NULL default '0',
  `ACQ_VAR_INFO` smallint(5) unsigned NOT NULL default '0',
  `RM_ACQ_AFTER_CALIB` tinyint(3) NOT NULL default '0',	  
  `RM_ACQ_SETTING_MODE` tinyint(3) NOT NULL default '0',
  `TRK_CALIB_USED` int(10) unsigned NOT NULL default '0',
  `CAL_DSP_MASK` tinyint(3) unsigned NOT NULL default '0',
  `LAST_TIMESYNC` int(10) unsigned NOT NULL default '0',
  `OBT_TIMESYNC` int(10) unsigned NOT NULL default '0',
  `VALIDATION` tinyint(3) unsigned NOT NULL default '0',
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID`),
  KEY `ID_RUN_FRAG_index` (`ID_RUN_FRAG`),
  KEY `ID_ROOT_L0_index` (`ID_ROOT_L0`),
  KEY `ID_ROOT_L2_index` (`ID_ROOT_L2`),
  KEY `COMPILATIONTS_index` (`COMPILATIONTIMESTAMP`),
  KEY `VALID_index` (`VALIDATION`),
  KEY `TRKCALIB_index` (`TRK_CALIB_USED`),
  KEY `CALDSPMASK_index` (`CAL_DSP_MASK`),
  KEY `EFF_WS_index` (`EFF_WRK_SCHEDULE`),
  KEY `FAV_WS_index` (`FAV_WRK_SCHEDULE`),
  KEY `RM_ACQ_AFTER_CALIB_index` (`RM_ACQ_AFTER_CALIB`),
  KEY `RM_ACQ_SETTING_MODE_index` (`RM_ACQ_SETTING_MODE`),
  KEY `ACQ_VAR_INFO_index` (`ACQ_VAR_INFO`),
  KEY `TRG_MODE_A_index` (`PRH_VAR_TRG_MODE_A`),
  KEY `TRG_MODE_B_index` (`PRH_VAR_TRG_MODE_B`),
  KEY `NEVENTS_index` (`NEVENTS`),
  KEY `BOOTNUMBER_index` (`BOOT_NUMBER`),
  KEY `ID_RUN_fk_constraint` (`ID_ROOT_L0`),
  KEY `ID_RUN_L2_fk_constraint` (`ID_ROOT_L2`)
) ENGINE=InnoDB;

CREATE TABLE `GL_RUN_FRAGMENTS` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_RUN_FRAG` int(10) unsigned NOT NULL default '0',
  `ID_ROOT_L0` int(10) unsigned NOT NULL default '0',
  `ID_ROOT_L2` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_TIME` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_TIME` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_OBT` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_OBT` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_PKT` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_PKT` int(10) unsigned NOT NULL default '0',
  `BOOT_NUMBER` smallint(5) unsigned NOT NULL default '0',
  `EV_FROM` int(10) unsigned NOT NULL default '0',
  `EV_TO` int(10) unsigned NOT NULL default '0',
  `NEVENTS` int(10) unsigned NOT NULL default '0',
  `PKT_COUNTER` int(10) unsigned NOT NULL default '0',
  `PKT_READY_COUNTER` int(10) unsigned NOT NULL default '0',
  `COMPILATIONTIMESTAMP` int(10) unsigned NOT NULL default '0',
  `FAV_WRK_SCHEDULE` tinyint(3) unsigned NOT NULL default '0',
  `EFF_WRK_SCHEDULE` tinyint(3) unsigned NOT NULL default '0',
  `PRH_VAR_TRG_MODE_A` int(10) unsigned NOT NULL default '0',
  `PRH_VAR_TRG_MODE_B` int(10) unsigned NOT NULL default '0',
  `ACQ_BUILD_INFO` int(10) unsigned NOT NULL default '0',
  `ACQ_VAR_INFO` smallint(5) unsigned NOT NULL default '0',
  `RM_ACQ_AFTER_CALIB` tinyint(3) NOT NULL default '0',	  
  `RM_ACQ_SETTING_MODE` tinyint(3) NOT NULL default '0',
  `TRK_CALIB_USED` int(10) unsigned NOT NULL default '0',
  `CAL_DSP_MASK` tinyint(3) unsigned NOT NULL default '0',
  `LAST_TIMESYNC` int(10) unsigned NOT NULL default '0',
  `OBT_TIMESYNC` int(10) unsigned NOT NULL default '0',
  `VALIDATION` tinyint(3) unsigned NOT NULL default '0',
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID`),
  KEY `ID_RUN_FRAG_index` (`ID_RUN_FRAG`),
  KEY `ID_ROOT_L0_index` (`ID_ROOT_L0`),
  KEY `BOOTNUMBER_index` (`BOOT_NUMBER`),
  KEY `TRKCALIB_index` (`TRK_CALIB_USED`),
  KEY `NID_RUN_fk_constraint` (`ID_ROOT_L0`)
) ENGINE=InnoDB;

CREATE TABLE `GL_RUN_TRASH` (
  `ID_TRASH` int(10) unsigned NOT NULL auto_increment,
  `ID` int(10) unsigned NOT NULL default '0',
  `ID_RUN_FRAG` int(10) unsigned NOT NULL default '0',
  `ID_ROOT_L0` int(10) unsigned NOT NULL default '0',
  `ID_ROOT_L2` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_TIME` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_TIME` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_OBT` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_OBT` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_PKT` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_PKT` int(10) unsigned NOT NULL default '0',
  `BOOT_NUMBER` smallint(5) unsigned NOT NULL default '0',
  `EV_FROM` int(10) unsigned NOT NULL default '0',
  `EV_TO` int(10) unsigned NOT NULL default '0',
  `NEVENTS` int(10) unsigned NOT NULL default '0',
  `PKT_COUNTER` int(10) unsigned NOT NULL default '0',
  `PKT_READY_COUNTER` int(10) unsigned NOT NULL default '0',
  `COMPILATIONTIMESTAMP` int(10) unsigned NOT NULL default '0',
  `FAV_WRK_SCHEDULE` tinyint(3) unsigned NOT NULL default '0',
  `EFF_WRK_SCHEDULE` tinyint(3) unsigned NOT NULL default '0',
  `PRH_VAR_TRG_MODE_A` int(10) unsigned NOT NULL default '0',
  `PRH_VAR_TRG_MODE_B` int(10) unsigned NOT NULL default '0',
  `ACQ_BUILD_INFO` int(10) unsigned NOT NULL default '0',
  `ACQ_VAR_INFO` smallint(5) unsigned NOT NULL default '0',
  `RM_ACQ_AFTER_CALIB` tinyint(3) NOT NULL default '0',	  
  `RM_ACQ_SETTING_MODE` tinyint(3) NOT NULL default '0',
  `TRK_CALIB_USED` int(10) unsigned NOT NULL default '0',
  `CAL_DSP_MASK` tinyint(3) unsigned NOT NULL default '0',
  `LAST_TIMESYNC` int(10) unsigned NOT NULL default '0',
  `OBT_TIMESYNC` int(10) unsigned NOT NULL default '0',
  `VALIDATION` tinyint(3) unsigned NOT NULL default '0',
  `FILENAMEL0` varchar(255) NOT NULL default '',
  `FILENAMEL2` varchar(255) NOT NULL default '',
  `BELONGED_TO` varchar(255) NOT NULL default '',
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID_TRASH`),
  KEY `TID_RUN_FRAG_index` (`ID_RUN_FRAG`),
  KEY `TID_ROOT_L0_index` (`ID_ROOT_L0`),
  KEY `TBOOTNUMBER_index` (`BOOT_NUMBER`),
  KEY `TTRKCALIB_index` (`TRK_CALIB_USED`),
  KEY `TFNAME0_index` (`FILENAMEL0`),
  KEY `TFNAME2_index` (`FILENAMEL2`),
  KEY `TBELONG_index` (`BELONGED_TO`)
) ENGINE=InnoDB;

CREATE TABLE `GL_CALO_CALIB` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_ROOT_L0` int(10) unsigned NOT NULL default '0',
  `EV_ROOT` int(10) unsigned NOT NULL default '0',
  `FROM_TIME` int(10) unsigned NOT NULL default '0',
  `TO_TIME` int(10) unsigned NOT NULL default '0',
  `SECTION` tinyint(3) unsigned NOT NULL default '0',
  `OBT` int(10) unsigned NOT NULL default '0',
  `PKT` int(10) unsigned NOT NULL default '0',
  `BOOT_NUMBER` smallint(5) unsigned NOT NULL default '0',
  `VALIDATION` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  KEY `SECTION_index` (`SECTION`),
  KEY `EV_ROOT_index` (`EV_ROOT`),
  KEY `ID_ROOT_index` (`ID_ROOT_L0`),
  KEY `BOOTNUMBER_index` (`BOOT_NUMBER`),
  KEY `VALID1_index` (`VALIDATION`)
) ENGINE=InnoDB;

CREATE TABLE `GL_TRK_CALIB` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_ROOT_L0` int(10) unsigned NOT NULL default '0',
  `EV_ROOT_CALIBTRK1` int(10) unsigned default NULL,
  `EV_ROOT_CALIBTRK2` int(10) unsigned default NULL,
  `FROM_TIME` int(10) unsigned NOT NULL default '0',
  `TO_TIME` int(10) unsigned NOT NULL default '0',
  `OBT1` int(10) unsigned NOT NULL default '0',
  `PKT1` int(10) unsigned NOT NULL default '0',
  `OBT2` int(10) unsigned NOT NULL default '0',
  `PKT2` int(10) unsigned NOT NULL default '0',
  `BOOT_NUMBER` smallint(5) unsigned NOT NULL default '0',
  `VALIDATION` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  KEY `ID_ROOT_index` (`ID_ROOT_L0`),
  KEY `EV_ROOT_CALIBTRK1index` (`EV_ROOT_CALIBTRK1`),
  KEY `EV_ROOT_CALIBTRK2index` (`EV_ROOT_CALIBTRK2`),
  KEY `BOOTNUMBER_index` (`BOOT_NUMBER`),
  KEY `VALID2_index` (`VALIDATION`)
) ENGINE=InnoDB;

CREATE TABLE `GL_S4_CALIB` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_ROOT_L0` int(10) unsigned NOT NULL default '0',
  `EV_ROOT` int(10) unsigned NOT NULL default '0',
  `FROM_TIME` int(10) unsigned NOT NULL default '0',
  `TO_TIME` int(10) unsigned NOT NULL default '0',
  `OBT` int(10) unsigned NOT NULL default '0',
  `PKT` int(10) unsigned NOT NULL default '0',  
  `BOOT_NUMBER` smallint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  KEY `ID_ROOT_index` (`ID_ROOT_L0`),
  KEY `BOOTNUMBER_index` (`BOOT_NUMBER`)
) ENGINE=InnoDB;


