#ifndef TrAng_H
#define TrAng_H

#include <TObject.h>
#include "TMatrixD.h"
#include "TString.h"
#include <TMath.h>

class PamelaOrientation : public TObject {

private:

Double_t a;// = 360/(2*TMath::Pi());
Double_t Re;// = 6000000.0;

TMatrixD DirAxisGreenwich;
TMatrixD DirAxisGEO;
void SetDirAxisGreenwich(TMatrixD Aij){DirAxisGreenwich = Aij;}
void SetDirAxisGEO(TMatrixD Aij){DirAxisGEO = Aij;}
//Double_t a = 360/(2*TMath::Pi());
//Re = 6000000.0;

public:

PamelaOrientation();
~PamelaOrientation();

Double_t PitchAngle;

TMatrixD QuatoECI(Float_t q0, Float_t q1, Float_t q2, Float_t q3);
TMatrixD ECItoGreenwich(TMatrixD Aij, UInt_t t);
TMatrixD GreenwichtoGEO(Double_t lat, Double_t lon, TMatrixD Aij);
TMatrixD PamelatoGEO(TMatrixD Aij, Double_t B1, Double_t B2, Double_t B3);
TMatrixD ColPermutation(TMatrixD Aij);
Double_t GetPitchAngle(Double_t x1, Double_t y1, Double_t z1, Double_t x2, Double_t y2, Double_t z2);

Double_t GetPamMainGwX(){return DirAxisGreenwich(0,1);}
Double_t GetPamMainGwY(){return DirAxisGreenwich(1,1);}
Double_t GetPamMainGwZ(){return DirAxisGreenwich(2,1);}

Double_t GetPamMainGEOX(){return DirAxisGEO(0,1);}
Double_t GetPamMainGEOY(){return DirAxisGEO(1,1);}
Double_t GetPamMainGEOZ(){return DirAxisGEO(2,1);}

TMatrixD GetGw(){return DirAxisGreenwich;}
TMatrixD GetGEO(){return DirAxisGEO;}

};

#endif
