#include <TObject.h>
#include <string.h>
#include <option.h>
#include "TString.h"
#include <iostream>

using namespace std;

OptionParam::OptionParam() : TObject(){
    
    debug = false;			opt.Neve = 0;				opt.Nverb = -1;				opt.Nstart = 0;
    opt.DoTr = false;
    //opt.PX.PamExpOn = false;		opt.AH.AnglHystOn = false;		opt.PE.PamEffOn = false;		opt.DH.DiffHystOn = false;
    //opt.DH.Z = false;			opt.DH.Az = false;   

};

OptionParam::~OptionParam(){
}

void OptionParam::helprint(){
    cout<<"Help is Empty now"<<endl;
}

Double_t OptionParam::CheckDouble(char* Arg, char* Mess){
    if(strcmp(Arg,"0")){
        if(!atof(Arg)){
            cout<<"ERROR!: Incorect Number of "<<Mess<<" : "<<Mess<<" "<<Arg<<"\n";
	    exit(1);
	}else return atof(Arg);
    }else return 0;
}

Int_t OptionParam::CheckInt(char* Arg, char* Mess){
    if(strcmp(Arg,"0")){
        if(!atoi(Arg)){
            cout<<"ERROR!: Incorect Number of "<<Mess<<" : "<<Mess<<" "<<Arg<<"\n";
	    exit(1);
	}else return atoi(Arg);
    }else return 0;
}

/*Int_t FindSS(Double_t Rmin, Double_t Rmax, Int_t detrminf, Int_t detrmaxf, Double_t detrmore, Double_t detrless, Float_t betamin, Float_t betamax, Bool_t AC, Bool_t Calo){
    Int_t NS = 0;
    if(debug) cout<<"\tFind earlier SelectionScheme's\n";
    for(Int_t sen=0; sen<US.size();sen++){
	if(SS[sen].SP.Rmin == Rmin && SS[sen].SP.Rmax == Rmax && SS[sen].SP.detrminf == detrminf && SS[sen].SP.detrmaxf &&
	    SS[sen].SP.detrmore == detrmore && SS[sen].SP.detrless == detrless && SS[sen].SP.betamin == betamin &&
	    SS[sen].SP.betamax == betamax && SS[sen].SP.AC == AC && SS[sen].SP.Calo == Calo) NS = sen;
    }
    if(NS==0){
	if(debug) cout<<"\tNot found SS with such parameters\n";
	SS.resize(SS.size()+1);
        if(debug) cout<<"\t\tsize of SS was increased...\tNew size = "<<SS.size()<<"\n";
        NS = SS.size()-1;
    }
    return NS;
}*/

Int_t OptionParam::FindUS(Double_t altmore, Double_t altless, Double_t Bmore, Double_t Bless, Double_t Lmore, Double_t Lless, Double_t Rmore, Double_t Rless){
    Int_t NS = -1;
    if(debug) cout<<"\tFind earlier US's\n";
    for(Int_t sen=0; sen<US.size();sen++){
	Bool_t bay = false;
	for(Int_t zen=0; zen<US[sen].USP.size();zen++){
	    if(US[sen].USP[zen].altmore == altmore && US[sen].USP[zen].altless == altless && US[sen].USP[zen].Bmore == Bmore && US[sen].USP[zen].Bless == Bless && US[sen].USP[zen].Lmore == Lmore && US[sen].USP[zen].Lless == Lless  && US[sen].USP[zen].Rmore == Rmore && US[sen].USP[zen].Rless == Rless) bay = true;else bay = false;
	}
	if(bay) NS = sen;
    }
    if(NS==-1){
	if(debug) cout<<"\tNot found US with such boundaries\n";
	US.resize(US.size()+1);
        if(debug) cout<<"\t\tsize of US was increased...\tNew size = "<<US.size()<<"\n";
        NS = US.size()-1;
    }
    return NS;
}

void OptionParam::SetupGeo(Double_t altmore, Double_t altless, Double_t Bmore, Double_t Bless, Double_t Lmore, Double_t Lless, Double_t Rmore, Double_t Rless, Int_t N, Int_t k){
    if(debug) cout<<"\tSet Geo Selection boundaries:\n";
    if(k==0) tmpNUS = FindUS(altmore,altless,Bmore,Bless,Lmore,Lless,Rmore,Rless);
    if(tmpNUS==US.size()-1){
	if(debug)cout<<"\tFill USP["<<k<<"]...\n";
	if(US[tmpNUS].USP.size()!=N) US[tmpNUS].USP.resize(N);
	US[tmpNUS].USP[k].altmore = altmore;
        US[tmpNUS].USP[k].altless = altless;
	US[tmpNUS].USP[k].Bmore = Bmore;
        US[tmpNUS].USP[k].Bless = Bless;
	US[tmpNUS].USP[k].Lmore = Lmore;
        US[tmpNUS].USP[k].Lless = Lless;
        US[tmpNUS].USP[k].Rmore = Rmore;
        US[tmpNUS].USP[k].Rless = Rless;
        //US[tmpNUS].USP[k].Pmore = Pmore;
        //US[tmpNUS].USP[k].Pless = Pless;
    }
    if(debug) cout<<"\t\taltmore = "<<altmore<<"\taltless = "<<altless<<"\n\t\tBmore = "<<Bmore<<"\tBless = "<<Bless<<"\n\t\tLmore = "<<Lmore<<"\tLless = "<<Lless<<"\n\n";
}

void OptionParam::SimpleCheck(char* hystname,char* NBinsx, char* firstx, char* lastx, char* NBinsy, char* firsty, char* lasty, char* NBinsz, char* firstz, char* lastz, char* filename, char* format, char* extype, Int_t Dim){
    Int_t NBinsX = CheckInt(NBinsx,"NBinsx");
    if(debug) cout<<"\t\tNbinsx is correct... "<<NBinsX<<"\n";
    Int_t NBinsY = CheckInt(NBinsy,"NBinsy");
    if(debug) cout<<"\t\tNbinsy is correct... "<<NBinsY<<"\n";
    Int_t NBinsZ = CheckInt(NBinsz,"NBinsz");
    if(debug) cout<<"\t\tNbinsz is correct... "<<NBinsZ<<"\n";
    Double_t Firstx = CheckDouble(firstx,"firstx");
    if(debug) cout<<"\t\tfirstx is correct... "<<Firstx<<"\n";
    Double_t Lastx = CheckDouble(lastx,"lastx");
    if(debug) cout<<"\t\tlastx is correct... "<<Lastx<<"\n";
    if(Lastx<=Firstx){
        cout<<"ERROR!: Incorect hystogramm diapason: NBins "<<NBinsx<<"\tfirst x bin "<<firstx<<"\tlast x bin "<<lastx<<"\n";
        exit(1);
    }
    Double_t Firsty = CheckDouble(firsty,"firsty");
    if(debug) cout<<"\t\tfirsty is correct... "<<Firsty<<"\n";
    Double_t Lasty = CheckDouble(lasty,"lasty");
    if(debug) cout<<"\t\tlasty is correct... "<<Lasty<<"\n";
    if(NBinsY!=0 && Lasty<=Firsty){
        cout<<"ERROR!: Incorect hystogramm diapason: NBinsy "<<NBinsY<<"\tfirst Y bin "<<firsty<<"\tlast y bin "<<lasty<<"\n";
        exit(1);
    }
    Double_t Firstz = CheckDouble(firstz,"firstz");
    if(debug) cout<<"\t\tfirstz is correct... "<<Firstz<<"\n";
    Double_t Lastz = CheckDouble(lastz,"lastz");
    if(debug) cout<<"\t\tlastz is correct... "<<Lastz<<"\n";
    if(NBinsZ!=0 && Lastz<=Firstz){
        cout<<"ERROR!: Incorect hystogramm diapason: NBinsz "<<NBinsZ<<"\tfirst Z bin "<<firstz<<"\tlast z bin "<<lastz<<"\n";
        exit(1);
    }
    if(debug) cout<<"\t\tHystogramm diapason is correct... \n";
    Int_t TypeExt;
    if(!strcmp(format,"RootOnly")) TypeExt = 0; else
    if(!strcmp(format,"PictureOnly")) TypeExt = 1; else
    if(!strcmp(format,"All")) TypeExt = 2;else{
        cout<<"ERROR!: Incorrect format of output - "<<format<<"\n";
        exit(1);
    }
    if(debug) cout<<"\t\tformat is correct... \n";
    Int_t Extype = CheckInt(extype,"extype");
    if(Extype<0 || Extype>7){
	cout<<"ERROR!: Incorect Type of Exposure: Extype "<<Extype<<"\n";
	exit(1);
    }
    if(debug) cout<<"\t\textype is correct... Exposure = "<<Extype<<" \n";
    if (Dim==1){
	//Hyst1D.resize(Hyst1D.size()+1);
	//if(debug) cout<<"\tvector of Hyst1D was increased, New size is "<<Hyst1D.size()<<endl;
	if(debug)cout<<"\tFilling 1D hystogramm"<<endl;
	Hyst1D[Hyst1D.size()-1].Hyst1DF.SetName(hystname);
	if(debug)cout<<"\thystname = "<<hystname<<endl;
	Hyst1D[Hyst1D.size()-1].Hyst1DF.SetBins(NBinsX,Firstx,Lastx);
	Hyst1D[Hyst1D.size()-1].HI.NUS = tmpNUS;
	if(debug)cout<<"\tNUS = "<<tmpNUS<<endl;
	Hyst1D[Hyst1D.size()-1].HI.NED = ED.size()-1;
	if(debug)cout<<"\tNED = "<<ED.size()-1<<endl;
	Hyst1D[Hyst1D.size()-1].HI.NSS = tmpSS;
	if(debug)cout<<"\tNSS = "<<tmpSS<<endl;
	Hyst1D[Hyst1D.size()-1].HI.NPT = PS.size()-1;
	if(debug)cout<<"\tNPT = "<<PS.size()-1<<endl;
	Hyst1D[Hyst1D.size()-1].HI.TypeExt = TypeExt;
	Hyst1D[Hyst1D.size()-1].HI.ExpType = Extype;
	Hyst1D[Hyst1D.size()-1].HI.LieveTime = 0;
	Hyst1D[Hyst1D.size()-1].HI.DeathTime = 0;
	Hyst1D[Hyst1D.size()-1].HI.filename = filename;
	if(debug)cout<<"\tfilename = "<<filename<<endl;
	US[tmpNUS].NAH1D.resize(US[tmpNUS].NAH1D.size()+1);
	if(debug)cout<<"US["<<tmpNUS<<"].NAH1D.size = "<<US[tmpNUS].NAH1D.size()<<endl;
	US[tmpNUS].NAH1D[US[tmpNUS].NAH1D.size()-1] = Hyst1D.size()-1;
	SS[tmpSS].NAH1D.resize(SS[tmpSS].NAH1D.size()+1);
	SS[tmpSS].NAH1D[SS[tmpSS].NAH1D.size()-1] = Hyst1D.size()-1;
	PS[PS.size()-1].NAH1D.resize(PS[PS.size()-1].NAH1D.size()+1);
	PS[PS.size()-1].NAH1D[PS[PS.size()-1].NAH1D.size()-1] = Hyst1D.size()-1;
	if(debug)cout<<"PS["<<PS.size()-1<<"].NAH1D["<<PS[PS.size()-1].NAH1D.size()-1<<"] = "<<Hyst1D.size()-1;
	if(Extype!=0){
	    if(debug)cout<<"\tHyst1DExpFilling..."<<endl;
	    Hyst1D[Hyst1D.size()-1].Hyst1DFExp.SetName(hystname);
	    Hyst1D[Hyst1D.size()-1].Hyst1DFExp.SetBins(NBinsX,Firstx,Lastx);
	}
    }
    if (Dim==2){
	//Hyst2D.resize(Hyst2D.size()+1);
	//if(debug) cout<<"\tvector of Hyst2D was increased, New size is "<<Hyst2D.size()<<endl;
	if(debug)cout<<"\tFilling 2D hystogramm"<<endl;
	//cout<<"Hyst2D.size() = "<<Hyst2D.size()<<endl;
	Hyst2D[Hyst2D.size()-1].Hyst2DF.SetName(hystname);
	if(debug)cout<<"\thystname = "<<hystname<<endl;
	Hyst2D[Hyst2D.size()-1].Hyst2DF.SetBins(NBinsX,Firstx,Lastx,NBinsY,Firsty,Lasty);
	Hyst2D[Hyst2D.size()-1].HI.NUS = tmpNUS;
	if(debug)cout<<"\tNUS = "<<tmpNUS<<endl;
	Hyst2D[Hyst2D.size()-1].HI.NED = ED.size()-1;
	if(debug)cout<<"\tNED = "<<ED.size()-1<<endl;
	Hyst2D[Hyst2D.size()-1].HI.NSS = tmpSS;
	if(debug)cout<<"\tNSS = "<<tmpSS<<endl;
	Hyst2D[Hyst2D.size()-1].HI.NPT = PS.size()-1;
	if(debug)cout<<"\tNPT = "<<PS.size()-1<<endl;
	Hyst2D[Hyst2D.size()-1].HI.TypeExt = TypeExt;
	Hyst2D[Hyst2D.size()-1].HI.ExpType = Extype;
	if(debug) cout<<"\tTypeExt = "<<Hyst2D[Hyst2D.size()-1].HI.TypeExt<<endl;
	Hyst2D[Hyst2D.size()-1].HI.LieveTime = 0;
	Hyst2D[Hyst2D.size()-1].HI.DeathTime = 0;
	Hyst2D[Hyst2D.size()-1].HI.filename = filename;
	if(debug)cout<<"\tfilename = "<<filename<<endl;
	//if(debug)cout<<"\ttmpNUS = "<<tmpNUS<<endl;
	US[tmpNUS].NAH2D.resize(US[tmpNUS].NAH2D.size()+1);
	if(debug)cout<<"US["<<tmpNUS<<"].NAH2D.size = "<<US[tmpNUS].NAH2D.size()<<endl;
	US[tmpNUS].NAH2D[US[tmpNUS].NAH2D.size()-1] = Hyst2D.size()-1;
	SS[tmpSS].NAH2D.resize(SS[tmpSS].NAH2D.size()+1);
	SS[tmpSS].NAH2D[SS[tmpSS].NAH2D.size()-1] = Hyst2D.size()-1;
	PS[PS.size()-1].NAH2D.resize(PS[PS.size()-1].NAH2D.size()+1);
	PS[PS.size()-1].NAH2D[PS[PS.size()-1].NAH2D.size()-1] = Hyst2D.size()-1;
	if(Extype!=0){
	    if(debug)cout<<"\tHyst1DExpFilling..."<<endl;
	    Hyst2D[Hyst2D.size()-1].Hyst2DFExp.SetName(hystname);
	    Hyst2D[Hyst2D.size()-1].Hyst2DFExp.SetBins(NBinsX,Firstx,Lastx,NBinsY,Firsty,Lasty);
	}
    }
    if (Dim==3){
	//Hyst2D.resize(Hyst2D.size()+1);
	//if(debug) cout<<"\tvector of Hyst2D was increased, New size is "<<Hyst2D.size()<<endl;
	if(debug)cout<<"\tFilling 3D hystogramm"<<endl;
	//cout<<"Hyst2D.size() = "<<Hyst2D.size()<<endl;
	Hyst3D[Hyst3D.size()-1].Hyst3DF.SetName(hystname);
	if(debug)cout<<"\thystname = "<<hystname<<endl;
	Hyst3D[Hyst3D.size()-1].Hyst3DF.SetBins(NBinsX,Firstx,Lastx,NBinsY,Firsty,Lasty,NBinsZ,Firstx,Lastz);
	Hyst3D[Hyst3D.size()-1].HI.NUS = tmpNUS;
	if(debug)cout<<"\tNUS = "<<tmpNUS<<endl;
	Hyst3D[Hyst3D.size()-1].HI.NED = ED.size()-1;
	if(debug)cout<<"\tNED = "<<ED.size()-1<<endl;
	Hyst3D[Hyst3D.size()-1].HI.NSS = tmpSS;
	if(debug)cout<<"\tNSS = "<<tmpSS<<endl;
	Hyst3D[Hyst3D.size()-1].HI.NPT = PS.size()-1;
	if(debug)cout<<"\tNPT = "<<PS.size()-1<<endl;
	Hyst3D[Hyst3D.size()-1].HI.TypeExt = TypeExt;
	Hyst3D[Hyst3D.size()-1].HI.ExpType = Extype;
	if(debug) cout<<"\tTypeExt = "<<Hyst3D[Hyst3D.size()-1].HI.TypeExt<<endl;
	Hyst3D[Hyst3D.size()-1].HI.LieveTime = 0;
	Hyst3D[Hyst3D.size()-1].HI.DeathTime = 0;
	Hyst3D[Hyst3D.size()-1].HI.filename = filename;
	if(debug)cout<<"\tfilename = "<<filename<<endl;
	//if(debug)cout<<"\ttmpNUS = "<<tmpNUS<<endl;
	US[tmpNUS].NAH3D.resize(US[tmpNUS].NAH2D.size()+1);
	if(debug)cout<<"US["<<tmpNUS<<"].NAH2D.size = "<<US[tmpNUS].NAH3D.size()<<endl;
	US[tmpNUS].NAH3D[US[tmpNUS].NAH3D.size()-1] = Hyst3D.size()-1;
	SS[tmpSS].NAH3D.resize(SS[tmpSS].NAH3D.size()+1);
	SS[tmpSS].NAH3D[SS[tmpSS].NAH3D.size()-1] = Hyst3D.size()-1;
	PS[PS.size()-1].NAH3D.resize(PS[PS.size()-1].NAH3D.size()+1);
	PS[PS.size()-1].NAH3D[PS[PS.size()-1].NAH3D.size()-1] = Hyst3D.size()-1;
	if(Extype!=0){
	    if(debug)cout<<"\tHyst1DExpFilling..."<<endl;
	    Hyst3D[Hyst3D.size()-1].Hyst3DFExp.SetName(hystname);
	    Hyst3D[Hyst3D.size()-1].Hyst3DFExp.SetBins(NBinsX,Firstx,Lastx);
	}
    }
}

void OptionParam::CheckBrackets(int Argc, char* Argv[], Int_t& i){
    if(debug) cout<<"\tCheck brackets expresion...\n\n";
    if(!strcmp(Argv[i],"[") && !strcmp(Argv[i+8],"]")){ //Dlya tempov scheta v savisimosti ot Pitch dlya GEO stroitsya eshe i zavisimosti ot L, B, LB, Altitude - eto i est' 9-yi parametr
        SimpleCheck(Argv[i+1],Argv[i+2],Argv[i+3], Argv[i+4],"0","0","0","0","0","0", Argv[i+6], Argv[i+5],Argv[i+7],1);
        i+=8;
    }else
    if(!strcmp(Argv[i],"[") && !strcmp(Argv[i+11],"]")){
        SimpleCheck(Argv[i+1],Argv[i+2],Argv[i+3], Argv[i+4],Argv[i+5],Argv[i+6],Argv[i+7],"0","0","0",Argv[i+9],Argv[i+8],Argv[i+10],2);
        i+=11;
    }else
    if(!strcmp(Argv[i],"[") && !strcmp(Argv[i+14],"]")){
        SimpleCheck(Argv[i+1],Argv[i+2],Argv[i+3], Argv[i+4],Argv[i+5],Argv[i+6],Argv[i+7],Argv[i+8],Argv[i+9],Argv[i+10],Argv[i+12],Argv[i+11],Argv[i+13],3);
        i+=14;
    }else{
        cout<<"ERROR!\tYou must indicate Parameters of Hystogramm and outputh file for saving!\t See --help\n\n";
        exit(1);
    }
}

void OptionParam::Run(int Argc, char* Argv[], Int_t& i){
    i++;
    if(debug) cout<<"\tRUN FUNCTION AnglCount....\n\n";
    while(i<Argc && ((!strcmp(Argv[i],"-Brazil")) || (!strcmp(Argv[i],"-Br")) || (!strcmp(Argv[i],"-WithoutBrazil")) || (!strcmp(Argv[i],"-WBr")) ||
	(!strcmp(Argv[i],"-Equator")) || (!strcmp(Argv[i],"-Eq")) || (!strcmp(Argv[i],"-Polar")) || (!strcmp(Argv[i],"-Po")) || (!strcmp(Argv[i],"-UserSelection")) || 
	(!strcmp(Argv[i],"-US")) || (!strcmp(Argv[i],"-AllGeography")) || (!strcmp(Argv[i],"-AGP")) || (!strcmp(Argv[i],"-Mode")) || (!strcmp(Argv[i],"[")))){
	
	if(debug)cout<<"Argv["<<i<<"] = "<<Argv[i]<<endl;
	if((!strcmp(Argv[i],"-Brazil")) || (!strcmp(Argv[i],"-Br"))){
	    SetupGeo(350,500,0,0.216,0,1.15,0.1,0.5,34,0); //altmore altless; Bmore Bless; Lmore Lless; Rmore Rless;
	    SetupGeo(350,600,0,0.216,0,1.15,0.1,1,34,1);
	    SetupGeo(350,400,0,0.216,1.15,1.2,0.1,0.5,34,2);
	    SetupGeo(500,600,0,0.213,0,1.15,0.1,0.5,34,3);
	    SetupGeo(400,500,0,0.213,1.35,1.4,0,1,34,4);
	    SetupGeo(550,600,0,0.213,1.35,1.4,0.5,1,34,5);
	    SetupGeo(350,600,0,0.210,0,1.15,1,1.5,34,6);
	    SetupGeo(350,400,0,0.210,0,1.15,1.5,2,34,7);
	    SetupGeo(400,600,0,0.210,1.15,1.2,0.1,1,34,8);
	    SetupGeo(350,400,0,0.210,1.15,1.2,0.5,1,34,9);
	    SetupGeo(350,400,0,0.210,1.2,1.25,0.1,1,34,10);
	    SetupGeo(450,600,0,0.210,1.2,1.25,0.5,1,34,11);
	    SetupGeo(450,500,0,0.210,1.2,1.25,0.1,0.5,34,12);
	    SetupGeo(350,400,0,0.210,1.25,1.3,0.1,1,34,13);
	    SetupGeo(450,600,0,0.210,1.25,1.3,0.1,1,34,14);
	    SetupGeo(350,550,0,0.210,1.3,1.35,0.1,1,34,15);
	    SetupGeo(350,400,0,0.210,1.35,1.4,0.1,1,34,16);
	    SetupGeo(550,600,0,0.210,1.35,1.4,0.1,0.5,34,17);
	    SetupGeo(550,600,0,0.208,1.3,1.35,0.1,1,34,18);
	    SetupGeo(550,600,0,0.208,1.35,1.4,0.1,1,34,19);
	    SetupGeo(450,500,0,0.205,0,1.15,1.5,2,34,20);
	    SetupGeo(550,600,0,0.205,0,1.15,1.5,2,34,21);
	    SetupGeo(350,600,0,0.205,1.2,1.25,0.1,1,34,22);
	    SetupGeo(400,450,0,0.205,1.2,1.25,0.1,1,34,23);
	    SetupGeo(500,600,0,0.205,1.2,1.25,0.1,0.5,34,24);
	    SetupGeo(400,450,0,0.205,1.25,1.3,0.1,1,34,25);
	    SetupGeo(500,550,0,0.202,0,1.2,1.5,2,34,26);
	    SetupGeo(450,550,0,0.202,1.2,1.25,1,1.5,34,27);
	    SetupGeo(550,600,0,0.198,1.15,1.2,1.5,2,34,28);
	    SetupGeo(350,450,0,0.198,1.2,1.25,1,1.5,34,29);
	    SetupGeo(550,600,0,0.198,1.2,1.25,1,1.5,34,30);
	    SetupGeo(450,500,0,0.195,1.15,1.2,1.5,2,34,31);
	    SetupGeo(350,600,0,0.195,1.25,1.3,1,1.5,34,32);
	    SetupGeo(350,600,0,0.211,1.1,1.4,2,1000,34,33);
	}
	if((!strcmp(Argv[i],"-WithoutBrazil")) || (!strcmp(Argv[i],"-WBr"))) SetupGeo(300,700,0.24,100,0.1,1000,0.1,1000,1,0);
	if((!strcmp(Argv[i],"-Equator")) || (!strcmp(Argv[i],"-Eq"))) SetupGeo(300,700,0.24,100,0,1.2,0.1,1000,1,0);
	if((!strcmp(Argv[i],"-Polar")) || (!strcmp(Argv[i],"-Po"))) SetupGeo(300,700,0,100,6,1000,0.1,1000,1,0);
	if((!strcmp(Argv[i],"-AllGeography")) || (!strcmp(Argv[i],"-AGP"))) SetupGeo(300,700,0,100,0,1000,0.1,1000,1,0);
	if((!strcmp(Argv[i],"-UserSelection")) || (!strcmp(Argv[i],"-US"))){
	    if(debug) cout<<"\tUser Selection Option was selected: \n\n";
	    Int_t j = i+1; 
	    Double_t Bmore = 0; Double_t Bless = 100;
	    Double_t Lmore = 0; Double_t Lless = 1000;
	    Double_t altmore = 0; Double_t altless = 700;
	    Double_t Rmore = 0.1; Double_t Rless = 1000;
	    //Double_t Pmore = -360; Double_t Pless = 360;
	    while(j<Argc && ((!strcmp(Argv[j],"-Bmore")) || (!strcmp(Argv[j],"-Bless")) || (!strcmp(Argv[j],"-Lmore")) || 
		(!strcmp(Argv[j],"-Lless")) || (!strcmp(Argv[j],"-altmore")) || (!strcmp(Argv[j],"-altless")) || 
		(!strcmp(Argv[j],"-Pmore")) || (!strcmp(Argv[j],"-Pless")) || atof(Argv[j]))){

		if(!strcmp(Argv[j],"-Bmore")) Bmore = CheckDouble(Argv[j+1],Argv[j]);
		if(!strcmp(Argv[j],"-Bless")) Bless = CheckDouble(Argv[j+1],Argv[j]);
		if(!strcmp(Argv[j],"-Lmore")) Lmore = CheckDouble(Argv[j+1],Argv[j]);
		if(!strcmp(Argv[j],"-Lless")) Lless = CheckDouble(Argv[j+1],Argv[j]);
		if(!strcmp(Argv[j],"-altmore")) altmore = CheckDouble(Argv[j+1],Argv[j]);
		if(!strcmp(Argv[j],"-altless")) altless = CheckDouble(Argv[j+1],Argv[j]);
		if(!strcmp(Argv[j],"-Rmore")) Rmore = CheckDouble(Argv[j+1],Argv[j]);
		if(!strcmp(Argv[j],"-Rless")) Rless = CheckDouble(Argv[j+1],Argv[j]);
		//if(!strcmp(Argv[j],"-Pmore")) Pmore = CheckDouble(Argv[j+1],Argv[j]);
		//if(!strcmp(Argv[j],"-Pless")) Pless = CheckDouble(Argv[j+1],Argv[j]);
		j++;i++;
	    }
	    SetupGeo(altmore,altless,Bmore,Bless,Lmore,Lless,Rmore,Rless,1,0);
	}
	i++;
    }//While
    if(debug){Int_t u; cin>>u;}
}

void OptionParam::CheckAD(int Argc, char* Argv[], Int_t& i){
    if(debug) cout<<"\t"<<Argv[i]<<" Option was selected: \n\n";
    i++;
    while(i<Argc && ((!strcmp(Argv[i],"-Emin")) || (!strcmp(Argv[i],"-Emax")) || (!strcmp(Argv[i],"-detrmin")) || (!strcmp(Argv[i],"-detrmax")))){
	if(debug)cout<<"Argv["<<i<<"] = "<<Argv[i]<<endl;
	if(!strcmp(Argv[i],"-Emin")){
	    ED.resize(ED.size()+1);
	    if(debug) cout<<"\tvector EnergyDiapason was increased...\tNew size = "<<ED.size()<<"\n\n";
	    ED[ED.size()-1].Emin = CheckDouble(Argv[i+1],Argv[i]);
	    ED[ED.size()-1].Emax = 1000;
	    ED[ED.size()-1].detrmin = 0;
	    ED[ED.size()-1].detrmax = 1000;
	    //ED[ED.size()-1].NAH = -1;
	    if(debug) cout<<"\t\t Emin = "<<ED[ED.size()-1].Emin<<"\n";
	    i++;
	}
	if(!strcmp(Argv[i],"-Emax")){
	    ED[ED.size()-1].Emax = CheckDouble(Argv[i+1],Argv[i]);
	    if(debug) cout<<"\t\t Emax = "<<ED[ED.size()-1].Emax<<"\n";
	    i++;
	}
	if(ED[ED.size()-1].Emax<=ED[ED.size()-1].Emin || ED[ED.size()-1].Emax<=0 || ED[ED.size()-1].Emin<0){
	    cout<<"ERROR! Incorrect Energy Diapason Emin = "<<ED[ED.size()-1].Emin<<" Emax = "<<ED[ED.size()-1].Emax<<"\n\n";
	    exit(1);
	}
	if(ED[ED.size()-1].Emin>1000) cout<<"WARNING\tPamela don't able to register particles of SUCH high energy\n\n";
	if(!strcmp(Argv[i],"-detrmin")){
	    ED[ED.size()-1].detrmin = CheckDouble(Argv[i+1],Argv[i]);
	    if(debug) cout<<"\t\t detrmin = "<<ED[ED.size()-1].detrmin<<"\n";
	    i++;
	}
	if(!strcmp(Argv[i],"-detrmax")){
	    ED[ED.size()-1].detrmax = CheckDouble(Argv[i+1],Argv[i]);
	    if(debug) cout<<"\t\t detrmax = "<<ED[ED.size()-1].detrmax<<"\n";
	    i++;
	}
	if(ED[ED.size()-1].detrmax<=ED[ED.size()-1].detrmin || ED[ED.size()-1].detrmax<=0 || ED[ED.size()-1].detrmin<0){
	    cout<<"ERROR! Incorrect Energy Diapason detrmin = "<<ED[ED.size()-1].detrmin<<" detrmax = "<<ED[ED.size()-1].detrmax<<"\n\n";
	    exit(1);
	}

	i++;
    }
    if(debug)cout<<"LastArgv["<<i<<"] = "<<Argv[i]<<endl<<endl;
}

void OptionParam::CheckPitch(int Argc, char* Argv[], Int_t& i){
    if(debug) cout<<"\t"<<Argv[i]<<" Option was selected: \n\n";
    i++;
    while(i<Argc && ((!strcmp(Argv[i],"-Pthmin")) || (!strcmp(Argv[i],"-Pthmax")))){
	if(debug)cout<<"Argv["<<i<<"] = "<<Argv[i]<<endl;
	if(!strcmp(Argv[i],"-Pthmin")){
	    PS.resize(PS.size()+1);
	    PS[PS.size()-1].PitchMin = CheckDouble(Argv[i+1],Argv[i]);
	    PS[PS.size()-1].PitchMax = 360;
	    if(debug)cout<<"\tPitchmin = "<<PS[PS.size()-1].PitchMin<<endl;
	    i++;
	}
	if(!strcmp(Argv[i],"-Pthmax")){
	    PS[PS.size()-1].PitchMax = CheckDouble(Argv[i+1],Argv[i]);
	    if(debug)cout<<"\tPitchmax = "<<PS[PS.size()-1].PitchMax<<endl;
	    i++;
	}
	i++;
    }
}

void OptionParam::SetExpOption(int Argc, char* Argv[], Int_t& i){
    if(debug) cout<<"\t Exposition Option was selected: \n\n";
    i++;
    while(i<Argc && ((!strcmp(Argv[i],"-infile")) || (!strcmp(Argv[i],"-effhyst")))){
	if(!strcmp(Argv[i],"-infile")){
	    EffHyst.resize(EffHyst.size()+1);
	    EffHyst[EffHyst.size()-1].inputfile = Argv[i+1];
	    i++;
	}
	if(!strcmp(Argv[i],"-effhyst")){
	    EffHyst[EffHyst.size()-1].inputhyst = Argv[i+1];
	}
    i++;
    }
}

/*
void OptionParam::ShowSSInfo(vector<SelectScheme> SS){
    for(UInt_t i = 0; i<SS.size(); i++){
	cout<<"\t\tSS["<<i<<"].Rmin = "<<SS[i].Rmin<<"\n";
	cout<<"\t\tSS["<<i<<"].Rmax = "<<SS[i].Rmax<<"\n";
	cout<<"\t\tSS["<<i<<"].detrminf = "<<SS[i].detrminf<<"\n";
	cout<<"\t\tSS["<<i<<"].detrmaxf = "<<SS[i].detrmaxf<<"\n";
	cout<<"\t\tSS["<<i<<"].detrmore = "<<SS[i].detrmore<<"\n";
	cout<<"\t\tSS["<<i<<"].detrless = "<<SS[i].detrless<<"\n";
	cout<<"\t\tSS["<<i<<"].betamin = "<<SS[i].betamin<<"\n";
	cout<<"\t\tSS["<<i<<"].betamax = "<<SS[i].betamax<<"\n";
	cout<<"\t\tSS["<<i<<"].AC = "<<SS[i].AC<<"\n";
	cout<<"\t\tSS["<<i<<"].Calo = "<<SS[i].Calo<<"\n\n";
    }
}
*/
Int_t OptionParam::CheckSS(Double_t Rmin, Double_t Rmax, Int_t detrminf, Int_t detrmaxf, Double_t detrmore, Double_t detrless, Float_t betamin, Float_t betamax, Bool_t AC, Bool_t Calo, Int_t NSP){
    if(debug)cout<<"\tCHeckUS function..."<<endl;
    if(debug)cout<<"US.size = "<<US.size()<<endl;
    for(Int_t sen=0; sen<US.size();sen++){
	if(SS[sen].SP.size()>NSP){
	if(SS[sen].SP[NSP].Rmin == Rmin && SS[sen].SP[NSP].Rmax == Rmax && SS[sen].SP[NSP].detrminf == detrminf && SS[sen].SP[NSP].detrmaxf &&
	    SS[sen].SP[NSP].detrmore == detrmore && SS[sen].SP[NSP].detrless == detrless && SS[sen].SP[NSP].betamin == betamin &&
	    SS[sen].SP[NSP].betamax == betamax && SS[sen].SP[NSP].AC == AC && SS[sen].SP[NSP].Calo == Calo) return sen;
	}
    }
    cout<<"end"<<endl;
    return -1;
}

void OptionParam::FillSS(SelectParam& SP, Double_t Rmin, Double_t Rmax, Int_t detrmin, Int_t detrmax, Double_t detrmore, Double_t detrless, Float_t betamin, Float_t betamax, Bool_t AC, Bool_t Calo){
    SP.Rmin = Rmin;
    SP.Rmax = Rmax;
    SP.detrminf = detrmin;
    SP.detrmaxf = detrmax;
    SP.detrmore = detrmore;
    SP.detrless = detrless;
    SP.betamin = betamin;
    SP.betamax = betamax;
    SP.AC = AC;
    SP.Calo = Calo;
}

void OptionParam::DefaultSelect(Int_t Np){
    if(debug) cout<<"\tCreating default selection scheme for "<<Np;
    if(Np == 0){
	if(debug) cout<<"All particle...\n\n";
	Int_t u=CheckSS(-1000,1000,0,0,0,200,0.2,1,false,false,0);
	if(u!=-1){if(SS[u].SP.size()==1) tmpSS = u;}else{
	    SS[SS.size()-1].SP.resize(1);
	    tmpSS = SS.size()-1;
	    if(debug) cout<<"\tvector SelectParam was increased...\tNew size = "<<SS[SS.size()-1].SP.size()<<"\n\n";
	    FillSS(SS[SS.size()-1].SP[0],-1000,1000,0,0,0,200,0.2,1,false,false);
	}
    }else
    if(Np == 1){
	if(debug) cout<<" Proton...\n\n";
	Int_t u = 0;
	u=CheckSS(0,0.4,1,0,0,20,0.2,1,false,false,0);
	if(u!=-1) u=CheckSS(0.4,0.8,1,2,0,0,0.2,1,false,false,1);
	if(u!=-1) u=CheckSS(0.8,3.0,0,2,0,0,0.2,1,false,true,2);
	if(u!=-1) u=CheckSS(3.0,1000,0,3,0,0,0.2,1,false,false,3);
	if(debug) cout<<"\tu = "<<u<<endl;
	if(u!=-1){if(SS[u].SP.size()==4) tmpSS = u;}else{
	    SS[SS.size()-1].SP.resize(4);
	    tmpSS = SS.size()-1;
	    if(debug) cout<<"\tvector SelectParam was increased...\tNew size = "<<SS[SS.size()-1].SP.size()<<"\n\n";
	    FillSS(SS[SS.size()-1].SP[0],0,0.4,1,0,0,20,0.2,1,false,false);
	    FillSS(SS[SS.size()-1].SP[1],0.4,0.8,1,2,0,0,0.2,1,false,false);
	    FillSS(SS[SS.size()-1].SP[2],0.8,3.0,0,2,0,0,0.2,1,false,true);
	    FillSS(SS[SS.size()-1].SP[3],3.0,1000,0,3,0,0,0.2,1,false,true);
	}
	if(debug)cout<<"\tProton Selection scheme was filled"<<endl;
	//if(debug) ShowSSInfo(SS);
    }else
    if(Np == 2){
	if(debug) cout<<"Electron...\n\n";
	Int_t u=0;
	u=CheckSS(-0.8,0,0,1,0,0,0.8,1,true,false,0);
	if(u!=-1) u=CheckSS(-1000,-0.8,0,2,0,0,0.8,1,false,true,1);
	if(u!=-1){if(SS[u].SP.size()==2) tmpSS = u;}else{
	    SS[SS.size()-1].SP.resize(2);
	    tmpSS = SS.size()-1;
	    if(debug) cout<<"\tvector SelectScheme was increased...\tNew size = "<<SS.size()<<"\n\n";
	    FillSS(SS[SS.size()-1].SP[0],-0.8,0,0,1,0,0,0.8,1,true,false);
	    FillSS(SS[SS.size()-1].SP[1],-1000,-0.8,0,2,0,0,0.8,1,false,true);
	}
	//if(debug) ShowSSInfo(SS);
    }else
    if(Np == 3){
	if(debug) cout<<"Positron...\n\n";
	Int_t u = 0;
	u=CheckSS(0,0.8,0,1,0,0,0.8,1,true,false,0);
	if(u!=-1) u=CheckSS(0.8,1000,0,2,0,0,0.8,1,false,true,1);
	if(u!=-1){if(SS[u].SP.size()==2) tmpSS = u;}else{
	    SS[SS.size()-1].SP.resize(2);
	    tmpSS = SS.size()-1;
	    if(debug) cout<<"\tvector SelectScheme was increased...\tNew size = "<<SS.size()<<"\n\n";
	    FillSS(SS[SS.size()-1].SP[0],0,0.8,0,1,0,0,0.8,1,true,false);
	    FillSS(SS[SS.size()-1].SP[1],0.8,1000,0,2,0,0,0.8,1,false,true);
	}
	//if(debug) ShowSSInfo(SS);
    }else
    if(Np == 4){
	if(debug) cout<<"Antiproton...\n\n";
	Int_t u = 0;
	u=CheckSS(-0.8,0,1,0,0,30,0.2,1,false,false,0);
	if(u!=-1) u=CheckSS(-1000,-0.8,0,0,0,0,0.2,1,false,true,1);
	if(u!=-1){if(SS[u].SP.size()==2) tmpSS = u;}else{
	    SS[SS.size()-1].SP.resize(2);
	    tmpSS = SS.size()-1;
	    if(debug) cout<<"\tvector SelectScheme was increased...\tNew size = "<<SS.size()<<"\n\n";
	    FillSS(SS[SS.size()-1].SP[0],-0.8,0,1,0,0,30,0.2,1,false,false);
	    FillSS(SS[SS.size()-1].SP[1],-1000,-0.8,0,0,0,0,0.2,1,false,true);
	    //tmpSS = 
	}
	//if(debug) ShowSSInfo(SS);
    }
    cout<<"\ttmpSS = "<<tmpSS<<endl;
    SS[tmpSS].PartType = Np;
    if(debug){Int_t ut; cin>>ut;}
}

void OptionParam::MakeSelectScheme(int Argc, char* Argv[], Int_t& i, Int_t type){
    if(debug) cout<<"\tSelect separation Scheme...\n\n";
    if(type==-1 && i==Argc){
	cout<<"ERROR!: SelectionScheme option needs in at least 1 parameters!\n";
	exit(1);
    }
    SS.resize(SS.size()+1);
    if(type!=-1) DefaultSelect(type);else{
    i++;
    SS[SS.size()-1].PartType = -1;
    tmpSS=SS.size()-1;
    while(i<Argc && ((!strcmp(Argv[i],"-Rmin")) || (!strcmp(Argv[i],"-Rmax")) || (!strcmp(Argv[i],"-detrminf")) || (!strcmp(Argv[i],"-detrmaxf")) ||
	(!strcmp(Argv[i],"-detrmore")) || (!strcmp(Argv[i],"-detrless")) || (!strcmp(Argv[i],"-AC")) || (!strcmp(Argv[i],"-Calo")) || 
	(!strcmp(Argv[i],"-betamin")) || (!strcmp(Argv[i],"-betamax")))){
	
	if(!strcmp(Argv[i],"-Rmin")){
	    SS[SS.size()-1].SP.resize(SS[SS.size()-1].SP.size()+1);
	    if(debug) cout<<"\tvector SelectScheme was increased...\tNew size = "<<SS[SS.size()-1].SP.size()<<"\n\n";
	    SS[SS.size()-1].SP[SS[SS.size()-1].SP.size()-1].Rmin = CheckDouble(Argv[i+1],Argv[i]);
	    if(debug) cout<<"\t\t Rmin = "<<SS[SS.size()-1].SP[SS[SS.size()-1].SP.size()-1].Rmin<<"\n";
	    SS[SS.size()-1].SP[SS[SS.size()-1].SP.size()-1].Rmax = 1000;
	    SS[SS.size()-1].SP[SS[SS.size()-1].SP.size()-1].detrminf = 0;
	    SS[SS.size()-1].SP[SS[SS.size()-1].SP.size()-1].detrmaxf = 0;
	    SS[SS.size()-1].SP[SS[SS.size()-1].SP.size()-1].detrmore = 0;
	    SS[SS.size()-1].SP[SS[SS.size()-1].SP.size()-1].detrless = 1000;
	    SS[SS.size()-1].SP[SS[SS.size()-1].SP.size()-1].betamin = 0.2;
	    SS[SS.size()-1].SP[SS[SS.size()-1].SP.size()-1].betamax = 1;
	    SS[SS.size()-1].SP[SS[SS.size()-1].SP.size()-1].AC = false;
	    SS[SS.size()-1].SP[SS[SS.size()-1].SP.size()-1].Calo = false;
	    i++;
	}
	if(!strcmp(Argv[i],"-Rmax")){
	    SS[SS.size()-1].SP[SS[SS.size()-1].SP.size()-1].Rmax = CheckDouble(Argv[i+1],Argv[i]);
	    if(debug) cout<<"\t\t Rmax = "<<SS[SS.size()-1].SP[SS[SS.size()-1].SP.size()-1].Rmax<<"\n";
	    i++;
	}
	if(SS[SS.size()-1].SP[SS[SS.size()-1].SP.size()-1].Rmax <= SS[SS.size()-1].SP[SS[SS.size()-1].SP.size()-1].Rmin){
	    cout<<"SelectionScheme: ERROR!!\tYou have incorrect rigidity diapason...\n\n";
	    exit(1);
	}
	if(!strcmp(Argv[i],"-detrminf")){
	    SS[SS.size()-1].SP[SS[SS.size()-1].SP.size()-1].detrminf = CheckInt(Argv[i+1],Argv[i]);
	    if(debug) cout<<"\t\t detrminf = "<<SS[SS.size()-1].SP[SS[SS.size()-1].SP.size()-1].detrminf<<"\n";
	    if(SS[SS.size()-1].SP[SS[SS.size()-1].SP.size()-1].detrminf<0 || SS[SS.size()-1].SP[SS[SS.size()-1].SP.size()-1].detrminf>3){
		cout<<"ERROR:\t-detrminf have incorrect value of argument: -detrminf = "<<Argv[i+1]<<"\n\n";
		exit(1);
	    }
	    i++;
	}
	if(!strcmp(Argv[i],"-detrmaxf")){
	    SS[SS.size()-1].SP[SS[SS.size()-1].SP.size()-1].detrmaxf = CheckInt(Argv[i+1],Argv[i]);;
	    if(debug) cout<<"\t\t detrmaxf = "<<SS[SS.size()-1].SP[SS[SS.size()-1].SP.size()-1].detrmaxf<<"\n";
	    if(SS[SS.size()-1].SP[SS[SS.size()-1].SP.size()-1].detrmaxf<0 || SS[SS.size()-1].SP[SS[SS.size()-1].SP.size()-1].detrmaxf>3){
		cout<<"ERROR:\t-detrmaxf have incorrect value of argument: -detrmaxf = "<<Argv[i+1]<<"\n\n";
		exit(1);
	    }
	    i++;
	}
	if(!strcmp(Argv[i],"-detrmore")){
	    SS[SS.size()-1].SP[SS[SS.size()-1].SP.size()-1].detrmore = CheckDouble(Argv[i+1],Argv[i]);
	    if(debug) cout<<"\t\t detrmore = "<<SS[SS.size()-1].SP[SS[SS.size()-1].SP.size()-1].detrmore<<"\n";
	    i++;
	}
	if(!strcmp(Argv[i],"-detrless")){
	    SS[SS.size()-1].SP[SS[SS.size()-1].SP.size()-1].detrless = CheckDouble(Argv[i+1],Argv[i]);
	    if(debug) cout<<"\t\t detrless = "<<SS[SS.size()-1].SP[SS[SS.size()-1].SP.size()-1].detrless<<"\n";
	    i++;
	}
	if(!strcmp(Argv[i],"-betamin")){
	    SS[SS.size()-1].SP[SS[SS.size()-1].SP.size()-1].betamin = CheckDouble(Argv[i+1],Argv[i]);
	    if(debug) cout<<"\t\t betamin = "<<SS[SS.size()-1].SP[SS[SS.size()-1].SP.size()-1].betamin<<"\n";
	    i++;
	}
	if(!strcmp(Argv[i],"-betamax")){
	    SS[SS.size()-1].SP[SS[SS.size()-1].SP.size()-1].betamax = CheckDouble(Argv[i+1],Argv[i]);
	    if(debug) cout<<"\t\t betamax = "<<SS[SS.size()-1].SP[SS[SS.size()-1].SP.size()-1].betamax<<"\n";
	    i++;
	}
	if(SS[SS.size()-1].SP[SS[SS.size()-1].SP.size()-1].betamax <= SS[SS.size()-1].SP[SS[SS.size()-1].SP.size()-1].betamin){
	    cout<<"SlectionScheme: ERROR!!\tYou have incorrect detr diapason...\n\n";
	    exit(1);
	}
	if(!strcmp(Argv[i],"-AC")){
	    SS[SS.size()-1].SP[SS[SS.size()-1].SP.size()-1].AC = true;
	    if(debug) cout<<"\t\t AntiCounter = "<<SS[SS.size()-1].SP[SS[SS.size()-1].SP.size()-1].AC<<"\n";
	}
	if(!strcmp(Argv[i],"-Calo")){
	    SS[SS.size()-1].SP[SS[SS.size()-1].SP.size()-1].Calo = true;
	    if(debug) cout<<"\t\t Calorimeter = "<<SS[SS.size()-1].SP[SS[SS.size()-1].SP.size()-1].Calo<<"\n";
	}
	i++;
    }//while
    }//else
    if(debug)cout<<"LastArgv["<<i<<"] = "<<Argv[i]<<endl<<endl;
    if(debug){Int_t u; cin>>u;}
}

void OptionParam::MakeHystAxis(int Argc, char* Argv[], Int_t& i){
    i++;
    if(debug)cout<<"MakeHystAxis function..."<<endl;
    
    if(!strcmp(Argv[i],"-Z")){
	if(Argc<=i+5){
	    cout<<"ERROR! -Z Needs at least 3 argument!"<<endl;
	    exit(1);
	}
	if(strcmp(Argv[i+2],"-Y")){
	    cout<<"ERROR! You need indicate meaning for Y-axis of hyst"<<endl;
	    exit(1);
	}
	if(strcmp(Argv[i+4],"-X")){
	    cout<<"ERROR! You need indicate meaning for X-axis of hyst"<<endl;
	    exit(1);
	}
	//Hyst3D.resize(Hyst3D.size()+1);
	//if(debug)cout<<"Hyst3D was increased. New size is "<<Hyst3D.size()<<endl;
	Int_t size = Hyst3D.size()-1;
	if(!strcmp(Argv[i+1],"-PamAzim")) Hyst3D[size].ZType = 1;
	if(!strcmp(Argv[i+1],"-PamZenith")) Hyst3D[size].ZType = 2;
	if(!strcmp(Argv[i+1],"-Pitch")) Hyst3D[size].ZType = 3;
	if(!strcmp(Argv[i+1],"-detr")) Hyst3D[size].ZType = 4;
	if(!strcmp(Argv[i+1],"-rigev")) Hyst3D[size].ZType = 5;
	if(!strcmp(Argv[i+1],"-lat")) Hyst3D[size].ZType = 6;
	if(!strcmp(Argv[i+1],"-lon")) Hyst3D[size].ZType = 7;
	if(!strcmp(Argv[i+1],"-L")) Hyst3D[size].ZType = 8;
	if(!strcmp(Argv[i+1],"-Babs")) Hyst3D[size].ZType = 9;
	if(!strcmp(Argv[i+1],"-Alt")) Hyst3D[size].ZType = 10;
	if(!strcmp(Argv[i+1],"-LieveTime")) Hyst3D[size].ZType = 11;
	if(!strcmp(Argv[i+1],"-DeathTime")) Hyst3D[size].ZType = 12;
	if(!strcmp(Argv[i+1],"-PNO")) Hyst3D[size].ZType = 13;
	if(!strcmp(Argv[i+1],"-MA")) Hyst3D[size].ZType = 14;
	if(!strcmp(Argv[i+1],"-Eff")) Hyst3D[size].ZType = 15;
	if(!strcmp(Argv[i+1],"-dS")) Hyst3D[size].ZType = 16;
	if(!strcmp(Argv[i+1],"-LogE")) Hyst3D[size].XType = 17;
	if(!strcmp(Argv[i+3],"-PamAzim")) Hyst3D[size].YType = 1;
	if(!strcmp(Argv[i+3],"-PamZenith")) Hyst3D[size].YType = 2;
	if(!strcmp(Argv[i+3],"-Pitch")) Hyst3D[size].YType = 3;
	if(!strcmp(Argv[i+3],"-detr")) Hyst3D[size].YType = 4;
	if(!strcmp(Argv[i+3],"-rigev")) Hyst3D[size].YType = 5;
	if(!strcmp(Argv[i+3],"-lat")) Hyst3D[size].YType = 6;
	if(!strcmp(Argv[i+3],"-lon")) Hyst3D[size].YType = 7;
	if(!strcmp(Argv[i+3],"-L")) Hyst3D[size].YType = 8;
	if(!strcmp(Argv[i+3],"-Babs")) Hyst3D[size].YType = 9;
	if(!strcmp(Argv[i+3],"-Alt")) Hyst3D[size].YType = 10;
	if(!strcmp(Argv[i+3],"-LieveTime")) Hyst3D[size].YType = 11;
	if(!strcmp(Argv[i+3],"-DeathTime")) Hyst3D[size].YType = 12;
	if(!strcmp(Argv[i+3],"-PNO")) Hyst3D[size].YType = 13;
	if(!strcmp(Argv[i+3],"-MA")) Hyst3D[size].YType = 14;
	if(!strcmp(Argv[i+3],"-Eff")) Hyst3D[size].YType = 15;
	if(!strcmp(Argv[i+3],"-dS")) Hyst3D[size].YType = 16;
	if(!strcmp(Argv[i+3],"-LogE")) Hyst3D[size].YType = 17;
	if(!strcmp(Argv[i+5],"-PamAzim")) Hyst3D[size].XType = 1;
	if(!strcmp(Argv[i+5],"-PamZenith")) Hyst3D[size].XType = 2;
	if(!strcmp(Argv[i+5],"-Pitch")) Hyst3D[size].XType = 3;
	if(!strcmp(Argv[i+5],"-detr")) Hyst3D[size].XType = 4;
	if(!strcmp(Argv[i+5],"-rigev")) Hyst3D[size].XType = 5;
	if(!strcmp(Argv[i+5],"-lat")) Hyst3D[size].XType = 6;
	if(!strcmp(Argv[i+5],"-lon")) Hyst3D[size].XType = 7;
	if(!strcmp(Argv[i+5],"-L")) Hyst3D[size].XType = 8;
	if(!strcmp(Argv[i+5],"-Babs")) Hyst3D[size].XType = 9;
	if(!strcmp(Argv[i+5],"-Alt")) Hyst3D[size].XType = 10;
	if(!strcmp(Argv[i+5],"-LieveTime")) Hyst3D[size].XType = 11;
	if(!strcmp(Argv[i+5],"-DeathTime")) Hyst3D[size].XType = 12;
	if(!strcmp(Argv[i+5],"-PNO")) Hyst3D[size].XType = 13;
	if(!strcmp(Argv[i+5],"-MA")) Hyst3D[size].XType = 14;
	if(!strcmp(Argv[i+5],"-Eff")) Hyst3D[size].XType = 15;
	if(!strcmp(Argv[i+5],"-dS")) Hyst3D[size].XType = 16;
	if(!strcmp(Argv[i+5],"-LogE")) Hyst3D[size].XType = 17;
	Hyst3D[size].NEI = EffHyst.size()-1;
	i+=5;
    };

    if(!strcmp(Argv[i],"-Y")){
	if(Argc<=i+3){
	    cout<<"ERROR! -Y Needs at least 3 argument!"<<endl;
	    exit(1);
	}
	if(strcmp(Argv[i+2],"-X")){
	    cout<<"ERROR! You need indicate meaning for X-axis of hyst"<<endl;
	    exit(1);
	}
	Hyst2D.resize(Hyst2D.size()+1);
	if(debug)cout<<"Hyst2D was increased. New size is "<<Hyst2D.size()<<endl;
	Int_t size = Hyst2D.size()-1;
	if(!strcmp(Argv[i+1],"-PamAzim")) Hyst2D[size].YType = 1;
	if(!strcmp(Argv[i+1],"-PamZenith")) Hyst2D[size].YType = 2;
	if(!strcmp(Argv[i+1],"-Pitch")) Hyst2D[size].YType = 3;
	if(!strcmp(Argv[i+1],"-detr")) Hyst2D[size].YType = 4;
	if(!strcmp(Argv[i+1],"-rigev")) Hyst2D[size].YType = 5;
	if(!strcmp(Argv[i+1],"-lat")) Hyst2D[size].YType = 6;
	if(!strcmp(Argv[i+1],"-lon")) Hyst2D[size].YType = 7;
	if(!strcmp(Argv[i+1],"-L")) Hyst2D[size].YType = 8;
	if(!strcmp(Argv[i+1],"-Babs")) Hyst2D[size].YType = 9;
	if(!strcmp(Argv[i+1],"-Alt")) Hyst2D[size].YType = 10;
	if(!strcmp(Argv[i+1],"-LieveTime")) Hyst2D[size].YType = 11;
	if(!strcmp(Argv[i+1],"-DeathTime")) Hyst2D[size].YType = 12;
	if(!strcmp(Argv[i+1],"-PNO")) Hyst2D[size].YType = 13;
	if(!strcmp(Argv[i+1],"-MA")) Hyst2D[size].YType = 14;
	if(!strcmp(Argv[i+1],"-LogE")) Hyst2D[size].YType = 17;
	if(!strcmp(Argv[i+3],"-PamAzim")) Hyst2D[size].XType = 1;
	if(!strcmp(Argv[i+3],"-PamZenith")) Hyst2D[size].XType = 2;
	if(!strcmp(Argv[i+3],"-Pitch")) Hyst2D[size].XType = 3;
	if(!strcmp(Argv[i+3],"-detr")) Hyst2D[size].XType = 4;
	if(!strcmp(Argv[i+3],"-rigev")) Hyst2D[size].XType = 5;
	if(!strcmp(Argv[i+3],"-lat")) Hyst2D[size].XType = 6;
	if(!strcmp(Argv[i+3],"-lon")) Hyst2D[size].XType = 7;
	if(!strcmp(Argv[i+3],"-L")) Hyst2D[size].XType = 8;
	if(!strcmp(Argv[i+3],"-Babs")) Hyst2D[size].XType = 9;
	if(!strcmp(Argv[i+3],"-Alt")) Hyst2D[size].XType = 10;
	if(!strcmp(Argv[i+3],"-LieveTime")) Hyst2D[size].XType = 11;
	if(!strcmp(Argv[i+3],"-DeathTime")) Hyst2D[size].XType = 12;
	if(!strcmp(Argv[i+3],"-PNO")) Hyst2D[size].XType = 13;
	if(!strcmp(Argv[i+3],"-MA")) Hyst2D[size].XType = 14;
	if(!strcmp(Argv[i+2],"-LogE")) Hyst2D[size].XType = 17;
	i+=3;
    }
    if(!strcmp(Argv[i],"-X")){
	if(Argc<=i+1){
	    cout<<"ERROR! -X Needs at least 1 argument!"<<endl;
	    exit(1);
	}
	Hyst1D.resize(Hyst1D.size()+1);
	if(debug)cout<<"Hyst1D was increased. New size is "<<Hyst1D.size()<<endl;
	Int_t size = Hyst1D.size()-1;
	if(!strcmp(Argv[i+1],"-PamAzim")) Hyst1D[size].XType = 1;
	if(!strcmp(Argv[i+1],"-PamZenith")) Hyst1D[size].XType = 2;
	if(!strcmp(Argv[i+1],"-Pitch")) Hyst1D[size].XType = 3;
	if(!strcmp(Argv[i+1],"-detr")) Hyst1D[size].XType = 4;
	if(!strcmp(Argv[i+1],"-rigev")) Hyst1D[size].XType = 5;
	if(!strcmp(Argv[i+1],"-lat")) Hyst1D[size].XType = 6;
	if(!strcmp(Argv[i+1],"-lon")) Hyst1D[size].XType = 7;
	if(!strcmp(Argv[i+1],"-L")) Hyst1D[size].XType = 8;
	if(!strcmp(Argv[i+1],"-Babs")) Hyst1D[size].XType = 9;
	if(!strcmp(Argv[i+1],"-Alt")) Hyst1D[size].XType = 10;
	if(!strcmp(Argv[i+1],"-LieveTime")) Hyst1D[size].XType = 11;
	if(!strcmp(Argv[i+1],"-DeathTime")) Hyst1D[size].XType = 12;
	if(!strcmp(Argv[i+1],"-PNO")) Hyst1D[size].XType = 13;
	if(!strcmp(Argv[i+1],"-MA")) Hyst1D[size].XType = 14;
	if(!strcmp(Argv[i+1],"-LogE")) Hyst1D[size].XType = 17;
	i++;
    }
}

void OptionParam::PamEffFunc(int Argc, char* Argv[]){
    Int_t i = 0;
    while(i<Argc){
	if(debug)cout<<"Argv["<<i<<"] = "<<Argv[i]<<endl;
	if(!strcmp(Argv[i],"-p") || !strcmp(Argv[i],"-Antiproton")) MakeSelectScheme(Argc, Argv, i, 4);
	if(!strcmp(Argv[i],"+p") || !strcmp(Argv[i],"-Proton")) MakeSelectScheme(Argc, Argv, i, 1);
	if(!strcmp(Argv[i],"-e") || !strcmp(Argv[i],"-Electron")) MakeSelectScheme(Argc, Argv, i, 2);
	if(!strcmp(Argv[i],"+e") || !strcmp(Argv[i],"-Positron")) MakeSelectScheme(Argc, Argv, i, 3);
	if(!strcmp(Argv[i],"-all") || !strcmp(Argv[i],"-AllParticles")) MakeSelectScheme(Argc, Argv, i, 0);
	if(!strcmp(Argv[i],"-SS") || !strcmp(Argv[i],"-SelectionScheme")) MakeSelectScheme(Argc, Argv, i, -1);
	if(!strcmp(Argv[i],"-ED") || !strcmp(Argv[i],"-EnergyDiapason")) CheckAD(Argc, Argv, i);
	if(!strcmp(Argv[i],"-GS") || !strcmp(Argv[i],"-GeoSelect")) Run(Argc, Argv, i);
	if(!strcmp(Argv[i],"-PS") || !strcmp(Argv[i],"-PitchSelect")) CheckPitch(Argc, Argv, i);
	if(!strcmp(Argv[i],"-Exp") || !strcmp(Argv[i],"-Exposition")) SetExpOption(Argc, Argv, i);
	if(!strcmp(Argv[i],"-HM") || !strcmp(Argv[i],"-HystMeaning")) MakeHystAxis(Argc, Argv, i);
	if(!strcmp(Argv[i],"[")) CheckBrackets(Argc, Argv, i);
	i++;
    }
    if(debug){
	for(Int_t se = 0; se<Hyst1D.size(); se++){
	    cout<<"Hyst1D["<<se<<"]..."<<endl;
	    cout<<"filename "<<Hyst1D[se].HI.filename<<endl;
	    cout<<"X axis is "<<Hyst1D[se].XType<<endl;
	    cout<<"NUS = "<<Hyst1D[se].HI.NUS<<endl;
	    for(Int_t U = 0; U<US[Hyst1D[se].HI.NUS].USP.size(); U++){
		cout<<"\tBmore = "<<US[Hyst1D[se].HI.NUS].USP[U].Bmore<<"\tBless = "<<US[Hyst1D[se].HI.NUS].USP[U].Bless<<endl;
		cout<<"\tLmore = "<<US[Hyst1D[se].HI.NUS].USP[U].Lmore<<"\tLless = "<<US[Hyst1D[se].HI.NUS].USP[U].Lless<<endl;
	        cout<<"\taltmore = "<<US[Hyst1D[se].HI.NUS].USP[U].altmore<<"\taltless = "<<US[Hyst1D[se].HI.NUS].USP[U].altless<<endl;
	        cout<<"\tRmore = "<<US[Hyst1D[se].HI.NUS].USP[U].Rmore<<"\tRless = "<<US[Hyst1D[se].HI.NUS].USP[U].Rless<<endl;
	        cout<<"\t\tNumbers of according 1D hystogramms:\t";
	        for(Int_t su = 0; su<US[Hyst1D[se].HI.NUS].NAH1D.size(); su++){
	    	    cout<<US[Hyst1D[se].HI.NUS].NAH1D[su]<<" ";
	        }
	    }
	    cout<<"NED = "<<Hyst1D[se].HI.NED<<endl;
	    cout<<"\tRmax = "<<ED[Hyst1D[se].HI.NED].Emax<<"\tRmin = "<<ED[Hyst1D[se].HI.NED].Emin<<endl;
	    cout<<"\tDetrmax = "<<ED[Hyst1D[se].HI.NED].detrmax<<"\tDetrmin = "<<ED[Hyst1D[se].HI.NED].detrmin<<endl;
	    cout<<"NSS = "<<Hyst1D[se].HI.NSS<<endl;
	    cout<<"NPT = "<<Hyst1D[se].HI.NPT<<endl;
	    cout<<"\tPitchmax = "<<PS[Hyst1D[se].HI.NPT].PitchMax<<"\tPitchmin = "<<PS[Hyst1D[se].HI.NPT].PitchMin<<endl;
	    cout<<"\t\t Size of PS["<<Hyst1D[se].HI.NPT<<"].NAH1D = "<<PS[Hyst1D[se].HI.NPT].NAH1D.size()<<endl;
	    cout<<"\t\tNumbers of according 1D hystogramms:\t";
	    for(Int_t su = 0; su<PS[Hyst1D[se].HI.NPT].NAH1D.size(); su++){
	    	    cout<<PS[Hyst1D[se].HI.NPT].NAH1D[su]<<" ";
	        }
	    //Int_t ytr;
	    //cin>>ytr;
	}
	for(Int_t se = 0; se<Hyst2D.size(); se++){
	    cout<<"Hyst1D["<<se<<"]..."<<endl;
	    cout<<"filename "<<Hyst2D[se].HI.filename<<endl;
	    cout<<"X axis is "<<Hyst2D[se].XType<<endl;
	    cout<<"Y axis is "<<Hyst2D[se].YType<<endl;
	    cout<<"NUS = "<<Hyst2D[se].HI.NUS<<endl;
	    for(Int_t U = 0; U<US[Hyst2D[se].HI.NUS].USP.size(); U++){
		cout<<"\tBmore = "<<US[Hyst2D[se].HI.NUS].USP[U].Bmore<<"\tBless = "<<US[Hyst2D[se].HI.NUS].USP[U].Bless<<endl;
	        cout<<"\tLmore = "<<US[Hyst2D[se].HI.NUS].USP[U].Lmore<<"\tLless = "<<US[Hyst2D[se].HI.NUS].USP[U].Lless<<endl;
		cout<<"\taltmore = "<<US[Hyst2D[se].HI.NUS].USP[U].altmore<<"\taltless = "<<US[Hyst2D[se].HI.NUS].USP[U].altless<<endl;
		cout<<"\tRmore = "<<US[Hyst2D[se].HI.NUS].USP[U].Rmore<<"\tRless = "<<US[Hyst2D[se].HI.NUS].USP[U].Rless<<endl;
		cout<<"\t\tNumbers of according 2D hystogramms:\t";
	        for(Int_t su = 0; su<US[Hyst2D[se].HI.NUS].NAH2D.size(); su++){
	    	    cout<<US[Hyst2D[se].HI.NUS].NAH2D[su]<<" ";
	        }
	    }
	    cout<<"NED = "<<Hyst2D[se].HI.NED<<endl;
	    cout<<"\tRmax = "<<ED[Hyst2D[se].HI.NED].Emax<<"\tRmin = "<<ED[Hyst2D[se].HI.NED].Emin<<endl;
	    cout<<"\tDetrmax = "<<ED[Hyst2D[se].HI.NED].detrmax<<"\tDetrmin = "<<ED[Hyst2D[se].HI.NED].detrmin<<endl;
	    cout<<"NSS = "<<Hyst2D[se].HI.NSS<<endl;
	    cout<<"NPT = "<<Hyst2D[se].HI.NPT<<endl;
	    cout<<"\tPitchmax = "<<PS[Hyst2D[se].HI.NPT].PitchMax<<"\tPitchmin = "<<PS[Hyst2D[se].HI.NPT].PitchMin<<endl;
	    cout<<"\t\tNumbers of according 2D hystogramms:\t";
	    for(Int_t su = 0; su<PS[Hyst2D[se].HI.NPT].NAH2D.size(); su++){
	    	    cout<<PS[Hyst2D[se].HI.NPT].NAH2D[su]<<" ";
	        }
	    //Int_t ytr;
	    //cin>>ytr;
	}
    }
}
/*
void OptionParam::SelectParam(int Argc, char* Argv[], Int_t& i, DHBuild& DHB){
    i++;
    while(i<Argc && ((!strcmp(Argv[i],"-AGD")) || (!strcmp(Argv[i],"-BGD")) || (!strcmp(Argv[i],"-LGD")) || (!strcmp(Argv[i],"-LTGD")))){
	if(!strcmp(Argv[i],"-AGD")){DHB.AltNAH.resize(DHB.AltNAH.size()+1);DHB.AltNAH[DHB.AltNAH.size()-1] = Hyst1D.size();Run(Argc, Argv, i, DHB.AltNUS);}else
	if(!strcmp(Argv[i],"-BGD")){DHB.BNAH.resize(DHB.BNAH.size()+1);DHB.BNAH[DHB.BNAH.size()-1] = Hyst1D.size();Run(Argc, Argv, i, DHB.BNUS);}else
	if(!strcmp(Argv[i],"-LGD")){DHB.LNAH.resize(DHB.LNAH.size()+1);DHB.LNAH[DHB.LNAH.size()-1] = Hyst1D.size();Run(Argc, Argv, i, DHB.LNUS);}else
	if(!strcmp(Argv[i],"-LTGD")){DHB.LTNAH.resize(DHB.LTNAH.size()+1);DHB.LTNAH[DHB.LTNAH.size()-1] = Hyst1D.size();Run(Argc, Argv, i, DHB.LTNUS);} //LiveTime
	i++;
    }
}

void OptionParam::DiffHystFunc(int Argc, char* Argv[]){
    Int_t i=0;
    if(debug) cout<<"DiffHyst Function...\n\n";
    while(i<Argc){
	if(!strcmp(Argv[i],"-GS") || !strcmp(Argv[i],"-GeoSelect")) SelectParam(Argc, Argv, i, opt.DH.GEOS);else
	if(!strcmp(Argv[i],"-BS") || !strcmp(Argv[i],"-BSelect")) SelectParam(Argc, Argv, i, opt.DH.BS);else
	if(!strcmp(Argv[i],"-LS") || !strcmp(Argv[i],"-LSelect")) SelectParam(Argc, Argv, i, opt.DH.LS);else
	if(!strcmp(Argv[i],"-C") || !strcmp(Argv[i],"-Count")) SelectParam(Argc, Argv, i, opt.DH.Count);else
	if(!strcmp(Argv[i],"-Z")) opt.DH.Z = true;else
	if(!strcmp(Argv[i],"-Az")) opt.DH.Az = true;
	i++;
    }
}

void OptionParam::PamExpFunc(int Argc, char* Argv[]){
    opt.PX.PamExpOn = true;
    Int_t i = 0;
    while(i<Argc){
	if(!strcmp(Argv[i],"-EO") || !strcmp(Argv[i],"-ExpOnly")){}
	if(!strcmp(Argv[i],"-GS") || !strcmp(Argv[i],"-GeoSelect")){}// SelectParam(Argc, Argv, i, opt.PX.In[opt.PX.In.size()-1].NUS);
	if(!strcmp(Argv[i],"-FN") || !strcmp(Argv[i],"-filename")){
	    if(i+1<Argc){
		opt.PX.In.resize(opt.PX.In.size()+1);
		opt.PX.In[opt.PX.In.size()-1].file = (TString)Argv[i];
		opt.PX.In[opt.PX.In.size()-1].HystName = Argv[i+1];
	    }
	}
    i++;
    }
}
*/