#ifndef option_H
#define option_H

#include <TObject.h>
#include "TString.h"
#include <TH1F.h>
#include <TH2F.h>
#include <TH3F.h>
//#include <PamLevel2.h>

using namespace std;

class OptionParam : public TObject {

public:

OptionParam();
~OptionParam();

/*struct ArraysParam{
    Float_t B;
    Float_t L;
    Float_t Alt;
    Float_t Lon;
    Float_t Lat;
    Float_t LiveTime;
    Float_t DeathTime;
};
*/
struct USparam{
    Double_t altmore;
    Double_t altless;
    Double_t Bmore;
    Double_t Bless;
    Double_t Lmore;
    Double_t Lless;
    Double_t Rmore;
    Double_t Rless;
//    Double_t Pmore;
//    Double_t Pless;
};

struct UserSelect{
    vector<USparam> USP;
    vector<Int_t> NAH1D;
    vector<Int_t> NAH2D;
    vector<Int_t> NAH3D;
    //vector<ArraysParam> AP;
};

struct PitchSelect{
    Float_t PitchMax;
    Float_t PitchMin;
    vector<Int_t> NAH1D;
    vector<Int_t> NAH2D;
    vector<Int_t> NAH3D;
    //vector<Int_t> NAH1D;
    //vector<Int_t> NAH2D;
};
/*
struct Angles{
    vector<Int_t> NUS;
    Int_t NAH;
    Bool_t Mode[10];
};
*/
struct SelectParam{
    Double_t Rmin;
    Double_t Rmax;
    Int_t detrminf;
    Int_t detrmaxf;
    Double_t detrmore;
    Double_t detrless;
    Float_t betamin;
    Float_t betamax;
    Bool_t AC;
    Bool_t Calo;
};

struct SelectionScheme{
    vector<SelectParam> SP;
    Int_t PartType;
    vector<Int_t> NAH1D;
    vector<Int_t> NAH2D; 
    vector<Int_t> NAH3D; 
};

/*
struct GeoDep{
    vector<Int_t> NUS;
    Int_t NAH;
    Int_t Type;
};
*/
struct EnergyDiapason{
    Double_t Emin;
    Double_t Emax;
    Double_t detrmin;
    Double_t detrmax;
    //Int_t NAH;		//Number of Accoding Hystogramm
    //vector<Int_t> NUS;
    //vector<GeoDep> GeDe;
};

struct FullInf{
    ULong_t NEvent;
    ULong_t AbsTime;
    string  UTS;
    Bool_t WT;		// With Track;
};

struct show{
    Bool_t Existed;
    Bool_t Nev;		//Show Number of Events;
    Bool_t ST;		//Show start time;
    Bool_t ET;		//Show end time;
    FullInf FI;		//Show fuul information;
    ULong_t AbsTime;	//Show numbers of events according this time;
    string UTS;		//Show numbers of events according this UTS;
};

struct option{
    //AnglHyst AH;
    //DiffHyst DH;
    //PamEff PE;
    //PamExp PX;
    Bool_t DoTr;
    Int_t verbose;
    //Bool_t ext[5];	//available extensions
    show SP;
    ULong_t Neve;
    Long_t Nverb;
    ULong_t Nstart;
};

Bool_t debug;
option opt;
string outdir;
string workdir;

//struct HystInfo{
//    Bool_t root;
//    Bool_t png;
//    Int_t ExpType;	// 0 - without exposition, 1 LiveTimeOneTrack, 2 DeathTimeOneTrack, 3 LiveTime+DeathTimeOneTrack, 4 liveTimeBetweenLastTrackAndOne, 5 DeathTimeBitweenLastTrackAndOne, 6 LiveTime+DeathTimeBetweenLastTrackAndOne
//};

struct SelectionPointers{
    Int_t NUS;
    Int_t NED;
    Int_t NSS;
    Int_t NPT;
    Int_t TypeExt; //0 - root only; 1 - png only; 2 - Both root and png;
    Int_t ExpType;	// 0 - without exposition, 1 LiveTimeOneTrack, 2 DeathTimeOneTrack, 3 LiveTime+DeathTimeOneTrack, 4 liveTimeBetweenLastTrackAndOne, 5 DeathTimeBitweenLastTrackAndOne, 6 LiveTime+DeathTimeBetweenLastTrackAndOne
    Float_t LieveTime;
    Float_t DeathTime;
    TString filename;
};

struct FileParam1{
    TH1F Hyst1DF;
    TH1F Hyst1DFExp;
    Int_t XType;
    SelectionPointers HI;
};

struct FileParam2{
    TH2F Hyst2DF;
    TH2F Hyst2DFExp;
    Int_t XType;
    Int_t YType;
    SelectionPointers HI;
};

struct FileParam3{
    TH3F Hyst3DF;
    TH1F Hyst3DFExp;
    Int_t XType;
    Int_t YType;
    Int_t ZType;
    Int_t NEI;
    SelectionPointers HI;
};

struct ExpInput{
    char* inputfile;
    char* inputhyst;
};

vector<ExpInput> EffHyst;
vector<FileParam1> Hyst1D;
vector<FileParam2> Hyst2D;
vector<FileParam3> Hyst3D;
vector<UserSelect> US;
vector<PitchSelect> PS;
vector<SelectionScheme> SS;
vector<EnergyDiapason> ED;

Int_t tmpNUS;
Int_t tmpSS;
//vector<Int_t> tmp2;

Double_t CheckDouble(char*, char*);
Int_t CheckInt(char*, char*);
Int_t FindUS(Double_t,Double_t,Double_t,Double_t,Double_t,Double_t,Double_t,Double_t);
Int_t CheckSS(Double_t,Double_t,Int_t,Int_t,Double_t,Double_t,Float_t,Float_t,Bool_t,Bool_t,Int_t);
void SimpleCheck(char*, char*, char*, char*, char*, char*, char*, char*, char*, char*, char*, char*, char*, Int_t);
void CheckBrackets(int Argc, char* Argv[], Int_t&);
//void AnglHystOption(HystInfo&, char*, Int_t, Double_t, Double_t, Int_t, Double_t, Double_t, Bool_t, Bool_t, string, Int_t);
void SetupGeo(Double_t, Double_t, Double_t, Double_t, Double_t, Double_t, Double_t, Double_t, Int_t, Int_t);
void Run(int Argc, char* Argv[],Int_t&);
//void Run(int Argc, char* Argv[],Int_t, Particles&);
//void AnglHystFunc(int Argc, char* Argv[]);
//void FillGeoDep(int Argc, char* Argv[], Int_t&, vector<GeoDep>&);
void CheckAD(int Argc, char* Argv[], Int_t&);
void CheckPitch(int Argc, char* Argv[], Int_t&);
void SetExpOption(int Argc, char* Argv[], Int_t&);
//void ShowSSInfo(vector<SelectScheme>);
void FillSS(SelectParam&, Double_t, Double_t, Int_t, Int_t, Double_t, Double_t, Float_t, Float_t, Bool_t, Bool_t);
void DefaultSelect(Int_t);
void MakeSelectScheme(int Argc, char* Argv[], Int_t&, Int_t);
//void SelectParticleOpt(int Argc, char* Argv[], Int_t&, Int_t, vector<Particles>&);
void MakeHystAxis(int Argc, char* Argv[], Int_t&);
void PamEffFunc(int Argc, char* Argv[]);
//void SelectParam(int Argc, char* Argv[], Int_t&, DHBuild&);
//void DiffHystFunc(int Argc, char* Argv[]);
//void PamExpFunc(int Argc, char* Argv[]);

void helprint();

};

#endif
