

/**
 * \file PamLevel2.h
 * \author Elena Vannuccini
 */
#ifndef pamlevel2_h
#define pamlevel2_h

#include <TClonesArray.h>

#include <TrkLevel2.h>
#include <CaloLevel2.h>
#include <ToFLevel2.h>
#include <TrigLevel2.h>
#include <S4Level2.h>
#include <NDLevel2.h>
#include <AcLevel2.h>

#include <TTree.h>
#include <TFile.h>

#include <iostream>
using namespace std;

/**
 * \brief Class to describe particle tracks in the apparatus, including tracker and track-related variables from other detectors (calorimeter and TOF).
 *
 * This class inherites from TrkTrack, CaloTrkVar ecc... 
 * 
 */
class PamTrack : public TrkTrack, public CaloTrkVar, public ToFTrkVar {

 private:

    TrkTrack*   trk_track;
    CaloTrkVar* calo_track;
    ToFTrkVar*  tof_track;

 public:

    PamTrack();

    PamTrack(TrkTrack* , CaloTrkVar* , ToFTrkVar* );

    ClassDef(PamTrack,1);
};

/**
 * \brief Class to describe PAMELA LEVEL2 data.
 *
 * This class inherites from TrkLevel2, CaloLevel2 ecc... and it overrides the TrkLevel2:GetTrack(int it) and TrkLevel2:GetTrackImage(int it) methods. 
 * This allows to solve the tracker ambiguity (that is, to choose between track images) by using also information from other detectors.
 */
		
class PamLevel2 : public CaloLevel2, public TrkLevel2, public ToFLevel2, public TrigLevel2, public S4Level2, public NDLevel2, public AcLevel2 {

 private:

    TrkLevel2*  trk_obj;
    CaloLevel2* calo_obj;
    ToFLevel2*  tof_obj;
    TrigLevel2* trig_obj;
    S4Level2*   s4_obj;
    NDLevel2*   nd_obj;
    AcLevel2*   ac_obj;
    
 public:

    PamLevel2();

    TrkLevel2*  GetTrkLevel2()  {return trk_obj;};
    CaloLevel2* GetCaloLevel2() {return calo_obj;};
    ToFLevel2*  GetToFLevel2()  {return tof_obj;};
    TrigLevel2* GetTrigLevel2() {return trig_obj;};
    S4Level2* GetS4Level2() {return s4_obj;};
    NDLevel2* GetNDLevel2() {return nd_obj;};
    AcLevel2* GetAcLevel2() {return ac_obj;};
    
//  =================================
//  methods needed to ... well I am not shure they are needed
//  =================================
    void*       GetPointerToTrk()  {return &trk_obj;};
    void*       GetPointerToCalo() {return &calo_obj;};
    void*       GetPointerToToF()  {return &tof_obj;};
    void*       GetPointerToTrig() {return &trig_obj;};
    void*       GetPointerToS4() {return &s4_obj;};
    void*       GetPointerToND() {return &nd_obj;};
    void*       GetPointerToAc() {return &ac_obj;};

    TTree* LoadPamTrees(TFile*);
    
    
//  =================================
//  methods to retrieve pamela tracks
//  =================================
    PamTrack*     GetStoredTrack(Int_t itrk);
    TClonesArray* GetTracks();
    PamTrack*     GetTrack(int);
    PamTrack*     GetTrackImage(int);
    ClassDef(PamLevel2,1);
};

//===============================================================================================
//
//
//
//
//===============================================================================================


#endif

