//////////////////////////////////////////////////////////
// Selection of events with single good tracks 
// (good fit, no albedo) with non-interacting pattern
// in the calorimeter.
//////////////////////////////////////////////////////////
#if !defined(__CINT__) || defined(__MAKECINT__)

#include <TString.h>
#include <TH1F.h>
#include <TH2F.h>
#include <TMath.h>
#include <TLine.h>
#include <TPolyMarker.h>
#include <TSelector.h>
#include <TFile.h>

#include <stdlib.h>
#include <iostream>
using namespace std;

#include <PamLevel2.h>
#include <CaloAxis.h>

#endif


//===============================================================================
//
//
//
//
//===============================================================================
Bool_t IsHit(TString what , AcLevel2* ac){

    char* cabl[] = {"CARD4","CAT2","CAS1","ND","CARD2","CAT4","CAS4","ND",
		    "CARD3","CAT3","CAS3","ND","CARD1","CAT1","CAS2","ND"};

    Bool_t answer = kFALSE;
    for(Int_t ibit=0; ibit<16; ibit++){
	if( what.Contains( cabl[ibit], TString::kIgnoreCase ) ){
	    if( what.Contains( "M" , TString::kIgnoreCase ) )
		answer = (Bool_t)((ac->hitmap[0]>>ibit)&1) & (Bool_t)((ac->hitstatus[0]>>ibit)&1);
	    else if( what.Contains( "E" , TString::kIgnoreCase ) )
		answer = (Bool_t)((ac->hitmap[1]>>ibit)&1) & (Bool_t)((ac->hitstatus[1]>>ibit)&1);
	    else cout << " M-ain or E-xtra not indicated" << endl;
	    return answer;
	};
    };
    cout << " wrong input "<< what << endl;
    return answer;

}

//===============================================================================
//
//
//
//
//===============================================================================
bool Select( PamLevel2* event ){

//  -----------------------------------------
//  +++++++++++++++++++++++++++++++++++++++++
//  GENERAL SELECTION CUTS
//  +++++++++++++++++++++++++++++++++++++++++
//  -----------------------------------------

    //  ------------
    //  single track
    //  ------------
    if( event->GetTrkLevel2()->GetNTracks()!=1 ) return false; 

    //  ------------
    //  calorimeter
    //  ------------
    
    //  ---------------------------
    //  one hit paddle on S1 S2 S3
    //  no single-PMT hits
    //  ---------------------------
    if(
	event->GetToFLevel2()->GetNHitPaddles(0) == 1 &&
	event->GetToFLevel2()->GetNHitPaddles(1) == 1 &&
	event->GetToFLevel2()->GetNHitPaddles(2) == 1 &&
	event->GetToFLevel2()->GetNHitPaddles(3) == 1 &&
	event->GetToFLevel2()->GetNHitPaddles(4) == 1 &&
	event->GetToFLevel2()->GetNHitPaddles(5) == 1 &&
	event->GetToFLevel2()->npmt() == 12           && 
	true
	){;;;
    }else return false;

    //  ----------------------------------------------
    //  no activity either in main and spare AC boards 
    //  ----------------------------------------------
    AcLevel2* ac = event->GetAcLevel2();
    if( IsHit("CARD1-M",ac) || IsHit("CARD1-E",ac) )return false;
    if( IsHit("CARD2-M",ac) || IsHit("CARD2-E",ac) )return false;
    if( IsHit("CARD3-M",ac) || IsHit("CARD3-E",ac) )return false;
    if( IsHit("CARD4-M",ac) || IsHit("CARD4-E",ac) )return false;

    if( IsHit("CAT1-M",ac) || IsHit("CAT1-E",ac) )return false;
    if( IsHit("CAT2-M",ac) || IsHit("CAT2-E",ac) )return false;
    if( IsHit("CAT3-M",ac) || IsHit("CAT3-E",ac) )return false;
    if( IsHit("CAT4-M",ac) || IsHit("CAT4-E",ac) )return false;

    if( IsHit("CAS1-M",ac) || IsHit("CAS1-E",ac) )return false;
    if( IsHit("CAS2-M",ac) || IsHit("CAS2-E",ac) )return false;
    if( IsHit("CAS3-M",ac) || IsHit("CAS3-E",ac) )return false;
    if( IsHit("CAS4-M",ac) || IsHit("CAS4-E",ac) )return false;


//  -----------------------------------------
//  +++++++++++++++++++++++++++++++++++++++++
//  TRACK SELECTION CUTS
//  +++++++++++++++++++++++++++++++++++++++++
//  -----------------------------------------

    //  -------------------
    //  tracker:
    //  - good fit
    //  - nx>=4 ny>=3
    //  - 5-plane lever-arm
    //  tof:
    //  - beta>0
    //  calorimeter:
    //  - non interacting
    //  -------------------
    PamTrack *track = event->GetTrack(0);
    bool TRACK__OK = false;
    if( 
	track->GetTrkTrack()->chi2 >0    &&
	track->GetTrkTrack()->GetNX()>=4 &&
	track->GetTrkTrack()->GetNY()>=3 &&
	((track->GetTrkTrack()->XGood(0) && track->GetTrkTrack()->XGood(5)) || (track->GetTrkTrack()->XGood(0) && track->GetTrkTrack()->XGood(4)) || (track->GetTrkTrack()->XGood(1) && track->GetTrkTrack()->XGood(5)) )  &&
	track->GetToFTrack()->beta[12]>0 && 	
	true
	){
	
	if(event->GetCaloLevel2()->qtot>0){
	    if(track->GetCaloTrack()->qtrack/event->GetCaloLevel2()->qtot <0.8)TRACK__OK = false;
	}

	TRACK__OK = true;
    };

    if(!TRACK__OK)return false;
    
    return true;

}
