////////////////////////////////////////////////////////////////
//
//  Histogram set for tracker-efficiency study.
//
//  It contains the functions:
//
//  - CreateHistos()
//  - FillHistos(PamLevel2* event)
//  - Save Histos()
//
//  Usage (example):
//  [] .L My-histo-set-macro.C+
//  [] .L My-selection.C+
//  [] .L Loop.C+
//  [] Loop("data-dir/","file-list.txt",100000,"+ALL fillTree fillHistos","output-file.root")
//  
////////////////////////////////////////////////////////////////

#if !defined(__CINT__) || defined(__MAKECINT__)

#include <TString.h>
#include <TH1F.h>
#include <TH2F.h>
#include <TMath.h>
#include <TLine.h>
#include <TPolyMarker.h>
#include <TSelector.h>
#include <TFile.h>

#include <stdlib.h>
#include <iostream>
using namespace std;

#include <PamLevel2.h>
#include <CaloAxis.h>

#endif
//======================
// HITOGRAMS declaration
//======================
TH1F *hresangx;
TH1F *hresangy;
//===============================================================
// Create histograms
//===============================================================
void CreateHistos( PamLevel2* event, TFile* outf ){

    gROOT->cd();//create histos in memory

    hresangx = new TH1F("hresangx","Angular residual on the top calo plane (x)",400,-40.,40.);
    hresangy = new TH1F("hresangy","Angular residual on the top calo plane (y)",400,-40.,40.);

}

//===============================================================
// Fill histograms (called event-by-event)
//===============================================================
 
void FillHistos( PamLevel2* event ){
//  ----------------------------------
//  retrieve histos
//  ----------------------------------
//     hresangx = dynamic_cast<TH1F*>(gDirectory->FindObject("hresangx"));
//     hresangy = dynamic_cast<TH1F*>(gDirectory->FindObject("hresangy"));


     float caloangx = 0;
     float caloangy = 0;

     CaloStrip top = CaloStrip();
     top.Set(0,0,48);
     float zcalotop = top.GetZ();



//  ----------------------------------
//  tracker variables
//  ----------------------------------

    float resangx = -999;
    float resangy = -999;
    if( event->GetTrkLevel2()->GetNTracks()==1 ){
	
	PamTrack *track = event->GetTrack(0);
	if( track->GetTrkTrack()->chi2 >0  ){

	    Float_t ztraj[13];
	    
	    Int_t i=0;
	    ztraj[i++] = event->GetToFLevel2()->GetZTOF(11);
	    ztraj[i++] = event->GetToFLevel2()->GetZTOF(12);
	    ztraj[i++] = event->GetToFLevel2()->GetZTOF(21);
	    ztraj[i++] = event->GetToFLevel2()->GetZTOF(22);
	    ztraj[i++] = event->GetTrkLevel2()->GetZTrk(1);
	    ztraj[i++] = event->GetTrkLevel2()->GetZTrk(2);
	    ztraj[i++] = event->GetTrkLevel2()->GetZTrk(3);
	    ztraj[i++] = event->GetTrkLevel2()->GetZTrk(4);
	    ztraj[i++] = event->GetTrkLevel2()->GetZTrk(5);
	    ztraj[i++] = event->GetTrkLevel2()->GetZTrk(6);
	    ztraj[i++] = event->GetToFLevel2()->GetZTOF(31);
	    ztraj[i++] = event->GetToFLevel2()->GetZTOF(32);
	    ztraj[i++] = zcalotop;
	    Trajectory traj = Trajectory(13,ztraj);
	    traj.DoTrack2( track->GetTrkTrack()->al );
	    
	    resangx = caloangx - traj.thx[12];
	    resangy = caloangy - traj.thy[12];

	}
    }
    
//  ----------------------------------
//  fill histograms
//  ----------------------------------
    hresangx->Fill(resangx);
    hresangy->Fill(resangy);


}
//===============================================================
// Save histograms
//===============================================================
void SaveHistos( TFile * outf ){

    gROOT->cd();
//  ----------------------------------
//  retrieve histos
//  ----------------------------------
//     hresangx = dynamic_cast<TH1F*>(gDirectory->FindObject("hresangx"));
//     hresangy = dynamic_cast<TH1F*>(gDirectory->FindObject("hresangy"));

//  ----------------------------------
//  save on file
//  ----------------------------------

    outf->cd();
    
    if(hresangx) hresangx->Write();
    if(hresangy) hresangy->Write();
}

