#if !defined(__CINT__) || defined(__MAKECINT__)


#include <TString.h>
#include <TH1F.h>
#include <TH2F.h>
#include <TMath.h>
#include <TLine.h>
#include <TPolyMarker.h>
#include <TSelector.h>
#include <TFile.h>

#include <stdlib.h>
#include <iostream>
using namespace std;

#include <PamLevel2.h>
#include <CaloAxis.h>

#endif


//===============================================================================
//
//
//
//
//===============================================================================
Bool_t IsHit(TString what , AcLevel2* ac){

    char* cabl[] = {"CARD4","CAT2","CAS1","ND","CARD2","CAT4","CAS4","ND",
		    "CARD3","CAT3","CAS3","ND","CARD1","CAT1","CAS2","ND"};

    Bool_t answer = kFALSE;
    for(Int_t ibit=0; ibit<16; ibit++){
	if( what.Contains( cabl[ibit], TString::kIgnoreCase ) ){
	    if( what.Contains( "M" , TString::kIgnoreCase ) )
		answer = (Bool_t)((ac->hitmap[0]>>ibit)&1) & (Bool_t)((ac->hitstatus[0]>>ibit)&1);
	    else if( what.Contains( "E" , TString::kIgnoreCase ) )
		answer = (Bool_t)((ac->hitmap[1]>>ibit)&1) & (Bool_t)((ac->hitstatus[1]>>ibit)&1);
	    else cout << " M-ain or E-xtra not indicated" << endl;
	    return answer;
	};
    };
    cout << " wrong input "<< what << endl;
    return answer;

}

//===============================================================================
//
//
//
//
//===============================================================================
void Dump(AcLevel2* ac){

    cout << "status[0]  :"<< hex << ac->status[0] <<endl;
    cout << "status[1]  :"<< hex << ac->status[1] <<endl;
    cout << "hitmap[0]  :"<< hex << ac->hitmap[0] <<endl;
    cout << "hitmap[1]  :"<< hex << ac->hitmap[1] <<endl;
    cout << "hitstatus[0]  :"<< hex << ac->hitstatus[0] <<endl;
    cout << "hitstatus[1]  :"<< hex << ac->hitstatus[1] <<endl;
    cout << "trigger[0]  :"<< hex << ac->trigger[0] <<endl;
    cout << "trigger[1]  :"<< hex << ac->trigger[1] <<endl;

}
void Dump(ToFTrkVar* tof){

    cout << endl<< "n. tdc hits :"<<tof->npmttdc;
    cout << endl<< "PMTs        :";
    for(Int_t ip=0; ip< tof->npmttdc; ip++)cout << " "<< tof->pmttdc[ip];
    cout << endl<< "n. adc hits :"<<tof->npmtadc;
    cout << endl<< "PMTs        :";
    for(Int_t ip=0; ip< tof->npmtadc; ip++)cout << " "<< tof->pmtadc[ip];
    cout << endl<< "dedx        :";
    for(Int_t ib=0; ib< tof->npmtadc; ib++)cout << " "<< tof->dedx[ib];
    cout << endl<< "beta        :";
    for(Int_t ib=0; ib<13 ; ib++)cout << " "<< tof->beta[ib];
    cout << endl<< "xtofpos     :";
    for(Int_t ib=0; ib<3 ; ib++)cout << " "<< tof->xtofpos[ib];
    cout << endl<< "ytofpos     :";
    for(Int_t ib=0; ib<3 ; ib++)cout << " "<<tof->ytofpos[ib];
    cout << endl;
}


//===============================================================================
//
//
//
//
//===============================================================================
bool Select( PamLevel2* event ){


    if(event->ntrk() ==0 )return false;

//  cout << event->nstrip << " "<<event->npmt() << " " << event->ntrk()<<endl; 
//  -----------------------------------------
//  +++++++++++++++++++++++++++++++++++++++++
//              CALORIMETER CUTS
//  +++++++++++++++++++++++++++++++++++++++++
//  -----------------------------------------
    
//     CaloAxis *x_axis = new CaloAxis();
//     CaloAxis *y_axis = new CaloAxis();

//     if(event->nstrip<60){

// 	// --------------------------------
// 	// evaluate track axis 
// 	// --------------------------------
// 	float rcil = 1.;// tolerance (cm)
// 	if( !x_axis->FitAxis(event->GetCaloLevel1(),0,rcil) )return 0;
// 	if( !y_axis->FitAxis(event->GetCaloLevel1(),1,rcil) )return 0;

// 	if(x_axis->GetN()<4 || y_axis->GetN()<4)return 0;

// 	float qtrack = x_axis->GetQaxis()+y_axis->GetQaxis();
// 	int   ntrack = x_axis->GetN()+y_axis->GetN();

// 	float qstrip = qtrack/ntrack;

// 	// --------------------------------
// 	// evaluate total energy release
// 	// --------------------------------
//  	float qtot   = 0;
//  	int   ntot   = 0;
// 	qtot = event->qtot;
// 	ntot = event->nstrip;


// 	float nratio = 0;
// 	float qratio = 0;
// 	if(ntot>0){
// 	    nratio = (float)ntrack/(float)ntot;
// 	    qratio = qtrack/qtot;
// 	}

// //	cout << qtrack << " " << ntrack << " "<< qtot << " "<<ntot<<endl;
// 	if(qratio < 0.8)return false;
	
//     }else return false;

//     x_axis->Delete();
//     y_axis->Delete();

//  -----------------------------------------
//  +++++++++++++++++++++++++++++++++++++++++
//                  TOF CUTS
//  +++++++++++++++++++++++++++++++++++++++++
//  -----------------------------------------

    //  ---------------------------
    //  one hit paddle on S1 and S2
    //  ---------------------------
//     if(
// 	event->GetNHitPaddles(0) == 1 &&
// 	event->GetNHitPaddles(1) == 1 &&
// 	event->GetNHitPaddles(2) == 1 &&
// 	event->GetNHitPaddles(3) == 1 &&
// 	event->GetNHitPaddles(4) == 1 &&
// 	event->GetNHitPaddles(5) == 1 &&
// 	true
// 	){;;;
//     }else return false;

//  -----------------------------------------
//  +++++++++++++++++++++++++++++++++++++++++
//                  AC CUTS
//  +++++++++++++++++++++++++++++++++++++++++
//  -----------------------------------------
//     AcLevel2* ac = event->GetAcLevel2();

//     if( IsHit("CARD1-M",ac) || IsHit("CARD1-E",ac) )return false;
//     if( IsHit("CARD2-M",ac) || IsHit("CARD2-E",ac) )return false;
//     if( IsHit("CARD3-M",ac) || IsHit("CARD3-E",ac) )return false;
//     if( IsHit("CARD4-M",ac) || IsHit("CARD4-E",ac) )return false;

//     if( IsHit("CAT1-M",ac) || IsHit("CAT1-E",ac) )return false;
//     if( IsHit("CAT2-M",ac) || IsHit("CAT2-E",ac) )return false;
//     if( IsHit("CAT3-M",ac) || IsHit("CAT3-E",ac) )return false;
//     if( IsHit("CAT4-M",ac) || IsHit("CAT4-E",ac) )return false;

//     if( IsHit("CAS1-M",ac) || IsHit("CAS1-E",ac) )return false;
//     if( IsHit("CAS2-M",ac) || IsHit("CAS2-E",ac) )return false;
//     if( IsHit("CAS3-M",ac) || IsHit("CAS3-E",ac) )return false;
//     if( IsHit("CAS4-M",ac) || IsHit("CAS4-E",ac) )return false;
    
     return true;

}






