////////////////////////////////////////////////////////////////
//
//  Histogram set for tracker-efficiency study.
//
//  It contains the functions:
//
//  - CreateHistos()
//  - FillHistos(PamLevel2* event)
//  - Save Histos()
//
//  Usage (example):
//  [] .L My-histo-set-macro.C+
//  [] .L My-selection.C+
//  [] .L Loop.C+
//  [] Loop("data-dir/","file-list.txt",100000,"+ALL fillTree fillHistos","output-file.root")
//  
////////////////////////////////////////////////////////////////

#if !defined(__CINT__) || defined(__MAKECINT__)

#include <TString.h>
#include <TH1F.h>
#include <TH2F.h>
#include <TMath.h>
#include <TLine.h>
#include <TPolyMarker.h>
#include <TSelector.h>
#include <TFile.h>

#include <stdlib.h>
#include <iostream>
using namespace std;

#include <PamLevel2.h>
#include <CaloAxis.h>

#endif
//======================
// HITOGRAMS declaration
//======================
TH1F *hresangx;
TH1F *hresangy;
//===============================================================
// Create histograms
//===============================================================
void CreateHistos( TFile* outf ){

    gROOT->cd();//create histos in memory

    hresangx = new TH1F("hresangx","Angular residual on the top calo plane (x)",400,-40.,40.);
    hresangy = new TH1F("hresangy","Angular residual on the top calo plane (y)",400,-40.,40.);

}

//===============================================================
// Fill histograms (called event-by-event)
//===============================================================
 
void FillHistos( PamLevel2* event ){
//  ----------------------------------
//  retrieve histos
//  ----------------------------------
//     hresangx = dynamic_cast<TH1F*>(gDirectory->FindObject("hresangx"));
//     hresangy = dynamic_cast<TH1F*>(gDirectory->FindObject("hresangy"));

//  ----------------------------------
//  calo variables
//  ----------------------------------
//     CaloAxis *x_axis = new CaloAxis();
//     CaloAxis *y_axis = new CaloAxis();

//     float rcil = 1.;// tolerance (cm)
//     x_axis->FitAxis(event->GetCaloLevel1(),0,rcil);
//     y_axis->FitAxis(event->GetCaloLevel1(),1,rcil);

//     float qtrack = x_axis->GetQaxis()+y_axis->GetQaxis();
//     int   ntrack = x_axis->GetN()+y_axis->GetN();    
    
//     float caloangx = (float)atan((double)x_axis->par[1])*180./3.1415026;
//     float caloangy = (float)atan((double)y_axis->par[1])*180./3.1415026;

     float caloangx = 0;
     float caloangy = 0;

     CaloStrip top = CaloStrip();
     top.Set(0,0,48);
     float zcalotop = top.GetZ();

//  ----------------------------------
//  tof variables
//  ----------------------------------
//  get track stored by the tof    
//     ToFTrkVar *tof = event->GetToFStoredTrack(-1);
//     if(!tof){
// 	cout << " no ToF-track stored "<<endl;
// 	return;
//     }

//  ----------------------------------
//  tracker variables
//  ----------------------------------

    float resangx = -999;
    float resangy = -999;
    if( event->GetNTracks()==1 ){
	
	PamTrack *track = event->GetTrack(0);
	if( track->chi2 >0  ){

	    Float_t ztraj[13];
	    
	    Int_t i=0;
	    ztraj[i++] = event->GetZTOF(11);
	    ztraj[i++] = event->GetZTOF(12);
	    ztraj[i++] = event->GetZTOF(21);
	    ztraj[i++] = event->GetZTOF(22);
	    ztraj[i++] = event->GetZTrk(1);
	    ztraj[i++] = event->GetZTrk(2);
	    ztraj[i++] = event->GetZTrk(3);
	    ztraj[i++] = event->GetZTrk(4);
	    ztraj[i++] = event->GetZTrk(5);
	    ztraj[i++] = event->GetZTrk(6);
	    ztraj[i++] = event->GetZTOF(31);
	    ztraj[i++] = event->GetZTOF(32);
	    ztraj[i++] = zcalotop;
	    Trajectory traj = Trajectory(13,ztraj);
	    traj.DoTrack2( track->al );
	    
	    resangx = caloangx - traj.thx[12];
	    resangy = caloangy - traj.thy[12];

	}
	if(track) delete track;
    }
    
//  ----------------------------------
//  fill histograms
//  ----------------------------------
    hresangx->Fill(resangx);
    hresangy->Fill(resangy);


}
//===============================================================
// Save histograms
//===============================================================
void SaveHistos( TFile * outf ){

    gROOT->cd();
//  ----------------------------------
//  retrieve histos
//  ----------------------------------
//     hresangx = dynamic_cast<TH1F*>(gDirectory->FindObject("hresangx"));
//     hresangy = dynamic_cast<TH1F*>(gDirectory->FindObject("hresangy"));

//  ----------------------------------
//  save on file
//  ----------------------------------

    outf->cd();
    
    if(hresangx) hresangx->Write();
    if(hresangy) hresangy->Write();
}

