
#if !defined(__CINT__) || defined(__MAKECINT__)


// ROOT includes //
#include <TString.h>
#include <TH1F.h>
#include <TH2F.h>

// standard libraries includes //
#include <stdlib.h>
#include <iostream>
//#include <fstream>
#include <iomanip>
using namespace std;

// PAMELA includes //
#include <PamLevel2.h>

#endif

//======================
// global variables
//======================
Int_t tot=0;
Int_t sel[]={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

TrkLevel2  *trkl2   = 0;
CaloLevel2 *calol2  = 0;
ToFLevel2  *tofl2   = 0;
TrigLevel2 *trigl2  = 0;
AcLevel2   *acl2    = 0;

//======================
// HISTOGRAMS declaration
//======================

TH2F* hxytof[6];

void Dump(ToFTrkVar* tof){
 
    cout << endl<< "n. tdc hits :"<<tof->npmttdc;
    cout << endl<< "PMTs        :";
    for(Int_t ip=0; ip< tof->npmttdc; ip++)cout << " "<< tof->pmttdc[ip];
    cout << endl<< "n. adc hits :"<<tof->npmtadc;
    cout << endl<< "PMTs        :";
    for(Int_t ip=0; ip< tof->npmtadc; ip++)cout << " "<< tof->pmtadc[ip];
    cout << endl<< "dedx        :";
    for(Int_t ib=0; ib< tof->npmtadc; ib++)cout << " "<< tof->dedx[ib];
    cout << endl<< "beta        :";
    for(Int_t ib=0; ib<13 ; ib++)cout << " "<< tof->beta[ib];
    cout << endl<< "xtofpos     :";
    for(Int_t ib=0; ib<3 ; ib++)cout << " "<< tof->xtofpos[ib];
    cout << endl<< "ytofpos     :";
    for(Int_t ib=0; ib<3 ; ib++)cout << " "<<tof->ytofpos[ib];
    cout <<endl<<"============================================="<<endl;
    
}


void Dump(ToFLevel2* l2){
    cout<<"ToF event: "<<l2->npmt()<<" hit PMTs"<<endl;
    cout<<" id      name  plane paddle    pmt    adc    tdc"<<endl;
    for(int ip=0; ip<l2->npmt(); ip++){
	Int_t iplane  = -1;
	Int_t ipaddle = -1;
	Int_t ipmt    = -1;
//	cout << l2->GetToFPMT(ip) << endl;
	Int_t id      = l2->GetToFPMT(ip)->pmt_id; 
	float adc = l2->GetToFPMT(ip)->adc;
	float tdc = l2->GetToFPMT(ip)->tdc_tw; // temporaneo
	cout <<setw(3)<<id<< setw(10) << l2->GetPMTName(id,iplane,ipaddle,ipmt) << setw(7) << iplane << setw(7)<< ipaddle << setw(7) << ipmt << setw(7) << adc << setw(7) << tdc <<endl;
    }
    cout <<"============================================="<<endl;

}

void Dump(TrigLevel2* l2){
    cout << "Trigger Configuration (hex): " << hex;
    cout << l2->trigconf << endl;
    cout <<"============================================="<<endl;
    cout << "Trigger Pattern (hex): " << hex;
    for(int i=0; i<6; i++)cout << setw(5) << l2->patterntrig[i];
    cout << dec << endl;
    cout <<"============================================="<<endl;
}

void EvaluatePatternTrig(UInt_t *patterntrig, ToFLevel2* l2){
    
//    TString photoS[48] = {
//      "S11_1A", "S11_1B", "S11_2A", "S11_2B", "S11_3A", "S11_3B", "S11_4A",
//      "S11_4B",
//      "S11_5A", "S11_5B", "S11_6A", "S11_6B", "S11_7A", "S11_7B", "S11_8A",
//      "S11_8B",
//      "S12_1A", "S12_1B", "S12_2A", "S12_2B", "S12_3A", "S12_3B", "S12_4A",
//      "S12_4B", "S12_5A",  "S12_5B", "S12_6A", "S12_6B",
//      "S21_1A", "S21_1B", "S21_2A", "S21_2B",
//      "S22_1A", "S22_1B", "S22_2A", "S22_2B",
//      "S31_1A", "S31_1B", "S31_2A", "S31_2B", "S31_3A", "S31_3B",
//      "S32_1A", "S32_1B", "S32_2A", "S32_2B", "S32_3A", "S32_3B"
//    }; 
// patterntrig(3) --> S3 [49 to 38] 12 bits: (S32b,S32a,S31b,S31a)
// patterntrig(4) --> S2 [37 to 30] 8 bits: (S22b,S22a,S21b,S21a)
// patterntrig(5) --> S12 [29 to 18] 12 bits: (S12b,S12a)
// patterntrig(6) --> S11 [17 to 2] 16 bits: (S11b,S11a)

//   UInt_t patterntrig[6];
   for(int i=0; i<6; i++)*(patterntrig+i)=0;

   UInt_t  word[]={
       5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5, //S11
       4,4,4,4,4,4,4,4,4,4,4,4,         //S12
       3,3,3,3,3,3,3,3,                 //S2
       2,2,2,2,2,2,2,2,2,2,2,2          //S3
   }; 
   UInt_t  bit[] ={
       0,8,1,9,2,10,3,11,4,12,5,13,6,14,7,15, //S11
       0,6,1,7,2,8,3,9,4,10,5,11,             //S12
       0,2,1,3,4,6,5,7,                       //S2
       0,3,1,4,2,5,6,9,7,10,8,11              //S3       
   }; 
   
    for(int ip=0; ip<l2->npmt(); ip++){
	Int_t iplane  = -1;
	Int_t ipaddle = -1;
	Int_t ipmt    = -1;
//	cout << l2->GetToFPMT(ip) << endl;
	Int_t id      = l2->GetToFPMT(ip)->pmt_id; 
	float tdc = l2->GetToFPMT(ip)->tdc_tw; // temporaneo
	
	if(tdc<4095) *(patterntrig+word[id]) = *(patterntrig+word[id]) | (UInt_t)(pow(2.,(float)bit[id]));
       
    }

   


}

//===============================================================================
//
//
//
//
//===============================================================================
bool Select( PamLevel2* event ){
//    return false;
    TrkParams::SetVerboseMode();

    //-------------------------------------------
    // check if the event contains selection info
    //-------------------------------------------
    if( event->GetTrkLevel2()==0 ){
	cout << "Missing TrkLevel2 object "<<endl;
	return false;
    }
    if( event->GetToFLevel2()==0 ){
	cout << "Missing ToFLevel2 object "<<endl;
	return false;
    }
    if( event->GetCaloLevel2()==0 ){
	cout << "Missing CaloLevel2 object "<<endl;
	return false;
    }
    if( event->GetTrigLevel2()==0 ){
	cout << "Missing TrigLevel2 object "<<endl;
	return false;
    }
    if( event->GetAcLevel2()==0 ){
	cout << "Missing AcLevel2 object "<<endl;
	return false;
    }
    if( event->GetRunInfo()==0 ){
	cout << "Missing RunInfo object "<<endl;
	return false;
    }

    trkl2   = event->GetTrkLevel2();
    calol2  = event->GetCaloLevel2();
    tofl2   = event->GetToFLevel2();
    trigl2  = event->GetTrigLevel2();
    acl2    = event->GetAcLevel2();

    tot++;


    //------------------------------------------------------------------
    // Orbital selection 
    //------------------------------------------------------------------
    bool ORB__OK = false;
    if(
	event->GetOrbitalInfo()->Babs>0.22 && //outside SSA
	true ) ORB__OK = true;
    if( !ORB__OK )return false;
    sel[0]++;

    //---------------------------------------------------------
    // trigger configuration: TOF 1 (standard)
    //---------------------------------------------------------
    bool trigg_patt_ok = false;
    if ( trigl2->trigconf & (1<<0) ) trigg_patt_ok = true;
    if(!trigg_patt_ok)return false;
    sel[1]++;
    
    //---------------------------------------------------------
    // single track
    //---------------------------------------------------------
    if( trkl2->GetNTracks()!=1 ) return false; // singola traccia (fisica)
    event->SetSortingMethod("+CAL");     // usa solo l'info del calorimetro per scegliere l'immagine
    PamTrack *track = event->GetTrack(0);// qui viene scelta l'"immagine" fisica
//    if( track->GetScore() <=0 )cout << " >>> Strange track <<< P-score "<< track->GetPScore() << " I-score "<<track->GetIScore()<<endl;

    if(!track)return false;

    //----------------------------------------------------------
    //  (CHI**2 standard) 
    //----------------------------------------------------------
    float p0 = 1.111588e+00;
    float p1 = 1.707656e+00;
    float p2 = 1.489693e-01;
    float def_0      = 0.07;
    float chi2m025_0 = p0 + fabs(def_0)*p1 + def_0*def_0*p2;

    //------------------------------------------------------------------
    // tracker pre-selection
    //------------------------------------------------------------------
    TrkTrack *trk = track->GetTrkTrack();

    float chi2m025 = p0 + fabs(trk->GetDeflection())*p1 + trk->GetDeflection()*trk->GetDeflection()*p2;
    float chi2m = pow( chi2m025-chi2m025_0+pow(6.4,0.25), 4.);

    bool TRACK__OK = false;
    if( 
//	trk->chi2 >0     &&
	trk->GetNX()>=4  &&
	trk->GetNY()>=3  &&
	trk->GetLeverArmX()>=5 &&
	trk->GetRigidity()> 4. && // unit: GV
	trk->GetDEDX()<3. && // unit: dE/dX for Z=1 MIP
	trk->IsInsideCavity() &&
	trk->chi2 < chi2m && 
	true ) TRACK__OK = true;

    if( !TRACK__OK )return false;
    
    sel[2]++;


    //------------------------------------------------------------------
    // AC
    //------------------------------------------------------------------
    if( acl2->IsHit("CARD1-M") || acl2->IsHit("CARD1-E") )return false;
    if( acl2->IsHit("CARD2-M") || acl2->IsHit("CARD2-E") )return false;
    if( acl2->IsHit("CARD3-M") || acl2->IsHit("CARD3-E") )return false;
    if( acl2->IsHit("CARD4-M") || acl2->IsHit("CARD4-E") )return false;

    if( acl2->IsHit("CAT1-M") || acl2->IsHit("CAT1-E") )return false;
    if( acl2->IsHit("CAT2-M") || acl2->IsHit("CAT2-E") )return false;
    if( acl2->IsHit("CAT3-M") || acl2->IsHit("CAT3-E") )return false;
    if( acl2->IsHit("CAT4-M") || acl2->IsHit("CAT4-E") )return false;

//     if( acl2->IsHit("CAS1-M") || acl2->IsHit("CAS1-E") )return false;
//     if( acl2->IsHit("CAS2-M") || acl2->IsHit("CAS2-E") )return false;
//     if( acl2->IsHit("CAS3-M") || acl2->IsHit("CAS3-E") )return false;
//     if( acl2->IsHit("CAS4-M") || acl2->IsHit("CAS4-E") )return false;
    sel[3]++;



    //------------------------------------------------------------------
    // CALORIMETER
    //------------------------------------------------------------------
    bool NONINT=false;
    if(
	track->GetCaloTrack()->qtrack / event->GetCaloLevel2()->qtot > 0.85 &&       
	true)NONINT=true;
    
    if(!NONINT)return false;
    sel[4]++;
    

    return true;
    

}
//===============================================================
// Create histograms
//
//
//
//
//
//===============================================================
void CreateHistos( PamLevel2* event , TFile* outf ){
    cout << "Creating histos..."<<endl;
    gROOT->cd();//create histos in memory
    TString hid;
    TString title;

    //--------------------------------
    // histos
    //--------------------------------
    for(Int_t i=0; i<6; i++){
	hid.Form("hxytof%i",i);
	title.Form("Track coordinates on ToF plane %i",i);
	hxytof[i] = new TH2F(hid.Data(),title.Data(),6000,-30.,30.,6000,-30.,30.);
    }

    //--------------------------------
    // initialization
    //--------------------------------
    cout << "Opening DB connection..."<<endl;
    event->SetDBConnection();

}
//===============================================================
// Retrieve histograms
//
//
//
//
//
//===============================================================
void RetrieveHistos(){

    gROOT->cd();
    TString hid;

    for(Int_t i=0; i<6; i++){
	hid.Form("hxytof%i",i);
	hxytof[i] = dynamic_cast<TH2F*>(gDirectory->FindObject(hid.Data()));
    }

}
//===============================================================
// Get histograms (... non ho capito la differenza con retrieve)
//
//
//
//
//
//===============================================================
void GetHistos(){

    TString hid;
}
//===============================================================
// Fill histograms (called event-by-event)
//
//
//
//
//
//
//=============================================================== 
void FillHistos( PamLevel2* event ){
//  ----------------------------------
//  retrieve histos
//  ----------------------------------
    RetrieveHistos();


//  ---------------------------------
//  Retrieve the track
//  ---------------------------------
    PamTrack  *track = event->GetTrack(0);
    TrkTrack  *trk   = track->GetTrkTrack();
    ToFTrkVar *tof   = track->GetToFTrack();

//     cout << track->GetTrkTrack()->GetRigidity() << endl;
//     cout << track->GetToFTrack()->beta[12] << endl;
//     cout << track->GetCaloTrack()->qcyl << endl;

//  ---------------------------------------------
//  track coordinates esxtrapolated on tof planes
//  ---------------------------------------------
    float ytof[6],xtof[6];
    for( int i=0; i<6; i++) ytof[i] = tof->ytr_tof[i];
    for( int i=0; i<6; i++) xtof[i] = tof->xtr_tof[i];

    for( int i=0; i<6; i++) hxytof[i]->Fill(xtof[i],ytof[i]);

    Dump(event->GetToFLevel2());
    Dump(event->GetTrigLevel2());
    UInt_t patterntrig[6];
    EvaluatePatternTrig(patterntrig, event->GetToFLevel2());
    cout << "TDC-Pattern:     "<<hex;
    for(int i=0; i<6; i++)cout << setw(5) << patterntrig[i];
    cout << dec << endl;
    cout <<"============================================="<<endl;
    Dump(tof);
    
        
}
//===============================================================
// Save histograms
//
//
//
//
//
//===============================================================
void SaveHistos( TFile * outf ){

TString hid; 

gROOT->cd();
//  ----------------------------------
//  retrieve histos
//  ----------------------------------
    RetrieveHistos();

//  ----------------------------------
//  save on file
//  ----------------------------------
    outf->cd();

    for(Int_t i=0; i<6; i++)hxytof[i]->Write();

    cout << "####------------------------------------------------------------------" <<endl;
    cout << "#### pre-selected :"<<tot<<endl;
    if(!tot)return;
    cout << "#### orbital            :"<<sel[0]<< "  (" << ((float)sel[0]/(float)tot) <<")"<<endl;
    cout << "#### trigger configuration            :"<<sel[1]<< "  (" << ((float)sel[1]/(float)tot) <<")"<<endl;
    cout << "#### tracker            :"<<sel[2]<< "  (" << ((float)sel[2]/(float)tot) <<")"<<endl;
    cout << "#### AC                 :"<<sel[3]<< "  (" << ((float)sel[3]/(float)tot) <<")"<<endl;
    cout << "#### calo (non-int)     :"<<sel[4]<< "  (" << ((float)sel[4]/(float)tot) <<")"<<endl;
    cout << "####------------------------------------------------------------------" <<endl;

}
