

/**
 * \file PamLevel2.h
 * \author Elena Vannuccini
 */
#ifndef pamlevel2_h
#define pamlevel2_h

#include <TRefArray.h>

#include <TrkLevel1.h>
#include <TrkLevel2.h>
#include <TrkHough.h>
#include <CaloLevel1.h>
#include <CaloLevel2.h>
#include <ToFLevel2.h>
#include <TrigLevel2.h>
#include <S4Level2.h>
#include <NDLevel2.h>
#include <AcLevel2.h>
#include <OrbitalInfo.h>
#include <OrbitalInfo.h>
#include <RunInfo.h>
#include <GLTables.h>


#include <TTree.h>
#include <TFriendElement.h>
#include <TChain.h>
#include <TFile.h>
#include <TList.h>
#include <TKey.h>
#include <TSystemFile.h>
#include <TSystemDirectory.h>

#include <iostream>
using namespace std;

/**
 * \brief Class to describe particle tracks in the apparatus, including tracker and track-related variables from other detectors (calorimeter and TOF).
 *
 * This class inherites from TrkTrack, CaloTrkVar ecc... 
 * 
 */
class PamTrack : public TrkTrack, public CaloTrkVar, public ToFTrkVar {

 private:

    TrkTrack*   trk_track;
    CaloTrkVar* calo_track;
    ToFTrkVar*  tof_track;

 public:

    PamTrack();

    PamTrack(TrkTrack* , CaloTrkVar* , ToFTrkVar* );

    TrkTrack* GetTrkTrack(){return trk_track;};
    CaloTrkVar* GetCaloTrack(){return calo_track;};
    ToFTrkVar* GetToFTrack(){return tof_track;};

    ClassDef(PamTrack,1);
};

/**
 * \brief Class to describe PAMELA LEVEL2 data.
 *
 * This class inherites from TrkLevel2, CaloLevel2 ecc... and it overrides the TrkLevel2:GetTrack(int it) and TrkLevel2:GetTrackImage(int it) methods. 
 * This allows to solve the tracker ambiguity (that is, to choose between track images) by using also information from other detectors.
 */
		
class PamLevel2 : public CaloLevel2, public CaloLevel1, public ToFLevel2, public TrkLevel2, public TrkLevel1, public TrkHough, public TrigLevel2, public S4Level2, public NDLevel2, public AcLevel2, public OrbitalInfo {

 private:
 public:

    TrkLevel1*   trk1_obj;
    TrkLevel2*   trk2_obj;
    TrkHough*    trkh_obj;

    CaloLevel1*  calo1_obj;
    CaloLevel2*  calo2_obj;

    ToFLevel2*   tof_obj;
    TrigLevel2*  trig_obj;
    S4Level2*    s4_obj;
    NDLevel2*    nd_obj;
    AcLevel2*    ac_obj;
    OrbitalInfo* orb_obj;
	
    GL_RUN*      run_obj;
    
/*     TrkLevel1*   trk1_clone; */
/*     TrkLevel2*   trk2_clone; */
/*     TrkHough*    trkh_clone; */

/*     CaloLevel1*  calo1_clone; */
/*     CaloLevel2*  calo2_clone; */

/*     ToFLevel2*   tof_clone; */
/*     TrigLevel2*  trig_clone; */
/*     S4Level2*    s4_clone; */
/*     NDLevel2*    nd_clone; */
/*     AcLevel2*    ac_clone; */
/*     OrbitalInfo* orb_clone; */

/*     TTree*       T_clone; //tracker */
/*     TTree*       C_clone; //calo */
/*     TTree*       O_clone; //tof */
/*     TTree*       R_clone; //trigger */
/*     TTree*       S_clone; //s4 */
/*     TTree*       A_clone; //anti */
/*     TTree*       N_clone; //nd */
/*     TTree*       B_clone; //orbital */

    TTree*       tree_clone[8];

    TRefArray*   sorted_tracks; 
	
    Bool_t CAL2; //level2 branch
    Bool_t CAL1; //level1 branch

    Bool_t TRK2; //level2 branch
    Bool_t TRK1; //level1 branch
    Bool_t TRKh; //hough branch

    Bool_t TRG;
    Bool_t TOF;
    Bool_t S4;
    Bool_t ND;
    Bool_t AC;
    Bool_t ORB;

    Bool_t RUN;
	 
    PamLevel2();
    ~PamLevel2();
	
    void Clear();

/*     TrkLevel1*   GetTrkLevel1()  { return trk1_obj;  }; */
/*     TrkLevel2*   GetTrkLevel2()  { return trk2_obj;  }; */
/*     TrkHough*    GetTrkHough()   { return trkh_obj;  }; */
/*     CaloLevel1*  GetCaloLevel1() { return calo1_obj; }; */
/*     CaloLevel2*  GetCaloLevel2() { return calo2_obj; }; */
/*     ToFLevel2*   GetToFLevel2()  { return tof_obj;  }; */
/*     TrigLevel2*  GetTrigLevel2() { return trig_obj; }; */
/*     S4Level2*    GetS4Level2()   { return s4_obj;   }; */
/*     NDLevel2*    GetNDLevel2()   { return nd_obj;   }; */
/*     AcLevel2*    GetAcLevel2()   { return ac_obj;   }; */
/*     OrbitalInfo* GetOrbitalInfo(){ return orb_obj;  }; */
/*     TrkLevel1*   GetTrkLevel1()  { return ; }; */
/*     TrkLevel2*   GetTrkLevel2()  { return TrkLevel2::GetTrkLevel2(); }; */
/*     TrkHough*    GetTrkHough()   { return TrkHough::GetTrkHough(); }; */
/*     CaloLevel1*  GetCaloLevel1() { return CaloLevel1::GetCaloLevel1(); }; */
/*     CaloLevel2*  GetCaloLevel2() { return CaloLevel2::GetCaloLevel2(); }; */
/*     ToFLevel2*   GetToFLevel2()  { return ToFLevel2::GetToFLevel2(); }; */
/*     TrigLevel2*  GetTrigLevel2() { return TrigLevel2::GetTrigLevel2(); }; */
/*     S4Level2*    GetS4Level2()   { return S4Level2::GetS4Level2(); }; */
/*     NDLevel2*    GetNDLevel2()   { return NDLevel2::GetNDLevel2(); }; */
/*     AcLevel2*    GetAcLevel2()   { return AcLevel2::GetAcLevel2(); }; */
/*     OrbitalInfo* GetOrbitalInfo(){ return OrbitalInfo::GetOrbitalInfo(); }; */
    GL_RUN*      GetRunInfo()    { return run_obj; };
	
//  =========================================
//  methods needed to read/write Level2 trees
//  =========================================
    void    SetWhichTrees(TString);
    void    GetWhichTrees(TFile*);

    TTree*  GetPamTree(TFile*,TString);
    TTree*  GetPamTree(TFile* f){return GetPamTree(f,"");};

    TList*  GetListOfLevel2Files(TString, TString);
    Bool_t  CheckLevel2File(TString);
    TChain* GetPamTree(TList*,TString);
    TChain* GetPamTree(TString ddir,TString list,TString detlist){ return GetPamTree(GetListOfLevel2Files(ddir,list),detlist); };
    TChain* GetPamTree(TString ddir,TString list){ return GetPamTree(GetListOfLevel2Files(ddir,list),""); };

    TTree*  GetRunTree(TFile*);
    TChain* GetRunTree(TList*);

    void    CreateCloneTrees0(TChain *fChain, TFile* file);
    void    CreateCloneTrees(TFile* file);
    void    FillCloneTrees();
    TTree  *GetCloneTree(TString);
    void    WriteCloneTrees();

    void    SetBranchAddress(TTree *);
    void    SetBranchAddress(TChain *);

//  =====================================
//  methods needed to set brach addresses
//  =====================================
/*     void*       GetPointerToTrk(); */
/*     void*       GetPointerToTrk(int s); */
/*     void*       GetPointerToCalo(); */
/*     void*       GetPointerToCalo(int s); */
/*     void*       GetPointerToToF(); */
/*     void*       GetPointerToTrig(); */
/*     void*       GetPointerToS4(); */
/*     void*       GetPointerToND(); */
/*     void*       GetPointerToAc(); */
/*     void*       GetPointerToOrb(); */
/*     void*       GetPointerToRun(); */
    void*       GetPointerTo(const char*);

//  ==============================================
//  methods to retrieve subdetectors stored tracks
//  ==============================================
    TrkTrack*   GetTrkStoredTrack(int seqno){return TrkLevel2::GetStoredTrack(seqno); };
    CaloTrkVar* GetCaloStoredTrack(int);
    ToFTrkVar*  GetToFStoredTrack(int);
    //
    PamTrack*   GetPamTrackAlong(TrkTrack*);
//	PamTrack*   GetPamTrackAlong(CaloTrkVar*);      //se serve
//	PamTrack*   GetPamTrackAlong(ToFTrkVar*);      //se serve
	
//  =================================
//  methods to retrieve pamela tracks
//  =================================
    PamTrack*     GetStoredTrack(Int_t);
    //
    void          SortTracks(TString);          //assign value to variable sorted_tracks
    TRefArray*    GetTracks();                  //return sorted_tracks
    PamTrack*     GetTrack(int);
    PamTrack*     GetTrackImage(int);
	
//  =================================
//  other methods
//  =================================
    Int_t ntrk(){ return TrkLevel2::ntrk(); };


    ClassDef(PamLevel2,1);
};

//===============================================================================================
//
//
//
//
//===============================================================================================


#endif

