#ifndef DIGITIZER_H
#define DIGITIZER_H

#include <iostream>
#include <fstream>


#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "Riostream.h"
#include "TFile.h"
#include "TDirectory.h"
#include "TTree.h"
#include "TLeafI.h"
#include "TH1.h"
#include "TH2.h"
#include "TF1.h"
#include "TMath.h"
#include "TSQLServer.h"
#include "TGraph.h"
#include "GLTables.h"
#include "TSystem.h"
#include "TRandom.h"

#include "CRC.h"
#include <CalibCalPedEvent.h>
#include "CalibTrk1Event.h"
#include "CalibTrk2Event.h"

class Digitizer{

 protected:

    // in and output data members

    TTree* fhBookTree;
    ofstream fOutputfile;
    int *nspe;
    int *ntof;
    int *ncat;
    int *ncas;
    int *ncar;
    int *ncal;
    int *nnd;
    int *nstr;

    static const int fPSCUbuffer = 8;
    static const int fTRIGGERbuffer = 152; //(bytes)
    static const int fTOFbuffer = 276;     //(bytes)
    static const int fACbuffer = 128;
    static const int fNDbuffer = 6;
    static const int fS4buffer = 3;
    static const int fPADbuffer = 64;  // changed from 32!
    static const int fCALObuffer = 10000;
    static const float fCALOGeV2MIPratio = 0.0001059994;

    static const int fDummybuffer = 64;

    //  dimensions of vectors and buffer, parameter for tracker
    static const int fTRACKbuffer = 50000; // to be optimized
    static const int fNviews = 12;
    static const int fNstrips_view = 3072;
    static const int fNladder=3;
    static const int fNstrips_ladder = 1024;
    static const int fCutzop= 4;
    static const int fCutclu= 7;
    static const int fNclst = 2;
    
    
    static const float fAvePedex = 1200.; // to be adjusted
    static const float fSigmaPedex = 1.;  // to be adjusted
    static const float fAveSigmax = 4.3;  // to be adjusted
    static const float fSigmaSigmax =0.1;  // to be adjusted
    static const float fAvePedey = 2800.; // to be adjusted
    static const float fSigmaPedey = 1.;  // to be adjusted
    static const float fAveSigmay = 8.;  // to be adjusted
    static const float fSigmaSigmay =0.1;  // to be adjusted
    static const float fSigmaCommon = 25.; // to be adjusted
  
  
    //  end dimensions of vectors and buffer, parameter for tracker

    UShort_t fDataPSCU[fPSCUbuffer];
    UInt_t fCounter;
    UInt_t fCounterPhys;
    UInt_t fOBT;

    UShort_t fDataPadding[fPADbuffer];
    UInt_t fPadding;

    UChar_t fDataTrigger[fTRIGGERbuffer];
    UChar_t fDataTof[fTOFbuffer];

    UShort_t fDataAC[fACbuffer];
    UShort_t fDataND[fNDbuffer];
    UShort_t fDataS4[fS4buffer];
    UShort_t fDataDummy[fDummybuffer];

    UShort_t fDataCALO[fCALObuffer];
    UShort_t fSecCalo[4];
    UShort_t fSecCALOLength[4];
    UShort_t fCALOlength;
    UShort_t fModCalo;
    Float_t fCalomip[2][22][96]; // ADC to MIP conversion values
    Float_t fcalped[4][11][96]; // pedestals
    Float_t fcalgood[4][11][96]; // used or not in the common noise calculation
    Float_t fcalthr[4][11][6]; // thresholds
    Float_t fcalrms[4][11][96]; // rms
    Float_t fcalbase[4][11][6]; // baselines (common noise) during calibration
    Float_t fcalvar[4][11][6]; // variance
    Float_t fcstwerr[4]; // status word
    Float_t fcperror[4]; // unpacking error flag
    UInt_t fGivenCaloCalib;

    char* fFilename;
    UInt_t fLen;
   


    //  vectors, buffer, and variables for tracker
    UShort_t fDataTrack[fTRACKbuffer];
    UInt_t   fTracklength; //  Actual length of buffer 
    Float_t  fPedeTrack[fNviews][fNstrips_view];
    Float_t  fSigmaTrack[fNviews][fNstrips_view];
//    UShort_t  fBadTrack[fNviews][fNstrips_view];
    Float_t  fMipCor[fNladder][fNviews] ;
    // end vectors, buffer, and variables for tracker 



    //
    // db variables
    //
    TSQLServer *fDbc;
    // Declaration of leave types
    Int_t           Irun;
    Int_t           Ievnt;
    Int_t           Ipa;
    Float_t         X0;
    Float_t         Y0;
    Float_t         Z0;
    Float_t         Theta;
    Float_t         Phi;
    Float_t         P0;
    Int_t           Nthtof;
    UChar_t         *Ipltof;
    UChar_t         *Ipaddle;
    //    UChar_t         *Ipartof;//DPMJET
    UShort_t        *Ipartof;
    Float_t         *Xintof;
    Float_t         *Yintof;
    Float_t         *Zintof;
    Float_t         *Xouttof;
    Float_t         *Youttof;
    Float_t         *Zouttof;
    Float_t         *Ereltof;
    Float_t         *Timetof;
    Float_t         *Pathtof;
    Float_t         *P0tof;
    Int_t           Nthcat;
    UChar_t         *Iparcat;
    UChar_t         *Icat;
    Float_t         *Xincat;
    Float_t         *Yincat;
    Float_t         *Zincat;
    Float_t         *Xoutcat;
    Float_t         *Youtcat;
    Float_t         *Zoutcat;
    Float_t         *Erelcat;
    Float_t         *Timecat;
    Float_t         *Pathcat;
    Float_t         *P0cat;
    Int_t           Nthcas;
    UChar_t         *Iparcas;
    UChar_t         *Icas;
    Float_t         *Xincas;
    Float_t         *Yincas;
    Float_t         *Zincas;
    Float_t         *Xoutcas;
    Float_t         *Youtcas;
    Float_t         *Zoutcas;
    Float_t         *Erelcas;
    Float_t         *Timecas;
    Float_t         *Pathcas;
    Float_t         *P0cas;
    Int_t           Nthspe;
    //    UChar_t         *Iparspe;//DPMJET
    //    UShort_t        *Iparspe;
    UChar_t         *Itrpb;
    UChar_t         *Itrsl;
    UChar_t         *Itspa;
    Float_t         *Xinspe;
    Float_t         *Yinspe;
    Float_t         *Zinspe;
    Float_t         *Xoutspe;
    Float_t         *Youtspe;
    Float_t         *Zoutspe;
    Float_t         *Xavspe;
    Float_t         *Yavspe;
    Float_t         *Zavspe;
    Float_t         *Erelspe;
    Float_t         *Pathspe;
    Float_t         *P0spe;
    UChar_t         *Nxmult;
    UChar_t         *Nymult;
    Int_t           Nstrpx;
    UChar_t         *Npstripx;
    UChar_t         *Ntstripx;
    UShort_t        *Istripx;
    Float_t         *Qstripx;
    Float_t         *Xstripx;
    Int_t           Nstrpy;
    UChar_t         *Npstripy;
    UChar_t         *Ntstripy;
    UShort_t        *Istripy;
    Float_t         *Qstripy;
    Float_t         *Ystripy;
    Int_t           Nthcali;
    UChar_t         Icaplane[4224];
    UChar_t         Icastrip[4224];
    Int_t           Icamod[4224];
    Float_t         Enestrip[4224];
    Int_t           Nthcal;
    UChar_t         *Icapl;
    UChar_t         *Icasi;
    UChar_t         *Icast;
    Float_t         *Xincal;
    Float_t         *Yincal;
    Float_t         *Zincal;
    Float_t         *Erelcal;
    Int_t           Nthnd;
    UChar_t         *Itubend;
    UChar_t         *Iparnd;
    Float_t         *Xinnd;
    Float_t         *Yinnd;
    Float_t         *Zinnd;
    Float_t         *Xoutnd;
    Float_t         *Youtnd;
    Float_t         *Zoutnd;
    Float_t         *Erelnd;
    Float_t         *Timend;
    Float_t         *Pathnd;
    Float_t         *P0nd;
    Int_t           Nthcard;
    UChar_t         *Iparcard;
    UChar_t         *Icard;
    Float_t         *Xincard;
    Float_t         *Yincard;
    Float_t         *Zincard;
    Float_t         *Xoutcard;
    Float_t         *Youtcard;
    Float_t         *Zoutcard;
    Float_t         *Erelcard;
    Float_t         *Timecard;
    Float_t         *Pathcard;
    Float_t         *P0card;

    // List of branches
    TBranch        *b_Irun;   //!
    TBranch        *b_Ievnt;   //!
    TBranch        *b_Ipa;   //!
    TBranch        *b_X0;   //!
    TBranch        *b_Y0;   //!
    TBranch        *b_Z0;   //!
    TBranch        *b_Theta;   //!
    TBranch        *b_Phi;   //!
    TBranch        *b_P0;   //!
    TBranch        *b_Nthtof;   //!
    TBranch        *b_Ipltof;   //!
    TBranch        *b_Ipaddle;   //!
    TBranch        *b_Ipartof;   //!
    TBranch        *b_Xintof;   //!
    TBranch        *b_Yintof;   //!
    TBranch        *b_Zintof;   //!
    TBranch        *b_Xouttof;   //!
    TBranch        *b_Youttof;   //!
    TBranch        *b_Zouttof;   //!
    TBranch        *b_Ereltof;   //!
    TBranch        *b_Timetof;   //!
    TBranch        *b_Pathtof;   //!
    TBranch        *b_P0tof;   //!
    TBranch        *b_Nthcat;   //!
    TBranch        *b_Iparcat;   //!
    TBranch        *b_Icat;   //!
    TBranch        *b_Xincat;   //!
    TBranch        *b_Yincat;   //!
    TBranch        *b_Zincat;   //!
    TBranch        *b_Xoutcat;   //!
    TBranch        *b_Youtcat;   //!
    TBranch        *b_Zoutcat;   //!
    TBranch        *b_Erelcat;   //!
    TBranch        *b_Timecat;   //!
    TBranch        *b_Pathcat;   //!
    TBranch        *b_P0cat;   //!
    TBranch        *b_Nthcas;   //!
    TBranch        *b_Iparcas;   //!
    TBranch        *b_Icas;   //!
    TBranch        *b_Xincas;   //!
    TBranch        *b_Yincas;   //!
    TBranch        *b_Zincas;   //!
    TBranch        *b_Xoutcas;   //!
    TBranch        *b_Youtcas;   //!
    TBranch        *b_Zoutcas;   //!
    TBranch        *b_Erelcas;   //!
    TBranch        *b_Timecas;   //!
    TBranch        *b_Pathcas;   //!
    TBranch        *b_P0cas;   //!
    TBranch        *b_Nthspe;   //!
    TBranch        *b_Iparspe;   //!
    TBranch        *b_Itrpb;   //!
    TBranch        *b_Itrsl;   //!
    TBranch        *b_Itspa;   //!
    TBranch        *b_Xinspe;   //!
    TBranch        *b_Yinspe;   //!
    TBranch        *b_Zinspe;   //!
    TBranch        *b_Xoutspe;   //!
    TBranch        *b_Youtspe;   //!
    TBranch        *b_Zoutspe;   //!
    TBranch        *b_Xavspe;   //!
    TBranch        *b_Yavspe;   //!
    TBranch        *b_Zavspe;   //!
    TBranch        *b_Erelspe;   //!
    TBranch        *b_Pathspe;   //!
    TBranch        *b_P0spe;   //!
    TBranch        *b_Nxmult;   //!
    TBranch        *b_Nymult;   //!
    TBranch        *b_Nstrpx;   //!
    TBranch        *b_Npstripx;   //!
    TBranch        *b_Ntstripx;   //!
    TBranch        *b_Istripx;   //!
    TBranch        *b_Qstripx;   //!
    TBranch        *b_Xstripx;   //!
    TBranch        *b_Nstrpy;   //!
    TBranch        *b_Npstripy;   //!
    TBranch        *b_Ntstripy;   //!
    TBranch        *b_Istripy;   //!
    TBranch        *b_Qstripy;   //!
    TBranch        *b_Ystripy;   //!
    TBranch        *b_Nthcali;   //!
    TBranch        *b_Icaplane;   //!
    TBranch        *b_Icastrip;   //!
    TBranch        *b_Icamod;   //!
    TBranch        *b_Enestrip;   //!
    TBranch        *b_Nthcal;   //!
    TBranch        *b_Icapl;   //!
    TBranch        *b_Icasi;   //!
    TBranch        *b_Icast;   //!
    TBranch        *b_Xincal;   //!
    TBranch        *b_Yincal;   //!
    TBranch        *b_Zincal;   //!
    TBranch        *b_Erelcal;   //!
    TBranch        *b_Nthnd;   //!
    TBranch        *b_Itubend;   //!
    TBranch        *b_Iparnd;   //!
    TBranch        *b_Xinnd;   //!
    TBranch        *b_Yinnd;   //!
    TBranch        *b_Zinnd;   //!
    TBranch        *b_Xoutnd;   //!
    TBranch        *b_Youtnd;   //!
    TBranch        *b_Zoutnd;   //!
    TBranch        *b_Erelnd;   //!
    TBranch        *b_Timend;   //!
    TBranch        *b_Pathnd;   //!
    TBranch        *b_P0nd;   //!
    TBranch        *b_Nthcard;   //!
    TBranch        *b_Iparcard;   //!
    TBranch        *b_Icard;   //!
    TBranch        *b_Xincard;   //!
    TBranch        *b_Yincard;   //!
    TBranch        *b_Zincard;   //!
    TBranch        *b_Xoutcard;   //!
    TBranch        *b_Youtcard;   //!
    TBranch        *b_Zoutcard;   //!
    TBranch        *b_Erelcard;   //!
    TBranch        *b_Timecard;   //!
    TBranch        *b_Pathcard;   //!
    TBranch        *b_P0card;   //!
    //
    TF1 *attenAC;
 public: 

    Digitizer(TTree*,char*&,int,int,int,int,int,int,int,int); // constructor

    void Close();
    void SetTree(TTree *tree) {fhBookTree = tree;};
    void Loop();  // does the looping over events
 
    void DigitizePSCU(UInt_t, UChar_t, UShort_t*);  // digitizes the CPU header
    void AddPadding();
    void DigitizeTOF(int np,float *atte1,float *atte2,float *lambda1,float *lambda2);  // digitizes the tof
    void LoadTOFCalib(int np,float *atte1,float *atte2,float *lambda1,float *lambda2); //load TOF calibration
    void DigitizeAC();  // digitizes the anti-counter
    void DigitizeND();  // digitizes the ND
    void DigitizeS4();  // digitizes the S4
    void DigitizeCALO();  // digitizes the calorimeter
    void DigitizeCALOCALIB();  // digitizes the calorimeter calibration
    void DigitizeCALORAW();  // digitizes the calorimeter
    void DigitizeCALOCOMPRESS();  // digitizes the calorimeter
    void DigitizeCALOFULL();  // digitizes the calorimeter

    Float_t GetCALOen(Int_t sec, Int_t plane, Int_t strip); // retrieve calorimeter strip energy from the simulation
    void ClearCaloCalib(Int_t s); // clear calorimeter calibration variables for section s
    Int_t CaloLoadCalib(Int_t s,TString fcalname, UInt_t calibno); // load calorimeter calibration variables for section s from file fcalname entry calibno
    void CaloLoadCalib();

    void DigitizeDummy(); // digitizes the dummy detector

    // ToF methods:
    UChar_t EvaluateCrcTof(UChar_t*);
    void Paddle2Pmt(Int_t, Int_t, Int_t*, Int_t*);
    //void Paddle2Pmt(Int_t, Int_t, Int_t &pmtleft, Int_t &pmtright);
    UChar_t Bin2GrayTof(UChar_t, UChar_t);
    void Crc8Tof(UChar_t*, UChar_t*);

    UChar_t EvaluateCrcTrigger(UChar_t*, Int_t);

    UShort_t* GetDataAC(){return(fDataAC);}; // retrieve AC data (not used right now)

    UShort_t* GetDataCALO(){return(fDataCALO);}; // retrieve AC data (not used right now)

    //  methods for Tracker
    void DigitizeTrack(); // digitizes the Tracker data
    void DigitizeTrackCalib(Int_t ii); // digitizes the Tracker calibration (x view or y view)
    void WriteTrackCalib();  // writes Tracker calibration to file
    void ClearTrackCalib(); // clear tracker calibration 
    void LoadTrackCalib(); // load in memmory tracker calibration 
    void CompressTrackData(Float_t AdcTrack[fNviews][fNstrips_view]); // Compress and Digitize data of one Ladder in turn
    void LoadMipCor(); // Load the strip calibration in memory 
    Float_t SaturationTrackx(Float_t ADC); // Saturation simulation
    Float_t SaturationTracky(Float_t ADC); // Saturation simulation
    //  end methods for Tracker

    void WriteData(); // writes data to file
    void ReadData();

    //

};

#endif /* DIGITIZER_H */



