DROP DATABASE IF EXISTS dbname;

CREATE DATABASE dbname;

USE dbname;

SET time_zone='+0:00';

CREATE TABLE `_RUNID_GEN` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  PRIMARY KEY  (`ID`)
) ENGINE=InnoDB;

CREATE TABLE `GL_RAW` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `PATH` varchar(255) NOT NULL default '',
  `NAME` varchar(255) NOT NULL default '',
  `BOOT_NUMBER` smallint(5) unsigned default NULL,
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID`),
  KEY `BOOTNUMBER_index` (`BOOT_NUMBER`),
  KEY `PATH_index` (`PATH`)
) ENGINE=InnoDB;

INSERT INTO GL_RAW VALUES(0,'$PAM_L2','level2 files',NULL,NULL);

CREATE TABLE `GL_ROOT` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_RAW` int(10) unsigned NOT NULL default '0',
  `ID_TIMESYNC` int(10) unsigned NOT NULL default '0',
  `PATH` varchar(255) NOT NULL default '',
  `NAME` varchar(255) NOT NULL default '',
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID`),
  KEY `ID_RAW_index` (`ID_RAW`),
  KEY `PATH_index` (`PATH`),
  CONSTRAINT `ROOT_fk` FOREIGN KEY (`ID_RAW`) REFERENCES `GL_RAW` (`ID`) ON DELETE CASCADE
) ENGINE=InnoDB;

CREATE TABLE `GL_RESURS_OFFSET` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `FROM_ORBIT` int(10) unsigned NOT NULL default '0',
  `SPECIAL_FILE` varchar(255) NOT NULL default '',
  `OFFSET_DATE` timestamp default '0000-00-00 00:00:00',
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID`)
) ENGINE=InnoDB;

INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','','2006-06-14 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'1619','','2006-09-28 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'2797','','2006-12-12 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'3221','','2007-01-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','04584_002_001_cln1.pam','2007-01-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','04584_003_001_cln1.pam','2007-01-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','04586_002_001_cln1.pam','2007-01-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','04586_003_001_cln1.pam','2007-01-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'4576','','2007-04-08 21:00:00',NULL);

CREATE TABLE `GL_TIMESYNC` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_RAW` int(10) unsigned NOT NULL default '0',
  `OBT0` int(10) unsigned NOT NULL default '0',
  `TIMESYNC` int(10) unsigned NOT NULL default '0',
  `TYPE` smallint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  KEY `ID_RAW_index` (`ID_RAW`),
  KEY `TYPE_index` (`TYPE`),
  CONSTRAINT `TIME_RAW_fk` FOREIGN KEY (`ID_RAW`) REFERENCES `GL_RAW` (`ID`) ON DELETE CASCADE
) ENGINE=InnoDB;

CREATE TABLE `GL_PARAM` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `PATH` varchar(255) NOT NULL default '',
  `NAME` varchar(255) NOT NULL default '',
  `FROM_TIME` int(10) unsigned NOT NULL default '0',
  `TO_TIME` int(10) unsigned NOT NULL default '0',
  `TYPE` smallint(5) unsigned NOT NULL default '0',
  `DESCR` varchar(255) NOT NULL default '',
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID`),
  KEY `PATH_index` (`PATH`),
  KEY `NAME_index` (`NAME`),
  KEY `TYPE_index` (`TYPE`),
  KEY `DESCR_index` (`DESCR`)
) ENGINE=InnoDB;

insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","field_param-0/",0,0,1,"field",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mip_param-0/",0,0,2,"trk mip",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","charge_param-1/",0,0,3,"trk charge",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","eta_param-0/",0,0,4,"trk pfa",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","align_param-0/",0,0,5,"trk alignment",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-1/",0,0,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","default_calib/",0,0,7,"default calibration",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloADC2MIP-dws2000.dat",1,1,101,"Calorimeter ADC to MIP from flight data dw serie 2000",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloADC2MIP.dat",1,1,101,"Calorimeter ADC to MIP from ground data",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloADC2MIPfc.dat",2,4294967295,101,"Calorimeter ADC to MIP from flight, relativistic particles",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloAlign.dat",1,1,102,"Calorimeter alignement",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloAlign-flight.dat",1,1,102,"Calorimeter alignement with flight data",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloAlign-flightEMS.dat",2,4294967295,102,"Calorimeter alignement with flight data EM showers",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloBadMask.dat",0,0,103,"Calorimeter bad strip offline mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloDefaultCalib.root",0,0,104,"Calorimeter default calibration",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_standard.rz",1,1153659999,201," Default tof param from flight data",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_july_24-31.rz",1153660000,1154375000,201," tof param from flight data 24th-31th July 2006",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_standard.rz",1154375001,1155849999,201," Default tof param from flight data",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_aug_18-22.rz",1155850000,1156280000,201," tof param from flight data 18th-22nd August 2006",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_standard.rz",1156280001,1168498999,201," Default tof param from flight data",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_jan_11-16.rz",1168499000,1168942000,201, " tof param from flight data 11th-16th January 2007",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_standard.rz",1168942001,4294967295,201," Default tof param from flight data",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/orb-param/","igrf05.dat",0,0,301,"igrf 2005",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/orb-param/","igrf05s.dat",0,0,302,"igrf 2010",NULL);

CREATE TABLE `GL_TLE` (
  `ID` int(10) NOT NULL auto_increment,
  `TLE1` varchar(255) NOT NULL default '',
  `TLE2` varchar(255) NOT NULL default '',
  `TLE3` varchar(255) NOT NULL default '',
  `FROM_TIME` datetime NOT NULL default '0000-00-00 00:00:00',
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID`)
) ENGINE=InnoDB;

CREATE TABLE `GL_RUN` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_RUN_FRAG` int(10) unsigned NOT NULL default '0',
  `ID_ROOT_L0` int(10) unsigned NOT NULL default '0',
  `ID_ROOT_L2` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_TIME` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_TIME` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_OBT` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_OBT` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_PKT` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_PKT` int(10) unsigned NOT NULL default '0',
  `BOOT_NUMBER` smallint(5) unsigned NOT NULL default '0',
  `EV_FROM` int(10) unsigned NOT NULL default '0',
  `EV_TO` int(10) unsigned NOT NULL default '0',
  `NEVENTS` int(10) unsigned NOT NULL default '0',
  `PKT_COUNTER` int(10) unsigned NOT NULL default '0',
  `PKT_READY_COUNTER` int(10) unsigned NOT NULL default '0',
  `COMPILATIONTIMESTAMP` int(10) unsigned NOT NULL default '0',
  `FAV_WRK_SCHEDULE` tinyint(3) unsigned NOT NULL default '0',
  `EFF_WRK_SCHEDULE` tinyint(3) unsigned NOT NULL default '0',
  `PRH_VAR_TRG_MODE_A` int(10) unsigned NOT NULL default '0',
  `PRH_VAR_TRG_MODE_B` int(10) unsigned NOT NULL default '0',
  `ACQ_BUILD_INFO` int(10) unsigned NOT NULL default '0',
  `ACQ_VAR_INFO` smallint(5) unsigned NOT NULL default '0',
  `RM_ACQ_AFTER_CALIB` tinyint(3) NOT NULL default '0',	  
  `RM_ACQ_SETTING_MODE` tinyint(3) NOT NULL default '0',
  `TRK_CALIB_USED` int(10) unsigned NOT NULL default '0',
  `CAL_DSP_MASK` tinyint(3) unsigned NOT NULL default '0',
  `LAST_TIMESYNC` int(10) unsigned NOT NULL default '0',
  `OBT_TIMESYNC` int(10) unsigned NOT NULL default '0',
  `VALIDATION` tinyint(3) unsigned NOT NULL default '0',
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID`),
  KEY `ID_RUN_FRAG_index` (`ID_RUN_FRAG`),
  KEY `ID_ROOT_L0_index` (`ID_ROOT_L0`),
  KEY `ID_ROOT_L2_index` (`ID_ROOT_L2`),
  KEY `COMPILATIONTS_index` (`COMPILATIONTIMESTAMP`),
  KEY `VALID_index` (`VALIDATION`),
  KEY `TRKCALIB_index` (`TRK_CALIB_USED`),
  KEY `CALDSPMASK_index` (`CAL_DSP_MASK`),
  KEY `EFF_WS_index` (`EFF_WRK_SCHEDULE`),
  KEY `FAV_WS_index` (`FAV_WRK_SCHEDULE`),
  KEY `RM_ACQ_AFTER_CALIB_index` (`RM_ACQ_AFTER_CALIB`),
  KEY `RM_ACQ_SETTING_MODE_index` (`RM_ACQ_SETTING_MODE`),
  KEY `ACQ_VAR_INFO_index` (`ACQ_VAR_INFO`),
  KEY `TRG_MODE_A_index` (`PRH_VAR_TRG_MODE_A`),
  KEY `TRG_MODE_B_index` (`PRH_VAR_TRG_MODE_B`),
  KEY `NEVENTS_index` (`NEVENTS`),
  KEY `BOOTNUMBER_index` (`BOOT_NUMBER`),
  KEY `ID_RUN_fk_constraint` (`ID_ROOT_L0`),
  KEY `ID_RUN_L2_fk_constraint` (`ID_ROOT_L2`)
) ENGINE=InnoDB;

CREATE TABLE `GL_RUN_FRAGMENTS` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_RUN_FRAG` int(10) unsigned NOT NULL default '0',
  `ID_ROOT_L0` int(10) unsigned NOT NULL default '0',
  `ID_ROOT_L2` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_TIME` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_TIME` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_OBT` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_OBT` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_PKT` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_PKT` int(10) unsigned NOT NULL default '0',
  `BOOT_NUMBER` smallint(5) unsigned NOT NULL default '0',
  `EV_FROM` int(10) unsigned NOT NULL default '0',
  `EV_TO` int(10) unsigned NOT NULL default '0',
  `NEVENTS` int(10) unsigned NOT NULL default '0',
  `PKT_COUNTER` int(10) unsigned NOT NULL default '0',
  `PKT_READY_COUNTER` int(10) unsigned NOT NULL default '0',
  `COMPILATIONTIMESTAMP` int(10) unsigned NOT NULL default '0',
  `FAV_WRK_SCHEDULE` tinyint(3) unsigned NOT NULL default '0',
  `EFF_WRK_SCHEDULE` tinyint(3) unsigned NOT NULL default '0',
  `PRH_VAR_TRG_MODE_A` int(10) unsigned NOT NULL default '0',
  `PRH_VAR_TRG_MODE_B` int(10) unsigned NOT NULL default '0',
  `ACQ_BUILD_INFO` int(10) unsigned NOT NULL default '0',
  `ACQ_VAR_INFO` smallint(5) unsigned NOT NULL default '0',
  `RM_ACQ_AFTER_CALIB` tinyint(3) NOT NULL default '0',	  
  `RM_ACQ_SETTING_MODE` tinyint(3) NOT NULL default '0',
  `TRK_CALIB_USED` int(10) unsigned NOT NULL default '0',
  `CAL_DSP_MASK` tinyint(3) unsigned NOT NULL default '0',
  `LAST_TIMESYNC` int(10) unsigned NOT NULL default '0',
  `OBT_TIMESYNC` int(10) unsigned NOT NULL default '0',
  `VALIDATION` tinyint(3) unsigned NOT NULL default '0',
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID`),
  KEY `ID_RUN_FRAG_index` (`ID_RUN_FRAG`),
  KEY `ID_ROOT_L0_index` (`ID_ROOT_L0`),
  KEY `BOOTNUMBER_index` (`BOOT_NUMBER`),
  KEY `TRKCALIB_index` (`TRK_CALIB_USED`),
  KEY `NID_RUN_fk_constraint` (`ID_ROOT_L0`)
) ENGINE=InnoDB;

CREATE TABLE `GL_RUN_TRASH` (
  `ID_TRASH` int(10) unsigned NOT NULL auto_increment,
  `ID` int(10) unsigned NOT NULL default '0',
  `ID_RUN_FRAG` int(10) unsigned NOT NULL default '0',
  `ID_ROOT_L0` int(10) unsigned NOT NULL default '0',
  `ID_ROOT_L2` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_TIME` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_TIME` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_OBT` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_OBT` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_PKT` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_PKT` int(10) unsigned NOT NULL default '0',
  `BOOT_NUMBER` smallint(5) unsigned NOT NULL default '0',
  `EV_FROM` int(10) unsigned NOT NULL default '0',
  `EV_TO` int(10) unsigned NOT NULL default '0',
  `NEVENTS` int(10) unsigned NOT NULL default '0',
  `PKT_COUNTER` int(10) unsigned NOT NULL default '0',
  `PKT_READY_COUNTER` int(10) unsigned NOT NULL default '0',
  `COMPILATIONTIMESTAMP` int(10) unsigned NOT NULL default '0',
  `FAV_WRK_SCHEDULE` tinyint(3) unsigned NOT NULL default '0',
  `EFF_WRK_SCHEDULE` tinyint(3) unsigned NOT NULL default '0',
  `PRH_VAR_TRG_MODE_A` int(10) unsigned NOT NULL default '0',
  `PRH_VAR_TRG_MODE_B` int(10) unsigned NOT NULL default '0',
  `ACQ_BUILD_INFO` int(10) unsigned NOT NULL default '0',
  `ACQ_VAR_INFO` smallint(5) unsigned NOT NULL default '0',
  `RM_ACQ_AFTER_CALIB` tinyint(3) NOT NULL default '0',	  
  `RM_ACQ_SETTING_MODE` tinyint(3) NOT NULL default '0',
  `TRK_CALIB_USED` int(10) unsigned NOT NULL default '0',
  `CAL_DSP_MASK` tinyint(3) unsigned NOT NULL default '0',
  `LAST_TIMESYNC` int(10) unsigned NOT NULL default '0',
  `OBT_TIMESYNC` int(10) unsigned NOT NULL default '0',
  `VALIDATION` tinyint(3) unsigned NOT NULL default '0',
  `FILENAMEL0` varchar(255) NOT NULL default '',
  `FILENAMEL2` varchar(255) NOT NULL default '',
  `BELONGED_TO` varchar(255) NOT NULL default '',
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID_TRASH`),
  KEY `TID_RUN_FRAG_index` (`ID_RUN_FRAG`),
  KEY `TID_ROOT_L0_index` (`ID_ROOT_L0`),
  KEY `TBOOTNUMBER_index` (`BOOT_NUMBER`),
  KEY `TTRKCALIB_index` (`TRK_CALIB_USED`),
  KEY `TFNAME0_index` (`FILENAMEL0`),
  KEY `TFNAME2_index` (`FILENAMEL2`),
  KEY `TBELONG_index` (`BELONGED_TO`)
) ENGINE=InnoDB;

CREATE TABLE `GL_CALO_CALIB` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_ROOT_L0` int(10) unsigned NOT NULL default '0',
  `EV_ROOT` int(10) unsigned NOT NULL default '0',
  `FROM_TIME` int(10) unsigned NOT NULL default '0',
  `TO_TIME` int(10) unsigned NOT NULL default '0',
  `SECTION` tinyint(3) unsigned NOT NULL default '0',
  `OBT` int(10) unsigned NOT NULL default '0',
  `PKT` int(10) unsigned NOT NULL default '0',
  `BOOT_NUMBER` smallint(5) unsigned NOT NULL default '0',
  `VALIDATION` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  KEY `SECTION_index` (`SECTION`),
  KEY `EV_ROOT_index` (`EV_ROOT`),
  KEY `ID_ROOT_index` (`ID_ROOT_L0`),
  KEY `BOOTNUMBER_index` (`BOOT_NUMBER`),
  KEY `VALID1_index` (`VALIDATION`)
) ENGINE=InnoDB;

CREATE TABLE `GL_TRK_CALIB` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_ROOT_L0` int(10) unsigned NOT NULL default '0',
  `EV_ROOT_CALIBTRK1` int(10) unsigned default NULL,
  `EV_ROOT_CALIBTRK2` int(10) unsigned default NULL,
  `FROM_TIME` int(10) unsigned NOT NULL default '0',
  `TO_TIME` int(10) unsigned NOT NULL default '0',
  `OBT1` int(10) unsigned NOT NULL default '0',
  `PKT1` int(10) unsigned NOT NULL default '0',
  `OBT2` int(10) unsigned NOT NULL default '0',
  `PKT2` int(10) unsigned NOT NULL default '0',
  `BOOT_NUMBER` smallint(5) unsigned NOT NULL default '0',
  `VALIDATION` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  KEY `ID_ROOT_index` (`ID_ROOT_L0`),
  KEY `EV_ROOT_CALIBTRK1index` (`EV_ROOT_CALIBTRK1`),
  KEY `EV_ROOT_CALIBTRK2index` (`EV_ROOT_CALIBTRK2`),
  KEY `BOOTNUMBER_index` (`BOOT_NUMBER`),
  KEY `VALID2_index` (`VALIDATION`)
) ENGINE=InnoDB;

CREATE TABLE `GL_S4_CALIB` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_ROOT_L0` int(10) unsigned NOT NULL default '0',
  `EV_ROOT` int(10) unsigned NOT NULL default '0',
  `FROM_TIME` int(10) unsigned NOT NULL default '0',
  `TO_TIME` int(10) unsigned NOT NULL default '0',
  `OBT` int(10) unsigned NOT NULL default '0',
  `PKT` int(10) unsigned NOT NULL default '0',  
  `BOOT_NUMBER` smallint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  KEY `ID_ROOT_index` (`ID_ROOT_L0`),
  KEY `BOOTNUMBER_index` (`BOOT_NUMBER`)
) ENGINE=InnoDB;


