*-- Author :    Elena Taddei-Sergio Bottai 09/08/2005
      
	SUBROUTINE GPUCOLLECTION(np,nt)

***************************************************************************
*                                                                         *
*   				                                          *
*								          *
*      Here we calculate the signal appearing on each ADC channel         *
*      starting from the charge collected on every strip of the silicon   *
*      sensor. Noise is kept from data of beam test. Capacitive coupling  *
*      between strips and energy to ADC calibration are introduced too.   *
*									  *
*                                                                         *
* Called by: GPDSPE                                        		  *
*                                                                         *
***************************************************************************

#include "gpstripspe.inc" 
c
c eventually to be removed in future version containing the BADVA1 filling
c
        DATA BADVA1/ntotva1*1/
c
c new strip capacitance simulation 19/02/09 S. Bottai
c        
c
        dimension stripqxtanti(nstripx)
        dimension stripqytanti(nstripy)
	



	
********zeroing**************

 	do i=1,nstripx
            stripqxtanti(i)=0.
        enddo
	do i=1,nstripy
           stripqytanti(i)=0.
        enddo
	
***************************
        if(NT.eq.1.or.NT.eq.4) LADD=1
        if(NT.eq.2.or.NT.eq.5) LADD=2
        if(NT.eq.3.or.NT.eq.6) LADD=3	
	
*
*      Odd strip, X side --> charge shared between adjacent strips
*      EFFCOUPL          --> coupling efficiency (capacitance to backplane =0?)
*      SHIFTMASK	 --> asymmetry in charge division on X view
*                            different in each sensor (mask)
	
	 
        do j=(1+8),(nstripx-7),2
      		proxtanti(np,nt,j-1)=
     +  	proxtanti(np,nt,j-1)+
     +          0.5*effcoupl*proxtanti(np,nt,j)*(1.-shiftmask) 

         	proxtanti(np,nt,j+1)=
     +  	proxtanti(np,nt,j+1)+
     +          0.5*effcoupl*proxtanti(np,nt,j)*(1.+shiftmask)
	    proxtanti(np,nt,j)=0.
         enddo	


*
*      Capacitive coupling: a fraction of the charge arriving at one strip
*      appears at the output of the neighbouring amplifiers
*      This fraction is about Cis/Cdec, where Cis is the interstrip 
*      capacitance and Cdec is the decoupling capacitance (see Turchetta)
*      An algorithm has been chosen that is precise for low values of the 
*      capacitive coupling, i.e. if the INDUCED charge on a given strip 
*      is little compared with the COLLECTED one.
*


******************** X side *************************
			    
	c=cistrx/cdec
        c2=cistrx2/cdec


	do j=8,nstripx-6,2	 ! only even strips on X side
CV            jm2=1
CV            IF(j-2.lt.8) jm2=0
CV            jp2=1
CV            IF(j+2.gt.(nstripx-6)) jp2=0
CV            jm4=1
CV            IF(j-4.lt.8) jm4=0
CV            jp4=1
CV            IF(j+4.gt.(nstripx-6)) jp4=0

            
            stripqxtanti(j)=proxtanti(np,nt,j)
            SUMF=0.
            DO KK=1,4  
	    KF=KK*2
            IF(KK.EQ.1) FN=F1
	    IF(KK.EQ.2) FN=F2
	    IF(KK.EQ.3) FN=F3
	    IF(KK.EQ.4) FN=F4
	    IF(KK.GE.5) FN=F1/KK
              IF((J-KF).GE.8) THEN 
	         stripqxtanti(j)=stripqxtanti(j)+FN*proxtanti(np,nt,j-KF)
                 SUMF=SUMF+FN
	      ENDIF
	      IF((J+KF).LE.(nstripx-6)) THEN
	         stripqxtanti(j)=stripqxtanti(j)+FN*proxtanti(np,nt,j+KF)
                 SUMF=SUMF+FN
              ENDIF
            ENDDO

            stripqxtanti(j)=stripqxtanti(j)-SUMF*proxtanti(np,nt,j)
	    
cv	    stripqxtanti(j)=proxtanti(np,nt,j)*(1.-2.*(c+c2))+ 	   
cv     +   c*(1.-2.*c)*(jm2*proxtanti(np,nt,j-2)
cv     +   +jp2*proxtanti(np,nt,j+2))+
cv     +  (c**2)*(jm4*proxtanti(np,nt,j-4)*(1.+c2/(c**2))+
cv     +   2.*proxtanti(np,nt,j)+jp4*proxtanti(np,nt,j+4)*(1.+c2/(c**2)))
        

	    if(stripqxtanti(j).gt.1.e-8) then

              IVA1=INT((J/2-1)/128)+1
	      IF(badva1(NP*2,LADD,IVA1).EQ.1) THEN               
               NSTRPX=NSTRPX+1 
               floatadcx=stripqxtanti(j)*xcalib
	       IF(NSTRPX.GT.MAXSTR) THEN
		 WRITE(6,*) 'ERROR - NSTRPX > MAXSTR'
		 NSTRPX=MAXSTR
	       ENDIF	      
	       NPSTRIPX(NSTRPX)=NP
	       NTSTRIPX(NSTRPX)=NT
	       ISTRIPX(NSTRPX)=(J/2)+(LADD-1)*1024
	       QSTRIPX(NSTRPX)=floatadcx
	       XSTRIPX(NSTRPX)=GLOBSTRIPX(NP,NT,J)
c              PRINT*,'1NPSTRIPX ',NP, ' NTSTRX ', NT,' ISTRIPX ', ISTRIPX(NSTRPX)
c              PRINT*,'2Q ',QSTRIPX(NSTRPX),' XS ', XSTRIPX(NSTRPX)
c              PRINT*,' '
	      
              ENDIF

	    endif
        enddo

c       PRINT*, 'NSTRPX', NSTRPX

******************** Y side *************************

        c=cistry/cdec
	

	do j=1,nstripy

            jmen1=j-1
            jm1=1
            if(jmen1.lt.1) then
             jm1=0
             jmen1=1
            endif

            jmen2=j-2
            jm2=1
            if(jmen2.lt.1) then
             jm2=0
             jmen2=1
            endif

            jpiu1=j+1
            jp1=1
            if(jpiu1.gt.nstripy) then
             jp1=0
             jpiu1=nstripy
            endif

            jpiu2=j+2
            jp2=1
            if(jpiu2.gt.nstripy) then
             jp2=0
             jpiu2=nstripy
            endif

	   stripqytanti(j)=proytanti(np,nt,j)*(1.-2.*c)+ 	   
     +    c*(1.-2.*c)*(jm1*proytanti(np,nt,jmen1)+jp1*
     +    proytanti(np,nt,jpiu1))+
     +    (c**2)*(jm2*proytanti(np,nt,jmen2)+2.*proytanti(np,nt,j)+
     +    jp2*proytanti(np,nt,jpiu2))

	   if(stripqytanti(j).gt.1.e-8) then


             IVA1=INT((J-1)/128)+1
	     IF(badva1(NP*2-1,LADD,IVA1).EQ.1) THEN          

	      NSTRPY=NSTRPY+1
	      IF(NSTRPY.GT.MAXSTR) THEN
	        WRITE(6,*) 'ERROR - NSTRPY > MAXSTR'
	        NSTRPY=MAXSTR
              ENDIF
	      floatadcy=stripqytanti(j)*ycalib
              NPSTRIPY(NSTRPY)=NP
	      NTSTRIPY(NSTRPY)=NT
	      ISTRIPY(NSTRPY)=J+(LADD-1)*1024
              QSTRIPY(NSTRPY)=FLOATADCY
              YSTRIPY(NSTRPY)=GLOBSTRIPY(NP,NT,J)
c             PRINT*,'1NPSTRIPY ',NP, ' NTSTRY ', NT,' ISTRIPY ', ISTRIPY(NSTRPY)
c              PRINT*,'2Q ',QSTRIPY(NSTRPY),' YS ', YSTRIPY(NSTRPY)
	      
             ENDIF
	     
	    endif

         enddo

c       PRINT*, 'NSTRPY', NSTRPY		
	 END

